/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.yson;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;

class YsonTextUtils {
    private static final char[] DIGITS = "0123456789abcdef".toCharArray();

    private YsonTextUtils() {
    }

    static void writeQuotedByte(byte b, Writer out) {
        try {
            switch (b) {
                case 9: {
                    out.append("\\t");
                    return;
                }
                case 10: {
                    out.append("\\n");
                    return;
                }
                case 13: {
                    out.append("\\r");
                    return;
                }
                case 34: {
                    out.append("\\\"");
                    return;
                }
                case 92: {
                    out.append("\\\\");
                    return;
                }
            }
            if (b <= 31 || b >= 127) {
                out.append("\\x");
                out.append(DIGITS[(b & 0xFF) >>> 4]);
                out.append(DIGITS[b & 0xF]);
            } else {
                out.append((char)b);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

