/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.spyt;

import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;
import tech.ytsaurus.spyt.HostAndPort;

public final class HostAndPort$
implements Serializable {
    public static HostAndPort$ MODULE$;
    private final Regex bracketedHostAndPort;
    private final Regex unbracketedHostAndPort;

    static {
        new HostAndPort$();
    }

    private Regex bracketedHostAndPort() {
        return this.bracketedHostAndPort;
    }

    private Regex unbracketedHostAndPort() {
        return this.unbracketedHostAndPort;
    }

    private int parsePort(String port) {
        int n;
        try {
            int p = new StringOps(Predef$.MODULE$.augmentString(port)).toInt();
            if (p < 0 || p > 65535) {
                throw new IllegalArgumentException(new StringBuilder(20).append("Invalid port number ").append(p).toString());
            }
            n = p;
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(new StringBuilder(24).append("Unparseable port number ").append(port).toString(), ex);
        }
        return n;
    }

    public HostAndPort fromString(String hostPortString) {
        HostAndPort hostAndPort;
        String string = hostPortString;
        Option option = this.bracketedHostAndPort().unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(3) == 0) {
            String host = (String)((LinearSeqOptimized)option.get()).apply(0);
            String port = (String)((LinearSeqOptimized)option.get()).apply(2);
            hostAndPort = new HostAndPort(host, this.parsePort(port));
        } else {
            Option option2 = this.unbracketedHostAndPort().unapplySeq((CharSequence)string);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(3) == 0) {
                String host = (String)((LinearSeqOptimized)option2.get()).apply(0);
                String port = (String)((LinearSeqOptimized)option2.get()).apply(2);
                hostAndPort = new HostAndPort(host, this.parsePort(port));
            } else {
                throw new IllegalArgumentException(new StringBuilder(16).append("Unable to parse ").append(hostPortString).toString());
            }
        }
        return hostAndPort;
    }

    public HostAndPort apply(String host, int port) {
        return new HostAndPort(host, port);
    }

    public Option<Tuple2<String, Object>> unapply(HostAndPort x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.host(), (Object)BoxesRunTime.boxToInteger((int)x$0.port())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private HostAndPort$() {
        MODULE$ = this;
        this.bracketedHostAndPort = new StringOps(Predef$.MODULE$.augmentString("^\\[(.*?)](:(\\d+))?$")).r();
        this.unbracketedHostAndPort = new StringOps(Predef$.MODULE$.augmentString("^(.*?)(:(\\d+))?$")).r();
    }
}

