/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.core.common;

import java.math.BigInteger;
import java.util.Arrays;
import javax.annotation.Nullable;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;

@NonNullApi
@NonNullFields
public class Decimal {
    private static final int MAX_PRECISION = 35;
    private static final byte[] PLUS_INF_4 = new byte[]{127, -1, -1, -2};
    private static final byte[] PLUS_INF_8 = new byte[]{127, -1, -1, -1, -1, -1, -1, -2};
    private static final byte[] PLUS_INF_16 = new byte[]{127, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2};
    private static final byte[] MINUS_INF_4 = new byte[]{-128, 0, 0, 2};
    private static final byte[] MINUS_INF_8 = new byte[]{-128, 0, 0, 0, 0, 0, 0, 2};
    private static final byte[] MINUS_INF_16 = new byte[]{-128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2};

    private Decimal() {
    }

    public static byte[] textToBinary(String textDecimal, int precision, int scale) {
        Decimal.validatePrecisionAndScale(precision, scale);
        int byteSize = Decimal.getValueBinarySize(precision);
        byte[] binary = Decimal.textToBinary(textDecimal, precision, scale, byteSize);
        if (binary.length > byteSize) {
            throw new RuntimeException(String.format("Binary size=%d, but expected no more than %d", binary.length, byteSize));
        }
        byte[] result = new byte[byteSize];
        System.arraycopy(binary, 0, result, byteSize - binary.length, binary.length);
        if (!textDecimal.isEmpty() && textDecimal.charAt(0) == '-') {
            for (int idx = 0; idx < byteSize - binary.length; ++idx) {
                result[idx] = -1;
            }
        }
        result[0] = (byte)(result[0] ^ 0x80);
        return result;
    }

    public static String binaryToText(byte[] binaryDecimal, int precision, int scale) {
        Decimal.validatePrecisionAndScale(precision, scale);
        int byteSize = Decimal.getValueBinarySize(precision);
        binaryDecimal[0] = (byte)(binaryDecimal[0] ^ 0x80);
        if (Arrays.equals(binaryDecimal, Decimal.getPlusInf(byteSize))) {
            return "inf";
        }
        if (Arrays.equals(binaryDecimal, Decimal.getMinusInf(byteSize))) {
            return "-inf";
        }
        if (Arrays.equals(binaryDecimal, Decimal.getNan(byteSize))) {
            return "nan";
        }
        BigInteger decodedValue = new BigInteger(binaryDecimal);
        String digits = String.format("%0" + (scale + 1) + "d", decodedValue);
        StringBuilder result = new StringBuilder(digits.length() + 2);
        result.append(digits.subSequence(0, digits.length() - scale));
        if (scale > 0) {
            result.append('.');
            result.append(digits.subSequence(digits.length() - scale, digits.length()));
        }
        return result.toString();
    }

    private static byte[] textToBinary(String textDecimal, int precision, int scale, int byteSize) {
        if (textDecimal.isEmpty()) {
            Decimal.throwInvalidDecimal(textDecimal, precision, scale, null);
        }
        int cur = 0;
        int end = textDecimal.length();
        boolean negative = false;
        switch (textDecimal.charAt(cur)) {
            case '-': {
                negative = true;
            }
            case '+': {
                ++cur;
                break;
            }
        }
        if (cur == end) {
            Decimal.throwInvalidDecimal(textDecimal, precision, scale, null);
        }
        switch (textDecimal.charAt(cur)) {
            case 'I': 
            case 'i': {
                if (!(cur + 3 != end || textDecimal.charAt(++cur) != 'n' && textDecimal.charAt(cur) != 'N' || textDecimal.charAt(++cur) != 'f' && textDecimal.charAt(cur) != 'F')) {
                    return negative ? Decimal.getMinusInf(byteSize) : Decimal.getPlusInf(byteSize);
                }
                Decimal.throwInvalidDecimal(textDecimal, precision, scale, null);
            }
            case 'N': 
            case 'n': {
                if (!(negative || cur + 3 != end || textDecimal.charAt(++cur) != 'a' && textDecimal.charAt(cur) != 'A' || textDecimal.charAt(++cur) != 'n' && textDecimal.charAt(cur) != 'N')) {
                    return Decimal.getNan(byteSize);
                }
                Decimal.throwInvalidDecimal(textDecimal, precision, scale, null);
            }
        }
        BigInteger result = BigInteger.ZERO;
        int beforePoint = 0;
        int afterPoint = 0;
        while (cur != end) {
            int currentDigit;
            if (textDecimal.charAt(cur) == '.') {
                ++cur;
                while (cur != end) {
                    currentDigit = textDecimal.charAt(cur) - 48;
                    result = result.multiply(BigInteger.TEN);
                    result = result.add(BigInteger.valueOf(currentDigit));
                    ++afterPoint;
                    if (currentDigit < 0 || currentDigit > 9) {
                        Decimal.throwInvalidDecimal(textDecimal, precision, scale, null);
                    }
                    ++cur;
                }
                break;
            }
            currentDigit = textDecimal.charAt(cur) - 48;
            result = result.multiply(BigInteger.TEN);
            result = result.add(BigInteger.valueOf(currentDigit));
            ++beforePoint;
            if (currentDigit < 0 || currentDigit > 9) {
                Decimal.throwInvalidDecimal(textDecimal, precision, scale, null);
            }
            ++cur;
        }
        while (afterPoint < scale) {
            result = result.multiply(BigInteger.TEN);
            ++afterPoint;
        }
        if (afterPoint > scale) {
            Decimal.throwInvalidDecimal(textDecimal, precision, scale, "too many digits after decimal point");
        }
        if (beforePoint + scale > precision) {
            Decimal.throwInvalidDecimal(textDecimal, precision, scale, "too many digits before decimal point");
        }
        return (negative ? result.negate() : result).toByteArray();
    }

    private static byte[] getPlusInf(int byteSize) {
        switch (byteSize) {
            case 4: {
                return PLUS_INF_4;
            }
            case 8: {
                return PLUS_INF_8;
            }
            case 16: {
                return PLUS_INF_16;
            }
        }
        throw new IllegalArgumentException("Incorrect byteSize in getPlusInf");
    }

    private static byte[] getMinusInf(int byteSize) {
        switch (byteSize) {
            case 4: {
                return MINUS_INF_4;
            }
            case 8: {
                return MINUS_INF_8;
            }
            case 16: {
                return MINUS_INF_16;
            }
        }
        throw new IllegalArgumentException("Incorrect byteSize in getMinusInf");
    }

    private static byte[] getNan(int byteSize) {
        byte[] result = (byte[])Decimal.getPlusInf(byteSize).clone();
        result[result.length - 1] = -1;
        return result;
    }

    private static void throwInvalidDecimal(String textDecimal, int precision, int scale, @Nullable String reason) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("String %s is not valid Decimal<%d,%d> representation", textDecimal, precision, scale));
        }
        throw new IllegalArgumentException(String.format("String %s is not valid Decimal<%d,%d> representation: %s", textDecimal, precision, scale, reason));
    }

    private static void validatePrecisionAndScale(int precision, int scale) {
        if (precision <= 0 || precision > 35) {
            throw new IllegalArgumentException(String.format("Invalid decimal precision %d, precision must be in range [1, %d]", precision, 35));
        }
        if (scale < 0 || scale > precision) {
            throw new IllegalArgumentException(String.format("Invalid decimal scale %d (precision: %d); decimal scale must be in range [0, PRECISION]", scale, precision));
        }
    }

    private static int getValueBinarySize(int precision) {
        if (precision > 0) {
            if (precision <= 9) {
                return 4;
            }
            if (precision <= 18) {
                return 8;
            }
            if (precision <= 35) {
                return 16;
            }
        }
        Decimal.validatePrecisionAndScale(precision, 0);
        throw new RuntimeException("Shouldn't be here");
    }
}

