/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.core.common;

import com.google.protobuf.ByteString;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import tech.ytsaurus.TError;
import tech.ytsaurus.core.common.YTsaurusErrorCode;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.yson.YsonConsumer;
import tech.ytsaurus.yson.YsonError;
import tech.ytsaurus.yson.YsonParser;
import tech.ytsaurus.yson.YsonTextWriter;
import tech.ytsaurus.ysontree.YTreeNode;
import tech.ytsaurus.ytree.TAttribute;
import tech.ytsaurus.ytree.TAttributeDictionary;

@NonNullApi
public class YTsaurusError
extends RuntimeException {
    private final TError error;

    public YTsaurusError(TError error) {
        super(YTsaurusError.createFullErrorDescription(error));
        this.error = error;
    }

    public static YTsaurusError parseFrom(Map<String, YTreeNode> error) {
        int code = Optional.ofNullable(error.get("code")).map(YTreeNode::intValue).orElse(0);
        String message = Optional.ofNullable(error.get("message")).map(YTreeNode::stringValue).orElse("");
        List attributes = Optional.ofNullable(error.get("attributes")).map(YTreeNode::asMap).map(Map::entrySet).map(entrySet -> entrySet.stream().map(entry -> TAttribute.newBuilder().setKey((String)entry.getKey()).setValue(ByteString.copyFrom((byte[])((YTreeNode)entry.getValue()).toBinary())).build()).collect(Collectors.toUnmodifiableList())).orElse(Collections.emptyList());
        List innerErrors = Optional.ofNullable(error.get("inner_errors")).map(YTreeNode::asList).map(list -> list.stream().map(YTreeNode::asMap).map(YTsaurusError::parseFrom).map(YTsaurusError::getError).collect(Collectors.toUnmodifiableList())).orElse(Collections.emptyList());
        return new YTsaurusError(TError.newBuilder().setCode(code).setMessage(message).setAttributes(TAttributeDictionary.newBuilder().addAllAttributes(attributes).build()).addAllInnerErrors(innerErrors).build());
    }

    public TError getError() {
        return this.error;
    }

    public boolean matches(Predicate<Integer> predicate) {
        return YTsaurusError.findMatching(this.error, e -> predicate.test(e.getCode())) != null;
    }

    public boolean matches(int code) {
        return this.findMatchingError(code) != null;
    }

    @Nullable
    public TError findMatchingError(int code) {
        return YTsaurusError.findMatching(this.error, e -> e.getCode() == code);
    }

    public Set<Integer> getErrorCodes() {
        final HashSet<Integer> result = new HashSet<Integer>();
        Consumer<TError> walker = new Consumer<TError>(){

            @Override
            public void accept(TError e) {
                result.add(e.getCode());
                for (TError inner : e.getInnerErrorsList()) {
                    this.accept(inner);
                }
            }
        };
        walker.accept(this.error);
        return result;
    }

    @Nullable
    @Deprecated
    public YTsaurusError findMatching(int code) {
        if (this.error.getCode() == code) {
            return this;
        }
        TError matching = YTsaurusError.findMatching(this.error, e -> e.getCode() == code);
        if (matching == null) {
            return null;
        }
        return new YTsaurusError(matching);
    }

    public boolean isUnrecoverable() {
        int code = this.error.getCode();
        return code == YTsaurusErrorCode.ProxyBanned.code || code == YTsaurusErrorCode.PeerBanned.code || code == YTsaurusErrorCode.TransportError.code || code == YTsaurusErrorCode.Unavailable.code || code == YTsaurusErrorCode.NoSuchService.code || code == YTsaurusErrorCode.NoSuchMethod.code || code == YTsaurusErrorCode.ProtocolError.code;
    }

    public static boolean isUnrecoverable(Throwable e) {
        return !(e instanceof YTsaurusError) || ((YTsaurusError)e).isUnrecoverable();
    }

    public static String createFullErrorDescription(TError error) {
        StringBuilder sb = new StringBuilder();
        YTsaurusError.writeShortErrorDescription(error, sb);
        sb.append("; full error: ");
        try {
            YTsaurusError.serializeError(error, (YsonConsumer)new YsonTextWriter(sb));
        }
        catch (YsonError ex) {
            sb.append("<yson parsing error occurred>");
        }
        return sb.toString();
    }

    @Nullable
    private static TError findMatching(@Nullable TError error, Predicate<TError> predicate) {
        TError inner;
        if (error == null) {
            return null;
        }
        if (predicate.test(error)) {
            return error;
        }
        TError result = null;
        Iterator iterator = error.getInnerErrorsList().iterator();
        while (iterator.hasNext() && (result = YTsaurusError.findMatching(inner = (TError)iterator.next(), predicate)) == null) {
        }
        return result;
    }

    private static void writeShortErrorDescription(TError error, StringBuilder sb) {
        while (true) {
            sb.append('\'').append(error.getMessage()).append('\'');
            if (error.getInnerErrorsCount() <= 0) break;
            sb.append(" <== ");
            error = error.getInnerErrors(0);
        }
    }

    private static void serializeError(TError error, YsonConsumer consumer) {
        consumer.onBeginMap();
        consumer.onKeyedItem("code");
        consumer.onInteger((long)error.getCode());
        consumer.onKeyedItem("message");
        consumer.onString(error.getMessage());
        if (error.getAttributes().getAttributesCount() != 0) {
            consumer.onKeyedItem("attributes");
            consumer.onBeginMap();
            for (TAttribute attribute : error.getAttributes().getAttributesList()) {
                consumer.onKeyedItem(attribute.getKey());
                new YsonParser(attribute.getValue().toByteArray()).parseNode(consumer);
            }
            consumer.onEndMap();
        }
        if (error.getInnerErrorsCount() > 0) {
            consumer.onKeyedItem("inner_errors");
            consumer.onBeginList();
            for (TError innerError : error.getInnerErrorsList()) {
                YTsaurusError.serializeError(innerError, consumer);
            }
            consumer.onEndList();
        }
        consumer.onEndMap();
    }
}

