/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.core.cypress;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.core.cypress.Exact;
import tech.ytsaurus.core.cypress.Range;
import tech.ytsaurus.core.cypress.RangeCriteria;
import tech.ytsaurus.core.cypress.RangeLimit;
import tech.ytsaurus.core.cypress.RichYPathParser;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.ysontree.YTree;
import tech.ytsaurus.ysontree.YTreeBuilder;
import tech.ytsaurus.ysontree.YTreeMapNode;
import tech.ytsaurus.ysontree.YTreeNode;
import tech.ytsaurus.ysontree.YTreeTextSerializer;

@NonNullFields
public class RichYPath
implements YPath {
    private String rootDesignator;
    private List<String> relativePath;
    @Nullable
    private Boolean append;
    @Nullable
    private Boolean primary;
    @Nullable
    private Boolean foreign;
    private List<RangeCriteria> ranges;
    private List<String> columns;
    private Map<String, String> renameColumns;
    private List<String> sortedBy;
    @Nullable
    private Long timestamp;
    @Nullable
    private YTreeNode schema;
    @Nullable
    private String format;
    @Nullable
    private Boolean bypassArtifactCache;
    @Nullable
    private Boolean executable;
    @Nullable
    private Boolean create;
    private Map<String, YTreeNode> additionalAttributes;

    RichYPath(String rootDesignator, List<String> relativePath) {
        this.rootDesignator = rootDesignator;
        this.relativePath = relativePath;
        this.append = null;
        this.primary = null;
        this.foreign = null;
        this.ranges = List.of();
        this.columns = List.of();
        this.renameColumns = Map.of();
        this.sortedBy = List.of();
        this.timestamp = null;
        this.schema = null;
        this.format = null;
        this.bypassArtifactCache = null;
        this.executable = null;
        this.create = null;
        this.additionalAttributes = Map.of();
    }

    private RichYPath(RichYPath other, List<String> relativePath) {
        this.rootDesignator = other.rootDesignator;
        this.relativePath = relativePath;
        this.append = other.append;
        this.primary = other.primary;
        this.ranges = other.ranges;
        this.columns = other.columns;
        this.renameColumns = other.renameColumns;
        this.foreign = other.foreign;
        this.sortedBy = other.sortedBy;
        this.timestamp = other.timestamp;
        this.schema = other.schema;
        this.format = other.format;
        this.bypassArtifactCache = other.bypassArtifactCache;
        this.executable = other.executable;
        this.create = other.create;
        this.additionalAttributes = other.additionalAttributes;
    }

    private RichYPath(RichYPath other) {
        this(other, other.relativePath);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RichYPath richYPath = (RichYPath)o;
        return Objects.equals(this.rootDesignator, richYPath.rootDesignator) && Objects.equals(this.relativePath, richYPath.relativePath) && Objects.equals(this.append, richYPath.append) && Objects.equals(this.primary, richYPath.primary) && Objects.equals(this.foreign, richYPath.foreign) && Objects.equals(this.ranges, richYPath.ranges) && Objects.equals(this.columns, richYPath.columns) && Objects.equals(this.renameColumns, richYPath.renameColumns) && Objects.equals(this.sortedBy, richYPath.sortedBy) && Objects.equals(this.timestamp, richYPath.timestamp) && Objects.equals(this.schema, richYPath.schema) && Objects.equals(this.format, richYPath.format) && Objects.equals(this.bypassArtifactCache, richYPath.bypassArtifactCache) && Objects.equals(this.executable, richYPath.executable) && Objects.equals(this.create, richYPath.create) && Objects.equals(this.additionalAttributes, richYPath.additionalAttributes);
    }

    public int hashCode() {
        return Objects.hash(this.rootDesignator, this.relativePath, this.append, this.primary, this.foreign, this.ranges, this.columns, this.renameColumns, this.sortedBy, this.timestamp, this.schema, this.format, this.bypassArtifactCache, this.executable, this.create, this.additionalAttributes);
    }

    @Override
    public YPath justPath() {
        return new RichYPath(this.rootDesignator, this.relativePath);
    }

    @Override
    public String name() {
        if (this.isAttribute()) {
            throw new IllegalStateException();
        }
        return this.relativePath.get(this.relativePath.size() - 1);
    }

    @Override
    public boolean isRoot() {
        return this.relativePath.isEmpty();
    }

    @Override
    public boolean isAttribute() {
        return !this.relativePath.isEmpty() && this.relativePath.get(this.relativePath.size() - 1).startsWith("@");
    }

    @Override
    public boolean hasObjectRootDesignator() {
        return this.rootDesignator.startsWith("#");
    }

    @Override
    public YPath withObjectRoot(GUID id) {
        RichYPath copy = new RichYPath(this);
        copy.rootDesignator = "#" + String.valueOf(id);
        copy.relativePath = List.of();
        return copy;
    }

    @Override
    public YPath parent() {
        if (this.relativePath.isEmpty()) {
            return this;
        }
        List<String> newRelativePath = List.copyOf(this.relativePath.subList(0, this.relativePath.size() - 1));
        return new RichYPath(this, newRelativePath);
    }

    @Override
    public YPath child(String key) {
        ArrayList<String> list = new ArrayList<String>(this.relativePath);
        list.addAll(RichYPath.getRelativePath("/".concat(key), 0));
        List<String> newRelativePath = List.copyOf(list);
        return new RichYPath(this, newRelativePath);
    }

    @Override
    public YPath after(int index) {
        ArrayList<String> list = new ArrayList<String>(this.relativePath);
        list.add("after:" + index);
        List<String> newRelativePath = List.copyOf(list);
        return new RichYPath(this, newRelativePath);
    }

    @Override
    public YPath before(int index) {
        ArrayList<String> list = new ArrayList<String>(this.relativePath);
        list.add("before:" + index);
        List<String> newRelativePath = List.copyOf(list);
        return new RichYPath(this, newRelativePath);
    }

    @Override
    public YPath begin() {
        ArrayList<String> list = new ArrayList<String>(this.relativePath);
        list.add("begin");
        List<String> newRelativePath = List.copyOf(list);
        return new RichYPath(this, newRelativePath);
    }

    @Override
    public YPath end() {
        ArrayList<String> list = new ArrayList<String>(this.relativePath);
        list.add("end");
        List<String> newRelativePath = List.copyOf(list);
        return new RichYPath(this, newRelativePath);
    }

    @Override
    public YPath child(int index) {
        ArrayList<String> list = new ArrayList<String>(this.relativePath);
        list.add(String.valueOf(index));
        RichYPath copy = new RichYPath(this);
        copy.relativePath = List.copyOf(list);
        return copy;
    }

    @Override
    public YPath attribute(String key) {
        ArrayList<String> list = new ArrayList<String>(this.relativePath);
        list.add("@" + key);
        RichYPath copy = new RichYPath(this);
        copy.relativePath = List.copyOf(list);
        return copy;
    }

    @Override
    public YPath all() {
        ArrayList<String> list = new ArrayList<String>(this.relativePath);
        list.add("*");
        RichYPath copy = new RichYPath(this);
        copy.relativePath = List.copyOf(list);
        return copy;
    }

    @Override
    public YPath allAttributes() {
        ArrayList<String> list = new ArrayList<String>(this.relativePath);
        list.add("@");
        RichYPath copy = new RichYPath(this);
        copy.relativePath = List.copyOf(list);
        return copy;
    }

    @Override
    public Optional<Boolean> getAppend() {
        return Optional.ofNullable(this.append);
    }

    @Override
    public YPath append(boolean append) {
        RichYPath copy = new RichYPath(this);
        copy.append = append;
        return copy;
    }

    @Override
    public Optional<Boolean> getPrimary() {
        return Optional.ofNullable(this.primary);
    }

    @Override
    public YPath primary(boolean primary) {
        RichYPath copy = new RichYPath(this);
        copy.primary = primary;
        return copy;
    }

    @Override
    public Optional<Boolean> getForeign() {
        return Optional.ofNullable(this.foreign);
    }

    @Override
    public YPath foreign(boolean foreign) {
        RichYPath copy = new RichYPath(this);
        copy.foreign = foreign;
        return copy;
    }

    @Override
    public Optional<YTreeNode> getSchema() {
        return Optional.ofNullable(this.schema);
    }

    @Override
    public YPath withSchema(YTreeNode schema) {
        RichYPath copy = new RichYPath(this);
        copy.schema = schema;
        return copy;
    }

    @Override
    public List<RangeCriteria> getRanges() {
        return this.ranges;
    }

    @Override
    public YPath ranges(List<RangeCriteria> ranges) {
        RichYPath copy = new RichYPath(this);
        copy.ranges = List.copyOf(new ArrayList<RangeCriteria>(ranges));
        return copy;
    }

    @Override
    public YPath plusRange(RangeCriteria range) {
        ArrayList<RangeCriteria> list = new ArrayList<RangeCriteria>(this.ranges);
        list.add(range);
        RichYPath copy = new RichYPath(this);
        copy.ranges = List.copyOf(new ArrayList<RangeCriteria>(list));
        return copy;
    }

    @Override
    public List<String> getColumns() {
        return this.columns;
    }

    @Override
    public YPath withColumns(Collection<String> columns) {
        RichYPath copy = new RichYPath(this);
        copy.columns = List.copyOf(new ArrayList<String>(columns));
        return copy;
    }

    @Override
    public Map<String, String> getRenameColumns() {
        return this.renameColumns;
    }

    @Override
    public YPath withRenameColumns(Map<String, String> renameColumns) {
        RichYPath copy = new RichYPath(this);
        copy.renameColumns = Map.copyOf(renameColumns);
        return copy;
    }

    @Override
    public YPath plusRenameColumns(Map<String, String> renameColumns) {
        HashMap<String, String> map = new HashMap<String, String>(this.renameColumns);
        map.putAll(renameColumns);
        RichYPath copy = new RichYPath(this);
        copy.renameColumns = Map.copyOf(map);
        return copy;
    }

    @Override
    public List<String> getSortedBy() {
        return this.sortedBy;
    }

    @Override
    public YPath sortedBy(List<String> sortedBy) {
        RichYPath copy = new RichYPath(this);
        copy.sortedBy = List.copyOf(new ArrayList<String>(sortedBy));
        return copy;
    }

    @Override
    public Optional<Long> getTimestamp() {
        return Optional.ofNullable(this.timestamp);
    }

    @Override
    public YPath withTimestamp(long timestamp) {
        RichYPath copy = new RichYPath(this);
        copy.timestamp = timestamp;
        return copy;
    }

    @Override
    public Optional<String> getFormat() {
        return Optional.ofNullable(this.format);
    }

    @Override
    public YPath withFormat(String format) {
        RichYPath copy = new RichYPath(this);
        copy.format = format;
        return copy;
    }

    @Override
    public Optional<Boolean> getExecutable() {
        return Optional.ofNullable(this.executable);
    }

    @Override
    public YPath withExecutable(boolean executable) {
        RichYPath copy = new RichYPath(this);
        copy.executable = executable;
        return copy;
    }

    @Override
    public Optional<Boolean> getCreate() {
        return Optional.ofNullable(this.create);
    }

    @Override
    public YPath create(boolean create) {
        RichYPath copy = new RichYPath(this);
        copy.create = create;
        return copy;
    }

    @Override
    public Optional<YTreeNode> getAdditionalAttribute(String attributeName) {
        return Optional.ofNullable(this.additionalAttributes.get(attributeName));
    }

    @Override
    public Map<String, YTreeNode> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    @Override
    public YPath withAdditionalAttributes(Map<String, YTreeNode> additionalAttributes) {
        RichYPath copy = new RichYPath(this);
        copy.additionalAttributes = Map.copyOf(additionalAttributes);
        return copy;
    }

    @Override
    public YPath plusAdditionalAttribute(String key, YTreeNode value) {
        HashMap<String, YTreeNode> map = new HashMap<String, YTreeNode>(this.additionalAttributes);
        map.put(key, value);
        RichYPath copy = new RichYPath(this);
        copy.additionalAttributes = Map.copyOf(map);
        return copy;
    }

    @Override
    public Optional<Boolean> getBypassArtifactCache() {
        return Optional.ofNullable(this.bypassArtifactCache);
    }

    @Override
    public YPath withBypassArtifactCache(boolean bypassArtifactCache) {
        RichYPath copy = new RichYPath(this);
        copy.bypassArtifactCache = bypassArtifactCache;
        return copy;
    }

    public String toString() {
        return this.toStringImpl(false);
    }

    @Override
    public String toStableString() {
        return this.toStringImpl(true);
    }

    private String toStringImpl(boolean stable) {
        String simpleString = Stream.concat(Stream.of(this.rootDesignator), this.relativePath.stream()).collect(Collectors.joining("/"));
        YTreeNode node = this.toTree();
        if (node.containsAttributes()) {
            String tmp = stable ? YTreeTextSerializer.stableSerialize((YTreeNode)this.buildAttributes(YTree.builder()).value(31337).build()) : YTreeTextSerializer.serialize((YTreeNode)this.buildAttributes(YTree.builder()).value(31337).build());
            return tmp.substring(0, tmp.length() - 5) + simpleString;
        }
        return simpleString;
    }

    @Override
    public YTreeNode toTree() {
        return this.toTree(YTree.builder()).build();
    }

    private YTreeBuilder buildAttributes(YTreeBuilder builder) {
        return builder.beginAttributes().when(this.append != null, b -> b.key("append").value(this.append)).when(this.primary != null, b -> b.key("primary").value(this.primary)).when(!this.ranges.isEmpty(), b -> b.key("ranges").value(this.ranges, (b2, r) -> {
            YTreeBuilder rangesBuilder = b2.beginMap();
            rangesBuilder = r.addRangeCriteria(rangesBuilder);
            return rangesBuilder.endMap();
        })).when(this.foreign != null, b -> b.key("foreign").value(this.foreign)).when(!this.columns.isEmpty(), b -> b.key("columns").value(this.columns)).when(!this.renameColumns.isEmpty(), b -> {
            YTreeBuilder mapBuilder = YTree.mapBuilder();
            for (Map.Entry<String, String> oldToNewColumn : this.renameColumns.entrySet()) {
                mapBuilder.key(oldToNewColumn.getKey()).value(oldToNewColumn.getValue());
            }
            return b.key("rename_columns").value((YTreeNode)mapBuilder.buildMap());
        }).when(!this.sortedBy.isEmpty(), b -> b.key("sorted_by").value(this.sortedBy)).when(this.timestamp != null, b -> b.key("timestamp").value(this.timestamp)).when(this.schema != null, b -> b.key("schema").value(this.schema)).when(this.format != null, b -> b.key("format").value(this.format)).when(this.bypassArtifactCache != null, b -> b.key("bypass_artifact_cache").value(this.bypassArtifactCache)).when(this.executable != null, b -> b.key("executable").value(this.executable)).when(this.create != null, b -> b.key("create").value(this.create)).apply(b -> {
            for (Map.Entry<String, YTreeNode> node : this.additionalAttributes.entrySet()) {
                b.key(node.getKey()).value(node.getValue());
            }
            return b;
        }).endAttributes();
    }

    @Override
    public YTreeBuilder toTree(YTreeBuilder builder) {
        return this.buildAttributes(builder).value(Stream.concat(Stream.of(this.rootDesignator), this.relativePath.stream()).collect(Collectors.joining("/")));
    }

    public static YPath cypressRoot() {
        return new RichYPath("/", List.of());
    }

    public static YPath objectRoot(GUID id) {
        return new RichYPath("#" + id.toString(), List.of());
    }

    public static YPath simple(String path) {
        return RichYPath.getRootDesignatorAndRelativePath(path);
    }

    public static YPath fromTree(YTreeNode node) {
        String path = node.stringValue();
        Map attributes = node.getAttributes();
        YPath simplePath = RichYPath.getRootDesignatorAndRelativePath(path);
        if (attributes.isEmpty()) {
            return simplePath;
        }
        return RichYPath.fromAttributes(simplePath, attributes);
    }

    public static YPath fromString(String data) {
        return RichYPathParser.parse(data);
    }

    private static YPath getRootDesignatorAndRelativePath(String path) {
        if (path.startsWith("/")) {
            return new RichYPath("/", RichYPath.getRelativePath(path, 1));
        }
        if (path.startsWith("#")) {
            int ptr;
            for (ptr = 0; ptr < path.length() && path.charAt(ptr) != '/'; ++ptr) {
            }
            String guid = path.substring(1, ptr);
            if (!GUID.isValid(guid)) {
                throw new IllegalArgumentException(path);
            }
            return new RichYPath("#" + guid, RichYPath.getRelativePath(path, ptr));
        }
        throw new IllegalArgumentException(path);
    }

    private static List<String> getRelativePath(String path, int ptr) {
        if (ptr >= path.length()) {
            return List.of();
        }
        if (path.charAt(ptr) != '/') {
            throw new IllegalStateException("Relative path must start with '/' character, but got '" + path + "'");
        }
        ArrayList<String> result = new ArrayList<String>();
        while (ptr < path.length()) {
            int nextPtr;
            for (nextPtr = ptr + 1; nextPtr < path.length() && path.charAt(nextPtr) != '/'; ++nextPtr) {
            }
            if (nextPtr == ptr + 1) {
                throw new IllegalArgumentException("Invalid path format: empty path component detected in '" + path + "'. Path components must not be empty (no consecutive '/' characters allowed).");
            }
            result.add(path.substring(ptr + 1, nextPtr));
            ptr = nextPtr;
        }
        return List.copyOf(result);
    }

    static YPath fromAttributes(YPath simplePath, Map<String, YTreeNode> attrs) {
        HashMap<String, YTreeNode> attributes = new HashMap<String, YTreeNode>(attrs);
        Optional<Boolean> append = Optional.ofNullable((YTreeNode)attributes.remove("append")).map(YTreeNode::boolValue);
        Optional<Boolean> primary = Optional.ofNullable((YTreeNode)attributes.remove("primary")).map(YTreeNode::boolValue);
        Optional<Boolean> foreign = Optional.ofNullable((YTreeNode)attributes.remove("foreign")).map(YTreeNode::boolValue);
        Optional<Boolean> bypassArtifactCache = Optional.ofNullable((YTreeNode)attributes.remove("bypass_artifact_cache")).map(YTreeNode::boolValue);
        Optional<Boolean> executable = Optional.ofNullable((YTreeNode)attributes.remove("executable")).map(YTreeNode::boolValue);
        Optional<Boolean> create = Optional.ofNullable((YTreeNode)attributes.remove("create")).map(YTreeNode::boolValue);
        ArrayList<RangeCriteria> ranges = new ArrayList<RangeCriteria>();
        Optional<YTreeNode> rangesAttribute = Optional.ofNullable((YTreeNode)attributes.remove("ranges"));
        if (rangesAttribute.isPresent()) {
            for (YTreeNode range : rangesAttribute.get().listNode()) {
                RangeLimit lower = RichYPath.getLimit(range, "lower_limit");
                RangeLimit upper = RichYPath.getLimit(range, "upper_limit");
                RangeLimit exact = RichYPath.getLimit(range, "exact");
                if (exact != null) {
                    ranges.add(new Exact(exact));
                    continue;
                }
                ranges.add(Range.builder().setLowerLimit(lower).setUpperLimit(upper).build());
            }
        }
        Set<String> columns = Optional.ofNullable((YTreeNode)attributes.remove("columns")).map(v -> v.asList().stream()).orElse(Stream.of(new YTreeNode[0])).map(YTreeNode::stringValue).collect(Collectors.toSet());
        Map<String, String> renameColumns = Optional.ofNullable((YTreeNode)attributes.remove("rename_columns")).map(v -> v.asMap().entrySet().stream()).orElse(Stream.of(new Map.Entry[0])).collect(Collectors.toMap(Map.Entry::getKey, v -> ((YTreeNode)v.getValue()).stringValue()));
        List<String> sortedBy = Optional.ofNullable((YTreeNode)attributes.remove("sorted_by")).map(v -> v.asList().stream()).orElse(Stream.of(new YTreeNode[0])).map(YTreeNode::stringValue).collect(Collectors.toList());
        Optional<Long> timestamp = Optional.ofNullable((YTreeNode)attributes.remove("timestamp")).map(YTreeNode::longValue);
        Optional<YTreeNode> schema = Optional.ofNullable((YTreeNode)attributes.remove("schema"));
        YPath result = simplePath;
        if (append.isPresent()) {
            result = result.append(append.get());
        }
        if (primary.isPresent()) {
            result = result.primary(primary.get());
        }
        if (foreign.isPresent()) {
            result = result.foreign(foreign.get());
        }
        if (!ranges.isEmpty()) {
            result = result.ranges(ranges);
        }
        if (!columns.isEmpty()) {
            result = result.withColumns(columns);
        }
        if (!renameColumns.isEmpty()) {
            result = result.withRenameColumns(renameColumns);
        }
        if (!sortedBy.isEmpty()) {
            result = result.sortedBy(sortedBy);
        }
        if (timestamp.isPresent()) {
            result = result.withTimestamp(timestamp.get());
        }
        if (schema.isPresent()) {
            result = result.withSchema(schema.get());
        }
        if (bypassArtifactCache.isPresent()) {
            result = result.withBypassArtifactCache(bypassArtifactCache.get());
        }
        if (executable.isPresent()) {
            result = result.withExecutable(executable.get());
        }
        if (create.isPresent()) {
            result = result.create(create.get());
        }
        if (!attributes.isEmpty()) {
            result = result.withAdditionalAttributes(attributes);
        }
        return result;
    }

    @Nullable
    private static RangeLimit getLimit(YTreeNode node, String key) {
        YTreeMapNode parentMapNode = node.mapNode();
        if (!parentMapNode.containsKey(key)) {
            return null;
        }
        return RangeLimit.fromTree(parentMapNode.getOrThrow(key));
    }
}

