/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.core.cypress;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import tech.ytsaurus.core.cypress.RangeLimit;
import tech.ytsaurus.core.cypress.RichYPath;
import tech.ytsaurus.core.cypress.RichYPathTags;
import tech.ytsaurus.core.cypress.TokenType;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.core.cypress.YPathTokenizer;
import tech.ytsaurus.yson.YsonConsumer;
import tech.ytsaurus.yson.YsonParser;
import tech.ytsaurus.yson.YsonToken;
import tech.ytsaurus.yson.YsonTokenType;
import tech.ytsaurus.yson.YsonTokenizer;
import tech.ytsaurus.ysontree.YTree;
import tech.ytsaurus.ysontree.YTreeBuilder;
import tech.ytsaurus.ysontree.YTreeEntityNode;
import tech.ytsaurus.ysontree.YTreeNode;

public class RichYPathParser {
    private RichYPathParser() {
    }

    public static YPath parse(String data) {
        return RichYPathParser.parse(data.getBytes(StandardCharsets.UTF_8));
    }

    public static YPath parse(byte[] data) {
        YTreeBuilder attributesBuilder = YTree.builder();
        YsonParser parser = new YsonParser(data);
        int offset = parser.parseAttributes((YsonConsumer)attributesBuilder);
        HashMap<String, YTreeNode> attributes = new HashMap<String, YTreeNode>(attributesBuilder.entity().build().getAttributes());
        byte[] pathWithoutAttributes = Arrays.copyOfRange(data, offset, data.length);
        YPathTokenizer tokenizer = new YPathTokenizer(pathWithoutAttributes);
        while (tokenizer.getType() != TokenType.EndOfStream && tokenizer.getType() != TokenType.Range) {
            tokenizer.advance();
        }
        YPath simplePath = RichYPath.simple(new String(tokenizer.getPrefix(), StandardCharsets.UTF_8));
        byte[] rangeBuffer = tokenizer.getToken();
        if (rangeBuffer != null && tokenizer.getType() == TokenType.Range) {
            YsonTokenizer ysonTokenizer = new YsonTokenizer(rangeBuffer);
            ysonTokenizer.parseNext();
            RichYPathParser.parseColumns(ysonTokenizer, attributes);
            RichYPathParser.parseRowRanges(ysonTokenizer, attributes);
            ysonTokenizer.getCurrentToken().expectType(YsonTokenType.EndOfStream);
        }
        if (attributes.isEmpty()) {
            return simplePath;
        }
        return RichYPath.fromAttributes(simplePath, attributes);
    }

    private static Optional<RangeLimit> parseRowLimit(YsonTokenizer tokenizer, List<YsonTokenType> separators) {
        RangeLimit rangeLimit;
        if (separators.contains(tokenizer.getCurrentType())) {
            return Optional.empty();
        }
        switch (tokenizer.getCurrentType()) {
            case Hash: {
                tokenizer.parseNext();
                rangeLimit = RangeLimit.row(tokenizer.getCurrentToken().asInt64Value());
                tokenizer.parseNext();
                break;
            }
            case LeftParenthesis: {
                tokenizer.parseNext();
                ArrayList<YTreeNode> keys = new ArrayList<YTreeNode>();
                block8: while (tokenizer.getCurrentType() != RichYPathTags.END_TUPLE_TOKEN) {
                    keys.add(RichYPathParser.parseKeyPart(tokenizer));
                    switch (tokenizer.getCurrentType()) {
                        case Comma: {
                            tokenizer.parseNext();
                            continue block8;
                        }
                        case RightParenthesis: {
                            continue block8;
                        }
                    }
                    RichYPathParser.throwUnexpectedToken(tokenizer.getCurrentToken());
                }
                rangeLimit = RangeLimit.key(keys);
                tokenizer.parseNext();
                break;
            }
            default: {
                rangeLimit = RangeLimit.key(List.of(RichYPathParser.parseKeyPart(tokenizer)));
            }
        }
        tokenizer.getCurrentToken().expectTypes(separators);
        return Optional.of(rangeLimit);
    }

    private static YTreeNode parseKeyPart(YsonTokenizer tokenizer) {
        YTreeEntityNode value = null;
        switch (tokenizer.getCurrentType()) {
            case String: {
                value = YTree.stringNode((String)tokenizer.getCurrentToken().asStringValue());
                break;
            }
            case Int64: {
                value = YTree.integerNode((long)tokenizer.getCurrentToken().asInt64Value());
                break;
            }
            case Uint64: {
                value = YTree.unsignedIntegerNode((long)tokenizer.getCurrentToken().asUint64Value());
                break;
            }
            case Double: {
                value = YTree.doubleNode((double)tokenizer.getCurrentToken().asDoubleValue());
                break;
            }
            case Boolean: {
                value = YTree.booleanNode((boolean)tokenizer.getCurrentToken().asBooleanValue());
                break;
            }
            case Hash: {
                value = YTree.entityNode();
                break;
            }
            default: {
                RichYPathParser.throwUnexpectedToken(tokenizer.getCurrentToken());
            }
        }
        tokenizer.parseNext();
        return value;
    }

    private static void parseRowRanges(YsonTokenizer tokenizer, Map<String, YTreeNode> attributes) {
        if (tokenizer.getCurrentType() != RichYPathTags.BEGIN_ROW_SELECTOR_TOKEN) {
            return;
        }
        tokenizer.parseNext();
        YTreeBuilder rangesBuilder = YTree.listBuilder();
        boolean finished = false;
        while (!finished) {
            Optional<RangeLimit> lowerLimit = RichYPathParser.parseRowLimit(tokenizer, List.of(RichYPathTags.RANGE_TOKEN, RichYPathTags.RANGE_SEPARATOR_TOKEN, RichYPathTags.END_ROW_SELECTOR_TOKEN));
            Optional<RangeLimit> upperLimit = Optional.empty();
            boolean isTwoSideRange = false;
            if (tokenizer.getCurrentType() == RichYPathTags.RANGE_TOKEN) {
                isTwoSideRange = true;
                tokenizer.parseNext();
                upperLimit = RichYPathParser.parseRowLimit(tokenizer, List.of(RichYPathTags.RANGE_SEPARATOR_TOKEN, RichYPathTags.END_ROW_SELECTOR_TOKEN));
            }
            YTreeBuilder rangeBuilder = YTree.mapBuilder();
            if (isTwoSideRange) {
                lowerLimit.ifPresent(rangeLimit -> rangeBuilder.key("lower_limit").apply(rangeLimit::toTree));
                upperLimit.ifPresent(rangeLimit -> rangeBuilder.key("upper_limit").apply(rangeLimit::toTree));
            } else {
                lowerLimit.ifPresent(rangeLimit -> rangeBuilder.key("exact").apply(rangeLimit::toTree));
            }
            rangesBuilder.value((YTreeNode)rangeBuilder.buildMap());
            if (tokenizer.getCurrentType() == RichYPathTags.END_ROW_SELECTOR_TOKEN) {
                finished = true;
            }
            tokenizer.parseNext();
        }
        attributes.put("ranges", (YTreeNode)rangesBuilder.buildList());
    }

    private static void parseColumns(YsonTokenizer tokenizer, Map<String, YTreeNode> attributes) {
        if (tokenizer.getCurrentType() != RichYPathTags.BEGIN_COLUMN_SELECTOR_TOKEN) {
            return;
        }
        tokenizer.parseNext();
        YTreeBuilder columnsBuilder = YTree.listBuilder();
        block4: while (tokenizer.getCurrentType() != RichYPathTags.END_COLUMN_SELECTOR_TOKEN) {
            if (tokenizer.getCurrentType() == YsonTokenType.String) {
                columnsBuilder.value((YTreeNode)YTree.stringNode((String)tokenizer.getCurrentToken().asStringValue()));
                tokenizer.parseNext();
            } else {
                RichYPathParser.throwUnexpectedToken(tokenizer.getCurrentToken());
            }
            switch (tokenizer.getCurrentType()) {
                case Comma: {
                    tokenizer.parseNext();
                    continue block4;
                }
                case RightBrace: {
                    continue block4;
                }
            }
            RichYPathParser.throwUnexpectedToken(tokenizer.getCurrentToken());
        }
        tokenizer.parseNext();
        attributes.put("columns", (YTreeNode)columnsBuilder.buildList());
    }

    private static void throwUnexpectedToken(YsonToken tag) {
        throw new RuntimeException("Unexpected token '" + String.valueOf(tag) + "'");
    }
}

