/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.core.cypress;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.core.YtTimestamp;
import tech.ytsaurus.core.cypress.Exact;
import tech.ytsaurus.core.cypress.Range;
import tech.ytsaurus.core.cypress.RangeCriteria;
import tech.ytsaurus.core.cypress.RangeLimit;
import tech.ytsaurus.core.cypress.RichYPath;
import tech.ytsaurus.ysontree.YTree;
import tech.ytsaurus.ysontree.YTreeBuilder;
import tech.ytsaurus.ysontree.YTreeNode;

public interface YPath {
    public YPath parent();

    public YPath justPath();

    public String name();

    public YPath child(String var1);

    public YPath after(int var1);

    public YPath before(int var1);

    public YPath begin();

    public YPath end();

    public YPath child(int var1);

    public YPath attribute(String var1);

    public YPath all();

    public YPath allAttributes();

    public boolean isRoot();

    public boolean isAttribute();

    public boolean hasObjectRootDesignator();

    public YPath withObjectRoot(GUID var1);

    public Optional<YTreeNode> getSchema();

    public YPath withSchema(YTreeNode var1);

    public Optional<String> getFormat();

    public YPath withFormat(String var1);

    public Optional<Boolean> getBypassArtifactCache();

    public YPath withBypassArtifactCache(boolean var1);

    public Optional<Boolean> getAppend();

    public YPath append(boolean var1);

    public Optional<Boolean> getPrimary();

    public YPath primary(boolean var1);

    public Optional<Boolean> getForeign();

    public YPath foreign(boolean var1);

    default public YPath withRange(long lowerRowIndex, long upperRowIndex) {
        return this.withRange(RangeLimit.row(lowerRowIndex), RangeLimit.row(upperRowIndex));
    }

    default public YPath withRange(RangeLimit lower, RangeLimit upper) {
        return this.plusRange(new Range(lower, upper));
    }

    default public YPath withExact(RangeLimit exact) {
        return this.plusRange(new Exact(exact));
    }

    public List<RangeCriteria> getRanges();

    public YPath ranges(List<RangeCriteria> var1);

    default public YPath ranges(RangeCriteria ... ranges) {
        return this.ranges(Arrays.asList(ranges));
    }

    public YPath plusRange(RangeCriteria var1);

    public List<String> getColumns();

    public YPath withColumns(Collection<String> var1);

    default public YPath withColumns(String ... columns) {
        return this.withColumns(Arrays.asList(columns));
    }

    public Map<String, String> getRenameColumns();

    public YPath withRenameColumns(Map<String, String> var1);

    default public YPath plusRenameColumns(String oldColumnName, String newColumnName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(oldColumnName, newColumnName);
        return this.plusRenameColumns(map);
    }

    public YPath plusRenameColumns(Map<String, String> var1);

    public List<String> getSortedBy();

    public YPath sortedBy(List<String> var1);

    default public YPath sortedBy(String ... sortedBy) {
        return this.sortedBy(Arrays.asList(sortedBy));
    }

    public Optional<Long> getTimestamp();

    public YPath withTimestamp(long var1);

    default public Optional<YtTimestamp> getYtTimestamp() {
        return this.getTimestamp().map(YtTimestamp::valueOf);
    }

    default public YPath withYtTimestamp(YtTimestamp ytTimestamp) {
        return this.withTimestamp(ytTimestamp.getValue());
    }

    public Optional<Boolean> getExecutable();

    public YPath withExecutable(boolean var1);

    public Optional<Boolean> getCreate();

    public YPath create(boolean var1);

    public Optional<YTreeNode> getAdditionalAttribute(String var1);

    public Map<String, YTreeNode> getAdditionalAttributes();

    public YPath withAdditionalAttributes(Map<String, YTreeNode> var1);

    default public YPath plusAdditionalAttribute(String key, Object value) {
        return this.plusAdditionalAttribute(key, YTree.node((Object)value));
    }

    public YPath plusAdditionalAttribute(String var1, YTreeNode var2);

    public YTreeNode toTree();

    public YTreeBuilder toTree(YTreeBuilder var1);

    public String toStableString();

    public static YPath cypressRoot() {
        return RichYPath.cypressRoot();
    }

    public static YPath objectRoot(GUID id) {
        return RichYPath.objectRoot(id);
    }

    public static YPath simple(String path) {
        return RichYPath.simple(path);
    }

    public static YPath fromTree(YTreeNode node) {
        return RichYPath.fromTree(node);
    }
}

