/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.core.operations;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import tech.ytsaurus.core.operations.CloseableIterator;
import tech.ytsaurus.core.operations.OperationContext;
import tech.ytsaurus.core.operations.Yield;
import tech.ytsaurus.core.rows.YTreeSerializer;
import tech.ytsaurus.yson.ClosableYsonConsumer;
import tech.ytsaurus.yson.YsonBinaryWriter;
import tech.ytsaurus.yson.YsonConsumer;
import tech.ytsaurus.yson.YsonParser;
import tech.ytsaurus.ysontree.YTree;
import tech.ytsaurus.ysontree.YTreeBuilder;
import tech.ytsaurus.ysontree.YTreeEntityNode;
import tech.ytsaurus.ysontree.YTreeNode;
import tech.ytsaurus.ysontree.YTreeNodeUtils;

public class YTreeBinarySerializer
extends tech.ytsaurus.ysontree.YTreeBinarySerializer {
    public static <T> void serializeAllObjects(List<T> objects, YTreeSerializer<T> serializer, OutputStream output) {
        try (ClosableYsonConsumer writer = YTreeBinarySerializer.getSerializer((OutputStream)output);){
            for (T obj : objects) {
                writer.onListItem();
                serializer.serialize(obj, (YsonConsumer)writer);
            }
            writer.onListItem();
        }
    }

    public static CloseableIterator<YTreeNode> iterator(final InputStream input, final OperationContext context) {
        final YTreeBuilder builder = new YTreeBuilder();
        final YsonParser parser = new YsonParser(input, 65536);
        return new CloseableIterator<YTreeNode>(){
            boolean hasNextChecked = false;
            YTreeNode next = null;
            int tableIndex = 0;
            long rowIndex = 0L;

            @Override
            public boolean hasNext() {
                YTreeNode node;
                this.hasNextChecked = true;
                if (this.next != null) {
                    return true;
                }
                while (true) {
                    boolean parsed;
                    if (!(parsed = parser.parseListFragmentItem((YsonConsumer)builder))) {
                        return false;
                    }
                    node = builder.build();
                    if (!(node instanceof YTreeEntityNode)) break;
                    if (node.containsAttribute("table_index")) {
                        this.tableIndex = node.getAttributeOrThrow("table_index").intValue();
                        context.setTableIndex(this.tableIndex);
                    }
                    if (!node.containsAttribute("row_index")) continue;
                    this.rowIndex = node.getAttributeOrThrow("row_index").longValue();
                }
                context.setRowIndex(this.rowIndex);
                if (context.isSettingTableIndex()) {
                    node.putAttribute("table_index", (YTreeNode)YTree.integerNode((long)this.tableIndex));
                }
                if (context.isSettingRowIndex()) {
                    node.putAttribute("row_index", (YTreeNode)YTree.integerNode((long)this.rowIndex));
                }
                this.next = node;
                return true;
            }

            @Override
            public YTreeNode next() {
                if (!this.hasNextChecked && !this.hasNext()) {
                    throw new IllegalStateException();
                }
                ++this.rowIndex;
                YTreeNode ret = this.next;
                this.next = null;
                this.hasNextChecked = false;
                return ret;
            }

            @Override
            public void close() throws Exception {
                input.close();
            }
        };
    }

    public static Yield<YTreeNode> yield(final OutputStream[] output) {
        final YsonBinaryWriter[] writers = new YsonBinaryWriter[output.length];
        for (int i = 0; i < output.length; ++i) {
            writers[i] = new YsonBinaryWriter(output[i], 65536);
        }
        return new Yield<YTreeNode>(){

            @Override
            public void yield(int index, YTreeNode value) {
                writers[index].onListItem();
                YTreeNodeUtils.walk((YTreeNode)value, (YsonConsumer)writers[index], (boolean)true);
            }

            @Override
            public void close() throws IOException {
                for (int i = 0; i < output.length; ++i) {
                    writers[i].close();
                    output[i].close();
                }
            }
        };
    }
}

