/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.core.tables;

import java.util.Objects;
import javax.annotation.Nullable;
import tech.ytsaurus.core.tables.ColumnSortOrder;
import tech.ytsaurus.core.tables.ColumnValueType;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.typeinfo.TiType;
import tech.ytsaurus.typeinfo.TypeIO;
import tech.ytsaurus.yson.YsonConsumer;
import tech.ytsaurus.ysontree.YTree;
import tech.ytsaurus.ysontree.YTreeBuilder;
import tech.ytsaurus.ysontree.YTreeConvertible;
import tech.ytsaurus.ysontree.YTreeMapNode;
import tech.ytsaurus.ysontree.YTreeNode;
import tech.ytsaurus.ysontree.YTreeNodeUtils;

@NonNullFields
public class ColumnSchema
implements YTreeConvertible {
    private final String name;
    private final TiType typeV3;
    @Nullable
    private final ColumnSortOrder sortOrder;
    @Nullable
    private final String lock;
    @Nullable
    private final String expression;
    @Nullable
    private final String aggregate;
    @Nullable
    private final String group;

    public ColumnSchema(String name, TiType typeV3) {
        this(name, typeV3, null);
    }

    public ColumnSchema(String name, TiType typeV3, @Nullable ColumnSortOrder sortOrder) {
        this.name = name;
        this.typeV3 = typeV3;
        this.sortOrder = sortOrder;
        this.lock = null;
        this.expression = null;
        this.aggregate = null;
        this.group = null;
    }

    public ColumnSchema(String name, ColumnValueType type) {
        this(name, type, null, null, null, null, null, false);
    }

    public ColumnSchema(String name, ColumnValueType type, ColumnSortOrder sortOrder) {
        this(name, type, sortOrder, null, null, null, null, false);
    }

    @Deprecated
    public ColumnSchema(String name, ColumnValueType type, ColumnSortOrder sortOrder, String lock, String expression, String aggregate, String group) {
        this(name, type, sortOrder, lock, expression, aggregate, group, false);
    }

    public ColumnSchema(String name, ColumnValueType type, @Nullable ColumnSortOrder sortOrder, @Nullable String lock, @Nullable String expression, @Nullable String aggregate, @Nullable String group, boolean required) {
        this.name = Objects.requireNonNull(name);
        this.typeV3 = ColumnSchema.fromOldType(type, required);
        this.sortOrder = sortOrder;
        this.lock = lock;
        this.expression = expression;
        this.aggregate = aggregate;
        this.group = group;
    }

    private ColumnSchema(Builder builder) {
        this.name = builder.name;
        this.typeV3 = builder.typeV3;
        this.sortOrder = builder.sortOrder;
        this.lock = builder.lock;
        this.expression = builder.expression;
        this.aggregate = builder.aggregate;
        this.group = builder.group;
    }

    public static Builder builder(String name, TiType typeV3) {
        return new Builder(name, typeV3);
    }

    public static Builder builder(String name, ColumnValueType type) {
        return new Builder(name, type);
    }

    public static Builder builder(String name, ColumnValueType type, boolean required) {
        return new Builder(name, type, required);
    }

    public String getName() {
        return this.name;
    }

    public ColumnValueType getWireType() {
        return ColumnSchema.toWireType((TiType)this.typeV3).columnValueType;
    }

    public ColumnValueType getType() {
        return ColumnSchema.toOldType((TiType)this.typeV3).columnValueType;
    }

    public TiType getTypeV3() {
        return this.typeV3;
    }

    @Nullable
    public ColumnSortOrder getSortOrder() {
        return this.sortOrder;
    }

    @Nullable
    public String getLock() {
        return this.lock;
    }

    @Nullable
    public String getExpression() {
        return this.expression;
    }

    @Nullable
    public String getAggregate() {
        return this.aggregate;
    }

    @Nullable
    public String getGroup() {
        return this.group;
    }

    public boolean isRequired() {
        return ColumnSchema.toOldType((TiType)this.typeV3).required;
    }

    public YTreeNode toYTree() {
        YTreeBuilder builder = YTree.builder().beginMap().key("name").value(this.name).key("type_v3").apply(b -> {
            this.typeV3.serializeTo((YsonConsumer)b);
            return b;
        });
        if (this.sortOrder != null) {
            builder.key("sort_order").value(this.sortOrder.getName());
        }
        if (this.lock != null) {
            builder.key("lock").value(this.lock);
        }
        if (this.expression != null) {
            builder.key("expression").value(this.expression);
        }
        if (this.aggregate != null) {
            builder.key("aggregate").value(this.aggregate);
        }
        if (this.group != null) {
            builder.key("group").value(this.group);
        }
        return builder.buildMap();
    }

    public static ColumnSchema fromYTree(YTreeNode node) {
        TiType typeV3;
        YTreeMapNode map = node.mapNode();
        String name = map.getOrThrow("name").stringValue();
        YTreeNode typeV3Node = map.get("type_v3").orElse(null);
        if (typeV3Node != null) {
            typeV3 = TypeIO.parseYson(c -> YTreeNodeUtils.walk((YTreeNode)map.getOrThrow("type_v3"), (YsonConsumer)c, (boolean)true));
        } else {
            boolean required = map.get("required").map(YTreeNode::boolValue).orElse(false);
            ColumnValueType type = ColumnValueType.fromName(map.getOrThrow("type", () -> "Neither 'type_v3' nor 'type' is specified").stringValue());
            typeV3 = ColumnSchema.fromOldType(type, required);
        }
        ColumnSortOrder sortOrder = map.get("sort_order").map(YTreeNode::stringValue).map(ColumnSortOrder::fromName).orElse(null);
        return ColumnSchema.builder(name, typeV3).setSortOrder(sortOrder).setLock(map.get("lock").map(YTreeNode::stringValue).orElse(null)).setExpression(map.get("expression").map(YTreeNode::stringValue).orElse(null)).setAggregate(map.get("aggregate").map(YTreeNode::stringValue).orElse(null)).setGroup(map.get("group").map(YTreeNode::stringValue).orElse(null)).build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return this.toYTree().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColumnSchema)) {
            return false;
        }
        ColumnSchema that = (ColumnSchema)o;
        return this.name.equals(that.name) && this.typeV3.equals((Object)that.typeV3) && this.sortOrder == that.sortOrder && Objects.equals(this.lock, that.lock) && Objects.equals(this.expression, that.expression) && Objects.equals(this.aggregate, that.aggregate) && Objects.equals(this.group, that.group);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.typeV3, this.sortOrder, this.lock, this.expression, this.aggregate, this.group});
    }

    static TiType fromOldType(ColumnValueType columnValueType, boolean required) {
        TiType newType;
        switch (columnValueType) {
            case NULL: {
                if (required) {
                    throw new IllegalStateException("Type " + String.valueOf((Object)columnValueType) + " cannot be required");
                }
                return TiType.nullType();
            }
            case INT64: {
                newType = TiType.int64();
                break;
            }
            case UINT64: {
                newType = TiType.uint64();
                break;
            }
            case DOUBLE: {
                newType = TiType.doubleType();
                break;
            }
            case BOOLEAN: {
                newType = TiType.bool();
                break;
            }
            case STRING: {
                newType = TiType.string();
                break;
            }
            case ANY: 
            case COMPOSITE: {
                newType = TiType.yson();
                break;
            }
            default: {
                throw new IllegalStateException("Cannot convert " + String.valueOf((Object)columnValueType));
            }
        }
        if (required) {
            return newType;
        }
        return TiType.optional((TiType)newType);
    }

    static OldType toOldType(TiType type) {
        switch (type.getTypeName()) {
            case Bool: {
                return new OldType(ColumnValueType.BOOLEAN, true);
            }
            case Int8: 
            case Int16: 
            case Int32: 
            case Int64: 
            case Interval: 
            case Date32: 
            case Datetime64: 
            case Timestamp64: 
            case Interval64: {
                return new OldType(ColumnValueType.INT64, true);
            }
            case Uint8: 
            case Uint16: 
            case Uint32: 
            case Uint64: 
            case Date: 
            case Datetime: 
            case Timestamp: {
                return new OldType(ColumnValueType.UINT64, true);
            }
            case Float: 
            case Double: {
                return new OldType(ColumnValueType.DOUBLE, true);
            }
            case String: 
            case Utf8: 
            case Decimal: 
            case Json: 
            case Uuid: {
                return new OldType(ColumnValueType.STRING, true);
            }
            case Void: 
            case Null: {
                return new OldType(ColumnValueType.NULL, false);
            }
            case Optional: {
                OldType itemOldType = ColumnSchema.toOldType(type.asOptional().getItem());
                if (itemOldType.required) {
                    return new OldType(itemOldType.columnValueType, false);
                }
                return new OldType(ColumnValueType.ANY, false);
            }
            case Yson: 
            case List: 
            case Dict: 
            case Struct: 
            case Tuple: 
            case Variant: {
                return new OldType(ColumnValueType.ANY, true);
            }
            case Tagged: {
                return ColumnSchema.toOldType(type.asTaggedType().getItem());
            }
        }
        throw new IllegalStateException("Type " + String.valueOf(type) + " is not supported by YT");
    }

    private static OldType toWireType(TiType type) {
        switch (type.getTypeName()) {
            case Optional: {
                OldType itemOldType = ColumnSchema.toWireType(type.asOptional().getItem());
                if (itemOldType.required) {
                    return new OldType(itemOldType.columnValueType, false);
                }
                return new OldType(ColumnValueType.ANY, false);
            }
            case List: 
            case Dict: 
            case Struct: {
                return new OldType(ColumnValueType.COMPOSITE, true);
            }
            case Tagged: {
                return ColumnSchema.toWireType(type.asTaggedType().getItem());
            }
        }
        return ColumnSchema.toOldType(type);
    }

    public static class Builder {
        private final String name;
        private final TiType typeV3;
        @Nullable
        private ColumnSortOrder sortOrder;
        @Nullable
        private String lock;
        @Nullable
        private String expression;
        @Nullable
        private String aggregate;
        @Nullable
        private String group;

        public Builder(String name, ColumnValueType type) {
            this.name = name;
            this.typeV3 = ColumnSchema.fromOldType(type, false);
        }

        public Builder(String name, ColumnValueType type, boolean required) {
            this.name = name;
            this.typeV3 = ColumnSchema.fromOldType(type, required);
        }

        public Builder(String name, TiType typeV3) {
            this.name = name;
            this.typeV3 = typeV3;
        }

        public Builder(ColumnSchema columnSchema) {
            this.name = columnSchema.name;
            this.typeV3 = columnSchema.typeV3;
            this.sortOrder = columnSchema.sortOrder;
            this.lock = columnSchema.lock;
            this.expression = columnSchema.expression;
            this.aggregate = columnSchema.aggregate;
            this.group = columnSchema.group;
        }

        public Builder setSortOrder(ColumnSortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder setLock(String lock) {
            this.lock = lock;
            return this;
        }

        public Builder setExpression(String expression) {
            this.expression = expression;
            return this;
        }

        public Builder setAggregate(String aggregate) {
            this.aggregate = aggregate;
            return this;
        }

        public Builder setGroup(String group) {
            this.group = group;
            return this;
        }

        public ColumnSchema build() {
            return new ColumnSchema(this);
        }
    }

    static class OldType {
        ColumnValueType columnValueType;
        boolean required;

        OldType(ColumnValueType columnValueType, boolean required) {
            this.columnValueType = columnValueType;
            this.required = required;
        }
    }
}

