/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.core.tables;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tech.ytsaurus.core.tables.ColumnSchema;
import tech.ytsaurus.core.tables.ColumnSortOrder;
import tech.ytsaurus.core.tables.ColumnValueType;
import tech.ytsaurus.core.tables.SortColumn;
import tech.ytsaurus.typeinfo.TiType;
import tech.ytsaurus.ysontree.YTree;
import tech.ytsaurus.ysontree.YTreeConvertible;
import tech.ytsaurus.ysontree.YTreeNode;

public class TableSchema
implements YTreeConvertible {
    private final List<ColumnSchema> columns;
    private final boolean strict;
    private final boolean uniqueKeys;
    private final Map<String, Integer> columnsByName = new HashMap<String, Integer>();
    private final int keyColumnsCount;
    private final boolean isKeysSchema;
    private final boolean isValuesSchema;
    private final boolean isWriteSchema;
    private final boolean isLookupSchema;
    private final String lock;
    private final String group;

    public TableSchema(List<ColumnSchema> columns, boolean strict, boolean uniqueKeys, String lock, String group) {
        this.columns = Objects.requireNonNull(columns);
        this.strict = strict;
        this.uniqueKeys = uniqueKeys;
        this.lock = lock;
        this.group = group;
        int localKeyColumnsCount = 0;
        boolean localIsKeyColumnSchema = true;
        boolean localIsValuesSchema = true;
        boolean localIsWriteSchema = true;
        boolean localIsLookupSchema = true;
        for (int index = 0; index < columns.size(); ++index) {
            ColumnSchema column = columns.get(index);
            if (this.columnsByName.containsKey(column.getName())) {
                throw new IllegalArgumentException("Duplicate column " + column.getName());
            }
            this.columnsByName.put(column.getName(), index);
            if (column.getLock() != null && column.getLock().isEmpty()) {
                throw new IllegalArgumentException("Column " + column.getName() + ": lock name cannot be empty");
            }
            if (column.getGroup() != null && column.getGroup().isEmpty()) {
                throw new IllegalArgumentException("Column " + column.getName() + ": group name cannot be empty");
            }
            if (column.getSortOrder() != null) {
                if (column.getAggregate() != null) {
                    throw new IllegalArgumentException("Key column " + column.getName() + " cannot be aggregated");
                }
                if (index != localKeyColumnsCount) {
                    throw new IllegalArgumentException("Key columns must form a prefix of schema");
                }
                ++localKeyColumnsCount;
                localIsValuesSchema = false;
            } else {
                localIsKeyColumnSchema = false;
                localIsLookupSchema = false;
            }
            if (column.getExpression() == null) continue;
            localIsWriteSchema = false;
            localIsLookupSchema = false;
        }
        this.keyColumnsCount = localKeyColumnsCount;
        if (uniqueKeys && localKeyColumnsCount == 0) {
            throw new IllegalArgumentException("Cannot set uniqueKeys on schemas without key columns");
        }
        this.isKeysSchema = localIsKeyColumnSchema;
        this.isValuesSchema = localIsValuesSchema;
        this.isWriteSchema = localIsWriteSchema;
        this.isLookupSchema = localIsLookupSchema;
    }

    public static Builder builder() {
        return new Builder(false);
    }

    public List<ColumnSchema> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public int getKeyColumnsCount() {
        return this.keyColumnsCount;
    }

    public int getColumnsCount() {
        return this.columns.size();
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean isUniqueKeys() {
        return this.uniqueKeys;
    }

    public boolean isKeysSchema() {
        return this.isKeysSchema;
    }

    public boolean isValuesSchema() {
        return this.isValuesSchema;
    }

    public boolean isWriteSchema() {
        return this.isWriteSchema;
    }

    public boolean isLookupSchema() {
        return this.isLookupSchema;
    }

    public int findColumn(String name) {
        Integer index = this.columnsByName.get(name);
        if (index == null) {
            return -1;
        }
        return index;
    }

    public ColumnSchema getColumnSchema(int index) {
        if (index >= 0 && index < this.columns.size()) {
            return this.columns.get(index);
        }
        return null;
    }

    public String getColumnName(int index) {
        ColumnSchema column = this.getColumnSchema(index);
        if (column != null) {
            return column.getName();
        }
        return "<unknown_" + index + ">";
    }

    public ColumnValueType getColumnType(int index) {
        ColumnSchema column = this.getColumnSchema(index);
        if (column != null) {
            return column.getType();
        }
        return ColumnValueType.ANY;
    }

    public List<String> getColumnNames() {
        return new AbstractList<String>(){

            @Override
            public String get(int index) {
                return TableSchema.this.columns.get(index).getName();
            }

            @Override
            public int size() {
                return TableSchema.this.columns.size();
            }
        };
    }

    public TableSchema toWrite() {
        if (this.isWriteSchema) {
            return this;
        }
        ArrayList<ColumnSchema> newColumns = new ArrayList<ColumnSchema>();
        for (ColumnSchema column : this.columns) {
            if (column.getExpression() != null) continue;
            newColumns.add(column);
        }
        return new TableSchema(newColumns, this.strict, this.uniqueKeys, this.lock, this.group);
    }

    public TableSchema toLookup() {
        if (this.isLookupSchema) {
            return this;
        }
        ArrayList<ColumnSchema> newColumns = new ArrayList<ColumnSchema>();
        for (ColumnSchema column : this.columns) {
            if (column.getExpression() != null || column.getSortOrder() == null) continue;
            newColumns.add(column);
        }
        return new TableSchema(newColumns, this.strict, this.uniqueKeys, this.lock, this.group);
    }

    public TableSchema toDelete() {
        return this.toLookup();
    }

    public TableSchema toKeys() {
        if (this.isKeysSchema) {
            return this;
        }
        ArrayList<ColumnSchema> newColumns = new ArrayList<ColumnSchema>();
        for (ColumnSchema column : this.columns) {
            if (column.getSortOrder() == null) continue;
            newColumns.add(column);
        }
        return new TableSchema(newColumns, this.strict, this.uniqueKeys, this.lock, this.group);
    }

    public TableSchema toValues() {
        if (this.isValuesSchema) {
            return this;
        }
        ArrayList<ColumnSchema> newColumns = new ArrayList<ColumnSchema>();
        for (ColumnSchema column : this.columns) {
            if (column.getSortOrder() != null) continue;
            newColumns.add(column);
        }
        return new TableSchema(newColumns, this.strict, false, this.lock, this.group);
    }

    public TableSchema toUniqueKeys() {
        if (this.uniqueKeys) {
            return this;
        }
        return new TableSchema(this.columns, this.strict, true, this.lock, this.group);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public YTreeNode toYTree() {
        return YTree.builder().beginAttributes().key("strict").value(this.strict).key("unique_keys").value(this.uniqueKeys).endAttributes().value((Collection)this.columns.stream().map(ColumnSchema::toYTree).collect(Collectors.toList())).build();
    }

    public static TableSchema fromYTree(YTreeNode node) {
        List list = node.listNode().asList();
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>();
        for (YTreeNode columnNode : list) {
            columns.add(ColumnSchema.fromYTree(columnNode));
        }
        boolean strict = node.getAttribute("strict").map(YTreeNode::boolValue).orElse(true);
        boolean uniqueKeys = node.getAttribute("unique_keys").map(YTreeNode::boolValue).orElse(false);
        return new TableSchema(columns, strict, uniqueKeys, null, null);
    }

    public String toString() {
        return this.toYTree().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableSchema)) {
            return false;
        }
        TableSchema that = (TableSchema)o;
        if (this.strict != that.strict) {
            return false;
        }
        if (this.uniqueKeys != that.uniqueKeys) {
            return false;
        }
        return this.columns.equals(that.columns);
    }

    public int hashCode() {
        int result = this.columns.hashCode();
        result = 31 * result + (this.strict ? 1 : 0);
        result = 31 * result + (this.uniqueKeys ? 1 : 0);
        return result;
    }

    public static class Builder {
        private final List<ColumnSchema> columns;
        private String lock;
        private String group;
        private boolean strict;
        private boolean uniqueKeys;

        public Builder() {
            this(true);
        }

        Builder(boolean uniqueKeys) {
            this.columns = new ArrayList<ColumnSchema>();
            this.lock = null;
            this.group = null;
            this.strict = true;
            this.uniqueKeys = uniqueKeys;
        }

        public Builder(TableSchema tableSchema) {
            this.columns = tableSchema.columns;
            this.lock = tableSchema.lock;
            this.group = tableSchema.group;
            this.strict = tableSchema.strict;
            this.uniqueKeys = tableSchema.uniqueKeys;
        }

        public Builder addKey(String name, ColumnValueType type) {
            return this.add(new ColumnSchema(name, type, ColumnSortOrder.ASCENDING, this.lock, null, null, this.group, false));
        }

        public Builder addKey(String name, TiType type) {
            return this.add(new ColumnSchema(name, type, ColumnSortOrder.ASCENDING));
        }

        public Builder addKeyExpression(String name, ColumnValueType type, String expression) {
            return this.add(new ColumnSchema(name, type, ColumnSortOrder.ASCENDING, this.lock, expression, null, this.group, false));
        }

        public Builder addValue(String name, TiType type) {
            return this.add(new ColumnSchema(name, type));
        }

        public Builder addValue(String name, ColumnValueType type) {
            return this.add(new ColumnSchema(name, type, null, this.lock, null, null, this.group, false));
        }

        public Builder addValueAggregate(String name, ColumnValueType type, String aggregate) {
            return this.add(new ColumnSchema(name, type, null, this.lock, null, aggregate, this.group, false));
        }

        public Builder add(ColumnSchema column) {
            this.columns.add(Objects.requireNonNull(column));
            return this;
        }

        public Builder sortByColumns(List<SortColumn> sortColumns) {
            Stream<ColumnSchema> keyColumns = sortColumns.stream().map(sortColumn -> this.columns.stream().filter(col -> col.getName().equals(sortColumn.name)).map(col -> col.toBuilder().setSortOrder(sortColumn.sortOrder).build()).findAny().orElseThrow(() -> new IllegalArgumentException("Can't find column in schema: " + sortColumn.name)));
            Stream<ColumnSchema> restColumns = this.columns.stream().filter(col -> sortColumns.stream().noneMatch(sortColumn -> sortColumn.name.equals(col.getName()))).map(keyCol -> keyCol.toBuilder().setSortOrder(null).build());
            List newColumns = Stream.concat(keyColumns, restColumns).collect(Collectors.toList());
            this.columns.clear();
            this.columns.addAll(newColumns);
            return this;
        }

        public Builder sortByColumns(SortColumn ... sortColumns) {
            return this.sortByColumns(Arrays.asList(sortColumns));
        }

        public Builder sortBy(List<String> sortColumnsNames) {
            return this.sortByColumns(SortColumn.convert(sortColumnsNames));
        }

        public Builder sortBy(String ... sortColumnNames) {
            return this.sortBy(Arrays.asList(sortColumnNames));
        }

        public Builder setColumns(List<ColumnSchema> columns) {
            this.columns.clear();
            this.columns.addAll(columns);
            return this;
        }

        public Builder addAll(List<ColumnSchema> columns) {
            this.columns.addAll(columns);
            return this;
        }

        public Builder setLock(String lock) {
            this.lock = lock;
            return this;
        }

        public Builder clearLock() {
            this.lock = null;
            return this;
        }

        public Builder setGroup(String group) {
            this.group = group;
            return this;
        }

        public Builder clearGroup() {
            this.group = null;
            return this;
        }

        public Builder setStrict(boolean strict) {
            this.strict = strict;
            return this;
        }

        public Builder setUniqueKeys(boolean uniqueKeys) {
            this.uniqueKeys = uniqueKeys;
            return this;
        }

        public TableSchema build() {
            return new TableSchema(new ArrayList<ColumnSchema>(this.columns), this.strict, this.uniqueKeys, this.lock, this.group);
        }
    }
}

