/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.core.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ClassUtils {
    private ClassUtils() {
    }

    public static <A extends Annotation, T extends AnnotatedElement> boolean hasAnnotationRecursive(T cls, Class<A> annotationCls) {
        return ClassUtils.getAnnotationRecursive(cls, annotationCls).isPresent();
    }

    public static <A extends Annotation, T extends AnnotatedElement> Optional<A> getAnnotationRecursive(T cls, Class<A> annotationCls) {
        HashSet<Class<? extends Annotation>> seen = new HashSet<Class<? extends Annotation>>();
        List<A> annotations = ClassUtils.getAnnotationsRecursive(cls, seen, annotationCls);
        if (annotations.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((Annotation)annotations.get(0));
    }

    private static <A extends Annotation, T extends AnnotatedElement> List<A> getAnnotationsRecursive(T cls, Set<Class<? extends Annotation>> seen, Class<A> annotationClass) {
        ArrayList<Annotation> rv = new ArrayList<Annotation>();
        for (Annotation annotation : cls.getAnnotations()) {
            Class<? extends Annotation> type = annotation.annotationType();
            if (seen.contains(type)) continue;
            if (type.isAssignableFrom(annotationClass)) {
                rv.add(annotation);
                continue;
            }
            seen.add(type);
            rv.addAll(ClassUtils.getAnnotationsRecursive(type, seen, annotationClass));
        }
        return rv;
    }

    public static List<Type> getAllGenericInterfaces(Class<?> cls) {
        ArrayList<Type> result = new ArrayList<Type>();
        if (cls.getSuperclass() != null) {
            result.addAll(ClassUtils.getAllGenericInterfaces(cls.getSuperclass()));
        }
        result.addAll(Arrays.asList(cls.getGenericInterfaces()));
        for (Class<?> intf : cls.getInterfaces()) {
            result.addAll(ClassUtils.getAllGenericInterfaces(intf));
        }
        return result.stream().distinct().collect(Collectors.toList());
    }

    public static <A> Class<A> erasure(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ClassUtils.erasure(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Class<A> componentType = ClassUtils.erasure(((GenericArrayType)type).getGenericComponentType());
            return ClassUtils.makeArrayClass(componentType);
        }
        if (type instanceof TypeVariable) {
            Type[] bounds = ((TypeVariable)type).getBounds();
            if (bounds.length != 1) {
                throw new RuntimeException("Not a single");
            }
            return ClassUtils.erasure(bounds[0]);
        }
        if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            if (upperBounds.length == 0) {
                throw new RuntimeException("Empty list");
            }
            return ClassUtils.erasure(upperBounds[0]);
        }
        throw new IllegalArgumentException("don't know how to get erasure of " + String.valueOf(type));
    }

    private static <T> Class<T[]> makeArrayClass(Class<T> cls) {
        return Array.newInstance(cls, 0).getClass();
    }

    public static List<Type> getActualTypeArguments(Type type) {
        return Arrays.asList(((ParameterizedType)type).getActualTypeArguments());
    }

    public static <T> List<Field> getAllDeclaredFields(Class<T> clazz) {
        Class<T> superClazz = clazz.getSuperclass();
        if (superClazz == null) {
            return new ArrayList<Field>();
        }
        List fields = ClassUtils.getAllDeclaredFields(superClazz).stream().filter(field -> Modifier.isPublic(field.getModifiers()) || Modifier.isProtected(field.getModifiers())).collect(Collectors.toList());
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        return fields.stream().filter(field -> !Modifier.isStatic(field.getModifiers())).collect(Collectors.toList());
    }

    public static <Type> Type castToType(Object object) {
        return (Type)object;
    }

    public static <E, T> E[] boxArray(T array, Class<?> elementClass) {
        if (elementClass.equals(Integer.TYPE)) {
            return (Object[])ClassUtils.castToType(Arrays.stream((int[])array).boxed().toArray(Integer[]::new));
        }
        if (elementClass.equals(Long.TYPE)) {
            return (Object[])ClassUtils.castToType(Arrays.stream((long[])array).boxed().toArray(Long[]::new));
        }
        if (elementClass.equals(Double.TYPE)) {
            return (Object[])ClassUtils.castToType(Arrays.stream((double[])array).boxed().toArray(Double[]::new));
        }
        if (elementClass.equals(Byte.TYPE)) {
            byte[] unboxedArray = (byte[])array;
            Byte[] boxedArray = new Byte[unboxedArray.length];
            for (int i = 0; i < boxedArray.length; ++i) {
                boxedArray[i] = unboxedArray[i];
            }
            return (Object[])ClassUtils.castToType(boxedArray);
        }
        if (elementClass.equals(Short.TYPE)) {
            short[] unboxedArray = (short[])array;
            Short[] boxedArray = new Short[unboxedArray.length];
            for (int i = 0; i < boxedArray.length; ++i) {
                boxedArray[i] = unboxedArray[i];
            }
            return (Object[])ClassUtils.castToType(boxedArray);
        }
        if (elementClass.equals(Float.TYPE)) {
            float[] unboxedArray = (float[])array;
            Float[] boxedArray = new Float[unboxedArray.length];
            for (int i = 0; i < boxedArray.length; ++i) {
                boxedArray[i] = Float.valueOf(unboxedArray[i]);
            }
            return (Object[])ClassUtils.castToType(boxedArray);
        }
        if (elementClass.equals(Boolean.TYPE)) {
            boolean[] unboxedArray = (boolean[])array;
            Boolean[] boxedArray = new Boolean[unboxedArray.length];
            for (int i = 0; i < boxedArray.length; ++i) {
                boxedArray[i] = unboxedArray[i];
            }
            return (Object[])ClassUtils.castToType(boxedArray);
        }
        if (elementClass.equals(Character.TYPE)) {
            char[] unboxedArray = (char[])array;
            Character[] boxedArray = new Character[unboxedArray.length];
            for (int i = 0; i < boxedArray.length; ++i) {
                boxedArray[i] = Character.valueOf(unboxedArray[i]);
            }
            return (Object[])ClassUtils.castToType(boxedArray);
        }
        throw new IllegalArgumentException("Elements of array are not primitive");
    }

    public static <T, O> O unboxArray(T array, Class<?> elementClass) {
        if (elementClass.equals(Integer.class)) {
            return (O)ClassUtils.castToType(Arrays.stream((Integer[])array).mapToInt(Integer::intValue).toArray());
        }
        if (elementClass.equals(Long.class)) {
            return (O)ClassUtils.castToType(Arrays.stream((Long[])array).mapToLong(Long::longValue).toArray());
        }
        if (elementClass.equals(Double.class)) {
            return (O)ClassUtils.castToType(Arrays.stream((Double[])array).mapToDouble(Double::doubleValue).toArray());
        }
        if (elementClass.equals(Byte.class)) {
            Byte[] boxedArray = (Byte[])array;
            byte[] unboxedArray = new byte[boxedArray.length];
            for (int i = 0; i < boxedArray.length; ++i) {
                unboxedArray[i] = boxedArray[i];
            }
            return (O)ClassUtils.castToType(unboxedArray);
        }
        if (elementClass.equals(Short.class)) {
            Short[] boxedArray = (Short[])array;
            short[] unboxedArray = new short[boxedArray.length];
            for (int i = 0; i < boxedArray.length; ++i) {
                unboxedArray[i] = boxedArray[i];
            }
            return (O)ClassUtils.castToType(unboxedArray);
        }
        if (elementClass.equals(Float.class)) {
            Float[] boxedArray = (Float[])array;
            float[] unboxedArray = new float[boxedArray.length];
            for (int i = 0; i < boxedArray.length; ++i) {
                unboxedArray[i] = boxedArray[i].floatValue();
            }
            return (O)ClassUtils.castToType(unboxedArray);
        }
        if (elementClass.equals(Boolean.class)) {
            Boolean[] boxedArray = (Boolean[])array;
            boolean[] unboxedArray = new boolean[boxedArray.length];
            for (int i = 0; i < boxedArray.length; ++i) {
                unboxedArray[i] = boxedArray[i];
            }
            return (O)ClassUtils.castToType(unboxedArray);
        }
        if (elementClass.equals(Character.class)) {
            Character[] boxedArray = (Character[])array;
            char[] unboxedArray = new char[boxedArray.length];
            for (int i = 0; i < boxedArray.length; ++i) {
                unboxedArray[i] = boxedArray[i].charValue();
            }
            return (O)ClassUtils.castToType(unboxedArray);
        }
        throw new IllegalArgumentException("Elements of array are not primitive");
    }

    public static boolean isAssignableToLong(Class<?> clazz) {
        return clazz.equals(Long.TYPE) || clazz.equals(Long.class) || ClassUtils.isAssignableToInt(clazz);
    }

    public static boolean isAssignableToInt(Class<?> clazz) {
        return clazz.equals(Integer.TYPE) || clazz.equals(Integer.class) || ClassUtils.isAssignableToShort(clazz);
    }

    public static boolean isAssignableToShort(Class<?> clazz) {
        return clazz.equals(Short.TYPE) || clazz.equals(Short.class) || ClassUtils.isAssignableToByte(clazz);
    }

    public static boolean isAssignableToByte(Class<?> clazz) {
        return clazz.equals(Byte.TYPE) || clazz.equals(Byte.class);
    }

    public static <LongType> LongType castLongToActualType(long l, Class<LongType> clazz) {
        if (clazz.equals(Long.TYPE) || clazz.equals(Long.class)) {
            return (LongType)ClassUtils.castToType(l);
        }
        return ClassUtils.castIntToActualType((int)l, clazz);
    }

    public static <IntType> IntType castIntToActualType(int i, Class<IntType> clazz) {
        if (clazz.equals(Integer.TYPE) || clazz.equals(Integer.class)) {
            return (IntType)ClassUtils.castToType(i);
        }
        return ClassUtils.castShortToActualType((short)i, clazz);
    }

    public static <ShortType> ShortType castShortToActualType(short s, Class<ShortType> clazz) {
        if (clazz.equals(Short.TYPE) || clazz.equals(Short.class)) {
            return (ShortType)ClassUtils.castToType(s);
        }
        if (clazz.equals(Byte.TYPE) || clazz.equals(Byte.class)) {
            return (ShortType)ClassUtils.castToType((byte)s);
        }
        throw new IllegalArgumentException(String.format("Cannot deserialize short to class %s", clazz.getCanonicalName()));
    }

    public static List<Type> getTypeParametersOfField(Field field) {
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType) {
            return ClassUtils.getTypeParametersOfGeneric(genericType);
        }
        return List.of();
    }

    public static TypeDescr getTypeDescription(Type type) {
        if (type instanceof Class) {
            return new TypeDescr((Class)type, List.of());
        }
        if (type instanceof ParameterizedType) {
            return new TypeDescr((Class)((ParameterizedType)type).getRawType(), ClassUtils.getTypeParametersOfGeneric(type));
        }
        throw new IllegalArgumentException("Type must be Class or ParameterizedType");
    }

    public static boolean isFieldTransient(Field field, Set<String> transientAnnotations) {
        return (field.getModifiers() & 0x80) != 0 || ClassUtils.anyOfAnnotationsPresent(field, transientAnnotations);
    }

    public static boolean anyOfAnnotationsPresent(AnnotatedElement element, Set<String> annotations) {
        return Arrays.stream(element.getDeclaredAnnotations()).map(annotation -> annotation.annotationType().getName()).anyMatch(annotations::contains);
    }

    public static boolean anyMatchWithAnnotation(Annotation annotation, Set<String> annotationNames) {
        return annotationNames.contains(annotation.annotationType().getName());
    }

    public static Optional<Annotation> getAnnotationIfPresent(AnnotatedElement element, Set<String> annotations) {
        return Arrays.stream(element.getDeclaredAnnotations()).filter(annotation -> annotations.contains(annotation.annotationType().getName())).findAny();
    }

    public static <T> T getValueOfAnnotationProperty(Annotation annotation, String propertyName) {
        try {
            return (T)ClassUtils.castToType(annotation.annotationType().getDeclaredMethod(propertyName, new Class[0]).invoke((Object)annotation, new Object[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(String.format("Cannot get value of property '%s' of annotation '%s'", propertyName, annotation), e);
        }
    }

    public static void setFieldsAccessibleToTrue(List<Field> fields) {
        fields.forEach(field -> field.setAccessible(true));
    }

    public static Function<Class<?>, Constructor<?>> getConstructorOrDefaultFor(Class<?> clazz) {
        return objectClass -> {
            try {
                return ClassUtils.getEmptyConstructor(objectClass);
            }
            catch (IllegalArgumentException e) {
                return ClassUtils.getEmptyConstructor(clazz);
            }
        };
    }

    public static <T> Constructor<T> getEmptyConstructor(Class<T> objectClass) {
        try {
            Constructor<T> constructor = objectClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("%s must have an empty constructor", objectClass.getCanonicalName()), e);
        }
    }

    public static <ObjectType> ObjectType getInstanceWithoutArguments(Constructor<?> defaultConstructor) {
        try {
            return (ObjectType)ClassUtils.castToType(defaultConstructor.newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalArgumentException("Constructor must have no arguments", e);
        }
    }

    private static List<Type> getTypeParametersOfGeneric(Type type) {
        return List.of(((ParameterizedType)type).getActualTypeArguments());
    }

    public static class TypeDescr {
        Class<?> typeClass;
        List<Type> typeParameters;

        public TypeDescr(Class<?> clazz, List<Type> typeParameters) {
            this.typeClass = clazz;
            this.typeParameters = typeParameters;
        }

        public Class<?> getTypeClass() {
            return this.typeClass;
        }

        public List<Type> getTypeParameters() {
            return this.typeParameters;
        }
    }
}

