"""Utility functions for getting country flag codes."""


def get_country_flag(country: str) -> str:
    """
    Get the country flag code for a given country.

    Args:
        country (str): The country name (e.g., "United States", "Germany").

    Returns:
        str: The corresponding country flag code.

    Raises:
        KeyError: If the country is not found in the lookup table.
    """
    lookup = {
        "Afghanistan": ":af:",
        "Aland Islands": ":ax:",
        "Albania": ":al:",
        "Algeria": ":dz:",
        "American Samoa": ":as:",
        "Andorra": ":ad:",
        "Angola": ":ao:",
        "Anguilla": ":ai:",
        "Antigua and Barbuda": ":ag:",
        "Argentina": ":ar:",
        "Armenia": ":am:",
        "Aruba": ":aw:",
        "Australia": ":au:",
        "Austria": ":at:",
        "Azerbaijan": ":az:",
        "Bahamas": ":bs:",
        "Bahrain": ":bh:",
        "Bangladesh": ":bd:",
        "Barbados": ":bb:",
        "Belarus": ":by:",
        "Belgium": ":be:",
        "Belize": ":bz:",
        "Benin": ":bj:",
        "Bermuda": ":bm:",
        "Bhutan": ":bt:",
        "Bolivia (Plurinational State of)": ":bo:",
        "Bonaire, Sint Eustatius and Saba": ":bq:",
        "Bosnia and Herzegovina": ":ba:",
        "Botswana": ":bw:",
        "Brazil": ":br:",
        "British Indian Ocean Territory": ":io:",
        "Brunei Darussalam": ":bn:",
        "Bulgaria": ":bg:",
        "Burkina Faso": ":bf:",
        "Burundi": ":bi:",
        "Cabo Verde": ":cv:",
        "Cambodia": ":kh:",
        "Cameroon": ":cm:",
        "Canada": ":ca:",
        "Cayman Islands": ":ky:",
        "Central African Republic": ":cf:",
        "Chad": ":td:",
        "Chile": ":cl:",
        "China": ":cn:",
        "Christmas Island": ":cx:",
        "Cocos (Keeling) Islands": ":cc:",
        "Colombia": ":co:",
        "Comoros": ":km:",
        "Cook Islands": ":ck:",
        "Costa Rica": ":cr:",
        "Côte d'Ivoire": ":ci:",
        "Croatia": ":hr:",
        "Cuba": ":cu:",
        "Curaçao": ":cw:",
        "Cyprus": ":cy:",
        "Czech Republic": ":cz:",
        "Democratic Republic of the Congo": ":cd:",
        "Denmark": ":dk:",
        "Djibouti": ":dj:",
        "Dominica": ":dm:",
        "Dominican Republic": ":do:",
        "Ecuador": ":ec:",
        "Egypt": ":eg:",
        "El Salvador": ":sv:",
        "Equatorial Guinea": ":gq:",
        "Eritrea": ":er:",
        "Estonia": ":ee:",
        "Ethiopia": ":et:",
        "European Union": ":eu:",
        "Falkland Islands": ":fk:",
        "Faroe Islands": ":fo:",
        "Federated States of Micronesia": ":fm:",
        "Fiji": ":fj:",
        "Finland": ":fi:",
        "North Macedonia": ":mk:",
        "France": ":fr:",
        "French Guiana": ":gf:",
        "French Polynesia": ":pf:",
        "French Southern Territories": ":tf:",
        "Gabon": ":ga:",
        "Gambia": ":gm:",
        "Georgia": ":ge:",
        "Germany": ":de:",
        "Ghana": ":gh:",
        "Gibraltar": ":gi:",
        "Greece": ":gr:",
        "Greenland": ":gl:",
        "Grenada": ":gd:",
        "Guadeloupe": ":gp:",
        "Guam": ":gu:",
        "Guatemala": ":gt:",
        "Guernsey": ":gg:",
        "Guinea": ":gn:",
        "Guinea-Bissau": ":gw:",
        "Guyana": ":gy:",
        "Haiti": ":ht:",
        "Holy See": ":va:",
        "Honduras": ":hn:",
        "Hong Kong": ":hk:",
        "Hungary": ":hu:",
        "Iceland": ":is:",
        "India": ":in:",
        "Indonesia": ":id:",
        "Iran (Islamic Republic of)": ":ir:",
        "Iraq": ":iq:",
        "Ireland": ":ie:",
        "Isle of Man": ":im:",
        "Israel": ":il:",
        "Italy": ":it:",
        "Jamaica": ":jm:",
        "Japan": ":jp:",
        "Jersey": ":je:",
        "Jordan": ":jo:",
        "Kazakhstan": ":kz:",
        "Kenya": ":ke:",
        "Kiribati": ":ki:",
        "Kosovo": ":xk:",
        "Kuwait": ":kw:",
        "Kyrgyzstan": ":kg:",
        "Laos": ":la:",
        "Latvia": ":lv:",
        "Lebanon": ":lb:",
        "Lesotho": ":ls:",
        "Liberia": ":lr:",
        "Libya": ":ly:",
        "Liechtenstein": ":li:",
        "Lithuania": ":lt:",
        "Luxembourg": ":lu:",
        "Macau": ":mo:",
        "Madagascar": ":mg:",
        "Malawi": ":mw:",
        "Malaysia": ":my:",
        "Maldives": ":mv:",
        "Mali": ":ml:",
        "Malta": ":mt:",
        "Marshall Islands": ":mh:",
        "Martinique": ":mq:",
        "Mauritania": ":mr:",
        "Mauritius": ":mu:",
        "Mayotte": ":yt:",
        "Mexico": ":mx:",
        "Moldova": ":md:",
        "Monaco": ":mc:",
        "Mongolia": ":mn:",
        "Montenegro": ":me:",
        "Montserrat": ":ms:",
        "Morocco": ":ma:",
        "Mozambique": ":mz:",
        "Myanmar": ":mm:",
        "Namibia": ":na:",
        "Nauru": ":nr:",
        "Nepal": ":np:",
        "Netherlands": ":nl:",
        "New Caledonia": ":nc:",
        "New Zealand": ":nz:",
        "Nicaragua": ":ni:",
        "Niger": ":ne:",
        "Nigeria": ":ng:",
        "Niue": ":nu:",
        "Norfolk Island": ":nf:",
        "North Korea": ":kp:",
        "Northern Mariana Islands": ":mp:",
        "Norway": ":no:",
        "Oman": ":om:",
        "Pakistan": ":pk:",
        "Palau": ":pw:",
        "Panama": ":pa:",
        "Papua New Guinea": ":pg:",
        "Paraguay": ":py:",
        "Peru": ":pe:",
        "Philippines": ":ph:",
        "Pitcairn": ":pn:",
        "Poland": ":pl:",
        "Portugal": ":pt:",
        "Puerto Rico": ":pr:",
        "Qatar": ":qa:",
        "Republic of the Congo": ":cg:",
        "Réunion": ":re:",
        "Romania": ":ro:",
        "Russia": ":ru:",
        "Rwanda": ":rw:",
        "Saint Barthélemy": ":bl:",
        "Saint Helena, Ascension and Tristan da Cunha": ":sh:",
        "Saint Kitts and Nevis": ":kn:",
        "Saint Lucia": ":lc:",
        "Saint Martin": ":mf:",
        "Saint Pierre and Miquelon": ":pm:",
        "Saint Vincent and the Grenadines": ":vc:",
        "Samoa": ":ws:",
        "San Marino": ":sm:",
        "Sao Tome and Principe": ":st:",
        "Saudi Arabia": ":sa:",
        "Senegal": ":sn:",
        "Serbia": ":rs:",
        "Seychelles": ":sc:",
        "Sierra Leone": ":sl:",
        "Singapore": ":sg:",
        "Sint Maarten": ":sx:",
        "Slovakia": ":sk:",
        "Slovenia": ":si:",
        "Solomon Islands": ":sb:",
        "Somalia": ":so:",
        "South Africa": ":za:",
        "South Georgia and the South Sandwich Islands": ":gs:",
        "South Korea": ":kr:",
        "South Sudan": ":ss:",
        "Spain": ":es:",
        "Sri Lanka": ":lk:",
        "State of Palestine": ":ps:",
        "Sudan": ":sd:",
        "Suriname": ":sr:",
        "Svalbard and Jan Mayen": ":sj:",
        "Swaziland": ":sz:",
        "Sweden": ":se:",
        "Switzerland": ":ch:",
        "Syrian Arab Republic": ":sy:",
        "Taiwan": ":tw:",
        "Tajikistan": ":tj:",
        "Tanzania": ":tz:",
        "Thailand": ":th:",
        "Timor-Leste": ":tl:",
        "Togo": ":tg:",
        "Tokelau": ":tk:",
        "Tonga": ":to:",
        "Trinidad and Tobago": ":tt:",
        "Tunisia": ":tn:",
        "Türkiye": ":tr:",
        "Turkmenistan": ":tm:",
        "Turks and Caicos Islands": ":tc:",
        "Tuvalu": ":tv:",
        "Uganda": ":ug:",
        "UK - England": ":gb-eng:",
        "UK - Northern Ireland": ":gb-nir:",
        "UK - Scotland": ":gb-sct:",
        "UK - Wales": ":gb-wls:",
        "Ukraine": ":ua:",
        "United Arab Emirates": ":ae:",
        "United Kingdom": ":gb:",
        "United States Minor Outlying Islands": ":um:",
        "United States of America": ":us:",
        "Uruguay": ":uy:",
        "Uzbekistan": ":uz:",
        "Vanuatu": ":vu:",
        "Venezuela (Bolivarian Republic of)": ":ve:",
        "Vietnam": ":vn:",
        "Virgin Islands (British)": ":vg:",
        "Virgin Islands (U.S.)": ":vi:",
        "Wallis and Futuna": ":wf:",
        "Western Sahara": ":eh:",
        "Yemen": ":ye:",
        "Zambia": ":zm:",
        "Zimbabwe": ":zw:",
        "U.S.": ":us:",
        "Euro zone": ":eu:",
        "UK": ":gb:",
    }
    return lookup[country]
