"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2023.07.26
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.api_client import ApiClient, Endpoint as _Endpoint
from agilicus_api.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from agilicus_api.model.application import Application
from agilicus_api.model.environment import Environment
from agilicus_api.model.environment_config import EnvironmentConfig
from agilicus_api.model.error_message import ErrorMessage
from agilicus_api.model.list_application_summary_response import ListApplicationSummaryResponse
from agilicus_api.model.list_applications_response import ListApplicationsResponse
from agilicus_api.model.list_combined_rules_response import ListCombinedRulesResponse
from agilicus_api.model.list_configs_response import ListConfigsResponse
from agilicus_api.model.list_environment_configs_response import ListEnvironmentConfigsResponse
from agilicus_api.model.list_role_to_rule_entries import ListRoleToRuleEntries
from agilicus_api.model.list_roles import ListRoles
from agilicus_api.model.list_rules import ListRules
from agilicus_api.model.org_scope_patch_document import OrgScopePatchDocument
from agilicus_api.model.role_to_rule_entry import RoleToRuleEntry
from agilicus_api.model.role_v2 import RoleV2
from agilicus_api.model.rule_scope_enum import RuleScopeEnum
from agilicus_api.model.rule_v2 import RuleV2
from agilicus_api.model.runtime_status import RuntimeStatus
from agilicus_api.model.usage_metric import UsageMetric
from agilicus_api.model.usage_metrics import UsageMetrics


class ApplicationsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __add_config(
            self,
            app_id,
            env_name,
            environment_config,
            **kwargs
        ):
            """Add an environment configuration row  # noqa: E501

            Add an environment configuration row  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_config(app_id, env_name, environment_config, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str): Application unique identifier
                env_name (str): The name of an Environment
                environment_config (EnvironmentConfig):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                EnvironmentConfig
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_id'] = \
                app_id
            kwargs['env_name'] = \
                env_name
            kwargs['environment_config'] = \
                environment_config
            return self.call_with_http_info(**kwargs)

        if self.add_config is None:
            self.add_config = _Endpoint(
                settings={
                    'response_type': (EnvironmentConfig,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/applications/{app_id}/environments/{env_name}/configs',
                    'operation_id': 'add_config',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'app_id',
                        'env_name',
                        'environment_config',
                    ],
                    'required': [
                        'app_id',
                        'env_name',
                        'environment_config',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_id',
                        'env_name',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                        ('env_name',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'app_id':
                            (str,),
                        'env_name':
                            (str,),
                        'environment_config':
                            (EnvironmentConfig,),
                    },
                    'attribute_map': {
                        'app_id': 'app_id',
                        'env_name': 'env_name',
                    },
                    'location_map': {
                        'app_id': 'path',
                        'env_name': 'path',
                        'environment_config': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__add_config
            )

        def __add_role(
            self,
            app_id,
            role_v2,
            **kwargs
        ):
            """Add a role to the application.  # noqa: E501

            Add a role to the application.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_role(app_id, role_v2, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str): Application unique identifier
                role_v2 (RoleV2):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RoleV2
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_id'] = \
                app_id
            kwargs['role_v2'] = \
                role_v2
            return self.call_with_http_info(**kwargs)

        if self.add_role is None:
            self.add_role = _Endpoint(
                settings={
                    'response_type': (RoleV2,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/applications/{app_id}/roles',
                    'operation_id': 'add_role',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'app_id',
                        'role_v2',
                    ],
                    'required': [
                        'app_id',
                        'role_v2',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_id',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'app_id':
                            (str,),
                        'role_v2':
                            (RoleV2,),
                    },
                    'attribute_map': {
                        'app_id': 'app_id',
                    },
                    'location_map': {
                        'app_id': 'path',
                        'role_v2': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__add_role
            )

        def __add_role_to_rule_entry(
            self,
            app_id,
            role_to_rule_entry,
            **kwargs
        ):
            """Add a rule to a role in the application.  # noqa: E501

            Add a rule to a role in the application.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_role_to_rule_entry(app_id, role_to_rule_entry, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str): Application unique identifier
                role_to_rule_entry (RoleToRuleEntry):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RoleToRuleEntry
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_id'] = \
                app_id
            kwargs['role_to_rule_entry'] = \
                role_to_rule_entry
            return self.call_with_http_info(**kwargs)

        if self.add_role_to_rule_entry is None:
            self.add_role_to_rule_entry = _Endpoint(
                settings={
                    'response_type': (RoleToRuleEntry,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/applications/{app_id}/role_to_rule_entries',
                    'operation_id': 'add_role_to_rule_entry',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'app_id',
                        'role_to_rule_entry',
                    ],
                    'required': [
                        'app_id',
                        'role_to_rule_entry',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_id',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'app_id':
                            (str,),
                        'role_to_rule_entry':
                            (RoleToRuleEntry,),
                    },
                    'attribute_map': {
                        'app_id': 'app_id',
                    },
                    'location_map': {
                        'app_id': 'path',
                        'role_to_rule_entry': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__add_role_to_rule_entry
            )

        def __add_rule(
            self,
            app_id,
            rule_v2,
            **kwargs
        ):
            """Add a rule to the application.  # noqa: E501

            Add a rule to the application.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_rule(app_id, rule_v2, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str): Application unique identifier
                rule_v2 (RuleV2):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RuleV2
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_id'] = \
                app_id
            kwargs['rule_v2'] = \
                rule_v2
            return self.call_with_http_info(**kwargs)

        if self.add_rule is None:
            self.add_rule = _Endpoint(
                settings={
                    'response_type': (RuleV2,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/applications/{app_id}/rules',
                    'operation_id': 'add_rule',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'app_id',
                        'rule_v2',
                    ],
                    'required': [
                        'app_id',
                        'rule_v2',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_id',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'app_id':
                            (str,),
                        'rule_v2':
                            (RuleV2,),
                    },
                    'attribute_map': {
                        'app_id': 'app_id',
                    },
                    'location_map': {
                        'app_id': 'path',
                        'rule_v2': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__add_rule
            )

        def __create_application(
            self,
            application,
            **kwargs
        ):
            """Create an application  # noqa: E501

            Create an application according to spec  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_application(application, async_req=True)
            >>> result = thread.get()

            Args:
                application (Application):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Application
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['application'] = \
                application
            return self.call_with_http_info(**kwargs)

        if self.create_application is None:
            self.create_application = _Endpoint(
                settings={
                    'response_type': (Application,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/applications',
                    'operation_id': 'create_application',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'application',
                    ],
                    'required': [
                        'application',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'application':
                            (Application,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'application': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_application
            )

        def __delete_application(
            self,
            app_id,
            **kwargs
        ):
            """Remove an application  # noqa: E501

            Remove an application  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_application(app_id, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str): Application unique identifier

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_id'] = \
                app_id
            return self.call_with_http_info(**kwargs)

        if self.delete_application is None:
            self.delete_application = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/applications/{app_id}',
                    'operation_id': 'delete_application',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'app_id',
                        'org_id',
                    ],
                    'required': [
                        'app_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_id',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'app_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'app_id': 'app_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'app_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_application
            )

        def __delete_config(
            self,
            app_id,
            env_name,
            env_config_id,
            maintenance_org_id,
            **kwargs
        ):
            """Remove an environment configuration  # noqa: E501

            Remove an environment configuration  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_config(app_id, env_name, env_config_id, maintenance_org_id, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str): Application unique identifier
                env_name (str): The name of an Environment
                env_config_id (str): environment configuration id
                maintenance_org_id (str): Organisation unique identifier for an object being maintained by an organisation different than it. 

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_id'] = \
                app_id
            kwargs['env_name'] = \
                env_name
            kwargs['env_config_id'] = \
                env_config_id
            kwargs['maintenance_org_id'] = \
                maintenance_org_id
            return self.call_with_http_info(**kwargs)

        if self.delete_config is None:
            self.delete_config = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/applications/{app_id}/environments/{env_name}/configs/{env_config_id}',
                    'operation_id': 'delete_config',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'app_id',
                        'env_name',
                        'env_config_id',
                        'maintenance_org_id',
                    ],
                    'required': [
                        'app_id',
                        'env_name',
                        'env_config_id',
                        'maintenance_org_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_id',
                        'env_name',
                        'env_config_id',
                        'maintenance_org_id',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                        ('env_name',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                        ('env_config_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                        ('maintenance_org_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'app_id':
                            (str,),
                        'env_name':
                            (str,),
                        'env_config_id':
                            (str,),
                        'maintenance_org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'app_id': 'app_id',
                        'env_name': 'env_name',
                        'env_config_id': 'env_config_id',
                        'maintenance_org_id': 'maintenance_org_id',
                    },
                    'location_map': {
                        'app_id': 'path',
                        'env_name': 'path',
                        'env_config_id': 'path',
                        'maintenance_org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_config
            )

        def __delete_role(
            self,
            app_id,
            role_id,
            **kwargs
        ):
            """Remove a role  # noqa: E501

            Remove a role  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_role(app_id, role_id, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str): Application unique identifier
                role_id (str): The id of a role

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_id'] = \
                app_id
            kwargs['role_id'] = \
                role_id
            return self.call_with_http_info(**kwargs)

        if self.delete_role is None:
            self.delete_role = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/applications/{app_id}/roles/{role_id}',
                    'operation_id': 'delete_role',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'app_id',
                        'role_id',
                        'org_id',
                    ],
                    'required': [
                        'app_id',
                        'role_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_id',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'app_id':
                            (str,),
                        'role_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'app_id': 'app_id',
                        'role_id': 'role_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'app_id': 'path',
                        'role_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_role
            )

        def __delete_role_to_rule_entry(
            self,
            app_id,
            role_to_rule_entry_id,
            **kwargs
        ):
            """Remove a role_to_rule_entry  # noqa: E501

            Remove a role_to_rule_entry  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_role_to_rule_entry(app_id, role_to_rule_entry_id, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str): Application unique identifier
                role_to_rule_entry_id (str): The id of a role to rule entry

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_id'] = \
                app_id
            kwargs['role_to_rule_entry_id'] = \
                role_to_rule_entry_id
            return self.call_with_http_info(**kwargs)

        if self.delete_role_to_rule_entry is None:
            self.delete_role_to_rule_entry = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/applications/{app_id}/role_to_rule_entries/{role_to_rule_entry_id}',
                    'operation_id': 'delete_role_to_rule_entry',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'app_id',
                        'role_to_rule_entry_id',
                        'org_id',
                    ],
                    'required': [
                        'app_id',
                        'role_to_rule_entry_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_id',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'app_id':
                            (str,),
                        'role_to_rule_entry_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'app_id': 'app_id',
                        'role_to_rule_entry_id': 'role_to_rule_entry_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'app_id': 'path',
                        'role_to_rule_entry_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_role_to_rule_entry
            )

        def __delete_rule(
            self,
            app_id,
            rule_id,
            **kwargs
        ):
            """Remove a rule  # noqa: E501

            Remove a rule  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_rule(app_id, rule_id, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str): Application unique identifier
                rule_id (str): The id of a rule

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_id'] = \
                app_id
            kwargs['rule_id'] = \
                rule_id
            return self.call_with_http_info(**kwargs)

        if self.delete_rule is None:
            self.delete_rule = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/applications/{app_id}/rules/{rule_id}',
                    'operation_id': 'delete_rule',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'app_id',
                        'rule_id',
                        'org_id',
                    ],
                    'required': [
                        'app_id',
                        'rule_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_id',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'app_id':
                            (str,),
                        'rule_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'app_id': 'app_id',
                        'rule_id': 'rule_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'app_id': 'path',
                        'rule_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_rule
            )

        def __get_all_usage_metrics(
            self,
            org_id,
            **kwargs
        ):
            """Get all resource metrics for the Applications API  # noqa: E501

            Retrieves all resource metrics for the Applications API for a specified the org_id.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_all_usage_metrics(org_id, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Organisation Unique identifier

            Keyword Args:
                org_ids ([str]): The list of org ids to search for. Each org will be searched for independently.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UsageMetrics
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            return self.call_with_http_info(**kwargs)

        if self.get_all_usage_metrics is None:
            self.get_all_usage_metrics = _Endpoint(
                settings={
                    'response_type': (UsageMetrics,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/resources/usage_metrics',
                    'operation_id': 'get_all_usage_metrics',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'org_ids',
                    ],
                    'required': [
                        'org_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'org_ids':
                            ([str],),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'org_ids': 'org_ids',
                    },
                    'location_map': {
                        'org_id': 'query',
                        'org_ids': 'query',
                    },
                    'collection_format_map': {
                        'org_ids': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_all_usage_metrics
            )

        def __get_application(
            self,
            app_id,
            **kwargs
        ):
            """Get a application  # noqa: E501

            Get a application  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_application(app_id, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str): Application unique identifier

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                assigned_org_id (str): Organisation unique identifier for an assigned object. [optional]
                include_migrated_environments (bool): Application environments have now been migrated to utilize their own application. While upgrading these environments to their own application, existing clients may still request the usage of multiple environments within an application. As such, the default behavior for retrieval of applications is to not include these new migrated environment applications. . [optional]
                get_scopes (bool): In an application or environment GET response, will render all scopes pertaining to an application/environment. For example, rendering will iterate through launchers bound to the application and return all associated application_services as scopes. The returned scopes will also return any scopes provided by the environments application_config.. [optional] if omitted the server will use the default value of False
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Application
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_id'] = \
                app_id
            return self.call_with_http_info(**kwargs)

        if self.get_application is None:
            self.get_application = _Endpoint(
                settings={
                    'response_type': (Application,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/applications/{app_id}',
                    'operation_id': 'get_application',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'app_id',
                        'org_id',
                        'assigned_org_id',
                        'include_migrated_environments',
                        'get_scopes',
                    ],
                    'required': [
                        'app_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_id',
                        'assigned_org_id',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                        ('assigned_org_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'app_id':
                            (str,),
                        'org_id':
                            (str,),
                        'assigned_org_id':
                            (str,),
                        'include_migrated_environments':
                            (bool,),
                        'get_scopes':
                            (bool,),
                    },
                    'attribute_map': {
                        'app_id': 'app_id',
                        'org_id': 'org_id',
                        'assigned_org_id': 'assigned_org_id',
                        'include_migrated_environments': 'include_migrated_environments',
                        'get_scopes': 'get_scopes',
                    },
                    'location_map': {
                        'app_id': 'path',
                        'org_id': 'query',
                        'assigned_org_id': 'query',
                        'include_migrated_environments': 'query',
                        'get_scopes': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_application
            )

        def __get_application_usage_metrics(
            self,
            org_id,
            **kwargs
        ):
            """Get application metrics  # noqa: E501

            Retrieves all application metrics related to the org_id.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_application_usage_metrics(org_id, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Organisation Unique identifier

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UsageMetric
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            return self.call_with_http_info(**kwargs)

        if self.get_application_usage_metrics is None:
            self.get_application_usage_metrics = _Endpoint(
                settings={
                    'response_type': (UsageMetric,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/applications/usage_metrics',
                    'operation_id': 'get_application_usage_metrics',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                    ],
                    'required': [
                        'org_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_application_usage_metrics
            )

        def __get_config(
            self,
            app_id,
            env_name,
            env_config_id,
            maintenance_org_id,
            **kwargs
        ):
            """Get environment configuration  # noqa: E501

            Retrieve environment configuration   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_config(app_id, env_name, env_config_id, maintenance_org_id, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str): Application unique identifier
                env_name (str): The name of an Environment
                env_config_id (str): environment configuration id
                maintenance_org_id (str): Organisation unique identifier for an object being maintained by an organisation different than it. 

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                EnvironmentConfig
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_id'] = \
                app_id
            kwargs['env_name'] = \
                env_name
            kwargs['env_config_id'] = \
                env_config_id
            kwargs['maintenance_org_id'] = \
                maintenance_org_id
            return self.call_with_http_info(**kwargs)

        if self.get_config is None:
            self.get_config = _Endpoint(
                settings={
                    'response_type': (EnvironmentConfig,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/applications/{app_id}/environments/{env_name}/configs/{env_config_id}',
                    'operation_id': 'get_config',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'app_id',
                        'env_name',
                        'env_config_id',
                        'maintenance_org_id',
                    ],
                    'required': [
                        'app_id',
                        'env_name',
                        'env_config_id',
                        'maintenance_org_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_id',
                        'env_name',
                        'env_config_id',
                        'maintenance_org_id',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                        ('env_name',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                        ('env_config_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                        ('maintenance_org_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'app_id':
                            (str,),
                        'env_name':
                            (str,),
                        'env_config_id':
                            (str,),
                        'maintenance_org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'app_id': 'app_id',
                        'env_name': 'env_name',
                        'env_config_id': 'env_config_id',
                        'maintenance_org_id': 'maintenance_org_id',
                    },
                    'location_map': {
                        'app_id': 'path',
                        'env_name': 'path',
                        'env_config_id': 'path',
                        'maintenance_org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_config
            )

        def __get_environment(
            self,
            app_id,
            env_name,
            org_id,
            **kwargs
        ):
            """Get an environment  # noqa: E501

            This allows an environment maintainer to get an environment they maintain.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_environment(app_id, env_name, org_id, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str): Application unique identifier
                env_name (str): The name of an Environment
                org_id (str): Organisation unique identifier

            Keyword Args:
                get_scopes (bool): In an application or environment GET response, will render all scopes pertaining to an application/environment. For example, rendering will iterate through launchers bound to the application and return all associated application_services as scopes. The returned scopes will also return any scopes provided by the environments application_config.. [optional] if omitted the server will use the default value of False
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Environment
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_id'] = \
                app_id
            kwargs['env_name'] = \
                env_name
            kwargs['org_id'] = \
                org_id
            return self.call_with_http_info(**kwargs)

        if self.get_environment is None:
            self.get_environment = _Endpoint(
                settings={
                    'response_type': (Environment,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/applications/{app_id}/environments/{env_name}',
                    'operation_id': 'get_environment',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'app_id',
                        'env_name',
                        'org_id',
                        'get_scopes',
                    ],
                    'required': [
                        'app_id',
                        'env_name',
                        'org_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_id',
                        'env_name',
                        'org_id',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                        ('env_name',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                        ('org_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'app_id':
                            (str,),
                        'env_name':
                            (str,),
                        'org_id':
                            (str,),
                        'get_scopes':
                            (bool,),
                    },
                    'attribute_map': {
                        'app_id': 'app_id',
                        'env_name': 'env_name',
                        'org_id': 'org_id',
                        'get_scopes': 'get_scopes',
                    },
                    'location_map': {
                        'app_id': 'path',
                        'env_name': 'path',
                        'org_id': 'query',
                        'get_scopes': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_environment
            )

        def __get_role(
            self,
            app_id,
            role_id,
            **kwargs
        ):
            """Get a role  # noqa: E501

            Retrieves a given role by ID   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_role(app_id, role_id, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str): Application unique identifier
                role_id (str): The id of a role

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RoleV2
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_id'] = \
                app_id
            kwargs['role_id'] = \
                role_id
            return self.call_with_http_info(**kwargs)

        if self.get_role is None:
            self.get_role = _Endpoint(
                settings={
                    'response_type': (RoleV2,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/applications/{app_id}/roles/{role_id}',
                    'operation_id': 'get_role',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'app_id',
                        'role_id',
                        'org_id',
                    ],
                    'required': [
                        'app_id',
                        'role_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_id',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'app_id':
                            (str,),
                        'role_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'app_id': 'app_id',
                        'role_id': 'role_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'app_id': 'path',
                        'role_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_role
            )

        def __get_role_to_rule_entry(
            self,
            app_id,
            role_to_rule_entry_id,
            **kwargs
        ):
            """Get a role_to_rule_entry  # noqa: E501

            Retrieves a given role_to_rule_entry by ID   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_role_to_rule_entry(app_id, role_to_rule_entry_id, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str): Application unique identifier
                role_to_rule_entry_id (str): The id of a role to rule entry

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RoleToRuleEntry
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_id'] = \
                app_id
            kwargs['role_to_rule_entry_id'] = \
                role_to_rule_entry_id
            return self.call_with_http_info(**kwargs)

        if self.get_role_to_rule_entry is None:
            self.get_role_to_rule_entry = _Endpoint(
                settings={
                    'response_type': (RoleToRuleEntry,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/applications/{app_id}/role_to_rule_entries/{role_to_rule_entry_id}',
                    'operation_id': 'get_role_to_rule_entry',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'app_id',
                        'role_to_rule_entry_id',
                        'org_id',
                    ],
                    'required': [
                        'app_id',
                        'role_to_rule_entry_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_id',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'app_id':
                            (str,),
                        'role_to_rule_entry_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'app_id': 'app_id',
                        'role_to_rule_entry_id': 'role_to_rule_entry_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'app_id': 'path',
                        'role_to_rule_entry_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_role_to_rule_entry
            )

        def __get_rule(
            self,
            app_id,
            rule_id,
            **kwargs
        ):
            """Get a rule  # noqa: E501

            Retrieves a given rule by ID   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_rule(app_id, rule_id, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str): Application unique identifier
                rule_id (str): The id of a rule

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RuleV2
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_id'] = \
                app_id
            kwargs['rule_id'] = \
                rule_id
            return self.call_with_http_info(**kwargs)

        if self.get_rule is None:
            self.get_rule = _Endpoint(
                settings={
                    'response_type': (RuleV2,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/applications/{app_id}/rules/{rule_id}',
                    'operation_id': 'get_rule',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'app_id',
                        'rule_id',
                        'org_id',
                    ],
                    'required': [
                        'app_id',
                        'rule_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_id',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'app_id':
                            (str,),
                        'rule_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'app_id': 'app_id',
                        'rule_id': 'rule_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'app_id': 'path',
                        'rule_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_rule
            )

        def __list_application_summaries(
            self,
            **kwargs
        ):
            """List application summaries  # noqa: E501

            Retrieve all application summaries corresponding to the provided parameters. One summary will exist per organisation assigned to the application. If a single org id is provided in the `org_id` parameter, then all assignments for all applications owned by that org will be listed. If a list of org ids are provided via the `assigned_org_ids` parameter, then the assignments will be constrained to ones for those org ids. Note that these two org id parameters can work together. One constrains the applications, and the other the assignments, so the combination of the two could be used to show a subset of the assignments for a given organisation's applications.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_application_summaries(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                assigned_org_ids ([str]): The asssigned org ids to search for. Each org will be searched for independently.. [optional]
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListApplicationSummaryResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_application_summaries is None:
            self.list_application_summaries = _Endpoint(
                settings={
                    'response_type': (ListApplicationSummaryResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/application_summaries',
                    'operation_id': 'list_application_summaries',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'assigned_org_ids',
                        'limit',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'assigned_org_ids':
                            ([str],),
                        'limit':
                            (int,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'assigned_org_ids': 'assigned_org_ids',
                        'limit': 'limit',
                    },
                    'location_map': {
                        'org_id': 'query',
                        'assigned_org_ids': 'query',
                        'limit': 'query',
                    },
                    'collection_format_map': {
                        'assigned_org_ids': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_application_summaries
            )

        def __list_applications(
            self,
            **kwargs
        ):
            """Get applications  # noqa: E501

            Retrieves all applications related to the org_id. Different types of relationship may be queried by setting the appropriate flags:   - assigned: Has an Environment assigned to the organisation.   - owned: Owned by the organisation.   - maintained: Has an Environment maintained by the organisation. Any combination of the relationship flags may be set. Note that if the organisation does not own the Application, but maintains or is assigned an environment only those assignments and environments for the querying organisation will be shown.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_applications(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                assigned_org_id (str): Organisation unique identifier for an assigned object. [optional]
                maintained (bool): Query for Applications maintained by the `org_id`. These are Applications which have an Environment whose `maintenance_org_id` is the `org_id`. . [optional]
                assigned (bool): Query for Applications assigned to the `org_id`. These are Applications with at least one Environment assigned to the `org_id`. . [optional]
                owned (bool): Query for Applications owned by the `org_id`.. [optional]
                updated_since (datetime): query since updated. [optional]
                show_status (bool): Whether the return value should include the status for included objects. If false the query may run faster but will not include status information. . [optional] if omitted the server will use the default value of False
                application_type ([str]): Query based on the application type. Multiple values are ORed together. . [optional] if omitted the server will use the default value of ["user_defined"]
                include_migrated_environments (bool): Application environments have now been migrated to utilize their own application. While upgrading these environments to their own application, existing clients may still request the usage of multiple environments within an application. As such, the default behavior for retrieval of applications is to not include these new migrated environment applications. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListApplicationsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_applications is None:
            self.list_applications = _Endpoint(
                settings={
                    'response_type': (ListApplicationsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/applications',
                    'operation_id': 'list_applications',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'assigned_org_id',
                        'maintained',
                        'assigned',
                        'owned',
                        'updated_since',
                        'show_status',
                        'application_type',
                        'include_migrated_environments',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                        'application_type',
                    ],
                    'validation': [
                        'assigned_org_id',
                    ]
                },
                root_map={
                    'validations': {
                        ('assigned_org_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                        ('application_type',): {

                            "USER_DEFINED": "user_defined",
                            "INTERNAL": "internal"
                        },
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'assigned_org_id':
                            (str,),
                        'maintained':
                            (bool,),
                        'assigned':
                            (bool,),
                        'owned':
                            (bool,),
                        'updated_since':
                            (datetime,),
                        'show_status':
                            (bool,),
                        'application_type':
                            ([str],),
                        'include_migrated_environments':
                            (bool,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'assigned_org_id': 'assigned_org_id',
                        'maintained': 'maintained',
                        'assigned': 'assigned',
                        'owned': 'owned',
                        'updated_since': 'updated_since',
                        'show_status': 'show_status',
                        'application_type': 'application_type',
                        'include_migrated_environments': 'include_migrated_environments',
                    },
                    'location_map': {
                        'org_id': 'query',
                        'assigned_org_id': 'query',
                        'maintained': 'query',
                        'assigned': 'query',
                        'owned': 'query',
                        'updated_since': 'query',
                        'show_status': 'query',
                        'application_type': 'query',
                        'include_migrated_environments': 'query',
                    },
                    'collection_format_map': {
                        'application_type': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_applications
            )

        def __list_combined_rules(
            self,
            **kwargs
        ):
            """List rules combined by scope or role  # noqa: E501

            Retrieve all role_to_rule_entries for an application. If assigned is true, this will list all role_to_rule_entries for applications assigned to the given org_id   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_combined_rules(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                scopes ([RuleScopeEnum]): The scopes of the rules to search for. Multiple values are ORed together.. [optional]
                app_id (str): Application unique identifier. [optional]
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                assigned (bool): Query for Applications assigned to the `org_id`. These are Applications with at least one Environment assigned to the `org_id`. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListCombinedRulesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_combined_rules is None:
            self.list_combined_rules = _Endpoint(
                settings={
                    'response_type': (ListCombinedRulesResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/combined_rules',
                    'operation_id': 'list_combined_rules',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'scopes',
                        'app_id',
                        'limit',
                        'assigned',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_id',
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'scopes':
                            ([RuleScopeEnum],),
                        'app_id':
                            (str,),
                        'limit':
                            (int,),
                        'assigned':
                            (bool,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'scopes': 'scopes',
                        'app_id': 'app_id',
                        'limit': 'limit',
                        'assigned': 'assigned',
                    },
                    'location_map': {
                        'org_id': 'query',
                        'scopes': 'query',
                        'app_id': 'query',
                        'limit': 'query',
                        'assigned': 'query',
                    },
                    'collection_format_map': {
                        'scopes': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_combined_rules
            )

        def __list_configs(
            self,
            app_id,
            env_name,
            maintenance_org_id,
            **kwargs
        ):
            """Get all environment configuration  # noqa: E501

            Retrieve all environment configuration   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_configs(app_id, env_name, maintenance_org_id, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str): Application unique identifier
                env_name (str): The name of an Environment
                maintenance_org_id (str): Organisation unique identifier for an object being maintained by an organisation different than it. 

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListConfigsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_id'] = \
                app_id
            kwargs['env_name'] = \
                env_name
            kwargs['maintenance_org_id'] = \
                maintenance_org_id
            return self.call_with_http_info(**kwargs)

        if self.list_configs is None:
            self.list_configs = _Endpoint(
                settings={
                    'response_type': (ListConfigsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/applications/{app_id}/environments/{env_name}/configs',
                    'operation_id': 'list_configs',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'app_id',
                        'env_name',
                        'maintenance_org_id',
                    ],
                    'required': [
                        'app_id',
                        'env_name',
                        'maintenance_org_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_id',
                        'env_name',
                        'maintenance_org_id',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                        ('env_name',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                        ('maintenance_org_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'app_id':
                            (str,),
                        'env_name':
                            (str,),
                        'maintenance_org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'app_id': 'app_id',
                        'env_name': 'env_name',
                        'maintenance_org_id': 'maintenance_org_id',
                    },
                    'location_map': {
                        'app_id': 'path',
                        'env_name': 'path',
                        'maintenance_org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_configs
            )

        def __list_environment_configs_all_apps(
            self,
            maintenance_org_id,
            **kwargs
        ):
            """Get all environment configuration for a given organisation.  # noqa: E501

            Retrieve all environment configuration for a organisation.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_environment_configs_all_apps(maintenance_org_id, async_req=True)
            >>> result = thread.get()

            Args:
                maintenance_org_id (str): Organisation unique identifier for an object being maintained by an organisation different than it. 

            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListEnvironmentConfigsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['maintenance_org_id'] = \
                maintenance_org_id
            return self.call_with_http_info(**kwargs)

        if self.list_environment_configs_all_apps is None:
            self.list_environment_configs_all_apps = _Endpoint(
                settings={
                    'response_type': (ListEnvironmentConfigsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/environment_configs',
                    'operation_id': 'list_environment_configs_all_apps',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'maintenance_org_id',
                        'limit',
                    ],
                    'required': [
                        'maintenance_org_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'maintenance_org_id',
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('maintenance_org_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'maintenance_org_id':
                            (str,),
                        'limit':
                            (int,),
                    },
                    'attribute_map': {
                        'maintenance_org_id': 'maintenance_org_id',
                        'limit': 'limit',
                    },
                    'location_map': {
                        'maintenance_org_id': 'query',
                        'limit': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_environment_configs_all_apps
            )

        def __list_role_to_rule_entries(
            self,
            app_id,
            **kwargs
        ):
            """Get all RoleToRuleEntries  # noqa: E501

            Retrieve all role_to_rule_entries for an application   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_role_to_rule_entries(app_id, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str): Application unique identifier

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListRoleToRuleEntries
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_id'] = \
                app_id
            return self.call_with_http_info(**kwargs)

        if self.list_role_to_rule_entries is None:
            self.list_role_to_rule_entries = _Endpoint(
                settings={
                    'response_type': (ListRoleToRuleEntries,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/applications/{app_id}/role_to_rule_entries',
                    'operation_id': 'list_role_to_rule_entries',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'app_id',
                        'org_id',
                        'limit',
                    ],
                    'required': [
                        'app_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_id',
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'app_id':
                            (str,),
                        'org_id':
                            (str,),
                        'limit':
                            (int,),
                    },
                    'attribute_map': {
                        'app_id': 'app_id',
                        'org_id': 'org_id',
                        'limit': 'limit',
                    },
                    'location_map': {
                        'app_id': 'path',
                        'org_id': 'query',
                        'limit': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_role_to_rule_entries
            )

        def __list_roles(
            self,
            app_id,
            **kwargs
        ):
            """Get all roles  # noqa: E501

            Retrieve all roles for an application   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_roles(app_id, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str): Application unique identifier

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListRoles
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_id'] = \
                app_id
            return self.call_with_http_info(**kwargs)

        if self.list_roles is None:
            self.list_roles = _Endpoint(
                settings={
                    'response_type': (ListRoles,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/applications/{app_id}/roles',
                    'operation_id': 'list_roles',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'app_id',
                        'org_id',
                        'limit',
                    ],
                    'required': [
                        'app_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_id',
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'app_id':
                            (str,),
                        'org_id':
                            (str,),
                        'limit':
                            (int,),
                    },
                    'attribute_map': {
                        'app_id': 'app_id',
                        'org_id': 'org_id',
                        'limit': 'limit',
                    },
                    'location_map': {
                        'app_id': 'path',
                        'org_id': 'query',
                        'limit': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_roles
            )

        def __list_rules(
            self,
            app_id,
            **kwargs
        ):
            """Get all rules  # noqa: E501

            Retrieve all rules for an application   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_rules(app_id, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str): Application unique identifier

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                scope (RuleScopeEnum): The scope of the rules to search for. [optional]
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListRules
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_id'] = \
                app_id
            return self.call_with_http_info(**kwargs)

        if self.list_rules is None:
            self.list_rules = _Endpoint(
                settings={
                    'response_type': (ListRules,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/applications/{app_id}/rules',
                    'operation_id': 'list_rules',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'app_id',
                        'org_id',
                        'scope',
                        'limit',
                    ],
                    'required': [
                        'app_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_id',
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'app_id':
                            (str,),
                        'org_id':
                            (str,),
                        'scope':
                            (RuleScopeEnum,),
                        'limit':
                            (int,),
                    },
                    'attribute_map': {
                        'app_id': 'app_id',
                        'org_id': 'org_id',
                        'scope': 'scope',
                        'limit': 'limit',
                    },
                    'location_map': {
                        'app_id': 'path',
                        'org_id': 'query',
                        'scope': 'query',
                        'limit': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_rules
            )

        def __list_runtime_status(
            self,
            app_id,
            env_name,
            org_id,
            **kwargs
        ):
            """Get an environment's runtime status  # noqa: E501

            Get an environment's runtime status   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_runtime_status(app_id, env_name, org_id, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str): Application unique identifier
                env_name (str): The name of an Environment
                org_id (str): Organisation unique identifier

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RuntimeStatus
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_id'] = \
                app_id
            kwargs['env_name'] = \
                env_name
            kwargs['org_id'] = \
                org_id
            return self.call_with_http_info(**kwargs)

        if self.list_runtime_status is None:
            self.list_runtime_status = _Endpoint(
                settings={
                    'response_type': (RuntimeStatus,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/applications/{app_id}/environments/{env_name}/status/runtime_status',
                    'operation_id': 'list_runtime_status',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'app_id',
                        'env_name',
                        'org_id',
                    ],
                    'required': [
                        'app_id',
                        'env_name',
                        'org_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_id',
                        'env_name',
                        'org_id',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                        ('env_name',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                        ('org_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'app_id':
                            (str,),
                        'env_name':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'app_id': 'app_id',
                        'env_name': 'env_name',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'app_id': 'path',
                        'env_name': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_runtime_status
            )

        def __replace_application(
            self,
            app_id,
            **kwargs
        ):
            """Create or update an application  # noqa: E501

            Create or update an application  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_application(app_id, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str): Application unique identifier

            Keyword Args:
                application (Application): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Application
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_id'] = \
                app_id
            return self.call_with_http_info(**kwargs)

        if self.replace_application is None:
            self.replace_application = _Endpoint(
                settings={
                    'response_type': (Application,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/applications/{app_id}',
                    'operation_id': 'replace_application',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'app_id',
                        'application',
                    ],
                    'required': [
                        'app_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_id',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'app_id':
                            (str,),
                        'application':
                            (Application,),
                    },
                    'attribute_map': {
                        'app_id': 'app_id',
                    },
                    'location_map': {
                        'app_id': 'path',
                        'application': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_application
            )

        def __replace_config(
            self,
            app_id,
            env_name,
            env_config_id,
            environment_config,
            **kwargs
        ):
            """Update environment configuration  # noqa: E501

            Update environment configuration   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_config(app_id, env_name, env_config_id, environment_config, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str): Application unique identifier
                env_name (str): The name of an Environment
                env_config_id (str): environment configuration id
                environment_config (EnvironmentConfig):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                EnvironmentConfig
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_id'] = \
                app_id
            kwargs['env_name'] = \
                env_name
            kwargs['env_config_id'] = \
                env_config_id
            kwargs['environment_config'] = \
                environment_config
            return self.call_with_http_info(**kwargs)

        if self.replace_config is None:
            self.replace_config = _Endpoint(
                settings={
                    'response_type': (EnvironmentConfig,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/applications/{app_id}/environments/{env_name}/configs/{env_config_id}',
                    'operation_id': 'replace_config',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'app_id',
                        'env_name',
                        'env_config_id',
                        'environment_config',
                    ],
                    'required': [
                        'app_id',
                        'env_name',
                        'env_config_id',
                        'environment_config',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_id',
                        'env_name',
                        'env_config_id',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                        ('env_name',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                        ('env_config_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'app_id':
                            (str,),
                        'env_name':
                            (str,),
                        'env_config_id':
                            (str,),
                        'environment_config':
                            (EnvironmentConfig,),
                    },
                    'attribute_map': {
                        'app_id': 'app_id',
                        'env_name': 'env_name',
                        'env_config_id': 'env_config_id',
                    },
                    'location_map': {
                        'app_id': 'path',
                        'env_name': 'path',
                        'env_config_id': 'path',
                        'environment_config': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_config
            )

        def __replace_environment(
            self,
            app_id,
            env_name,
            **kwargs
        ):
            """Update an environment  # noqa: E501

            This allows an environment maintainer to update the environment. Note that the maintenence_organisation in the body must match the existing one.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_environment(app_id, env_name, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str): Application unique identifier
                env_name (str): The name of an Environment

            Keyword Args:
                get_scopes (bool): In an application or environment GET response, will render all scopes pertaining to an application/environment. For example, rendering will iterate through launchers bound to the application and return all associated application_services as scopes. The returned scopes will also return any scopes provided by the environments application_config.. [optional] if omitted the server will use the default value of False
                environment (Environment): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Environment
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_id'] = \
                app_id
            kwargs['env_name'] = \
                env_name
            return self.call_with_http_info(**kwargs)

        if self.replace_environment is None:
            self.replace_environment = _Endpoint(
                settings={
                    'response_type': (Environment,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/applications/{app_id}/environments/{env_name}',
                    'operation_id': 'replace_environment',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'app_id',
                        'env_name',
                        'get_scopes',
                        'environment',
                    ],
                    'required': [
                        'app_id',
                        'env_name',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_id',
                        'env_name',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                        ('env_name',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'app_id':
                            (str,),
                        'env_name':
                            (str,),
                        'get_scopes':
                            (bool,),
                        'environment':
                            (Environment,),
                    },
                    'attribute_map': {
                        'app_id': 'app_id',
                        'env_name': 'env_name',
                        'get_scopes': 'get_scopes',
                    },
                    'location_map': {
                        'app_id': 'path',
                        'env_name': 'path',
                        'get_scopes': 'query',
                        'environment': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_environment
            )

        def __replace_role(
            self,
            app_id,
            role_id,
            **kwargs
        ):
            """Update a role  # noqa: E501

            Updates a role with a new specification.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_role(app_id, role_id, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str): Application unique identifier
                role_id (str): The id of a role

            Keyword Args:
                role_v2 (RoleV2): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RoleV2
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_id'] = \
                app_id
            kwargs['role_id'] = \
                role_id
            return self.call_with_http_info(**kwargs)

        if self.replace_role is None:
            self.replace_role = _Endpoint(
                settings={
                    'response_type': (RoleV2,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/applications/{app_id}/roles/{role_id}',
                    'operation_id': 'replace_role',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'app_id',
                        'role_id',
                        'role_v2',
                    ],
                    'required': [
                        'app_id',
                        'role_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_id',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'app_id':
                            (str,),
                        'role_id':
                            (str,),
                        'role_v2':
                            (RoleV2,),
                    },
                    'attribute_map': {
                        'app_id': 'app_id',
                        'role_id': 'role_id',
                    },
                    'location_map': {
                        'app_id': 'path',
                        'role_id': 'path',
                        'role_v2': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_role
            )

        def __replace_role_to_rule_entry(
            self,
            app_id,
            role_to_rule_entry_id,
            **kwargs
        ):
            """Update a role_to_rule_entry  # noqa: E501

            Updates a role_to_rule_entry with a new specification.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_role_to_rule_entry(app_id, role_to_rule_entry_id, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str): Application unique identifier
                role_to_rule_entry_id (str): The id of a role to rule entry

            Keyword Args:
                role_to_rule_entry (RoleToRuleEntry): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RoleToRuleEntry
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_id'] = \
                app_id
            kwargs['role_to_rule_entry_id'] = \
                role_to_rule_entry_id
            return self.call_with_http_info(**kwargs)

        if self.replace_role_to_rule_entry is None:
            self.replace_role_to_rule_entry = _Endpoint(
                settings={
                    'response_type': (RoleToRuleEntry,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/applications/{app_id}/role_to_rule_entries/{role_to_rule_entry_id}',
                    'operation_id': 'replace_role_to_rule_entry',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'app_id',
                        'role_to_rule_entry_id',
                        'role_to_rule_entry',
                    ],
                    'required': [
                        'app_id',
                        'role_to_rule_entry_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_id',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'app_id':
                            (str,),
                        'role_to_rule_entry_id':
                            (str,),
                        'role_to_rule_entry':
                            (RoleToRuleEntry,),
                    },
                    'attribute_map': {
                        'app_id': 'app_id',
                        'role_to_rule_entry_id': 'role_to_rule_entry_id',
                    },
                    'location_map': {
                        'app_id': 'path',
                        'role_to_rule_entry_id': 'path',
                        'role_to_rule_entry': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_role_to_rule_entry
            )

        def __replace_rule(
            self,
            app_id,
            rule_id,
            **kwargs
        ):
            """Update a rule  # noqa: E501

            Updates a rule with a new specification.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_rule(app_id, rule_id, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str): Application unique identifier
                rule_id (str): The id of a rule

            Keyword Args:
                rule_v2 (RuleV2): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RuleV2
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_id'] = \
                app_id
            kwargs['rule_id'] = \
                rule_id
            return self.call_with_http_info(**kwargs)

        if self.replace_rule is None:
            self.replace_rule = _Endpoint(
                settings={
                    'response_type': (RuleV2,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/applications/{app_id}/rules/{rule_id}',
                    'operation_id': 'replace_rule',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'app_id',
                        'rule_id',
                        'rule_v2',
                    ],
                    'required': [
                        'app_id',
                        'rule_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_id',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'app_id':
                            (str,),
                        'rule_id':
                            (str,),
                        'rule_v2':
                            (RuleV2,),
                    },
                    'attribute_map': {
                        'app_id': 'app_id',
                        'rule_id': 'rule_id',
                    },
                    'location_map': {
                        'app_id': 'path',
                        'rule_id': 'path',
                        'rule_v2': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_rule
            )

        def __replace_runtime_status(
            self,
            app_id,
            env_name,
            runtime_status,
            **kwargs
        ):
            """update an environemnt's runtime status  # noqa: E501

            update an environemnt's runtime status  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_runtime_status(app_id, env_name, runtime_status, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str): Application unique identifier
                env_name (str): The name of an Environment
                runtime_status (RuntimeStatus):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RuntimeStatus
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_id'] = \
                app_id
            kwargs['env_name'] = \
                env_name
            kwargs['runtime_status'] = \
                runtime_status
            return self.call_with_http_info(**kwargs)

        if self.replace_runtime_status is None:
            self.replace_runtime_status = _Endpoint(
                settings={
                    'response_type': (RuntimeStatus,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/applications/{app_id}/environments/{env_name}/status/runtime_status',
                    'operation_id': 'replace_runtime_status',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'app_id',
                        'env_name',
                        'runtime_status',
                    ],
                    'required': [
                        'app_id',
                        'env_name',
                        'runtime_status',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_id',
                        'env_name',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                        ('env_name',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'app_id':
                            (str,),
                        'env_name':
                            (str,),
                        'runtime_status':
                            (RuntimeStatus,),
                    },
                    'attribute_map': {
                        'app_id': 'app_id',
                        'env_name': 'env_name',
                    },
                    'location_map': {
                        'app_id': 'path',
                        'env_name': 'path',
                        'runtime_status': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_runtime_status
            )

        def __update_patch_application(
            self,
            app_id,
            **kwargs
        ):
            """patch application  # noqa: E501

            patch application  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_patch_application(app_id, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str): Application unique identifier

            Keyword Args:
                org_scope_patch_document (OrgScopePatchDocument): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Application
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_id'] = \
                app_id
            return self.call_with_http_info(**kwargs)

        if self.update_patch_application is None:
            self.update_patch_application = _Endpoint(
                settings={
                    'response_type': (Application,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/applications/{app_id}',
                    'operation_id': 'update_patch_application',
                    'http_method': 'PATCH',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'app_id',
                        'org_scope_patch_document',
                    ],
                    'required': [
                        'app_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_id',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'app_id':
                            (str,),
                        'org_scope_patch_document':
                            (OrgScopePatchDocument,),
                    },
                    'attribute_map': {
                        'app_id': 'app_id',
                    },
                    'location_map': {
                        'app_id': 'path',
                        'org_scope_patch_document': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__update_patch_application
            )

    add_config = None 
    add_role = None 
    add_role_to_rule_entry = None 
    add_rule = None 
    create_application = None 
    delete_application = None 
    delete_config = None 
    delete_role = None 
    delete_role_to_rule_entry = None 
    delete_rule = None 
    get_all_usage_metrics = None 
    get_application = None 
    get_application_usage_metrics = None 
    get_config = None 
    get_environment = None 
    get_role = None 
    get_role_to_rule_entry = None 
    get_rule = None 
    list_application_summaries = None 
    list_applications = None 
    list_combined_rules = None 
    list_configs = None 
    list_environment_configs_all_apps = None 
    list_role_to_rule_entries = None 
    list_roles = None 
    list_rules = None 
    list_runtime_status = None 
    replace_application = None 
    replace_config = None 
    replace_environment = None 
    replace_role = None 
    replace_role_to_rule_entry = None 
    replace_rule = None 
    replace_runtime_status = None 
    update_patch_application = None 
