"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2023.07.26
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.api_client import ApiClient, Endpoint as _Endpoint
from agilicus_api.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from agilicus_api.model.billing_account import BillingAccount
from agilicus_api.model.billing_org import BillingOrg
from agilicus_api.model.billing_org_subscription import BillingOrgSubscription
from agilicus_api.model.create_billing_usage_records import CreateBillingUsageRecords
from agilicus_api.model.error_message import ErrorMessage
from agilicus_api.model.list_billing_accounts_response import ListBillingAccountsResponse
from agilicus_api.model.list_billing_org_subscriptions_response import ListBillingOrgSubscriptionsResponse
from agilicus_api.model.list_billing_usage_records_response import ListBillingUsageRecordsResponse
from agilicus_api.model.list_orgs_response import ListOrgsResponse
from agilicus_api.model.list_products_response import ListProductsResponse
from agilicus_api.model.organisation import Organisation
from agilicus_api.model.product import Product


class BillingApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __add_billing_usage_record(
            self,
            billing_account_id,
            **kwargs
        ):
            """Add usage records for a billing account  # noqa: E501

            Add usage records for a billing account  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_billing_usage_record(billing_account_id, async_req=True)
            >>> result = thread.get()

            Args:
                billing_account_id (str): Billing account Unique identifier

            Keyword Args:
                create_billing_usage_records (CreateBillingUsageRecords): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CreateBillingUsageRecords
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['billing_account_id'] = \
                billing_account_id
            return self.call_with_http_info(**kwargs)

        if self.add_billing_usage_record is None:
            self.add_billing_usage_record = _Endpoint(
                settings={
                    'response_type': (CreateBillingUsageRecords,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/billing_accounts/{billing_account_id}/usage_records',
                    'operation_id': 'add_billing_usage_record',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'billing_account_id',
                        'create_billing_usage_records',
                    ],
                    'required': [
                        'billing_account_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'billing_account_id':
                            (str,),
                        'create_billing_usage_records':
                            (CreateBillingUsageRecords,),
                    },
                    'attribute_map': {
                        'billing_account_id': 'billing_account_id',
                    },
                    'location_map': {
                        'billing_account_id': 'path',
                        'create_billing_usage_records': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__add_billing_usage_record
            )

        def __add_org_to_billing_account(
            self,
            billing_account_id,
            **kwargs
        ):
            """Add an org to a billing account  # noqa: E501

            Add an org to a billing account  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_org_to_billing_account(billing_account_id, async_req=True)
            >>> result = thread.get()

            Args:
                billing_account_id (str): Billing account Unique identifier

            Keyword Args:
                billing_org (BillingOrg): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Organisation
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['billing_account_id'] = \
                billing_account_id
            return self.call_with_http_info(**kwargs)

        if self.add_org_to_billing_account is None:
            self.add_org_to_billing_account = _Endpoint(
                settings={
                    'response_type': (Organisation,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/billing_accounts/{billing_account_id}/orgs',
                    'operation_id': 'add_org_to_billing_account',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'billing_account_id',
                        'billing_org',
                    ],
                    'required': [
                        'billing_account_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'billing_account_id':
                            (str,),
                        'billing_org':
                            (BillingOrg,),
                    },
                    'attribute_map': {
                        'billing_account_id': 'billing_account_id',
                    },
                    'location_map': {
                        'billing_account_id': 'path',
                        'billing_org': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__add_org_to_billing_account
            )

        def __add_org_to_billing_subscription(
            self,
            billing_subscription_id,
            **kwargs
        ):
            """Add an org to a billing subscription  # noqa: E501

            Add an org to a billing subscription  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_org_to_billing_subscription(billing_subscription_id, async_req=True)
            >>> result = thread.get()

            Args:
                billing_subscription_id (str): Billing subscription Unique identifier

            Keyword Args:
                billing_org (BillingOrg): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Organisation
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['billing_subscription_id'] = \
                billing_subscription_id
            return self.call_with_http_info(**kwargs)

        if self.add_org_to_billing_subscription is None:
            self.add_org_to_billing_subscription = _Endpoint(
                settings={
                    'response_type': (Organisation,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/billing_subscriptions/{billing_subscription_id}/orgs',
                    'operation_id': 'add_org_to_billing_subscription',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'billing_subscription_id',
                        'billing_org',
                    ],
                    'required': [
                        'billing_subscription_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'billing_subscription_id':
                            (str,),
                        'billing_org':
                            (BillingOrg,),
                    },
                    'attribute_map': {
                        'billing_subscription_id': 'billing_subscription_id',
                    },
                    'location_map': {
                        'billing_subscription_id': 'path',
                        'billing_org': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__add_org_to_billing_subscription
            )

        def __create_billing_account(
            self,
            billing_account,
            **kwargs
        ):
            """Create a billing account  # noqa: E501

            Create a billing account  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_billing_account(billing_account, async_req=True)
            >>> result = thread.get()

            Args:
                billing_account (BillingAccount):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                BillingAccount
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['billing_account'] = \
                billing_account
            return self.call_with_http_info(**kwargs)

        if self.create_billing_account is None:
            self.create_billing_account = _Endpoint(
                settings={
                    'response_type': (BillingAccount,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/billing_accounts',
                    'operation_id': 'create_billing_account',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'billing_account',
                    ],
                    'required': [
                        'billing_account',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'billing_account':
                            (BillingAccount,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'billing_account': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_billing_account
            )

        def __create_product(
            self,
            product,
            **kwargs
        ):
            """Create a product  # noqa: E501

            Create a product  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_product(product, async_req=True)
            >>> result = thread.get()

            Args:
                product (Product):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Product
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['product'] = \
                product
            return self.call_with_http_info(**kwargs)

        if self.create_product is None:
            self.create_product = _Endpoint(
                settings={
                    'response_type': (Product,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/products',
                    'operation_id': 'create_product',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'product',
                    ],
                    'required': [
                        'product',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'product':
                            (Product,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'product': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_product
            )

        def __create_subscription(
            self,
            billing_org_subscription,
            **kwargs
        ):
            """Create a billing subscription  # noqa: E501

            Create a billing subscription  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_subscription(billing_org_subscription, async_req=True)
            >>> result = thread.get()

            Args:
                billing_org_subscription (BillingOrgSubscription):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                BillingOrgSubscription
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['billing_org_subscription'] = \
                billing_org_subscription
            return self.call_with_http_info(**kwargs)

        if self.create_subscription is None:
            self.create_subscription = _Endpoint(
                settings={
                    'response_type': (BillingOrgSubscription,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/billing_subscriptions',
                    'operation_id': 'create_subscription',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'billing_org_subscription',
                    ],
                    'required': [
                        'billing_org_subscription',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'billing_org_subscription':
                            (BillingOrgSubscription,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'billing_org_subscription': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_subscription
            )

        def __delete_billing_account(
            self,
            billing_account_id,
            **kwargs
        ):
            """Delete a billing account  # noqa: E501

            Delete a billing account  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_billing_account(billing_account_id, async_req=True)
            >>> result = thread.get()

            Args:
                billing_account_id (str): Billing account Unique identifier

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['billing_account_id'] = \
                billing_account_id
            return self.call_with_http_info(**kwargs)

        if self.delete_billing_account is None:
            self.delete_billing_account = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/billing_accounts/{billing_account_id}',
                    'operation_id': 'delete_billing_account',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'billing_account_id',
                    ],
                    'required': [
                        'billing_account_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'billing_account_id':
                            (str,),
                    },
                    'attribute_map': {
                        'billing_account_id': 'billing_account_id',
                    },
                    'location_map': {
                        'billing_account_id': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_billing_account
            )

        def __delete_product(
            self,
            product_id,
            **kwargs
        ):
            """Delete a product  # noqa: E501

            Delete a product  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_product(product_id, async_req=True)
            >>> result = thread.get()

            Args:
                product_id (str): Product Unique identifier

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['product_id'] = \
                product_id
            return self.call_with_http_info(**kwargs)

        if self.delete_product is None:
            self.delete_product = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/products/{product_id}',
                    'operation_id': 'delete_product',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'product_id',
                    ],
                    'required': [
                        'product_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'product_id':
                            (str,),
                    },
                    'attribute_map': {
                        'product_id': 'product_id',
                    },
                    'location_map': {
                        'product_id': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_product
            )

        def __delete_subscription(
            self,
            billing_subscription_id,
            **kwargs
        ):
            """Delete a billing subscription  # noqa: E501

            Delete a billing subscription  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_subscription(billing_subscription_id, async_req=True)
            >>> result = thread.get()

            Args:
                billing_subscription_id (str): Billing subscription Unique identifier

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['billing_subscription_id'] = \
                billing_subscription_id
            return self.call_with_http_info(**kwargs)

        if self.delete_subscription is None:
            self.delete_subscription = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/billing_subscriptions/{billing_subscription_id}',
                    'operation_id': 'delete_subscription',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'billing_subscription_id',
                    ],
                    'required': [
                        'billing_subscription_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'billing_subscription_id':
                            (str,),
                    },
                    'attribute_map': {
                        'billing_subscription_id': 'billing_subscription_id',
                    },
                    'location_map': {
                        'billing_subscription_id': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_subscription
            )

        def __get_billing_account(
            self,
            billing_account_id,
            **kwargs
        ):
            """Get a single billing account  # noqa: E501

            Get a single billing account  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_billing_account(billing_account_id, async_req=True)
            >>> result = thread.get()

            Args:
                billing_account_id (str): Billing account Unique identifier

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                get_subscription_data (bool): In billing response, return subscription data. [optional] if omitted the server will use the default value of False
                get_customer_data (bool): In billing response, return customer data. [optional] if omitted the server will use the default value of False
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                BillingAccount
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['billing_account_id'] = \
                billing_account_id
            return self.call_with_http_info(**kwargs)

        if self.get_billing_account is None:
            self.get_billing_account = _Endpoint(
                settings={
                    'response_type': (BillingAccount,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/billing_accounts/{billing_account_id}',
                    'operation_id': 'get_billing_account',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'billing_account_id',
                        'org_id',
                        'get_subscription_data',
                        'get_customer_data',
                    ],
                    'required': [
                        'billing_account_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'billing_account_id':
                            (str,),
                        'org_id':
                            (str,),
                        'get_subscription_data':
                            (bool,),
                        'get_customer_data':
                            (bool,),
                    },
                    'attribute_map': {
                        'billing_account_id': 'billing_account_id',
                        'org_id': 'org_id',
                        'get_subscription_data': 'get_subscription_data',
                        'get_customer_data': 'get_customer_data',
                    },
                    'location_map': {
                        'billing_account_id': 'path',
                        'org_id': 'query',
                        'get_subscription_data': 'query',
                        'get_customer_data': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_billing_account
            )

        def __get_billing_account_orgs(
            self,
            billing_account_id,
            **kwargs
        ):
            """Get all orgs in a billing account  # noqa: E501

            Get all orgs in a billing account  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_billing_account_orgs(billing_account_id, async_req=True)
            >>> result = thread.get()

            Args:
                billing_account_id (str): Billing account Unique identifier

            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListOrgsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['billing_account_id'] = \
                billing_account_id
            return self.call_with_http_info(**kwargs)

        if self.get_billing_account_orgs is None:
            self.get_billing_account_orgs = _Endpoint(
                settings={
                    'response_type': (ListOrgsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/billing_accounts/{billing_account_id}/orgs',
                    'operation_id': 'get_billing_account_orgs',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'billing_account_id',
                        'limit',
                    ],
                    'required': [
                        'billing_account_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'billing_account_id':
                            (str,),
                        'limit':
                            (int,),
                    },
                    'attribute_map': {
                        'billing_account_id': 'billing_account_id',
                        'limit': 'limit',
                    },
                    'location_map': {
                        'billing_account_id': 'path',
                        'limit': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_billing_account_orgs
            )

        def __get_billing_subscription_orgs(
            self,
            billing_subscription_id,
            **kwargs
        ):
            """Get all orgs in a billing subscription  # noqa: E501

            Get all orgs in a billing subscription  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_billing_subscription_orgs(billing_subscription_id, async_req=True)
            >>> result = thread.get()

            Args:
                billing_subscription_id (str): Billing subscription Unique identifier

            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListOrgsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['billing_subscription_id'] = \
                billing_subscription_id
            return self.call_with_http_info(**kwargs)

        if self.get_billing_subscription_orgs is None:
            self.get_billing_subscription_orgs = _Endpoint(
                settings={
                    'response_type': (ListOrgsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/billing_subscriptions/{billing_subscription_id}/orgs',
                    'operation_id': 'get_billing_subscription_orgs',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'billing_subscription_id',
                        'limit',
                    ],
                    'required': [
                        'billing_subscription_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'billing_subscription_id':
                            (str,),
                        'limit':
                            (int,),
                    },
                    'attribute_map': {
                        'billing_subscription_id': 'billing_subscription_id',
                        'limit': 'limit',
                    },
                    'location_map': {
                        'billing_subscription_id': 'path',
                        'limit': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_billing_subscription_orgs
            )

        def __get_product(
            self,
            product_id,
            **kwargs
        ):
            """Get a single product  # noqa: E501

            Get a single product  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_product(product_id, async_req=True)
            >>> result = thread.get()

            Args:
                product_id (str): Product Unique identifier

            Keyword Args:
                get_subscription_data (bool): In billing response, return subscription data. [optional] if omitted the server will use the default value of False
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Product
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['product_id'] = \
                product_id
            return self.call_with_http_info(**kwargs)

        if self.get_product is None:
            self.get_product = _Endpoint(
                settings={
                    'response_type': (Product,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/products/{product_id}',
                    'operation_id': 'get_product',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'product_id',
                        'get_subscription_data',
                    ],
                    'required': [
                        'product_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'product_id':
                            (str,),
                        'get_subscription_data':
                            (bool,),
                    },
                    'attribute_map': {
                        'product_id': 'product_id',
                        'get_subscription_data': 'get_subscription_data',
                    },
                    'location_map': {
                        'product_id': 'path',
                        'get_subscription_data': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_product
            )

        def __get_subscription(
            self,
            billing_subscription_id,
            **kwargs
        ):
            """Get a single billing subscription  # noqa: E501

            Get a single billing subscription  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_subscription(billing_subscription_id, async_req=True)
            >>> result = thread.get()

            Args:
                billing_subscription_id (str): Billing subscription Unique identifier

            Keyword Args:
                get_subscription_data (bool): In billing response, return subscription data. [optional] if omitted the server will use the default value of False
                get_customer_data (bool): In billing response, return customer data. [optional] if omitted the server will use the default value of False
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                BillingOrgSubscription
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['billing_subscription_id'] = \
                billing_subscription_id
            return self.call_with_http_info(**kwargs)

        if self.get_subscription is None:
            self.get_subscription = _Endpoint(
                settings={
                    'response_type': (BillingOrgSubscription,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/billing_subscriptions/{billing_subscription_id}',
                    'operation_id': 'get_subscription',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'billing_subscription_id',
                        'get_subscription_data',
                        'get_customer_data',
                    ],
                    'required': [
                        'billing_subscription_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'billing_subscription_id':
                            (str,),
                        'get_subscription_data':
                            (bool,),
                        'get_customer_data':
                            (bool,),
                    },
                    'attribute_map': {
                        'billing_subscription_id': 'billing_subscription_id',
                        'get_subscription_data': 'get_subscription_data',
                        'get_customer_data': 'get_customer_data',
                    },
                    'location_map': {
                        'billing_subscription_id': 'path',
                        'get_subscription_data': 'query',
                        'get_customer_data': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_subscription
            )

        def __get_usage_records(
            self,
            billing_account_id,
            **kwargs
        ):
            """Get all subscription usage records  # noqa: E501

            Get all subscription usage records  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_usage_records(billing_account_id, async_req=True)
            >>> result = thread.get()

            Args:
                billing_account_id (str): Billing account Unique identifier

            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListBillingUsageRecordsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['billing_account_id'] = \
                billing_account_id
            return self.call_with_http_info(**kwargs)

        if self.get_usage_records is None:
            self.get_usage_records = _Endpoint(
                settings={
                    'response_type': (ListBillingUsageRecordsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/billing_accounts/{billing_account_id}/usage_records',
                    'operation_id': 'get_usage_records',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'billing_account_id',
                        'limit',
                    ],
                    'required': [
                        'billing_account_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'billing_account_id':
                            (str,),
                        'limit':
                            (int,),
                    },
                    'attribute_map': {
                        'billing_account_id': 'billing_account_id',
                        'limit': 'limit',
                    },
                    'location_map': {
                        'billing_account_id': 'path',
                        'limit': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_usage_records
            )

        def __list_billing_accounts(
            self,
            **kwargs
        ):
            """Get all billing accounts  # noqa: E501

            Get all billing accounts  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_billing_accounts(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                org_id (str): Organisation Unique identifier. [optional]
                customer_id (str): query by billing customer id. [optional]
                get_subscription_data (bool): In billing response, return subscription data. [optional] if omitted the server will use the default value of False
                get_customer_data (bool): In billing response, return customer data. [optional] if omitted the server will use the default value of False
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListBillingAccountsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_billing_accounts is None:
            self.list_billing_accounts = _Endpoint(
                settings={
                    'response_type': (ListBillingAccountsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/billing_accounts',
                    'operation_id': 'list_billing_accounts',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'org_id',
                        'customer_id',
                        'get_subscription_data',
                        'get_customer_data',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'org_id':
                            (str,),
                        'customer_id':
                            (str,),
                        'get_subscription_data':
                            (bool,),
                        'get_customer_data':
                            (bool,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'org_id': 'org_id',
                        'customer_id': 'customer_id',
                        'get_subscription_data': 'get_subscription_data',
                        'get_customer_data': 'get_customer_data',
                    },
                    'location_map': {
                        'limit': 'query',
                        'org_id': 'query',
                        'customer_id': 'query',
                        'get_subscription_data': 'query',
                        'get_customer_data': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_billing_accounts
            )

        def __list_products(
            self,
            **kwargs
        ):
            """Get all products  # noqa: E501

            Get all products  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_products(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                get_subscription_data (bool): In billing response, return subscription data. [optional] if omitted the server will use the default value of False
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListProductsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_products is None:
            self.list_products = _Endpoint(
                settings={
                    'response_type': (ListProductsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/products',
                    'operation_id': 'list_products',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'get_subscription_data',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'get_subscription_data':
                            (bool,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'get_subscription_data': 'get_subscription_data',
                    },
                    'location_map': {
                        'limit': 'query',
                        'get_subscription_data': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_products
            )

        def __list_subscriptions(
            self,
            **kwargs
        ):
            """Get all billing subscriptions for a billing account  # noqa: E501

            Get all billing subscriptions for a billing account  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_subscriptions(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                get_subscription_data (bool): In billing response, return subscription data. [optional] if omitted the server will use the default value of False
                get_customer_data (bool): In billing response, return customer data. [optional] if omitted the server will use the default value of False
                billing_account_id (str): Billing account Unique identifier. [optional]
                org_id (str): Organisation Unique identifier. [optional]
                customer_id (str): query by billing customer id. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListBillingOrgSubscriptionsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_subscriptions is None:
            self.list_subscriptions = _Endpoint(
                settings={
                    'response_type': (ListBillingOrgSubscriptionsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/billing_subscriptions',
                    'operation_id': 'list_subscriptions',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'get_subscription_data',
                        'get_customer_data',
                        'billing_account_id',
                        'org_id',
                        'customer_id',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'get_subscription_data':
                            (bool,),
                        'get_customer_data':
                            (bool,),
                        'billing_account_id':
                            (str,),
                        'org_id':
                            (str,),
                        'customer_id':
                            (str,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'get_subscription_data': 'get_subscription_data',
                        'get_customer_data': 'get_customer_data',
                        'billing_account_id': 'billing_account_id',
                        'org_id': 'org_id',
                        'customer_id': 'customer_id',
                    },
                    'location_map': {
                        'limit': 'query',
                        'get_subscription_data': 'query',
                        'get_customer_data': 'query',
                        'billing_account_id': 'query',
                        'org_id': 'query',
                        'customer_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_subscriptions
            )

        def __remove_org_from_billing_account(
            self,
            billing_account_id,
            org_id,
            **kwargs
        ):
            """Remove an org from a billing account  # noqa: E501

            From an org from a billing account  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.remove_org_from_billing_account(billing_account_id, org_id, async_req=True)
            >>> result = thread.get()

            Args:
                billing_account_id (str): Billing account Unique identifier
                org_id (str): Organisation Unique identifier

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['billing_account_id'] = \
                billing_account_id
            kwargs['org_id'] = \
                org_id
            return self.call_with_http_info(**kwargs)

        if self.remove_org_from_billing_account is None:
            self.remove_org_from_billing_account = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/billing_accounts/{billing_account_id}/orgs/{org_id}',
                    'operation_id': 'remove_org_from_billing_account',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'billing_account_id',
                        'org_id',
                    ],
                    'required': [
                        'billing_account_id',
                        'org_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'billing_account_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'billing_account_id': 'billing_account_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'billing_account_id': 'path',
                        'org_id': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__remove_org_from_billing_account
            )

        def __remove_org_from_billing_subscription(
            self,
            org_id,
            billing_subscription_id,
            **kwargs
        ):
            """Remove an org from a billing subscription  # noqa: E501

            From an org from a billing subscription  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.remove_org_from_billing_subscription(org_id, billing_subscription_id, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Organisation Unique identifier
                billing_subscription_id (str): Billing subscription Unique identifier

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            kwargs['billing_subscription_id'] = \
                billing_subscription_id
            return self.call_with_http_info(**kwargs)

        if self.remove_org_from_billing_subscription is None:
            self.remove_org_from_billing_subscription = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/billing_subscriptions/{billing_subscription_id}/orgs/{org_id}',
                    'operation_id': 'remove_org_from_billing_subscription',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'billing_subscription_id',
                    ],
                    'required': [
                        'org_id',
                        'billing_subscription_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'billing_subscription_id':
                            (str,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'billing_subscription_id': 'billing_subscription_id',
                    },
                    'location_map': {
                        'org_id': 'path',
                        'billing_subscription_id': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__remove_org_from_billing_subscription
            )

        def __replace_billing_account(
            self,
            billing_account_id,
            **kwargs
        ):
            """Create or update a billing account  # noqa: E501

            Create or update a billing account  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_billing_account(billing_account_id, async_req=True)
            >>> result = thread.get()

            Args:
                billing_account_id (str): Billing account Unique identifier

            Keyword Args:
                billing_account (BillingAccount): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                BillingAccount
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['billing_account_id'] = \
                billing_account_id
            return self.call_with_http_info(**kwargs)

        if self.replace_billing_account is None:
            self.replace_billing_account = _Endpoint(
                settings={
                    'response_type': (BillingAccount,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/billing_accounts/{billing_account_id}',
                    'operation_id': 'replace_billing_account',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'billing_account_id',
                        'billing_account',
                    ],
                    'required': [
                        'billing_account_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'billing_account_id':
                            (str,),
                        'billing_account':
                            (BillingAccount,),
                    },
                    'attribute_map': {
                        'billing_account_id': 'billing_account_id',
                    },
                    'location_map': {
                        'billing_account_id': 'path',
                        'billing_account': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_billing_account
            )

        def __replace_product(
            self,
            product_id,
            **kwargs
        ):
            """Create or update a product  # noqa: E501

            Create or update a product  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_product(product_id, async_req=True)
            >>> result = thread.get()

            Args:
                product_id (str): Product Unique identifier

            Keyword Args:
                product (Product): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Product
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['product_id'] = \
                product_id
            return self.call_with_http_info(**kwargs)

        if self.replace_product is None:
            self.replace_product = _Endpoint(
                settings={
                    'response_type': (Product,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/products/{product_id}',
                    'operation_id': 'replace_product',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'product_id',
                        'product',
                    ],
                    'required': [
                        'product_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'product_id':
                            (str,),
                        'product':
                            (Product,),
                    },
                    'attribute_map': {
                        'product_id': 'product_id',
                    },
                    'location_map': {
                        'product_id': 'path',
                        'product': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_product
            )

        def __replace_subscription(
            self,
            billing_subscription_id,
            **kwargs
        ):
            """Create or update a billing subscription  # noqa: E501

            Create or update a billing subscription  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_subscription(billing_subscription_id, async_req=True)
            >>> result = thread.get()

            Args:
                billing_subscription_id (str): Billing subscription Unique identifier

            Keyword Args:
                billing_org_subscription (BillingOrgSubscription): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                BillingOrgSubscription
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['billing_subscription_id'] = \
                billing_subscription_id
            return self.call_with_http_info(**kwargs)

        if self.replace_subscription is None:
            self.replace_subscription = _Endpoint(
                settings={
                    'response_type': (BillingOrgSubscription,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/billing_subscriptions/{billing_subscription_id}',
                    'operation_id': 'replace_subscription',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'billing_subscription_id',
                        'billing_org_subscription',
                    ],
                    'required': [
                        'billing_subscription_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'billing_subscription_id':
                            (str,),
                        'billing_org_subscription':
                            (BillingOrgSubscription,),
                    },
                    'attribute_map': {
                        'billing_subscription_id': 'billing_subscription_id',
                    },
                    'location_map': {
                        'billing_subscription_id': 'path',
                        'billing_org_subscription': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_subscription
            )

    add_billing_usage_record = None 
    add_org_to_billing_account = None 
    add_org_to_billing_subscription = None 
    create_billing_account = None 
    create_product = None 
    create_subscription = None 
    delete_billing_account = None 
    delete_product = None 
    delete_subscription = None 
    get_billing_account = None 
    get_billing_account_orgs = None 
    get_billing_subscription_orgs = None 
    get_product = None 
    get_subscription = None 
    get_usage_records = None 
    list_billing_accounts = None 
    list_products = None 
    list_subscriptions = None 
    remove_org_from_billing_account = None 
    remove_org_from_billing_subscription = None 
    replace_billing_account = None 
    replace_product = None 
    replace_subscription = None 
