"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2023.07.26
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.api_client import ApiClient, Endpoint as _Endpoint
from agilicus_api.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from agilicus_api.model.csr_reason_enum import CSRReasonEnum
from agilicus_api.model.cert_signing_req import CertSigningReq
from agilicus_api.model.error_message import ErrorMessage
from agilicus_api.model.inline_response200 import InlineResponse200
from agilicus_api.model.list_cert_signing_req_response import ListCertSigningReqResponse
from agilicus_api.model.list_x509_certificate_response import ListX509CertificateResponse
from agilicus_api.model.x509_certificate import X509Certificate


class CertificatesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_cert(
            self,
            x509_certificate,
            **kwargs
        ):
            """Creates a X509Certificate  # noqa: E501

            Creates a X509Certificate   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_cert(x509_certificate, async_req=True)
            >>> result = thread.get()

            Args:
                x509_certificate (X509Certificate):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                X509Certificate
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['x509_certificate'] = \
                x509_certificate
            return self.call_with_http_info(**kwargs)

        if self.create_cert is None:
            self.create_cert = _Endpoint(
                settings={
                    'response_type': (X509Certificate,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/certificates',
                    'operation_id': 'create_cert',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'x509_certificate',
                    ],
                    'required': [
                        'x509_certificate',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'x509_certificate':
                            (X509Certificate,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'x509_certificate': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_cert
            )

        def __delete_agent_csr(
            self,
            connector_id,
            csr_id,
            **kwargs
        ):
            """Delete a CertSigningReq  # noqa: E501

            Delete a CertSigningReq  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_agent_csr(connector_id, csr_id, async_req=True)
            >>> result = thread.get()

            Args:
                connector_id (str): connector id path
                csr_id (str): A certificate signing request id

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connector_id'] = \
                connector_id
            kwargs['csr_id'] = \
                csr_id
            return self.call_with_http_info(**kwargs)

        if self.delete_agent_csr is None:
            self.delete_agent_csr = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/agent_connectors/{connector_id}/certificate_signing_requests/{csr_id}',
                    'operation_id': 'delete_agent_csr',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'connector_id',
                        'csr_id',
                        'org_id',
                    ],
                    'required': [
                        'connector_id',
                        'csr_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'connector_id':
                            (str,),
                        'csr_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'connector_id': 'connector_id',
                        'csr_id': 'csr_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'connector_id': 'path',
                        'csr_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_agent_csr
            )

        def __delete_cert(
            self,
            certificate_id,
            **kwargs
        ):
            """Delete a X509Certificate  # noqa: E501

            Delete a X509Certificate  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_cert(certificate_id, async_req=True)
            >>> result = thread.get()

            Args:
                certificate_id (str): A certificate id

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['certificate_id'] = \
                certificate_id
            return self.call_with_http_info(**kwargs)

        if self.delete_cert is None:
            self.delete_cert = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/certificates/{certificate_id}',
                    'operation_id': 'delete_cert',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'certificate_id',
                        'org_id',
                    ],
                    'required': [
                        'certificate_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'certificate_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'certificate_id': 'certificate_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'certificate_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_cert
            )

        def __delete_csr(
            self,
            csr_id,
            **kwargs
        ):
            """Delete a CertSigningReq  # noqa: E501

            Delete a CertSigningReq  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_csr(csr_id, async_req=True)
            >>> result = thread.get()

            Args:
                csr_id (str): A certificate signing request id

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                private_key_id (str): query by private key id. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['csr_id'] = \
                csr_id
            return self.call_with_http_info(**kwargs)

        if self.delete_csr is None:
            self.delete_csr = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/certificate_signing_requests/{csr_id}',
                    'operation_id': 'delete_csr',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'csr_id',
                        'org_id',
                        'private_key_id',
                    ],
                    'required': [
                        'csr_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'csr_id':
                            (str,),
                        'org_id':
                            (str,),
                        'private_key_id':
                            (str,),
                    },
                    'attribute_map': {
                        'csr_id': 'csr_id',
                        'org_id': 'org_id',
                        'private_key_id': 'private_key_id',
                    },
                    'location_map': {
                        'csr_id': 'path',
                        'org_id': 'query',
                        'private_key_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_csr
            )

        def __get_cert(
            self,
            certificate_id,
            **kwargs
        ):
            """Get a X509Certificate  # noqa: E501

            Get a X509Certificate  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_cert(certificate_id, async_req=True)
            >>> result = thread.get()

            Args:
                certificate_id (str): A certificate id

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                X509Certificate
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['certificate_id'] = \
                certificate_id
            return self.call_with_http_info(**kwargs)

        if self.get_cert is None:
            self.get_cert = _Endpoint(
                settings={
                    'response_type': (X509Certificate,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/certificates/{certificate_id}',
                    'operation_id': 'get_cert',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'certificate_id',
                        'org_id',
                    ],
                    'required': [
                        'certificate_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'certificate_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'certificate_id': 'certificate_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'certificate_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_cert
            )

        def __get_csr(
            self,
            csr_id,
            **kwargs
        ):
            """Get a CertSigningReq  # noqa: E501

            Get a CertSigningReq  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_csr(csr_id, async_req=True)
            >>> result = thread.get()

            Args:
                csr_id (str): A certificate signing request id

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                private_key_id (str): query by private key id. [optional]
                limit_csr_certificates (int): limit the number of certficates returned in a csr. [optional] if omitted the server will use the default value of 10
                get_certificate_updates (bool): For CSR queries, also return certificate updates for pending or failed certificates.. [optional] if omitted the server will use the default value of False
                certificate_updates_start_cursor (int): If get_certificate_updates is enabled, specifies the starting point cursor query.. [optional] if omitted the server will use the default value of 0
                certificate_updates_end_cursor (int): If get_certificate_updates is enabled, specifies the end of the query range (starting with certificate_updates_start_cursor).. [optional] if omitted the server will use the default value of 99
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CertSigningReq
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['csr_id'] = \
                csr_id
            return self.call_with_http_info(**kwargs)

        if self.get_csr is None:
            self.get_csr = _Endpoint(
                settings={
                    'response_type': (CertSigningReq,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/certificate_signing_requests/{csr_id}',
                    'operation_id': 'get_csr',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'csr_id',
                        'org_id',
                        'private_key_id',
                        'limit_csr_certificates',
                        'get_certificate_updates',
                        'certificate_updates_start_cursor',
                        'certificate_updates_end_cursor',
                    ],
                    'required': [
                        'csr_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit_csr_certificates',
                        'certificate_updates_start_cursor',
                        'certificate_updates_end_cursor',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit_csr_certificates',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                        ('certificate_updates_start_cursor',): {

                            'inclusive_minimum': 0,
                        },
                        ('certificate_updates_end_cursor',): {

                            'inclusive_minimum': 0,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'csr_id':
                            (str,),
                        'org_id':
                            (str,),
                        'private_key_id':
                            (str,),
                        'limit_csr_certificates':
                            (int,),
                        'get_certificate_updates':
                            (bool,),
                        'certificate_updates_start_cursor':
                            (int,),
                        'certificate_updates_end_cursor':
                            (int,),
                    },
                    'attribute_map': {
                        'csr_id': 'csr_id',
                        'org_id': 'org_id',
                        'private_key_id': 'private_key_id',
                        'limit_csr_certificates': 'limit_csr_certificates',
                        'get_certificate_updates': 'get_certificate_updates',
                        'certificate_updates_start_cursor': 'certificate_updates_start_cursor',
                        'certificate_updates_end_cursor': 'certificate_updates_end_cursor',
                    },
                    'location_map': {
                        'csr_id': 'path',
                        'org_id': 'query',
                        'private_key_id': 'query',
                        'limit_csr_certificates': 'query',
                        'get_certificate_updates': 'query',
                        'certificate_updates_start_cursor': 'query',
                        'certificate_updates_end_cursor': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_csr
            )

        def __list_certs(
            self,
            **kwargs
        ):
            """list certificates  # noqa: E501

            List certificates   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_certs(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListX509CertificateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_certs is None:
            self.list_certs = _Endpoint(
                settings={
                    'response_type': (ListX509CertificateResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/certificates',
                    'operation_id': 'list_certs',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'org_id',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'limit': 'query',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_certs
            )

        def __list_csr(
            self,
            **kwargs
        ):
            """list certificate signing requests  # noqa: E501

            List certificate signing requests.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_csr(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                org_id (str): Organisation Unique identifier. [optional]
                reason (CSRReasonEnum): Query a CSR based on its certificate reason status. This option is deprecated, as all csr queries will return only issued certificates. . [optional]
                not_valid_after (str): Search criteria for finding expired certificates * In UTC. * Supports human-friendly values. * Example, find all expired certificates in 30 days: not_after_after=\"in 30 days\" * Example, find all expired certificates today:  not_valid_after=\"tomorrow\" * Example, find all expired now:  not_valid_after=\"now\" . [optional]
                target_issuer ([str]): A list of target issuers to search for. If an item matches an entry in the list, is returned. . [optional]
                limit_csr_certificates (int): limit the number of certficates returned in a csr. [optional] if omitted the server will use the default value of 10
                get_certificate_updates (bool): For CSR queries, also return certificate updates for pending or failed certificates.. [optional] if omitted the server will use the default value of False
                certificate_updates_start_cursor (int): If get_certificate_updates is enabled, specifies the starting point cursor query.. [optional] if omitted the server will use the default value of 0
                certificate_updates_end_cursor (int): If get_certificate_updates is enabled, specifies the end of the query range (starting with certificate_updates_start_cursor).. [optional] if omitted the server will use the default value of 99
                auto_renew (bool): When enabled, query only certificate requests that have their auto_renew status enabled, when false, query only certificate requests that have their auto_renew as false. If not set (neither true or false), certificate requests are returned regardless of the auto_renew status. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListCertSigningReqResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_csr is None:
            self.list_csr = _Endpoint(
                settings={
                    'response_type': (ListCertSigningReqResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/certificate_signing_requests',
                    'operation_id': 'list_csr',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'org_id',
                        'reason',
                        'not_valid_after',
                        'target_issuer',
                        'limit_csr_certificates',
                        'get_certificate_updates',
                        'certificate_updates_start_cursor',
                        'certificate_updates_end_cursor',
                        'auto_renew',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                        'limit_csr_certificates',
                        'certificate_updates_start_cursor',
                        'certificate_updates_end_cursor',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                        ('limit_csr_certificates',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                        ('certificate_updates_start_cursor',): {

                            'inclusive_minimum': 0,
                        },
                        ('certificate_updates_end_cursor',): {

                            'inclusive_minimum': 0,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'org_id':
                            (str,),
                        'reason':
                            (CSRReasonEnum,),
                        'not_valid_after':
                            (str,),
                        'target_issuer':
                            ([str],),
                        'limit_csr_certificates':
                            (int,),
                        'get_certificate_updates':
                            (bool,),
                        'certificate_updates_start_cursor':
                            (int,),
                        'certificate_updates_end_cursor':
                            (int,),
                        'auto_renew':
                            (bool,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'org_id': 'org_id',
                        'reason': 'reason',
                        'not_valid_after': 'not_valid_after',
                        'target_issuer': 'target_issuer',
                        'limit_csr_certificates': 'limit_csr_certificates',
                        'get_certificate_updates': 'get_certificate_updates',
                        'certificate_updates_start_cursor': 'certificate_updates_start_cursor',
                        'certificate_updates_end_cursor': 'certificate_updates_end_cursor',
                        'auto_renew': 'auto_renew',
                    },
                    'location_map': {
                        'limit': 'query',
                        'org_id': 'query',
                        'reason': 'query',
                        'not_valid_after': 'query',
                        'target_issuer': 'query',
                        'limit_csr_certificates': 'query',
                        'get_certificate_updates': 'query',
                        'certificate_updates_start_cursor': 'query',
                        'certificate_updates_end_cursor': 'query',
                        'auto_renew': 'query',
                    },
                    'collection_format_map': {
                        'target_issuer': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_csr
            )

        def __list_root_certs(
            self,
            **kwargs
        ):
            """list root certificates  # noqa: E501

            List the root certificates an organsation should trust when interacting with the local resources exposed by the Agilicus platform.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_root_certs(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                InlineResponse200
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_root_certs is None:
            self.list_root_certs = _Endpoint(
                settings={
                    'response_type': (InlineResponse200,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/root_certificates',
                    'operation_id': 'list_root_certs',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'org_id',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'limit': 'query',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_root_certs
            )

        def __replace_csr(
            self,
            csr_id,
            **kwargs
        ):
            """Update a CertSigningReq  # noqa: E501

            Update a CertSigningReq  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_csr(csr_id, async_req=True)
            >>> result = thread.get()

            Args:
                csr_id (str): A certificate signing request id

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                private_key_id (str): query by private key id. [optional]
                cert_signing_req (CertSigningReq): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CertSigningReq
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['csr_id'] = \
                csr_id
            return self.call_with_http_info(**kwargs)

        if self.replace_csr is None:
            self.replace_csr = _Endpoint(
                settings={
                    'response_type': (CertSigningReq,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/certificate_signing_requests/{csr_id}',
                    'operation_id': 'replace_csr',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'csr_id',
                        'org_id',
                        'private_key_id',
                        'cert_signing_req',
                    ],
                    'required': [
                        'csr_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'csr_id':
                            (str,),
                        'org_id':
                            (str,),
                        'private_key_id':
                            (str,),
                        'cert_signing_req':
                            (CertSigningReq,),
                    },
                    'attribute_map': {
                        'csr_id': 'csr_id',
                        'org_id': 'org_id',
                        'private_key_id': 'private_key_id',
                    },
                    'location_map': {
                        'csr_id': 'path',
                        'org_id': 'query',
                        'private_key_id': 'query',
                        'cert_signing_req': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_csr
            )

    create_cert = None 
    delete_agent_csr = None 
    delete_cert = None 
    delete_csr = None 
    get_cert = None 
    get_csr = None 
    list_certs = None 
    list_csr = None 
    list_root_certs = None 
    replace_csr = None 
