"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2023.07.26
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.api_client import ApiClient, Endpoint as _Endpoint
from agilicus_api.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from agilicus_api.model.bulk_user_metadata import BulkUserMetadata
from agilicus_api.model.bulk_user_request_approval import BulkUserRequestApproval
from agilicus_api.model.email import Email
from agilicus_api.model.error_message import ErrorMessage
from agilicus_api.model.host_permissions import HostPermissions
from agilicus_api.model.list_access_requests_response import ListAccessRequestsResponse
from agilicus_api.model.list_combined_user_details_response import ListCombinedUserDetailsResponse
from agilicus_api.model.list_guid_metadata_response import ListGuidMetadataResponse
from agilicus_api.model.list_mfa_challenge_methods import ListMFAChallengeMethods
from agilicus_api.model.list_orgs_response import ListOrgsResponse
from agilicus_api.model.list_service_account_response import ListServiceAccountResponse
from agilicus_api.model.list_upstream_user_identities_response import ListUpstreamUserIdentitiesResponse
from agilicus_api.model.list_user_application_access_info_response import ListUserApplicationAccessInfoResponse
from agilicus_api.model.list_user_desktop_access_info_response import ListUserDesktopAccessInfoResponse
from agilicus_api.model.list_user_file_share_access_info_response import ListUserFileShareAccessInfoResponse
from agilicus_api.model.list_user_guids_response import ListUserGuidsResponse
from agilicus_api.model.list_user_launcher_access_info_response import ListUserLauncherAccessInfoResponse
from agilicus_api.model.list_user_metadata_response import ListUserMetadataResponse
from agilicus_api.model.list_user_request_info_response import ListUserRequestInfoResponse
from agilicus_api.model.list_user_resource_access_info_response import ListUserResourceAccessInfoResponse
from agilicus_api.model.list_user_roles_for_an_org import ListUserRolesForAnOrg
from agilicus_api.model.list_user_ssh_access_info_response import ListUserSSHAccessInfoResponse
from agilicus_api.model.list_users_response import ListUsersResponse
from agilicus_api.model.mfa_challenge_method import MFAChallengeMethod
from agilicus_api.model.rendered_resource_permissions import RenderedResourcePermissions
from agilicus_api.model.replace_user_role_request import ReplaceUserRoleRequest
from agilicus_api.model.reset_mfa_challenge_method import ResetMFAChallengeMethod
from agilicus_api.model.reset_user_identity_request import ResetUserIdentityRequest
from agilicus_api.model.resource_type_enum import ResourceTypeEnum
from agilicus_api.model.roles import Roles
from agilicus_api.model.selector_tag import SelectorTag
from agilicus_api.model.service_account import ServiceAccount
from agilicus_api.model.upstream_user_identity import UpstreamUserIdentity
from agilicus_api.model.user import User
from agilicus_api.model.user_identity_update import UserIdentityUpdate
from agilicus_api.model.user_metadata import UserMetadata
from agilicus_api.model.user_request_info import UserRequestInfo
from agilicus_api.model.user_status_enum import UserStatusEnum


class UsersApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __bulk_approve_requests(
            self,
            bulk_user_request_approval,
            **kwargs
        ):
            """Approve a list of requests on behalf of users  # noqa: E501

            Approve a list of requests on behalf of users, optionally modifying a user's status or resetting their permissions. Note that this may also be used to decline a request.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.bulk_approve_requests(bulk_user_request_approval, async_req=True)
            >>> result = thread.get()

            Args:
                bulk_user_request_approval (BulkUserRequestApproval):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                BulkUserRequestApproval
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['bulk_user_request_approval'] = \
                bulk_user_request_approval
            return self.call_with_http_info(**kwargs)

        if self.bulk_approve_requests is None:
            self.bulk_approve_requests = _Endpoint(
                settings={
                    'response_type': (BulkUserRequestApproval,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/user_requests/bulk_approve',
                    'operation_id': 'bulk_approve_requests',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'bulk_user_request_approval',
                    ],
                    'required': [
                        'bulk_user_request_approval',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'bulk_user_request_approval':
                            (BulkUserRequestApproval,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'bulk_user_request_approval': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__bulk_approve_requests
            )

        def __bulk_update_metadata(
            self,
            **kwargs
        ):
            """Update a group of user's metadata for the specified org  # noqa: E501

            Update a group of user's metadata for the specified org  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.bulk_update_metadata(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                bulk_user_metadata (BulkUserMetadata): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.bulk_update_metadata is None:
            self.bulk_update_metadata = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/user_metadata_rpc/bulk_update',
                    'operation_id': 'bulk_update_metadata',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'bulk_user_metadata',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'bulk_user_metadata':
                            (BulkUserMetadata,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'bulk_user_metadata': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__bulk_update_metadata
            )

        def __create_challenge_method(
            self,
            user_id,
            mfa_challenge_method,
            **kwargs
        ):
            """Create a multi-factor authentication method  # noqa: E501

            Create a multi-factor authentication method  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_challenge_method(user_id, mfa_challenge_method, async_req=True)
            >>> result = thread.get()

            Args:
                user_id (str): user_id path
                mfa_challenge_method (MFAChallengeMethod):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                MFAChallengeMethod
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_id'] = \
                user_id
            kwargs['mfa_challenge_method'] = \
                mfa_challenge_method
            return self.call_with_http_info(**kwargs)

        if self.create_challenge_method is None:
            self.create_challenge_method = _Endpoint(
                settings={
                    'response_type': (MFAChallengeMethod,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/users/{user_id}/mfa_challenge_methods',
                    'operation_id': 'create_challenge_method',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_id',
                        'mfa_challenge_method',
                    ],
                    'required': [
                        'user_id',
                        'mfa_challenge_method',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_id':
                            (str,),
                        'mfa_challenge_method':
                            (MFAChallengeMethod,),
                    },
                    'attribute_map': {
                        'user_id': 'user_id',
                    },
                    'location_map': {
                        'user_id': 'path',
                        'mfa_challenge_method': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_challenge_method
            )

        def __create_service_account(
            self,
            service_account,
            **kwargs
        ):
            """Create a service account  # noqa: E501

            Create a service account  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_service_account(service_account, async_req=True)
            >>> result = thread.get()

            Args:
                service_account (ServiceAccount):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ServiceAccount
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['service_account'] = \
                service_account
            return self.call_with_http_info(**kwargs)

        if self.create_service_account is None:
            self.create_service_account = _Endpoint(
                settings={
                    'response_type': (ServiceAccount,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/service_accounts',
                    'operation_id': 'create_service_account',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'service_account',
                    ],
                    'required': [
                        'service_account',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'service_account':
                            (ServiceAccount,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'service_account': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_service_account
            )

        def __create_upstream_user_identity(
            self,
            user_id,
            upstream_user_identity,
            **kwargs
        ):
            """Create an upstream user identity  # noqa: E501

            Create an upstream user identity  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_upstream_user_identity(user_id, upstream_user_identity, async_req=True)
            >>> result = thread.get()

            Args:
                user_id (str): user_id path
                upstream_user_identity (UpstreamUserIdentity):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UpstreamUserIdentity
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_id'] = \
                user_id
            kwargs['upstream_user_identity'] = \
                upstream_user_identity
            return self.call_with_http_info(**kwargs)

        if self.create_upstream_user_identity is None:
            self.create_upstream_user_identity = _Endpoint(
                settings={
                    'response_type': (UpstreamUserIdentity,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/users/{user_id}/upstream_user_identities',
                    'operation_id': 'create_upstream_user_identity',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_id',
                        'upstream_user_identity',
                    ],
                    'required': [
                        'user_id',
                        'upstream_user_identity',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_id':
                            (str,),
                        'upstream_user_identity':
                            (UpstreamUserIdentity,),
                    },
                    'attribute_map': {
                        'user_id': 'user_id',
                    },
                    'location_map': {
                        'user_id': 'path',
                        'upstream_user_identity': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_upstream_user_identity
            )

        def __create_user(
            self,
            user,
            **kwargs
        ):
            """Create a user  # noqa: E501

            Create a user  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_user(user, async_req=True)
            >>> result = thread.get()

            Args:
                user (User):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                User
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user'] = \
                user
            return self.call_with_http_info(**kwargs)

        if self.create_user is None:
            self.create_user = _Endpoint(
                settings={
                    'response_type': (User,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/users',
                    'operation_id': 'create_user',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user',
                    ],
                    'required': [
                        'user',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user':
                            (User,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'user': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_user
            )

        def __create_user_identity_update(
            self,
            user_id,
            user_identity_update,
            **kwargs
        ):
            """Update a user's core identity information.  # noqa: E501

            Update a user's core identity information.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_user_identity_update(user_id, user_identity_update, async_req=True)
            >>> result = thread.get()

            Args:
                user_id (str): user_id path
                user_identity_update (UserIdentityUpdate):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UserIdentityUpdate
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_id'] = \
                user_id
            kwargs['user_identity_update'] = \
                user_identity_update
            return self.call_with_http_info(**kwargs)

        if self.create_user_identity_update is None:
            self.create_user_identity_update = _Endpoint(
                settings={
                    'response_type': (UserIdentityUpdate,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/users/{user_id}/user_identity_updates',
                    'operation_id': 'create_user_identity_update',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_id',
                        'user_identity_update',
                    ],
                    'required': [
                        'user_id',
                        'user_identity_update',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_id':
                            (str,),
                        'user_identity_update':
                            (UserIdentityUpdate,),
                    },
                    'attribute_map': {
                        'user_id': 'user_id',
                    },
                    'location_map': {
                        'user_id': 'path',
                        'user_identity_update': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_user_identity_update
            )

        def __create_user_metadata(
            self,
            user_metadata,
            **kwargs
        ):
            """Create a metadata entry for the user  # noqa: E501

            Create a metadata entry for the user  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_user_metadata(user_metadata, async_req=True)
            >>> result = thread.get()

            Args:
                user_metadata (UserMetadata):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UserMetadata
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_metadata'] = \
                user_metadata
            return self.call_with_http_info(**kwargs)

        if self.create_user_metadata is None:
            self.create_user_metadata = _Endpoint(
                settings={
                    'response_type': (UserMetadata,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/user_metadata',
                    'operation_id': 'create_user_metadata',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_metadata',
                    ],
                    'required': [
                        'user_metadata',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_metadata':
                            (UserMetadata,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'user_metadata': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_user_metadata
            )

        def __create_user_request(
            self,
            user_request_info,
            **kwargs
        ):
            """Create a request on behalf of the user  # noqa: E501

            Create a request on behalf of the user  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_user_request(user_request_info, async_req=True)
            >>> result = thread.get()

            Args:
                user_request_info (UserRequestInfo):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UserRequestInfo
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_request_info'] = \
                user_request_info
            return self.call_with_http_info(**kwargs)

        if self.create_user_request is None:
            self.create_user_request = _Endpoint(
                settings={
                    'response_type': (UserRequestInfo,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/user_requests',
                    'operation_id': 'create_user_request',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_request_info',
                    ],
                    'required': [
                        'user_request_info',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_request_info':
                            (UserRequestInfo,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'user_request_info': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_user_request
            )

        def __delete_challenge_method(
            self,
            user_id,
            challenge_method_id,
            **kwargs
        ):
            """Delete a user's multi-factor authentication challenge method  # noqa: E501

            Delete a user's multi-factor authentication challenge method  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_challenge_method(user_id, challenge_method_id, async_req=True)
            >>> result = thread.get()

            Args:
                user_id (str): user_id path
                challenge_method_id (str): challenge method id

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_id'] = \
                user_id
            kwargs['challenge_method_id'] = \
                challenge_method_id
            return self.call_with_http_info(**kwargs)

        if self.delete_challenge_method is None:
            self.delete_challenge_method = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/users/{user_id}/mfa_challenge_methods/{challenge_method_id}',
                    'operation_id': 'delete_challenge_method',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_id',
                        'challenge_method_id',
                    ],
                    'required': [
                        'user_id',
                        'challenge_method_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_id':
                            (str,),
                        'challenge_method_id':
                            (str,),
                    },
                    'attribute_map': {
                        'user_id': 'user_id',
                        'challenge_method_id': 'challenge_method_id',
                    },
                    'location_map': {
                        'user_id': 'path',
                        'challenge_method_id': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_challenge_method
            )

        def __delete_service_account(
            self,
            service_account_id,
            **kwargs
        ):
            """Delete a service account  # noqa: E501

            Delete a service account  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_service_account(service_account_id, async_req=True)
            >>> result = thread.get()

            Args:
                service_account_id (str): service_account_id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                protected_by_id (str): optional argument for specifying an objects protected_by_id. [optional]
                protected_by_type (str): optional argument for specifying an objects protected_by_type. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['service_account_id'] = \
                service_account_id
            return self.call_with_http_info(**kwargs)

        if self.delete_service_account is None:
            self.delete_service_account = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/service_accounts/{service_account_id}',
                    'operation_id': 'delete_service_account',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'service_account_id',
                        'org_id',
                        'protected_by_id',
                        'protected_by_type',
                    ],
                    'required': [
                        'service_account_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'service_account_id':
                            (str,),
                        'org_id':
                            (str,),
                        'protected_by_id':
                            (str,),
                        'protected_by_type':
                            (str,),
                    },
                    'attribute_map': {
                        'service_account_id': 'service_account_id',
                        'org_id': 'org_id',
                        'protected_by_id': 'protected_by_id',
                        'protected_by_type': 'protected_by_type',
                    },
                    'location_map': {
                        'service_account_id': 'path',
                        'org_id': 'query',
                        'protected_by_id': 'query',
                        'protected_by_type': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_service_account
            )

        def __delete_upstream_user_identity(
            self,
            user_id,
            upstream_user_identity_id,
            **kwargs
        ):
            """Delete an upstream user identity  # noqa: E501

            Delete an upstream user identity  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_upstream_user_identity(user_id, upstream_user_identity_id, async_req=True)
            >>> result = thread.get()

            Args:
                user_id (str): user_id path
                upstream_user_identity_id (str): The unique id of the upstream user identity

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_id'] = \
                user_id
            kwargs['upstream_user_identity_id'] = \
                upstream_user_identity_id
            return self.call_with_http_info(**kwargs)

        if self.delete_upstream_user_identity is None:
            self.delete_upstream_user_identity = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/users/{user_id}/upstream_user_identities/{upstream_user_identity_id}',
                    'operation_id': 'delete_upstream_user_identity',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_id',
                        'upstream_user_identity_id',
                    ],
                    'required': [
                        'user_id',
                        'upstream_user_identity_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_id':
                            (str,),
                        'upstream_user_identity_id':
                            (str,),
                    },
                    'attribute_map': {
                        'user_id': 'user_id',
                        'upstream_user_identity_id': 'upstream_user_identity_id',
                    },
                    'location_map': {
                        'user_id': 'path',
                        'upstream_user_identity_id': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_upstream_user_identity
            )

        def __delete_user(
            self,
            org_id,
            user_id,
            **kwargs
        ):
            """Remove a user from an organisation  # noqa: E501

            Remove a user from an organisation  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_user(org_id, user_id, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Organisation Unique identifier
                user_id (str): user_id path

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            kwargs['user_id'] = \
                user_id
            return self.call_with_http_info(**kwargs)

        if self.delete_user is None:
            self.delete_user = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/orgs/{org_id}/users/{user_id}',
                    'operation_id': 'delete_user',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'user_id',
                    ],
                    'required': [
                        'org_id',
                        'user_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'user_id':
                            (str,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'user_id': 'user_id',
                    },
                    'location_map': {
                        'org_id': 'path',
                        'user_id': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_user
            )

        def __delete_user_metadata(
            self,
            metadata_id,
            **kwargs
        ):
            """Delete an user metadata entry  # noqa: E501

            Delete an user metadata entry  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_user_metadata(metadata_id, async_req=True)
            >>> result = thread.get()

            Args:
                metadata_id (str): metadata id

            Keyword Args:
                user_id (str): Query based on user id. [optional]
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['metadata_id'] = \
                metadata_id
            return self.call_with_http_info(**kwargs)

        if self.delete_user_metadata is None:
            self.delete_user_metadata = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/user_metadata/{metadata_id}',
                    'operation_id': 'delete_user_metadata',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'metadata_id',
                        'user_id',
                        'org_id',
                    ],
                    'required': [
                        'metadata_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'metadata_id':
                            (str,),
                        'user_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'metadata_id': 'metadata_id',
                        'user_id': 'user_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'metadata_id': 'path',
                        'user_id': 'query',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_user_metadata
            )

        def __delete_user_request(
            self,
            user_request_id,
            **kwargs
        ):
            """Delete an user request  # noqa: E501

            Delete an user request  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_user_request(user_request_id, async_req=True)
            >>> result = thread.get()

            Args:
                user_request_id (str): user request id

            Keyword Args:
                user_id (str): Query based on user id. [optional]
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_request_id'] = \
                user_request_id
            return self.call_with_http_info(**kwargs)

        if self.delete_user_request is None:
            self.delete_user_request = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/user_requests/{user_request_id}',
                    'operation_id': 'delete_user_request',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_request_id',
                        'user_id',
                        'org_id',
                    ],
                    'required': [
                        'user_request_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_request_id':
                            (str,),
                        'user_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'user_request_id': 'user_request_id',
                        'user_id': 'user_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'user_request_id': 'path',
                        'user_id': 'query',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_user_request
            )

        def __get_challenge_method(
            self,
            user_id,
            challenge_method_id,
            **kwargs
        ):
            """Get a single challenge method for the given user  # noqa: E501

            Get a single challenge method for the given user  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_challenge_method(user_id, challenge_method_id, async_req=True)
            >>> result = thread.get()

            Args:
                user_id (str): user_id path
                challenge_method_id (str): challenge method id

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                MFAChallengeMethod
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_id'] = \
                user_id
            kwargs['challenge_method_id'] = \
                challenge_method_id
            return self.call_with_http_info(**kwargs)

        if self.get_challenge_method is None:
            self.get_challenge_method = _Endpoint(
                settings={
                    'response_type': (MFAChallengeMethod,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/users/{user_id}/mfa_challenge_methods/{challenge_method_id}',
                    'operation_id': 'get_challenge_method',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_id',
                        'challenge_method_id',
                    ],
                    'required': [
                        'user_id',
                        'challenge_method_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_id':
                            (str,),
                        'challenge_method_id':
                            (str,),
                    },
                    'attribute_map': {
                        'user_id': 'user_id',
                        'challenge_method_id': 'challenge_method_id',
                    },
                    'location_map': {
                        'user_id': 'path',
                        'challenge_method_id': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_challenge_method
            )

        def __get_service_account(
            self,
            service_account_id,
            **kwargs
        ):
            """Get a service account  # noqa: E501

            Get a service account  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_service_account(service_account_id, async_req=True)
            >>> result = thread.get()

            Args:
                service_account_id (str): service_account_id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ServiceAccount
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['service_account_id'] = \
                service_account_id
            return self.call_with_http_info(**kwargs)

        if self.get_service_account is None:
            self.get_service_account = _Endpoint(
                settings={
                    'response_type': (ServiceAccount,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/service_accounts/{service_account_id}',
                    'operation_id': 'get_service_account',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'service_account_id',
                        'org_id',
                    ],
                    'required': [
                        'service_account_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'service_account_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'service_account_id': 'service_account_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'service_account_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_service_account
            )

        def __get_upstream_user_identity(
            self,
            user_id,
            upstream_user_identity_id,
            **kwargs
        ):
            """Get a single upstream user identity  # noqa: E501

            Get a single upstream user identity  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_upstream_user_identity(user_id, upstream_user_identity_id, async_req=True)
            >>> result = thread.get()

            Args:
                user_id (str): user_id path
                upstream_user_identity_id (str): The unique id of the upstream user identity

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UpstreamUserIdentity
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_id'] = \
                user_id
            kwargs['upstream_user_identity_id'] = \
                upstream_user_identity_id
            return self.call_with_http_info(**kwargs)

        if self.get_upstream_user_identity is None:
            self.get_upstream_user_identity = _Endpoint(
                settings={
                    'response_type': (UpstreamUserIdentity,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/users/{user_id}/upstream_user_identities/{upstream_user_identity_id}',
                    'operation_id': 'get_upstream_user_identity',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_id',
                        'upstream_user_identity_id',
                    ],
                    'required': [
                        'user_id',
                        'upstream_user_identity_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_id':
                            (str,),
                        'upstream_user_identity_id':
                            (str,),
                    },
                    'attribute_map': {
                        'user_id': 'user_id',
                        'upstream_user_identity_id': 'upstream_user_identity_id',
                    },
                    'location_map': {
                        'user_id': 'path',
                        'upstream_user_identity_id': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_upstream_user_identity
            )

        def __get_user(
            self,
            user_id,
            **kwargs
        ):
            """Get a single user  # noqa: E501

            Get a single user  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_user(user_id, async_req=True)
            >>> result = thread.get()

            Args:
                user_id (str): user_id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                User
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_id'] = \
                user_id
            return self.call_with_http_info(**kwargs)

        if self.get_user is None:
            self.get_user = _Endpoint(
                settings={
                    'response_type': (User,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/users/{user_id}',
                    'operation_id': 'get_user',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_id',
                        'org_id',
                    ],
                    'required': [
                        'user_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'user_id': 'user_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'user_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_user
            )

        def __get_user_metadata(
            self,
            metadata_id,
            **kwargs
        ):
            """Get a single user metadata entry  # noqa: E501

            Get a single user metadata entry  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_user_metadata(metadata_id, async_req=True)
            >>> result = thread.get()

            Args:
                metadata_id (str): metadata id

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                user_id (str): Query based on user id. [optional]
                recursive (bool): If true, the query will recurse upwards. [optional] if omitted the server will use the default value of False
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UserMetadata
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['metadata_id'] = \
                metadata_id
            return self.call_with_http_info(**kwargs)

        if self.get_user_metadata is None:
            self.get_user_metadata = _Endpoint(
                settings={
                    'response_type': (UserMetadata,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/user_metadata/{metadata_id}',
                    'operation_id': 'get_user_metadata',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'metadata_id',
                        'org_id',
                        'user_id',
                        'recursive',
                    ],
                    'required': [
                        'metadata_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'metadata_id':
                            (str,),
                        'org_id':
                            (str,),
                        'user_id':
                            (str,),
                        'recursive':
                            (bool,),
                    },
                    'attribute_map': {
                        'metadata_id': 'metadata_id',
                        'org_id': 'org_id',
                        'user_id': 'user_id',
                        'recursive': 'recursive',
                    },
                    'location_map': {
                        'metadata_id': 'path',
                        'org_id': 'query',
                        'user_id': 'query',
                        'recursive': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_user_metadata
            )

        def __get_user_request(
            self,
            user_request_id,
            **kwargs
        ):
            """Get a single user request  # noqa: E501

            Get a single user request  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_user_request(user_request_id, async_req=True)
            >>> result = thread.get()

            Args:
                user_request_id (str): user request id

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                user_id (str): Query based on user id. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UserRequestInfo
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_request_id'] = \
                user_request_id
            return self.call_with_http_info(**kwargs)

        if self.get_user_request is None:
            self.get_user_request = _Endpoint(
                settings={
                    'response_type': (UserRequestInfo,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/user_requests/{user_request_id}',
                    'operation_id': 'get_user_request',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_request_id',
                        'org_id',
                        'user_id',
                    ],
                    'required': [
                        'user_request_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_request_id':
                            (str,),
                        'org_id':
                            (str,),
                        'user_id':
                            (str,),
                    },
                    'attribute_map': {
                        'user_request_id': 'user_request_id',
                        'org_id': 'org_id',
                        'user_id': 'user_id',
                    },
                    'location_map': {
                        'user_request_id': 'path',
                        'org_id': 'query',
                        'user_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_user_request
            )

        def __list_access_requests(
            self,
            org_id,
            **kwargs
        ):
            """Get a list of access requests  # noqa: E501

            Get a list of access requests  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_access_requests(org_id, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Organisation Unique identifier

            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                user_id (str): Query based on user id. [optional]
                request_state (str): The state of the request to filter the query. [optional]
                request_type (str): The type of the request to filter the query. Note that `application_access` and `file_share_access` are deprecated. They have been replaced with `application` and `fileshare` respectively. . [optional]
                email (str, none_type): Pagination based query with the user's email as the key. To get the initial entries supply either an empty string or null.. [optional]
                search_direction (str): Direction which the search should go starting from the email_nullable_query parameter. . [optional] if omitted the server will use the default value of "forwards"
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListAccessRequestsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            return self.call_with_http_info(**kwargs)

        if self.list_access_requests is None:
            self.list_access_requests = _Endpoint(
                settings={
                    'response_type': (ListAccessRequestsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/access_requests',
                    'operation_id': 'list_access_requests',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'limit',
                        'user_id',
                        'request_state',
                        'request_type',
                        'email',
                        'search_direction',
                    ],
                    'required': [
                        'org_id',
                    ],
                    'nullable': [
                        'email',
                    ],
                    'enum': [
                        'request_state',
                        'request_type',
                        'search_direction',
                    ],
                    'validation': [
                        'limit',
                        'email',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                        ('email',): {
                            'max_length': 100,
                            'min_length': 0,
                        },
                    },
                    'allowed_values': {
                        ('request_state',): {

                            "PENDING": "pending",
                            "APPROVED": "approved",
                            "DECLINED": "declined"
                        },
                        ('request_type',): {

                            "APPLICATION_ACCESS": "application_access",
                            "FILE_SHARE_ACCESS": "file_share_access",
                            "APPLICATION": "application",
                            "FILESHARE": "fileshare",
                            "APPLICATION_SERVICE": "application_service",
                            "LAUNCHER": "launcher"
                        },
                        ('search_direction',): {

                            "BACKWARDS": "backwards",
                            "FORWARDS": "forwards"
                        },
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'limit':
                            (int,),
                        'user_id':
                            (str,),
                        'request_state':
                            (str,),
                        'request_type':
                            (str,),
                        'email':
                            (str, none_type,),
                        'search_direction':
                            (str,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'limit': 'limit',
                        'user_id': 'user_id',
                        'request_state': 'request_state',
                        'request_type': 'request_type',
                        'email': 'email',
                        'search_direction': 'search_direction',
                    },
                    'location_map': {
                        'org_id': 'query',
                        'limit': 'query',
                        'user_id': 'query',
                        'request_state': 'query',
                        'request_type': 'query',
                        'email': 'query',
                        'search_direction': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_access_requests
            )

        def __list_all_resource_permissions(
            self,
            user_id,
            org_id,
            **kwargs
        ):
            """Return all per-resource permissions for a user  # noqa: E501

            Retrieves the per-resource permissions for a user granted for them by the given organisation. These permissions are recursively inherted from any groups to which the user belongs.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_all_resource_permissions(user_id, org_id, async_req=True)
            >>> result = thread.get()

            Args:
                user_id (str): user_id path
                org_id (str): Organisation Unique identifier

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RenderedResourcePermissions
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_id'] = \
                user_id
            kwargs['org_id'] = \
                org_id
            return self.call_with_http_info(**kwargs)

        if self.list_all_resource_permissions is None:
            self.list_all_resource_permissions = _Endpoint(
                settings={
                    'response_type': (RenderedResourcePermissions,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/users/{user_id}/render_resource_permissions',
                    'operation_id': 'list_all_resource_permissions',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_id',
                        'org_id',
                    ],
                    'required': [
                        'user_id',
                        'org_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'user_id': 'user_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'user_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_all_resource_permissions
            )

        def __list_all_user_orgs(
            self,
            user_id,
            **kwargs
        ):
            """Return all organisations a user has been assigned to  # noqa: E501

            Return all organisations a user has been assigned to  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_all_user_orgs(user_id, async_req=True)
            >>> result = thread.get()

            Args:
                user_id (str): user_id path

            Keyword Args:
                issuer (str): Organisation issuer. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListOrgsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_id'] = \
                user_id
            return self.call_with_http_info(**kwargs)

        if self.list_all_user_orgs is None:
            self.list_all_user_orgs = _Endpoint(
                settings={
                    'response_type': (ListOrgsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/users/{user_id}/orgs',
                    'operation_id': 'list_all_user_orgs',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_id',
                        'issuer',
                    ],
                    'required': [
                        'user_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_id':
                            (str,),
                        'issuer':
                            (str,),
                    },
                    'attribute_map': {
                        'user_id': 'user_id',
                        'issuer': 'issuer',
                    },
                    'location_map': {
                        'user_id': 'path',
                        'issuer': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_all_user_orgs
            )

        def __list_all_user_roles(
            self,
            user_id,
            **kwargs
        ):
            """Return all roles for a user  # noqa: E501

            Retrieves the roles (application and api) for a user granted for them by the given organisation. These permissions are recursively inherted from any groups to which the user belongs.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_all_user_roles(user_id, async_req=True)
            >>> result = thread.get()

            Args:
                user_id (str): user_id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Roles
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_id'] = \
                user_id
            return self.call_with_http_info(**kwargs)

        if self.list_all_user_roles is None:
            self.list_all_user_roles = _Endpoint(
                settings={
                    'response_type': (Roles,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/users/{user_id}/render_roles',
                    'operation_id': 'list_all_user_roles',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_id',
                        'org_id',
                    ],
                    'required': [
                        'user_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'user_id': 'user_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'user_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_all_user_roles
            )

        def __list_challenge_methods(
            self,
            user_id,
            **kwargs
        ):
            """Get all of a user's multi-factor authentication challenge method configuration  # noqa: E501

            Get all of a user's multi-factor authentication challenge method configuration  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_challenge_methods(user_id, async_req=True)
            >>> result = thread.get()

            Args:
                user_id (str): user_id path

            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                challenge_type (str): challenge method type query. [optional]
                method_status (bool): The status of the challenge method. True for enabled, false for disabled.. [optional]
                method_origin (str): The origin of a challenge method. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListMFAChallengeMethods
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_id'] = \
                user_id
            return self.call_with_http_info(**kwargs)

        if self.list_challenge_methods is None:
            self.list_challenge_methods = _Endpoint(
                settings={
                    'response_type': (ListMFAChallengeMethods,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/users/{user_id}/mfa_challenge_methods',
                    'operation_id': 'list_challenge_methods',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_id',
                        'limit',
                        'challenge_type',
                        'method_status',
                        'method_origin',
                    ],
                    'required': [
                        'user_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_id':
                            (str,),
                        'limit':
                            (int,),
                        'challenge_type':
                            (str,),
                        'method_status':
                            (bool,),
                        'method_origin':
                            (str,),
                    },
                    'attribute_map': {
                        'user_id': 'user_id',
                        'limit': 'limit',
                        'challenge_type': 'challenge_type',
                        'method_status': 'method_status',
                        'method_origin': 'method_origin',
                    },
                    'location_map': {
                        'user_id': 'path',
                        'limit': 'query',
                        'challenge_type': 'query',
                        'method_status': 'query',
                        'method_origin': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_challenge_methods
            )

        def __list_combined_user_details(
            self,
            **kwargs
        ):
            """Get all combined details about users  # noqa: E501

            Get all combined details about users  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_combined_user_details(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                email (Email): Query based on user email. [optional]
                previous_email (Email): Pagination based query with the user's email as the key. To get the initial entries supply an empty string.. [optional]
                org_id (str): Organisation Unique identifier. [optional]
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                type (str): user type. [optional]
                user_id (str): Query based on user id. [optional]
                status ([UserStatusEnum]): The status of users to search for. Multiple values are ORed together.. [optional]
                mfa_enrolled (bool): Restrict query based on the mfa enrollment status of users. Can be omitted for no query restriction. If true, only get users with at least one mfa challenge method. If false, only get users without any mfa challenge methods. . [optional]
                auto_created (bool): Restrict query based on auto-creation. Can be omitted to get all users with no restriction. If true, only get users that are in the auto-created-users group. If false, only get users that are not in the auto-created-users group. . [optional]
                search_direction (str): Direction which the search should go starting from the email_nullable_query parameter. . [optional] if omitted the server will use the default value of "forwards"
                prefix_email_search (Email): Keyword used to search for a list of users based on email. This parameter is case insensitive and finds users with an email that matches the keyword by its prefix. For example, if the keyword \"Foo\" is supplied to this parameter, users with emails of \"foo1@example.com\" and \"Foo2@test.com\" could be returned. . [optional]
                allow_partial_match (bool): Perform a case insensitive partial match of any string query parameters included in the query . [optional]
                first_name (str): query for users with a first name that matches the query parameter. [optional]
                last_name (str): query for users with a last name that matches the query parameter. [optional]
                search_params ([str]): A list of strings to perform a case-insensitive search on all relevant fields in the database for a given collection. Multiple values are ANDed together . [optional]
                disabled_at_time (bool): If set to true, query users that have the disabled_at_time property set. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListCombinedUserDetailsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_combined_user_details is None:
            self.list_combined_user_details = _Endpoint(
                settings={
                    'response_type': (ListCombinedUserDetailsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/combined_user_details',
                    'operation_id': 'list_combined_user_details',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'email',
                        'previous_email',
                        'org_id',
                        'limit',
                        'type',
                        'user_id',
                        'status',
                        'mfa_enrolled',
                        'auto_created',
                        'search_direction',
                        'prefix_email_search',
                        'allow_partial_match',
                        'first_name',
                        'last_name',
                        'search_params',
                        'disabled_at_time',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                        'type',
                        'search_direction',
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                        ('type',): {

                            "USER": "user",
                            "GROUP": "group",
                            "SYSGROUP": "sysgroup",
                            "BIGROUP": "bigroup",
                            "SERVICE_ACCOUNT": "service_account"
                        },
                        ('search_direction',): {

                            "BACKWARDS": "backwards",
                            "FORWARDS": "forwards"
                        },
                    },
                    'openapi_types': {
                        'email':
                            (Email,),
                        'previous_email':
                            (Email,),
                        'org_id':
                            (str,),
                        'limit':
                            (int,),
                        'type':
                            (str,),
                        'user_id':
                            (str,),
                        'status':
                            ([UserStatusEnum],),
                        'mfa_enrolled':
                            (bool,),
                        'auto_created':
                            (bool,),
                        'search_direction':
                            (str,),
                        'prefix_email_search':
                            (Email,),
                        'allow_partial_match':
                            (bool,),
                        'first_name':
                            (str,),
                        'last_name':
                            (str,),
                        'search_params':
                            ([str],),
                        'disabled_at_time':
                            (bool,),
                    },
                    'attribute_map': {
                        'email': 'email',
                        'previous_email': 'previous_email',
                        'org_id': 'org_id',
                        'limit': 'limit',
                        'type': 'type',
                        'user_id': 'user_id',
                        'status': 'status',
                        'mfa_enrolled': 'mfa_enrolled',
                        'auto_created': 'auto_created',
                        'search_direction': 'search_direction',
                        'prefix_email_search': 'prefix_email_search',
                        'allow_partial_match': 'allow_partial_match',
                        'first_name': 'first_name',
                        'last_name': 'last_name',
                        'search_params': 'search_params',
                        'disabled_at_time': 'disabled_at_time',
                    },
                    'location_map': {
                        'email': 'query',
                        'previous_email': 'query',
                        'org_id': 'query',
                        'limit': 'query',
                        'type': 'query',
                        'user_id': 'query',
                        'status': 'query',
                        'mfa_enrolled': 'query',
                        'auto_created': 'query',
                        'search_direction': 'query',
                        'prefix_email_search': 'query',
                        'allow_partial_match': 'query',
                        'first_name': 'query',
                        'last_name': 'query',
                        'search_params': 'query',
                        'disabled_at_time': 'query',
                    },
                    'collection_format_map': {
                        'status': 'multi',
                        'search_params': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_combined_user_details
            )

        def __list_desktop_access_info(
            self,
            org_id,
            user_id,
            **kwargs
        ):
            """Query various users' desktop access information  # noqa: E501

            Query various users' desktop access information  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_desktop_access_info(org_id, user_id, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Organisation Unique identifier
                user_id (str): Query based on user id

            Keyword Args:
                tag ([SelectorTag]): Search files based on tag. [optional]
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                desktop_type (str): The type of desktop search for.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListUserDesktopAccessInfoResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            kwargs['user_id'] = \
                user_id
            return self.call_with_http_info(**kwargs)

        if self.list_desktop_access_info is None:
            self.list_desktop_access_info = _Endpoint(
                settings={
                    'response_type': (ListUserDesktopAccessInfoResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/user_desktop_access_info',
                    'operation_id': 'list_desktop_access_info',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'user_id',
                        'tag',
                        'limit',
                        'desktop_type',
                    ],
                    'required': [
                        'org_id',
                        'user_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                        'desktop_type',
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                        ('desktop_type',): {

                            "RDP": "rdp",
                            "VNC": "vnc"
                        },
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'user_id':
                            (str,),
                        'tag':
                            ([SelectorTag],),
                        'limit':
                            (int,),
                        'desktop_type':
                            (str,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'user_id': 'user_id',
                        'tag': 'tag',
                        'limit': 'limit',
                        'desktop_type': 'desktop_type',
                    },
                    'location_map': {
                        'org_id': 'query',
                        'user_id': 'query',
                        'tag': 'query',
                        'limit': 'query',
                        'desktop_type': 'query',
                    },
                    'collection_format_map': {
                        'tag': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_desktop_access_info
            )

        def __list_org_user_roles(
            self,
            **kwargs
        ):
            """Get all org user roles  # noqa: E501

            Get all org user roles  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_org_user_roles(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                user_id (str): Query based on user id. [optional]
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                offset (int): An offset into the set of data to be returned. This is used for pagination.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListUserRolesForAnOrg
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_org_user_roles is None:
            self.list_org_user_roles = _Endpoint(
                settings={
                    'response_type': (ListUserRolesForAnOrg,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/users/org_user_roles',
                    'operation_id': 'list_org_user_roles',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'user_id',
                        'limit',
                        'offset',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                        'offset',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                        ('offset',): {

                            'inclusive_minimum': 0,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'user_id':
                            (str,),
                        'limit':
                            (int,),
                        'offset':
                            (int,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'user_id': 'user_id',
                        'limit': 'limit',
                        'offset': 'offset',
                    },
                    'location_map': {
                        'org_id': 'query',
                        'user_id': 'query',
                        'limit': 'query',
                        'offset': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_org_user_roles
            )

        def __list_service_accounts(
            self,
            **kwargs
        ):
            """List service accounts  # noqa: E501

            List service accounts  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_service_accounts(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                user_id (str): Query based on user id. [optional]
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListServiceAccountResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_service_accounts is None:
            self.list_service_accounts = _Endpoint(
                settings={
                    'response_type': (ListServiceAccountResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/service_accounts',
                    'operation_id': 'list_service_accounts',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'user_id',
                        'limit',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'user_id':
                            (str,),
                        'limit':
                            (int,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'user_id': 'user_id',
                        'limit': 'limit',
                    },
                    'location_map': {
                        'org_id': 'query',
                        'user_id': 'query',
                        'limit': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_service_accounts
            )

        def __list_ssh_access_info(
            self,
            org_id,
            user_id,
            **kwargs
        ):
            """Query various users' SSH access information  # noqa: E501

            Query various users' SSH access information  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_ssh_access_info(org_id, user_id, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Organisation Unique identifier
                user_id (str): Query based on user id

            Keyword Args:
                tag ([SelectorTag]): Search files based on tag. [optional]
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListUserSSHAccessInfoResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            kwargs['user_id'] = \
                user_id
            return self.call_with_http_info(**kwargs)

        if self.list_ssh_access_info is None:
            self.list_ssh_access_info = _Endpoint(
                settings={
                    'response_type': (ListUserSSHAccessInfoResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/user_ssh_access_info',
                    'operation_id': 'list_ssh_access_info',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'user_id',
                        'tag',
                        'limit',
                    ],
                    'required': [
                        'org_id',
                        'user_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'user_id':
                            (str,),
                        'tag':
                            ([SelectorTag],),
                        'limit':
                            (int,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'user_id': 'user_id',
                        'tag': 'tag',
                        'limit': 'limit',
                    },
                    'location_map': {
                        'org_id': 'query',
                        'user_id': 'query',
                        'tag': 'query',
                        'limit': 'query',
                    },
                    'collection_format_map': {
                        'tag': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_ssh_access_info
            )

        def __list_upstream_user_identities(
            self,
            user_id,
            **kwargs
        ):
            """Get all of a user's upstream user identities  # noqa: E501

            Get all of a user's upstream user identities  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_upstream_user_identities(user_id, async_req=True)
            >>> result = thread.get()

            Args:
                user_id (str): user_id path

            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListUpstreamUserIdentitiesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_id'] = \
                user_id
            return self.call_with_http_info(**kwargs)

        if self.list_upstream_user_identities is None:
            self.list_upstream_user_identities = _Endpoint(
                settings={
                    'response_type': (ListUpstreamUserIdentitiesResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/users/{user_id}/upstream_user_identities',
                    'operation_id': 'list_upstream_user_identities',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_id',
                        'limit',
                    ],
                    'required': [
                        'user_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_id':
                            (str,),
                        'limit':
                            (int,),
                    },
                    'attribute_map': {
                        'user_id': 'user_id',
                        'limit': 'limit',
                    },
                    'location_map': {
                        'user_id': 'path',
                        'limit': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_upstream_user_identities
            )

        def __list_user_application_access_info(
            self,
            org_id,
            user_id,
            **kwargs
        ):
            """Query various users' application access information  # noqa: E501

            Query various users' application access information  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_user_application_access_info(org_id, user_id, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Organisation Unique identifier
                user_id (str): Query based on user id

            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListUserApplicationAccessInfoResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            kwargs['user_id'] = \
                user_id
            return self.call_with_http_info(**kwargs)

        if self.list_user_application_access_info is None:
            self.list_user_application_access_info = _Endpoint(
                settings={
                    'response_type': (ListUserApplicationAccessInfoResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/user_application_access_info',
                    'operation_id': 'list_user_application_access_info',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'user_id',
                        'limit',
                    ],
                    'required': [
                        'org_id',
                        'user_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'user_id':
                            (str,),
                        'limit':
                            (int,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'user_id': 'user_id',
                        'limit': 'limit',
                    },
                    'location_map': {
                        'org_id': 'query',
                        'user_id': 'query',
                        'limit': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_user_application_access_info
            )

        def __list_user_file_share_access_info(
            self,
            org_id,
            user_id,
            **kwargs
        ):
            """Query various users' file share access information  # noqa: E501

            Query various users' file share access information  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_user_file_share_access_info(org_id, user_id, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Organisation Unique identifier
                user_id (str): Query based on user id

            Keyword Args:
                tag ([SelectorTag]): Search files based on tag. [optional]
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListUserFileShareAccessInfoResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            kwargs['user_id'] = \
                user_id
            return self.call_with_http_info(**kwargs)

        if self.list_user_file_share_access_info is None:
            self.list_user_file_share_access_info = _Endpoint(
                settings={
                    'response_type': (ListUserFileShareAccessInfoResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/user_file_share_access_info',
                    'operation_id': 'list_user_file_share_access_info',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'user_id',
                        'tag',
                        'limit',
                    ],
                    'required': [
                        'org_id',
                        'user_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'user_id':
                            (str,),
                        'tag':
                            ([SelectorTag],),
                        'limit':
                            (int,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'user_id': 'user_id',
                        'tag': 'tag',
                        'limit': 'limit',
                    },
                    'location_map': {
                        'org_id': 'query',
                        'user_id': 'query',
                        'tag': 'query',
                        'limit': 'query',
                    },
                    'collection_format_map': {
                        'tag': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_user_file_share_access_info
            )

        def __list_user_guid_mapping(
            self,
            **kwargs
        ):
            """Get all user guids and a unique name mapping  # noqa: E501

            Get all user guids and a unique name mapping  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_user_guid_mapping(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                user_id (str): Query based on user id. [optional]
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                previous_guid (str): Pagination based query with the guid as the key. To get the initial entries supply an empty string.. [optional]
                updated_since (datetime): query since updated. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListGuidMetadataResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_user_guid_mapping is None:
            self.list_user_guid_mapping = _Endpoint(
                settings={
                    'response_type': (ListGuidMetadataResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/users/guids',
                    'operation_id': 'list_user_guid_mapping',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'user_id',
                        'limit',
                        'previous_guid',
                        'updated_since',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'user_id':
                            (str,),
                        'limit':
                            (int,),
                        'previous_guid':
                            (str,),
                        'updated_since':
                            (datetime,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'user_id': 'user_id',
                        'limit': 'limit',
                        'previous_guid': 'previous_guid',
                        'updated_since': 'updated_since',
                    },
                    'location_map': {
                        'org_id': 'query',
                        'user_id': 'query',
                        'limit': 'query',
                        'previous_guid': 'query',
                        'updated_since': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_user_guid_mapping
            )

        def __list_user_guids(
            self,
            **kwargs
        ):
            """Get a list of all user GUIDs  # noqa: E501

            Get a list of all user GUIDs  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_user_guids(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                updated_since (datetime): query since updated. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListUserGuidsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_user_guids is None:
            self.list_user_guids = _Endpoint(
                settings={
                    'response_type': (ListUserGuidsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/users_ids',
                    'operation_id': 'list_user_guids',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'updated_since',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'updated_since':
                            (datetime,),
                    },
                    'attribute_map': {
                        'updated_since': 'updated_since',
                    },
                    'location_map': {
                        'updated_since': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_user_guids
            )

        def __list_user_launcher_access_info(
            self,
            org_id,
            user_id,
            **kwargs
        ):
            """Query various users' launchers access information  # noqa: E501

            Query various users' launchers access information  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_user_launcher_access_info(org_id, user_id, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Organisation Unique identifier
                user_id (str): Query based on user id

            Keyword Args:
                tag ([SelectorTag]): Search files based on tag. [optional]
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListUserLauncherAccessInfoResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            kwargs['user_id'] = \
                user_id
            return self.call_with_http_info(**kwargs)

        if self.list_user_launcher_access_info is None:
            self.list_user_launcher_access_info = _Endpoint(
                settings={
                    'response_type': (ListUserLauncherAccessInfoResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/user_launcher_access_info',
                    'operation_id': 'list_user_launcher_access_info',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'user_id',
                        'tag',
                        'limit',
                    ],
                    'required': [
                        'org_id',
                        'user_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'user_id':
                            (str,),
                        'tag':
                            ([SelectorTag],),
                        'limit':
                            (int,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'user_id': 'user_id',
                        'tag': 'tag',
                        'limit': 'limit',
                    },
                    'location_map': {
                        'org_id': 'query',
                        'user_id': 'query',
                        'tag': 'query',
                        'limit': 'query',
                    },
                    'collection_format_map': {
                        'tag': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_user_launcher_access_info
            )

        def __list_user_metadata(
            self,
            **kwargs
        ):
            """Get a list of user metadata entries  # noqa: E501

            Get a list of user metadata entries  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_user_metadata(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                user_id (str): Query based on user id. [optional]
                org_id (str): Organisation Unique identifier. [optional]
                app_id (str): Application unique identifier. [optional]
                data_type (str): The data type of the metadata. [optional]
                recursive (bool): If true, the query will recurse upwards. [optional] if omitted the server will use the default value of False
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListUserMetadataResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_user_metadata is None:
            self.list_user_metadata = _Endpoint(
                settings={
                    'response_type': (ListUserMetadataResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/user_metadata',
                    'operation_id': 'list_user_metadata',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'user_id',
                        'org_id',
                        'app_id',
                        'data_type',
                        'recursive',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                        'app_id',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                        ('app_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'user_id':
                            (str,),
                        'org_id':
                            (str,),
                        'app_id':
                            (str,),
                        'data_type':
                            (str,),
                        'recursive':
                            (bool,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'user_id': 'user_id',
                        'org_id': 'org_id',
                        'app_id': 'app_id',
                        'data_type': 'data_type',
                        'recursive': 'recursive',
                    },
                    'location_map': {
                        'limit': 'query',
                        'user_id': 'query',
                        'org_id': 'query',
                        'app_id': 'query',
                        'data_type': 'query',
                        'recursive': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_user_metadata
            )

        def __list_user_permissions(
            self,
            user_id,
            **kwargs
        ):
            """Return the user's host permissions  # noqa: E501

            Return the user's host permissions  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_user_permissions(user_id, async_req=True)
            >>> result = thread.get()

            Args:
                user_id (str): user_id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HostPermissions
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_id'] = \
                user_id
            return self.call_with_http_info(**kwargs)

        if self.list_user_permissions is None:
            self.list_user_permissions = _Endpoint(
                settings={
                    'response_type': (HostPermissions,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/users/{user_id}/host_permissions',
                    'operation_id': 'list_user_permissions',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_id',
                        'org_id',
                    ],
                    'required': [
                        'user_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'user_id': 'user_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'user_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_user_permissions
            )

        def __list_user_requests(
            self,
            **kwargs
        ):
            """Get a list of user requests  # noqa: E501

            Get a list of user requests  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_user_requests(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                user_id (str): Query based on user id. [optional]
                org_id (str): Organisation Unique identifier. [optional]
                request_state (str): The state of the request to filter the query. [optional]
                request_type (str): The type of the request to filter the query. Note that `application_access` and `file_share_access` are deprecated. They have been replaced with `application` and `fileshare` respectively. . [optional]
                expired (bool): Search for items that have or have not expired. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListUserRequestInfoResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_user_requests is None:
            self.list_user_requests = _Endpoint(
                settings={
                    'response_type': (ListUserRequestInfoResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/user_requests',
                    'operation_id': 'list_user_requests',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'user_id',
                        'org_id',
                        'request_state',
                        'request_type',
                        'expired',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                        'request_state',
                        'request_type',
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                        ('request_state',): {

                            "PENDING": "pending",
                            "APPROVED": "approved",
                            "DECLINED": "declined"
                        },
                        ('request_type',): {

                            "APPLICATION_ACCESS": "application_access",
                            "FILE_SHARE_ACCESS": "file_share_access",
                            "APPLICATION": "application",
                            "FILESHARE": "fileshare",
                            "APPLICATION_SERVICE": "application_service",
                            "LAUNCHER": "launcher"
                        },
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'user_id':
                            (str,),
                        'org_id':
                            (str,),
                        'request_state':
                            (str,),
                        'request_type':
                            (str,),
                        'expired':
                            (bool,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'user_id': 'user_id',
                        'org_id': 'org_id',
                        'request_state': 'request_state',
                        'request_type': 'request_type',
                        'expired': 'expired',
                    },
                    'location_map': {
                        'limit': 'query',
                        'user_id': 'query',
                        'org_id': 'query',
                        'request_state': 'query',
                        'request_type': 'query',
                        'expired': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_user_requests
            )

        def __list_user_resource_access_info(
            self,
            org_id,
            user_id,
            **kwargs
        ):
            """Query various users' resource access information  # noqa: E501

            Query various users' resource access information  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_user_resource_access_info(org_id, user_id, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Organisation Unique identifier
                user_id (str): Query based on user id

            Keyword Args:
                resource_type (ResourceTypeEnum): The type of resource to query for. [optional]
                tag ([SelectorTag]): Search files based on tag. [optional]
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListUserResourceAccessInfoResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            kwargs['user_id'] = \
                user_id
            return self.call_with_http_info(**kwargs)

        if self.list_user_resource_access_info is None:
            self.list_user_resource_access_info = _Endpoint(
                settings={
                    'response_type': (ListUserResourceAccessInfoResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/user_resource_access_info',
                    'operation_id': 'list_user_resource_access_info',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'user_id',
                        'resource_type',
                        'tag',
                        'limit',
                    ],
                    'required': [
                        'org_id',
                        'user_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'user_id':
                            (str,),
                        'resource_type':
                            (ResourceTypeEnum,),
                        'tag':
                            ([SelectorTag],),
                        'limit':
                            (int,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'user_id': 'user_id',
                        'resource_type': 'resource_type',
                        'tag': 'tag',
                        'limit': 'limit',
                    },
                    'location_map': {
                        'org_id': 'query',
                        'user_id': 'query',
                        'resource_type': 'query',
                        'tag': 'query',
                        'limit': 'query',
                    },
                    'collection_format_map': {
                        'tag': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_user_resource_access_info
            )

        def __list_users(
            self,
            **kwargs
        ):
            """Get all users  # noqa: E501

            Get all users  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_users(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                email (Email): Query based on user email. [optional]
                previous_email (Email): Pagination based query with the user's email as the key. To get the initial entries supply an empty string.. [optional]
                provider (str): Query based on identity provider. [optional]
                org_id (str): Organisation Unique identifier. [optional]
                issuer (str): Organisation issuer. [optional]
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                type ([str]): The type of users to search for. Multiple values are ORed together.. [optional]
                upstream_user_id (str): The id of the user from upstream. [optional]
                upstream_idp_id (str): The unique id of the upstream idp. [optional]
                status ([UserStatusEnum]): The status of users to search for. Multiple values are ORed together.. [optional]
                search_direction (str): Direction which the search should go starting from the email_nullable_query parameter. . [optional] if omitted the server will use the default value of "forwards"
                has_roles (bool): Restrict query based on user permissions. Can be omitted to get all users with no restriction. If true, only get users that have at least one role. If false, only get users with no roles. . [optional]
                has_resource_roles (bool): Restrict query based on user resource permissions. Can be omitted to get all users with no resource restriction. If true, only get users that have at least one resource role. If false, only get users with no resource roles. . [optional]
                prefix_email_search (Email): Keyword used to search for a list of users based on email. This parameter is case insensitive and finds users with an email that matches the keyword by its prefix. For example, if the keyword \"Foo\" is supplied to this parameter, users with emails of \"foo1@example.com\" and \"Foo2@test.com\" could be returned. . [optional]
                orgless_users (bool): Filter for all users that do not have an org associated with them. [optional]
                allow_partial_match (bool): Perform a case insensitive partial match of any string query parameters included in the query . [optional]
                first_name (str): query for users with a first name that matches the query parameter. [optional]
                last_name (str): query for users with a last name that matches the query parameter. [optional]
                user_id (str): Query based on user id. [optional]
                search_params ([str]): A list of strings to perform a case-insensitive search on all relevant fields in the database for a given collection. Multiple values are ANDed together . [optional]
                has_application_permissions (bool): Only return users who have at least one application permission. [optional] if omitted the server will use the default value of False
                application_permissions (bool): Restriction to query users based on application permissions. [optional] if omitted the server will use the default value of False
                disabled_at_time (bool): If set to true, query users that have the disabled_at_time property set. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListUsersResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_users is None:
            self.list_users = _Endpoint(
                settings={
                    'response_type': (ListUsersResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/users',
                    'operation_id': 'list_users',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'email',
                        'previous_email',
                        'provider',
                        'org_id',
                        'issuer',
                        'limit',
                        'type',
                        'upstream_user_id',
                        'upstream_idp_id',
                        'status',
                        'search_direction',
                        'has_roles',
                        'has_resource_roles',
                        'prefix_email_search',
                        'orgless_users',
                        'allow_partial_match',
                        'first_name',
                        'last_name',
                        'user_id',
                        'search_params',
                        'has_application_permissions',
                        'application_permissions',
                        'disabled_at_time',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                        'type',
                        'search_direction',
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                        ('type',): {

                            "USER": "user",
                            "GROUP": "group",
                            "SYSGROUP": "sysgroup",
                            "BIGROUP": "bigroup",
                            "SERVICE_ACCOUNT": "service_account"
                        },
                        ('search_direction',): {

                            "BACKWARDS": "backwards",
                            "FORWARDS": "forwards"
                        },
                    },
                    'openapi_types': {
                        'email':
                            (Email,),
                        'previous_email':
                            (Email,),
                        'provider':
                            (str,),
                        'org_id':
                            (str,),
                        'issuer':
                            (str,),
                        'limit':
                            (int,),
                        'type':
                            ([str],),
                        'upstream_user_id':
                            (str,),
                        'upstream_idp_id':
                            (str,),
                        'status':
                            ([UserStatusEnum],),
                        'search_direction':
                            (str,),
                        'has_roles':
                            (bool,),
                        'has_resource_roles':
                            (bool,),
                        'prefix_email_search':
                            (Email,),
                        'orgless_users':
                            (bool,),
                        'allow_partial_match':
                            (bool,),
                        'first_name':
                            (str,),
                        'last_name':
                            (str,),
                        'user_id':
                            (str,),
                        'search_params':
                            ([str],),
                        'has_application_permissions':
                            (bool,),
                        'application_permissions':
                            (bool,),
                        'disabled_at_time':
                            (bool,),
                    },
                    'attribute_map': {
                        'email': 'email',
                        'previous_email': 'previous_email',
                        'provider': 'provider',
                        'org_id': 'org_id',
                        'issuer': 'issuer',
                        'limit': 'limit',
                        'type': 'type',
                        'upstream_user_id': 'upstream_user_id',
                        'upstream_idp_id': 'upstream_idp_id',
                        'status': 'status',
                        'search_direction': 'search_direction',
                        'has_roles': 'has_roles',
                        'has_resource_roles': 'has_resource_roles',
                        'prefix_email_search': 'prefix_email_search',
                        'orgless_users': 'orgless_users',
                        'allow_partial_match': 'allow_partial_match',
                        'first_name': 'first_name',
                        'last_name': 'last_name',
                        'user_id': 'user_id',
                        'search_params': 'search_params',
                        'has_application_permissions': 'has_application_permissions',
                        'application_permissions': 'application_permissions',
                        'disabled_at_time': 'disabled_at_time',
                    },
                    'location_map': {
                        'email': 'query',
                        'previous_email': 'query',
                        'provider': 'query',
                        'org_id': 'query',
                        'issuer': 'query',
                        'limit': 'query',
                        'type': 'query',
                        'upstream_user_id': 'query',
                        'upstream_idp_id': 'query',
                        'status': 'query',
                        'search_direction': 'query',
                        'has_roles': 'query',
                        'has_resource_roles': 'query',
                        'prefix_email_search': 'query',
                        'orgless_users': 'query',
                        'allow_partial_match': 'query',
                        'first_name': 'query',
                        'last_name': 'query',
                        'user_id': 'query',
                        'search_params': 'query',
                        'has_application_permissions': 'query',
                        'application_permissions': 'query',
                        'disabled_at_time': 'query',
                    },
                    'collection_format_map': {
                        'type': 'multi',
                        'status': 'multi',
                        'search_params': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_users
            )

        def __replace_challenge_method(
            self,
            user_id,
            challenge_method_id,
            **kwargs
        ):
            """Update a user's multi-factor authentication challenge method  # noqa: E501

            Update a user's multi-factor authentication challenge method  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_challenge_method(user_id, challenge_method_id, async_req=True)
            >>> result = thread.get()

            Args:
                user_id (str): user_id path
                challenge_method_id (str): challenge method id

            Keyword Args:
                mfa_challenge_method (MFAChallengeMethod): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                MFAChallengeMethod
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_id'] = \
                user_id
            kwargs['challenge_method_id'] = \
                challenge_method_id
            return self.call_with_http_info(**kwargs)

        if self.replace_challenge_method is None:
            self.replace_challenge_method = _Endpoint(
                settings={
                    'response_type': (MFAChallengeMethod,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/users/{user_id}/mfa_challenge_methods/{challenge_method_id}',
                    'operation_id': 'replace_challenge_method',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_id',
                        'challenge_method_id',
                        'mfa_challenge_method',
                    ],
                    'required': [
                        'user_id',
                        'challenge_method_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_id':
                            (str,),
                        'challenge_method_id':
                            (str,),
                        'mfa_challenge_method':
                            (MFAChallengeMethod,),
                    },
                    'attribute_map': {
                        'user_id': 'user_id',
                        'challenge_method_id': 'challenge_method_id',
                    },
                    'location_map': {
                        'user_id': 'path',
                        'challenge_method_id': 'path',
                        'mfa_challenge_method': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_challenge_method
            )

        def __replace_service_account(
            self,
            service_account_id,
            **kwargs
        ):
            """Update a service account  # noqa: E501

            Update a service account  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_service_account(service_account_id, async_req=True)
            >>> result = thread.get()

            Args:
                service_account_id (str): service_account_id path

            Keyword Args:
                service_account (ServiceAccount): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ServiceAccount
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['service_account_id'] = \
                service_account_id
            return self.call_with_http_info(**kwargs)

        if self.replace_service_account is None:
            self.replace_service_account = _Endpoint(
                settings={
                    'response_type': (ServiceAccount,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/service_accounts/{service_account_id}',
                    'operation_id': 'replace_service_account',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'service_account_id',
                        'service_account',
                    ],
                    'required': [
                        'service_account_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'service_account_id':
                            (str,),
                        'service_account':
                            (ServiceAccount,),
                    },
                    'attribute_map': {
                        'service_account_id': 'service_account_id',
                    },
                    'location_map': {
                        'service_account_id': 'path',
                        'service_account': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_service_account
            )

        def __replace_upstream_user_identity(
            self,
            user_id,
            upstream_user_identity_id,
            **kwargs
        ):
            """Update an upstream user identity  # noqa: E501

            Update an upstream user identity  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_upstream_user_identity(user_id, upstream_user_identity_id, async_req=True)
            >>> result = thread.get()

            Args:
                user_id (str): user_id path
                upstream_user_identity_id (str): The unique id of the upstream user identity

            Keyword Args:
                upstream_user_identity (UpstreamUserIdentity): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UpstreamUserIdentity
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_id'] = \
                user_id
            kwargs['upstream_user_identity_id'] = \
                upstream_user_identity_id
            return self.call_with_http_info(**kwargs)

        if self.replace_upstream_user_identity is None:
            self.replace_upstream_user_identity = _Endpoint(
                settings={
                    'response_type': (UpstreamUserIdentity,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/users/{user_id}/upstream_user_identities/{upstream_user_identity_id}',
                    'operation_id': 'replace_upstream_user_identity',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_id',
                        'upstream_user_identity_id',
                        'upstream_user_identity',
                    ],
                    'required': [
                        'user_id',
                        'upstream_user_identity_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_id':
                            (str,),
                        'upstream_user_identity_id':
                            (str,),
                        'upstream_user_identity':
                            (UpstreamUserIdentity,),
                    },
                    'attribute_map': {
                        'user_id': 'user_id',
                        'upstream_user_identity_id': 'upstream_user_identity_id',
                    },
                    'location_map': {
                        'user_id': 'path',
                        'upstream_user_identity_id': 'path',
                        'upstream_user_identity': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_upstream_user_identity
            )

        def __replace_user(
            self,
            user_id,
            **kwargs
        ):
            """Create or update a user  # noqa: E501

            Create or update a user  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_user(user_id, async_req=True)
            >>> result = thread.get()

            Args:
                user_id (str): user_id path

            Keyword Args:
                user (User): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                User
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_id'] = \
                user_id
            return self.call_with_http_info(**kwargs)

        if self.replace_user is None:
            self.replace_user = _Endpoint(
                settings={
                    'response_type': (User,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/users/{user_id}',
                    'operation_id': 'replace_user',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_id',
                        'user',
                    ],
                    'required': [
                        'user_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_id':
                            (str,),
                        'user':
                            (User,),
                    },
                    'attribute_map': {
                        'user_id': 'user_id',
                    },
                    'location_map': {
                        'user_id': 'path',
                        'user': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_user
            )

        def __replace_user_metadata(
            self,
            metadata_id,
            **kwargs
        ):
            """Update an user metadata entry.  # noqa: E501

            Update an user metadata entry.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_user_metadata(metadata_id, async_req=True)
            >>> result = thread.get()

            Args:
                metadata_id (str): metadata id

            Keyword Args:
                user_metadata (UserMetadata): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UserMetadata
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['metadata_id'] = \
                metadata_id
            return self.call_with_http_info(**kwargs)

        if self.replace_user_metadata is None:
            self.replace_user_metadata = _Endpoint(
                settings={
                    'response_type': (UserMetadata,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/user_metadata/{metadata_id}',
                    'operation_id': 'replace_user_metadata',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'metadata_id',
                        'user_metadata',
                    ],
                    'required': [
                        'metadata_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'metadata_id':
                            (str,),
                        'user_metadata':
                            (UserMetadata,),
                    },
                    'attribute_map': {
                        'metadata_id': 'metadata_id',
                    },
                    'location_map': {
                        'metadata_id': 'path',
                        'user_metadata': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_user_metadata
            )

        def __replace_user_request(
            self,
            user_request_id,
            **kwargs
        ):
            """Update an user request. Note this method ignores the state parameter.  # noqa: E501

            Update an user request. Note this method ignores the state parameter.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_user_request(user_request_id, async_req=True)
            >>> result = thread.get()

            Args:
                user_request_id (str): user request id

            Keyword Args:
                user_request_info (UserRequestInfo): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UserRequestInfo
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_request_id'] = \
                user_request_id
            return self.call_with_http_info(**kwargs)

        if self.replace_user_request is None:
            self.replace_user_request = _Endpoint(
                settings={
                    'response_type': (UserRequestInfo,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/user_requests/{user_request_id}',
                    'operation_id': 'replace_user_request',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_request_id',
                        'user_request_info',
                    ],
                    'required': [
                        'user_request_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_request_id':
                            (str,),
                        'user_request_info':
                            (UserRequestInfo,),
                    },
                    'attribute_map': {
                        'user_request_id': 'user_request_id',
                    },
                    'location_map': {
                        'user_request_id': 'path',
                        'user_request_info': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_user_request
            )

        def __replace_user_role(
            self,
            user_id,
            **kwargs
        ):
            """Create or update a user role  # noqa: E501

            Create or update a user role  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_user_role(user_id, async_req=True)
            >>> result = thread.get()

            Args:
                user_id (str): user_id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                replace_user_role_request (ReplaceUserRoleRequest): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_id'] = \
                user_id
            return self.call_with_http_info(**kwargs)

        if self.replace_user_role is None:
            self.replace_user_role = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/users/{user_id}/roles',
                    'operation_id': 'replace_user_role',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_id',
                        'org_id',
                        'replace_user_role_request',
                    ],
                    'required': [
                        'user_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_id':
                            (str,),
                        'org_id':
                            (str,),
                        'replace_user_role_request':
                            (ReplaceUserRoleRequest,),
                    },
                    'attribute_map': {
                        'user_id': 'user_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'user_id': 'path',
                        'org_id': 'query',
                        'replace_user_role_request': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_user_role
            )

        def __reset_user_identity(
            self,
            user_id,
            reset_user_identity_request,
            **kwargs
        ):
            """Resets a user's identity if allowed  # noqa: E501

            Resets a user's identity if they belong to a single organisation, allowing a change of their core identity information.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.reset_user_identity(user_id, reset_user_identity_request, async_req=True)
            >>> result = thread.get()

            Args:
                user_id (str): user_id path
                reset_user_identity_request (ResetUserIdentityRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                User
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_id'] = \
                user_id
            kwargs['reset_user_identity_request'] = \
                reset_user_identity_request
            return self.call_with_http_info(**kwargs)

        if self.reset_user_identity is None:
            self.reset_user_identity = _Endpoint(
                settings={
                    'response_type': (User,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/users/{user_id}/reset_user_identity',
                    'operation_id': 'reset_user_identity',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_id',
                        'reset_user_identity_request',
                    ],
                    'required': [
                        'user_id',
                        'reset_user_identity_request',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_id':
                            (str,),
                        'reset_user_identity_request':
                            (ResetUserIdentityRequest,),
                    },
                    'attribute_map': {
                        'user_id': 'user_id',
                    },
                    'location_map': {
                        'user_id': 'path',
                        'reset_user_identity_request': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__reset_user_identity
            )

        def __reset_user_mfa_challenge_methods(
            self,
            user_id,
            reset_mfa_challenge_method,
            **kwargs
        ):
            """Resets a user's multi-factor authentication method  # noqa: E501

            Resets a user's multi-factor authentication method  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.reset_user_mfa_challenge_methods(user_id, reset_mfa_challenge_method, async_req=True)
            >>> result = thread.get()

            Args:
                user_id (str): user_id path
                reset_mfa_challenge_method (ResetMFAChallengeMethod):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_id'] = \
                user_id
            kwargs['reset_mfa_challenge_method'] = \
                reset_mfa_challenge_method
            return self.call_with_http_info(**kwargs)

        if self.reset_user_mfa_challenge_methods is None:
            self.reset_user_mfa_challenge_methods = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/users/{user_id}/reset_mfa_challenge_methods',
                    'operation_id': 'reset_user_mfa_challenge_methods',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_id',
                        'reset_mfa_challenge_method',
                    ],
                    'required': [
                        'user_id',
                        'reset_mfa_challenge_method',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_id':
                            (str,),
                        'reset_mfa_challenge_method':
                            (ResetMFAChallengeMethod,),
                    },
                    'attribute_map': {
                        'user_id': 'user_id',
                    },
                    'location_map': {
                        'user_id': 'path',
                        'reset_mfa_challenge_method': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__reset_user_mfa_challenge_methods
            )

        def __update_user_request(
            self,
            user_request_id,
            **kwargs
        ):
            """Uses the state parameter in the body to apply the action to the request  # noqa: E501

            Uses the state parameter in the body to apply the action to the request  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_user_request(user_request_id, async_req=True)
            >>> result = thread.get()

            Args:
                user_request_id (str): user request id

            Keyword Args:
                user_request_info (UserRequestInfo): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UserRequestInfo
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_request_id'] = \
                user_request_id
            return self.call_with_http_info(**kwargs)

        if self.update_user_request is None:
            self.update_user_request = _Endpoint(
                settings={
                    'response_type': (UserRequestInfo,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/user_requests/{user_request_id}',
                    'operation_id': 'update_user_request',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_request_id',
                        'user_request_info',
                    ],
                    'required': [
                        'user_request_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_request_id':
                            (str,),
                        'user_request_info':
                            (UserRequestInfo,),
                    },
                    'attribute_map': {
                        'user_request_id': 'user_request_id',
                    },
                    'location_map': {
                        'user_request_id': 'path',
                        'user_request_info': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__update_user_request
            )

    bulk_approve_requests = None 
    bulk_update_metadata = None 
    create_challenge_method = None 
    create_service_account = None 
    create_upstream_user_identity = None 
    create_user = None 
    create_user_identity_update = None 
    create_user_metadata = None 
    create_user_request = None 
    delete_challenge_method = None 
    delete_service_account = None 
    delete_upstream_user_identity = None 
    delete_user = None 
    delete_user_metadata = None 
    delete_user_request = None 
    get_challenge_method = None 
    get_service_account = None 
    get_upstream_user_identity = None 
    get_user = None 
    get_user_metadata = None 
    get_user_request = None 
    list_access_requests = None 
    list_all_resource_permissions = None 
    list_all_user_orgs = None 
    list_all_user_roles = None 
    list_challenge_methods = None 
    list_combined_user_details = None 
    list_desktop_access_info = None 
    list_org_user_roles = None 
    list_service_accounts = None 
    list_ssh_access_info = None 
    list_upstream_user_identities = None 
    list_user_application_access_info = None 
    list_user_file_share_access_info = None 
    list_user_guid_mapping = None 
    list_user_guids = None 
    list_user_launcher_access_info = None 
    list_user_metadata = None 
    list_user_permissions = None 
    list_user_requests = None 
    list_user_resource_access_info = None 
    list_users = None 
    replace_challenge_method = None 
    replace_service_account = None 
    replace_upstream_user_identity = None 
    replace_user = None 
    replace_user_metadata = None 
    replace_user_request = None 
    replace_user_role = None 
    reset_user_identity = None 
    reset_user_mfa_challenge_methods = None 
    update_user_request = None 
