"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2023.07.26
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)
from ..model_utils import OpenApiModel
from agilicus_api.exceptions import ApiAttributeError


def lazy_import():
    from agilicus_api.model.cors_origin import CORSOrigin
    globals()['CORSOrigin'] = CORSOrigin


class CORSSettings(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('origin_matching',): {
            'ME': "me",
            'WILDCARD': "wildcard",
            'LIST': "list",
        },
    }

    validations = {
        ('max_age_seconds',): {
            'inclusive_minimum': -1,
        },
    }

    @property
    def enabled(self):
       return self.get("enabled")

    @enabled.setter
    def enabled(self, new_value):
       self.enabled = new_value

    @property
    def mode(self):
       return self.get("mode")

    @mode.setter
    def mode(self, new_value):
       self.mode = new_value

    @property
    def origin_matching(self):
       return self.get("origin_matching")

    @origin_matching.setter
    def origin_matching(self, new_value):
       self.origin_matching = new_value

    @property
    def allow_resource_origins(self):
       return self.get("allow_resource_origins")

    @allow_resource_origins.setter
    def allow_resource_origins(self, new_value):
       self.allow_resource_origins = new_value

    @property
    def allow_origins(self):
       return self.get("allow_origins")

    @allow_origins.setter
    def allow_origins(self, new_value):
       self.allow_origins = new_value

    @property
    def allow_methods(self):
       return self.get("allow_methods")

    @allow_methods.setter
    def allow_methods(self, new_value):
       self.allow_methods = new_value

    @property
    def allow_headers(self):
       return self.get("allow_headers")

    @allow_headers.setter
    def allow_headers(self, new_value):
       self.allow_headers = new_value

    @property
    def expose_headers(self):
       return self.get("expose_headers")

    @expose_headers.setter
    def expose_headers(self, new_value):
       self.expose_headers = new_value

    @property
    def max_age_seconds(self):
       return self.get("max_age_seconds")

    @max_age_seconds.setter
    def max_age_seconds(self, new_value):
       self.max_age_seconds = new_value

    @property
    def allow_credentials(self):
       return self.get("allow_credentials")

    @allow_credentials.setter
    def allow_credentials(self, new_value):
       self.allow_credentials = new_value

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'enabled': (bool,),  # noqa: E501
            'origin_matching': (str,),  # noqa: E501
            'allow_origins': ([CORSOrigin],),  # noqa: E501
            'allow_methods': ([str],),  # noqa: E501
            'allow_headers': ([str],),  # noqa: E501
            'expose_headers': ([str],),  # noqa: E501
            'max_age_seconds': (int,),  # noqa: E501
            'allow_credentials': (bool,),  # noqa: E501
            'mode': (str,),  # noqa: E501
            'allow_resource_origins': (bool,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None



    attribute_map = {
        'enabled': 'enabled',  # noqa: E501
        'origin_matching': 'origin_matching',  # noqa: E501
        'allow_origins': 'allow_origins',  # noqa: E501
        'allow_methods': 'allow_methods',  # noqa: E501
        'allow_headers': 'allow_headers',  # noqa: E501
        'expose_headers': 'expose_headers',  # noqa: E501
        'max_age_seconds': 'max_age_seconds',  # noqa: E501
        'allow_credentials': 'allow_credentials',  # noqa: E501
        'mode': 'mode',  # noqa: E501
        'allow_resource_origins': 'allow_resource_origins',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, enabled, origin_matching, allow_origins, allow_methods, allow_headers, expose_headers, max_age_seconds, allow_credentials, *args, **kwargs):  # noqa: E501
        """CORSSettings - a model defined in OpenAPI

        Args:
            enabled (bool): Whether or not to apply the CORS policy. If the policy is disabled, then any CORS headers applied by the application will be passed through unchanged. 
            origin_matching (str): How to match the origin. Note that in all cases the 'allow_origins' list will be consulted.  - `me`: match the hosts on which this application can be reached.  - `wildcard`: match any host.  - `list`: match only those hosts provided in the `allow_origins` list. 
            allow_origins ([CORSOrigin]): Lists the origins allowed to access the resources of this application. Any matching origin will have its value echoed back in the `Access-Control-Allow-Origin` header. 
            allow_methods ([str]): The methods for which to allow access to resources. These correspond to the `Access-Control-Allow-Methods` header, into which they are joined by commas. If this value is null, then the methods are wildcarded. Set a value to '*' to wildcard. 
            allow_headers ([str]): The headers which may be sent in a request to resources from this application. These correspond to the `Access-Control-Allow-Headers` header, into which they are joined by commas. If this value is null, then the headers are wildcarded. Set a value to '*' to wildcard. 
            expose_headers ([str]): The response headers which the javascript running in the browser may access for resources from this application. These correspond to the `Access-Control-Expose-Headers` header, into which they are joined by commas. If this value is null, then the headers are wildcarded. Set a value to '*' to wildcard. 
            max_age_seconds (int): This sets the `Access-Control-Max-Age` which controls the maximum number of seconds for which the results of the CORS preflight check may be cached. -1 disables caching. 
            allow_credentials (bool): Whether credentials may be sent in requests. This corresponds to the `Access-Control-Allow-Credentials` header. 

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            mode (str): How the CORS settings are applied. - `overwrite`: CORS settings as configured overwrite any policy returned by the server.   This is the default behaviour. - `clear`: No CORS settings are applied. Any policy returned by the server is cleared out. . [optional]  # noqa: E501
            allow_resource_origins (bool): When true, an Applications that have multiple ApplicationServices assigned to them will be allowed access according to the hostname configured for that service. See expose_as_hostnames in ApplicationService. When true, this setting will work in addition to the origin_matching configuration. . [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.enabled = enabled
        self.origin_matching = origin_matching
        self.allow_origins = allow_origins
        self.allow_methods = allow_methods
        self.allow_headers = allow_headers
        self.expose_headers = expose_headers
        self.max_age_seconds = max_age_seconds
        self.allow_credentials = allow_credentials
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    def __python_set(val):
        return set(val)
 
    required_properties = __python_set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, enabled, origin_matching, allow_origins, allow_methods, allow_headers, expose_headers, max_age_seconds, allow_credentials, *args, **kwargs):  # noqa: E501
        """CORSSettings - a model defined in OpenAPI

        Args:
            enabled (bool): Whether or not to apply the CORS policy. If the policy is disabled, then any CORS headers applied by the application will be passed through unchanged. 
            origin_matching (str): How to match the origin. Note that in all cases the 'allow_origins' list will be consulted.  - `me`: match the hosts on which this application can be reached.  - `wildcard`: match any host.  - `list`: match only those hosts provided in the `allow_origins` list. 
            allow_origins ([CORSOrigin]): Lists the origins allowed to access the resources of this application. Any matching origin will have its value echoed back in the `Access-Control-Allow-Origin` header. 
            allow_methods ([str]): The methods for which to allow access to resources. These correspond to the `Access-Control-Allow-Methods` header, into which they are joined by commas. If this value is null, then the methods are wildcarded. Set a value to '*' to wildcard. 
            allow_headers ([str]): The headers which may be sent in a request to resources from this application. These correspond to the `Access-Control-Allow-Headers` header, into which they are joined by commas. If this value is null, then the headers are wildcarded. Set a value to '*' to wildcard. 
            expose_headers ([str]): The response headers which the javascript running in the browser may access for resources from this application. These correspond to the `Access-Control-Expose-Headers` header, into which they are joined by commas. If this value is null, then the headers are wildcarded. Set a value to '*' to wildcard. 
            max_age_seconds (int): This sets the `Access-Control-Max-Age` which controls the maximum number of seconds for which the results of the CORS preflight check may be cached. -1 disables caching. 
            allow_credentials (bool): Whether credentials may be sent in requests. This corresponds to the `Access-Control-Allow-Credentials` header. 

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            mode (str): How the CORS settings are applied. - `overwrite`: CORS settings as configured overwrite any policy returned by the server.   This is the default behaviour. - `clear`: No CORS settings are applied. Any policy returned by the server is cleared out. . [optional]  # noqa: E501
            allow_resource_origins (bool): When true, an Applications that have multiple ApplicationServices assigned to them will be allowed access according to the hostname configured for that service. See expose_as_hostnames in ApplicationService. When true, this setting will work in addition to the origin_matching configuration. . [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.enabled = enabled
        self.origin_matching = origin_matching
        self.allow_origins = allow_origins
        self.allow_methods = allow_methods
        self.allow_headers = allow_headers
        self.expose_headers = expose_headers
        self.max_age_seconds = max_age_seconds
        self.allow_credentials = allow_credentials
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

