"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2023.07.26
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import unittest

import agilicus_api
from agilicus_api.api.challenges_api import ChallengesApi  # noqa: E501


class TestChallengesApi(unittest.TestCase):
    """ChallengesApi unit test stubs"""

    def setUp(self):
        self.api = ChallengesApi()  # noqa: E501

    def tearDown(self):
        pass

    def test_create_challenge(self):
        """Test case for create_challenge

        create a challenge  # noqa: E501
        """
        pass

    def test_create_one_time_use_action(self):
        """Test case for create_one_time_use_action

        create a one time use action challenge  # noqa: E501
        """
        pass

    def test_create_totp_enrollment(self):
        """Test case for create_totp_enrollment

        create a TOTP challenge enrollment  # noqa: E501
        """
        pass

    def test_create_webauthn_enrollment(self):
        """Test case for create_webauthn_enrollment

        create a WebAuthN challenge enrollment  # noqa: E501
        """
        pass

    def test_delete_challenge(self):
        """Test case for delete_challenge

        Delete the challenge specified by challenge_id  # noqa: E501
        """
        pass

    def test_delete_totp_enrollment(self):
        """Test case for delete_totp_enrollment

        Delete the TOTP enrollment specified by totp id  # noqa: E501
        """
        pass

    def test_delete_webauthn_enrollment(self):
        """Test case for delete_webauthn_enrollment

        Delete the WebAuthN enrollment specified by webauthn_id  # noqa: E501
        """
        pass

    def test_get_answer(self):
        """Test case for get_answer

        answer a challenge  # noqa: E501
        """
        pass

    def test_get_challenge(self):
        """Test case for get_challenge

        Get the challenge specified by challenge_id  # noqa: E501
        """
        pass

    def test_get_totp_enrollment(self):
        """Test case for get_totp_enrollment

        Get the TOTP enrollment specified by totp_id  # noqa: E501
        """
        pass

    def test_get_webauthn_enrollment(self):
        """Test case for get_webauthn_enrollment

        Get the WebAuthN enrollment specified by webauthn_id  # noqa: E501
        """
        pass

    def test_list_totp_enrollment(self):
        """Test case for list_totp_enrollment

        List the totp enrollment results  # noqa: E501
        """
        pass

    def test_list_webauthn_enrollments(self):
        """Test case for list_webauthn_enrollments

        List the webauthn enrollments  # noqa: E501
        """
        pass

    def test_replace_challenge(self):
        """Test case for replace_challenge

        Replace the challenge specified by challenge_id  # noqa: E501
        """
        pass

    def test_update_totp_enrollment(self):
        """Test case for update_totp_enrollment

        Update the totp_enrollment if the answer provided is correct.  # noqa: E501
        """
        pass

    def test_update_webauthn_enrollment(self):
        """Test case for update_webauthn_enrollment

        Update the WebAuthN enrollment if the answer provided is correct.  # noqa: E501
        """
        pass


if __name__ == '__main__':
    unittest.main()
