# API Reference <a name="API Reference"></a>

## Constructs <a name="Constructs"></a>

### Provider <a name="cdk-ec2spot.Provider"></a>

#### Initializers <a name="cdk-ec2spot.Provider.Initializer"></a>

```typescript
import { Provider } from 'cdk-ec2spot'

new Provider(scope: Construct, id: string)
```

##### `scope`<sup>Required</sup> <a name="cdk-ec2spot.Provider.parameter.scope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

---

##### `id`<sup>Required</sup> <a name="cdk-ec2spot.Provider.parameter.id"></a>

- *Type:* `string`

---

#### Methods <a name="Methods"></a>

##### `createAutoScalingGroup` <a name="cdk-ec2spot.Provider.createAutoScalingGroup"></a>

```typescript
public createAutoScalingGroup(id: string, options: AutoScalingGroupOptions)
```

###### `id`<sup>Required</sup> <a name="cdk-ec2spot.Provider.parameter.id"></a>

- *Type:* `string`

AutoScaling Group ID.

---

###### `options`<sup>Required</sup> <a name="cdk-ec2spot.Provider.parameter.options"></a>

- *Type:* [`cdk-ec2spot.AutoScalingGroupOptions`](#cdk-ec2spot.AutoScalingGroupOptions)

AutoScaling Group options.

---

##### `createFleet` <a name="cdk-ec2spot.Provider.createFleet"></a>

```typescript
public createFleet(id: string, options: SpotFleetOptions)
```

###### `id`<sup>Required</sup> <a name="cdk-ec2spot.Provider.parameter.id"></a>

- *Type:* `string`

fleet id.

---

###### `options`<sup>Required</sup> <a name="cdk-ec2spot.Provider.parameter.options"></a>

- *Type:* [`cdk-ec2spot.SpotFleetOptions`](#cdk-ec2spot.SpotFleetOptions)

spot fleet options.

---

##### `createInstance` <a name="cdk-ec2spot.Provider.createInstance"></a>

```typescript
public createInstance(id: string, optons: SpotInstanceProps)
```

###### `id`<sup>Required</sup> <a name="cdk-ec2spot.Provider.parameter.id"></a>

- *Type:* `string`

---

###### `optons`<sup>Required</sup> <a name="cdk-ec2spot.Provider.parameter.optons"></a>

- *Type:* [`cdk-spot-one.SpotInstanceProps`](#cdk-spot-one.SpotInstanceProps)

---

##### `createInstanceProfile` <a name="cdk-ec2spot.Provider.createInstanceProfile"></a>

```typescript
public createInstanceProfile(id: string)
```

###### `id`<sup>Required</sup> <a name="cdk-ec2spot.Provider.parameter.id"></a>

- *Type:* `string`

---

##### `createLaunchTemplate` <a name="cdk-ec2spot.Provider.createLaunchTemplate"></a>

```typescript
public createLaunchTemplate(id: string, options?: LaunchTemplateOptions)
```

###### `id`<sup>Required</sup> <a name="cdk-ec2spot.Provider.parameter.id"></a>

- *Type:* `string`

launch template id.

---

###### `options`<sup>Optional</sup> <a name="cdk-ec2spot.Provider.parameter.options"></a>

- *Type:* [`cdk-ec2spot.LaunchTemplateOptions`](#cdk-ec2spot.LaunchTemplateOptions)

launch template options.

---

##### `getOrCreateVpc` <a name="cdk-ec2spot.Provider.getOrCreateVpc"></a>

```typescript
public getOrCreateVpc(scope: Construct)
```

###### `scope`<sup>Required</sup> <a name="cdk-ec2spot.Provider.parameter.scope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

---


#### Properties <a name="Properties"></a>

##### `amazonLinuxAmiImageId`<sup>Required</sup> <a name="cdk-ec2spot.Provider.property.amazonLinuxAmiImageId"></a>

```typescript
public readonly amazonLinuxAmiImageId: string;
```

- *Type:* `string`

---


## Structs <a name="Structs"></a>

### AutoScalingGroupOptions <a name="cdk-ec2spot.AutoScalingGroupOptions"></a>

#### Initializer <a name="[object Object].Initializer"></a>

```typescript
import { AutoScalingGroupOptions } from 'cdk-ec2spot'

const autoScalingGroupOptions: AutoScalingGroupOptions = { ... }
```

##### `instanceProfile`<sup>Optional</sup> <a name="cdk-ec2spot.AutoScalingGroupOptions.property.instanceProfile"></a>

```typescript
public readonly instanceProfile: CfnInstanceProfile;
```

- *Type:* [`aws-cdk-lib.aws_iam.CfnInstanceProfile`](#aws-cdk-lib.aws_iam.CfnInstanceProfile)

---

##### `instanceType`<sup>Optional</sup> <a name="cdk-ec2spot.AutoScalingGroupOptions.property.instanceType"></a>

```typescript
public readonly instanceType: InstanceType;
```

- *Type:* [`aws-cdk-lib.aws_ec2.InstanceType`](#aws-cdk-lib.aws_ec2.InstanceType)

---

##### `machineImage`<sup>Optional</sup> <a name="cdk-ec2spot.AutoScalingGroupOptions.property.machineImage"></a>

```typescript
public readonly machineImage: IMachineImage;
```

- *Type:* [`aws-cdk-lib.aws_ec2.IMachineImage`](#aws-cdk-lib.aws_ec2.IMachineImage)

---

##### `spotOptions`<sup>Optional</sup> <a name="cdk-ec2spot.AutoScalingGroupOptions.property.spotOptions"></a>

```typescript
public readonly spotOptions: SpotOptions;
```

- *Type:* [`cdk-ec2spot.SpotOptions`](#cdk-ec2spot.SpotOptions)

---

##### `userData`<sup>Optional</sup> <a name="cdk-ec2spot.AutoScalingGroupOptions.property.userData"></a>

```typescript
public readonly userData: UserData;
```

- *Type:* [`aws-cdk-lib.aws_ec2.UserData`](#aws-cdk-lib.aws_ec2.UserData)

---

##### `vpc`<sup>Required</sup> <a name="cdk-ec2spot.AutoScalingGroupOptions.property.vpc"></a>

```typescript
public readonly vpc: IVpc;
```

- *Type:* [`aws-cdk-lib.aws_ec2.IVpc`](#aws-cdk-lib.aws_ec2.IVpc)

The vpc for the AutoScalingGroup.

---

##### `defaultCapacitySize`<sup>Optional</sup> <a name="cdk-ec2spot.AutoScalingGroupOptions.property.defaultCapacitySize"></a>

```typescript
public readonly defaultCapacitySize: number;
```

- *Type:* `number`
- *Default:* 1

default capacity size for the Auto Scaling Group.

---

### LaunchTemplateOptions <a name="cdk-ec2spot.LaunchTemplateOptions"></a>

#### Initializer <a name="[object Object].Initializer"></a>

```typescript
import { LaunchTemplateOptions } from 'cdk-ec2spot'

const launchTemplateOptions: LaunchTemplateOptions = { ... }
```

##### `instanceProfile`<sup>Optional</sup> <a name="cdk-ec2spot.LaunchTemplateOptions.property.instanceProfile"></a>

```typescript
public readonly instanceProfile: CfnInstanceProfile;
```

- *Type:* [`aws-cdk-lib.aws_iam.CfnInstanceProfile`](#aws-cdk-lib.aws_iam.CfnInstanceProfile)

---

##### `instanceType`<sup>Optional</sup> <a name="cdk-ec2spot.LaunchTemplateOptions.property.instanceType"></a>

```typescript
public readonly instanceType: InstanceType;
```

- *Type:* [`aws-cdk-lib.aws_ec2.InstanceType`](#aws-cdk-lib.aws_ec2.InstanceType)

---

##### `machineImage`<sup>Optional</sup> <a name="cdk-ec2spot.LaunchTemplateOptions.property.machineImage"></a>

```typescript
public readonly machineImage: IMachineImage;
```

- *Type:* [`aws-cdk-lib.aws_ec2.IMachineImage`](#aws-cdk-lib.aws_ec2.IMachineImage)

---

##### `spotOptions`<sup>Optional</sup> <a name="cdk-ec2spot.LaunchTemplateOptions.property.spotOptions"></a>

```typescript
public readonly spotOptions: SpotOptions;
```

- *Type:* [`cdk-ec2spot.SpotOptions`](#cdk-ec2spot.SpotOptions)

---

##### `userData`<sup>Optional</sup> <a name="cdk-ec2spot.LaunchTemplateOptions.property.userData"></a>

```typescript
public readonly userData: UserData;
```

- *Type:* [`aws-cdk-lib.aws_ec2.UserData`](#aws-cdk-lib.aws_ec2.UserData)

---

### SpotFleetOptions <a name="cdk-ec2spot.SpotFleetOptions"></a>

#### Initializer <a name="[object Object].Initializer"></a>

```typescript
import { SpotFleetOptions } from 'cdk-ec2spot'

const spotFleetOptions: SpotFleetOptions = { ... }
```

##### `instanceProfile`<sup>Optional</sup> <a name="cdk-ec2spot.SpotFleetOptions.property.instanceProfile"></a>

```typescript
public readonly instanceProfile: CfnInstanceProfile;
```

- *Type:* [`aws-cdk-lib.aws_iam.CfnInstanceProfile`](#aws-cdk-lib.aws_iam.CfnInstanceProfile)

---

##### `instanceType`<sup>Optional</sup> <a name="cdk-ec2spot.SpotFleetOptions.property.instanceType"></a>

```typescript
public readonly instanceType: InstanceType;
```

- *Type:* [`aws-cdk-lib.aws_ec2.InstanceType`](#aws-cdk-lib.aws_ec2.InstanceType)

---

##### `machineImage`<sup>Optional</sup> <a name="cdk-ec2spot.SpotFleetOptions.property.machineImage"></a>

```typescript
public readonly machineImage: IMachineImage;
```

- *Type:* [`aws-cdk-lib.aws_ec2.IMachineImage`](#aws-cdk-lib.aws_ec2.IMachineImage)

---

##### `spotOptions`<sup>Optional</sup> <a name="cdk-ec2spot.SpotFleetOptions.property.spotOptions"></a>

```typescript
public readonly spotOptions: SpotOptions;
```

- *Type:* [`cdk-ec2spot.SpotOptions`](#cdk-ec2spot.SpotOptions)

---

##### `userData`<sup>Optional</sup> <a name="cdk-ec2spot.SpotFleetOptions.property.userData"></a>

```typescript
public readonly userData: UserData;
```

- *Type:* [`aws-cdk-lib.aws_ec2.UserData`](#aws-cdk-lib.aws_ec2.UserData)

---

##### `vpc`<sup>Required</sup> <a name="cdk-ec2spot.SpotFleetOptions.property.vpc"></a>

```typescript
public readonly vpc: IVpc;
```

- *Type:* [`aws-cdk-lib.aws_ec2.IVpc`](#aws-cdk-lib.aws_ec2.IVpc)

The vpc for the AutoScalingGroup.

---

##### `defaultCapacitySize`<sup>Optional</sup> <a name="cdk-ec2spot.SpotFleetOptions.property.defaultCapacitySize"></a>

```typescript
public readonly defaultCapacitySize: number;
```

- *Type:* `number`
- *Default:* 1

default capacity size for the Auto Scaling Group.

---

##### `terminateInstancesWithExpiration`<sup>Optional</sup> <a name="cdk-ec2spot.SpotFleetOptions.property.terminateInstancesWithExpiration"></a>

```typescript
public readonly terminateInstancesWithExpiration: boolean;
```

- *Type:* `boolean`
- *Default:* true

Whether to terminate the fleet with expiration.

---

##### `validFrom`<sup>Optional</sup> <a name="cdk-ec2spot.SpotFleetOptions.property.validFrom"></a>

```typescript
public readonly validFrom: string;
```

- *Type:* `string`
- *Default:* now

The timestamp of the beginning of the valid duration.

---

##### `validUntil`<sup>Optional</sup> <a name="cdk-ec2spot.SpotFleetOptions.property.validUntil"></a>

```typescript
public readonly validUntil: string;
```

- *Type:* `string`
- *Default:* unlimited

The timestamp of the beginning of the valid duration.

---

##### `vpcSubnet`<sup>Optional</sup> <a name="cdk-ec2spot.SpotFleetOptions.property.vpcSubnet"></a>

```typescript
public readonly vpcSubnet: SubnetSelection;
```

- *Type:* [`aws-cdk-lib.aws_ec2.SubnetSelection`](#aws-cdk-lib.aws_ec2.SubnetSelection)
- *Default:* ec2.SubnetType.PRIVATE

VPC subnet selection.

---

### SpotOptions <a name="cdk-ec2spot.SpotOptions"></a>

#### Initializer <a name="[object Object].Initializer"></a>

```typescript
import { SpotOptions } from 'cdk-ec2spot'

const spotOptions: SpotOptions = { ... }
```

##### `blockDurationMinutes`<sup>Optional</sup> <a name="cdk-ec2spot.SpotOptions.property.blockDurationMinutes"></a>

```typescript
public readonly blockDurationMinutes: BlockDurationMinutes;
```

- *Type:* [`cdk-ec2spot.BlockDurationMinutes`](#cdk-ec2spot.BlockDurationMinutes)

---

##### `instanceInterruptionBehavior`<sup>Optional</sup> <a name="cdk-ec2spot.SpotOptions.property.instanceInterruptionBehavior"></a>

```typescript
public readonly instanceInterruptionBehavior: InstanceInterruptionBehavior;
```

- *Type:* [`cdk-ec2spot.InstanceInterruptionBehavior`](#cdk-ec2spot.InstanceInterruptionBehavior)

---

##### `maxPrice`<sup>Optional</sup> <a name="cdk-ec2spot.SpotOptions.property.maxPrice"></a>

```typescript
public readonly maxPrice: string;
```

- *Type:* `string`

---

##### `spotInstanceType`<sup>Optional</sup> <a name="cdk-ec2spot.SpotOptions.property.spotInstanceType"></a>

```typescript
public readonly spotInstanceType: SpotInstanceType;
```

- *Type:* [`cdk-ec2spot.SpotInstanceType`](#cdk-ec2spot.SpotInstanceType)

---

##### `validUntil`<sup>Optional</sup> <a name="cdk-ec2spot.SpotOptions.property.validUntil"></a>

```typescript
public readonly validUntil: string;
```

- *Type:* `string`

---



## Enums <a name="Enums"></a>

### BlockDurationMinutes <a name="BlockDurationMinutes"></a>

#### `ONE_HOUR` <a name="cdk-ec2spot.BlockDurationMinutes.ONE_HOUR"></a>

---


#### `TWO_HOURS` <a name="cdk-ec2spot.BlockDurationMinutes.TWO_HOURS"></a>

---


#### `THREE_HOURS` <a name="cdk-ec2spot.BlockDurationMinutes.THREE_HOURS"></a>

---


#### `FOUR_HOURS` <a name="cdk-ec2spot.BlockDurationMinutes.FOUR_HOURS"></a>

---


#### `FIVE_HOURS` <a name="cdk-ec2spot.BlockDurationMinutes.FIVE_HOURS"></a>

---


#### `SIX_HOURS` <a name="cdk-ec2spot.BlockDurationMinutes.SIX_HOURS"></a>

---


### InstanceInterruptionBehavior <a name="InstanceInterruptionBehavior"></a>

#### `HIBERNATE` <a name="cdk-ec2spot.InstanceInterruptionBehavior.HIBERNATE"></a>

---


#### `STOP` <a name="cdk-ec2spot.InstanceInterruptionBehavior.STOP"></a>

---


#### `TERMINATE` <a name="cdk-ec2spot.InstanceInterruptionBehavior.TERMINATE"></a>

---


### SpotInstanceType <a name="SpotInstanceType"></a>

#### `ONE_TIME` <a name="cdk-ec2spot.SpotInstanceType.ONE_TIME"></a>

---


#### `PERSISTENT` <a name="cdk-ec2spot.SpotInstanceType.PERSISTENT"></a>

---

