"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const ec2spot = require("./index");
class IntegTesting {
    constructor() {
        const app = new aws_cdk_lib_1.App();
        const env = {
            region: process.env.CDK_DEFAULT_REGION || 'us-east-1',
            account: process.env.CDK_DEFAULT_ACCOUNT || '123456789012',
        };
        const stack = new aws_cdk_lib_1.Stack(app, 'integ-stack', { env });
        const provider = new ec2spot.Provider(stack, 'Provider');
        const vpc = provider.getOrCreateVpc(stack);
        // create a autoscaling group with spot instances
        provider.createAutoScalingGroup('SpotASG', {
            vpc,
            defaultCapacitySize: 2,
            instanceType: new aws_cdk_lib_1.aws_ec2.InstanceType('m5.large'),
        });
        // create a spot fleet
        provider.createFleet('SpotFleet', {
            vpc,
            defaultCapacitySize: 2,
            instanceType: new aws_cdk_lib_1.aws_ec2.InstanceType('t3.large'),
        });
        // create single spot instance
        provider.createInstance('SpotInstance', { vpc });
        // create another instance with new provider
        new ec2spot.Provider(stack, 'Provider2')
            .createInstance('SpotInstance2', { vpc });
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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