/*
  Precomputed statistics for significance testing of merged sequence pairs

  These values were obtained from PEAR:

  https://github.com/xflouris/PEAR

  http://www.exelixis-lab.org/web/software/pear

  Copyright Jiajie Zhang, Kassian Kobert, Tomas Flouri & Alexandros Stamatakis
  
  Zhang J, Kobert K, Flouri T & Stamatakis A (2014)
  PEAR: a fast and accurate Illumina Paired-End reAd mergeR
  Bioinformatics, 30(5):614-20. 
  doi: 10.1093/bioinformatics/btt593

  Included in vsearch with permission.
*/

/* 
   Value range from 0 to 99, precomp_05 is the table for p-value < 0.5,
   precomp_05[i][j] is the proportion of match of the best
   overlap, given i minimal allowed overlap, and random match q =
   j/100, that will reach a p-value at least 0.05. Which means if the
   user specify p = 0.05, then we observed a f, given min_0 = i and q =
   j/100 if f >= precomp_05[i][j], this assembly will be kept.
*/

double precomp2_05[100][100] =
  {
    {
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0
    },
    {
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,   4.0,   4.0,   4.0,   5.0,   5.0,
        6.0,   6.0,   7.0,   7.0,   8.0,   9.0,  10.0,  11.0,  12.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,   4.0,   4.0,   4.0,   5.0,   5.0,
        6.0,   6.0,   7.0,   7.0,   8.0,   9.0,  10.0,  11.0,  12.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,   4.0,   4.0,   4.0,   5.0,   5.0,
        6.0,   6.0,   7.0,   7.0,   8.0,   9.0,  10.0,  11.0,  12.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,   4.0,   4.0,   4.0,   5.0,   5.0,
        6.0,   6.0,   7.0,   7.0,   8.0,   9.0,  10.0,  11.0,  12.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,   4.0,   4.0,   4.0,   5.0,   5.0,
        6.0,   6.0,   7.0,   7.0,   8.0,   9.0,  10.0,  11.0,  12.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,   4.0,   4.0,   4.0,   5.0,   5.0,
        6.0,   6.0,   7.0,   7.0,   8.0,   9.0,  10.0,  11.0,  12.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,   4.0,   4.0,   4.0,   5.0,   5.0,
        6.0,   6.0,   7.0,   7.0,   8.0,   9.0,  10.0,  11.0,  12.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,   4.0,   4.0,   4.0,   5.0,   5.0,
        6.0,   6.0,   7.0,   7.0,   8.0,   9.0,  10.0,  11.0,  12.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,   3.0,   4.0,   4.0,   5.0,   5.0,
        5.0,   6.0,   7.0,   7.0,   8.0,   9.0,  10.0,  11.0,  12.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,   3.0,   4.0,   4.0,   4.0,   5.0,
        5.0,   6.0,   7.0,   7.0,   8.0,   9.0,  10.0,  11.0,  12.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,   3.0,   3.0,   4.0,   4.0,   5.0,
        5.0,   6.0,   6.0,   7.0,   8.0,   9.0,  10.0,  11.0,  12.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,   3.0,   3.0,   4.0,   4.0,   5.0,
        5.0,   6.0,   6.0,   7.0,   8.0,   9.0,  10.0,  11.0,  12.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,   3.0,   3.0,   4.0,   4.0,   5.0,
        5.0,   6.0,   6.0,   7.0,   8.0,   9.0,  10.0,  11.0,  12.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,   2.0,   3.0,   4.0,   4.0,   5.0,
        5.0,   6.0,   6.0,   7.0,   8.0,   9.0,  10.0,  11.0,  12.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,   2.0,   3.0,   3.0,   4.0,   4.0,
        5.0,   6.0,   6.0,   7.0,   8.0,   9.0,   9.0,  11.0,  12.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,   2.0,   3.0,   3.0,   4.0,   4.0,
        5.0,   6.0,   6.0,   7.0,   8.0,   9.0,   9.0,  11.0,  12.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,   2.0,   2.0,   3.0,   4.0,   4.0,
        5.0,   5.0,   6.0,   7.0,   8.0,   9.0,   9.0,  11.0,  12.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,   2.0,   2.0,   3.0,   3.0,   4.0,
        5.0,   5.0,   6.0,   7.0,   8.0,   8.0,   9.0,  11.0,  12.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,   1.0,   2.0,   3.0,   3.0,   4.0,
        5.0,   5.0,   6.0,   7.0,   8.0,   8.0,   9.0,  11.0,  12.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,   1.0,   2.0,   2.0,   3.0,   4.0,
        4.0,   5.0,   6.0,   7.0,   8.0,   8.0,   9.0,  11.0,  12.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,   1.0,   2.0,   2.0,   3.0,   4.0,
        4.0,   5.0,   6.0,   7.0,   7.0,   8.0,   9.0,  11.0,  12.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,   1.0,   1.0,   2.0,   3.0,   3.0,
        4.0,   5.0,   6.0,   7.0,   7.0,   8.0,   9.0,  10.0,  12.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,   0.0,   1.0,   2.0,   3.0,   3.0,
        4.0,   5.0,   6.0,   6.0,   7.0,   8.0,   9.0,  10.0,  12.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,   0.0,   1.0,   2.0,   2.0,   3.0,
        4.0,   5.0,   6.0,   6.0,   7.0,   8.0,   9.0,  10.0,  12.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,   0.0,   1.0,   1.0,   2.0,   3.0,
        4.0,   5.0,   5.0,   6.0,   7.0,   8.0,   9.0,  10.0,  12.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,   0.0,   0.0,   1.0,   2.0,   3.0,
        4.0,   4.0,   5.0,   6.0,   7.0,   8.0,   9.0,  10.0,  12.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  -1.0,   0.0,   1.0,   2.0,   3.0,
        3.0,   4.0,   5.0,   6.0,   7.0,   8.0,   9.0,  10.0,  12.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  -1.0,   0.0,   1.0,   2.0,   2.0,
        3.0,   4.0,   5.0,   6.0,   7.0,   8.0,   9.0,  10.0,  12.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  -1.0,   0.0,   1.0,   1.0,   2.0,
        3.0,   4.0,   5.0,   6.0,   7.0,   8.0,   9.0,  10.0,  12.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  -2.0,  -1.0,   0.0,   1.0,   2.0,
        3.0,   4.0,   5.0,   6.0,   7.0,   8.0,   9.0,  10.0,  12.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  -2.0,  -1.0,   0.0,   1.0,   2.0,
        3.0,   4.0,   5.0,   6.0,   7.0,   8.0,   9.0,  10.0,  12.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  -2.0,  -1.0,   0.0,   1.0,   2.0,
        3.0,   4.0,   5.0,   6.0,   7.0,   8.0,   9.0,  10.0,  12.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  -2.0,  -1.0,   0.0,   1.0,   1.0,
        2.0,   3.0,   4.0,   5.0,   7.0,   8.0,   9.0,  10.0,  12.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  -3.0,  -2.0,  -1.0,   0.0,   1.0,
        2.0,   3.0,   4.0,   5.0,   6.0,   8.0,   9.0,  10.0,  12.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  -3.0,  -2.0,  -1.0,   0.0,   1.0,
        2.0,   3.0,   4.0,   5.0,   6.0,   8.0,   9.0,  10.0,  12.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  -3.0,  -2.0,  -1.0,   0.0,   1.0,
        2.0,   3.0,   4.0,   5.0,   6.0,   7.0,   9.0,  10.0,  12.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  -3.0,  -3.0,  -1.0,   0.0,   1.0,
        2.0,   3.0,   4.0,   5.0,   6.0,   7.0,   9.0,  10.0,  11.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  -4.0,  -3.0,  -2.0,  -1.0,   0.0,
        2.0,   3.0,   4.0,   5.0,   6.0,   7.0,   9.0,  10.0,  11.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  -4.0,  -3.0,  -2.0,  -1.0,   0.0,
        1.0,   2.0,   4.0,   5.0,   6.0,   7.0,   9.0,  10.0,  11.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  -4.0,  -3.0,  -2.0,  -1.0,   0.0,
        1.0,   2.0,   3.0,   5.0,   6.0,   7.0,   8.0,  10.0,  11.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  -5.0,  -4.0,  -3.0,  -1.0,   0.0,
        1.0,   2.0,   3.0,   5.0,   6.0,   7.0,   8.0,  10.0,  11.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  -5.0,  -4.0,  -3.0,  -2.0,   0.0,
        1.0,   2.0,   3.0,   4.0,   6.0,   7.0,   8.0,  10.0,  11.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  -5.0,  -4.0,  -3.0,  -2.0,  -1.0,
        1.0,   2.0,   3.0,   4.0,   6.0,   7.0,   8.0,  10.0,  11.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  -6.0,  -4.0,  -3.0,  -2.0,  -1.0,
        0.0,   2.0,   3.0,   4.0,   5.0,   7.0,   8.0,  10.0,  11.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  -6.0,  -5.0,  -4.0,  -2.0,  -1.0,
        0.0,   1.0,   3.0,   4.0,   5.0,   7.0,   8.0,  10.0,  11.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  -6.0,  -5.0,  -4.0,  -3.0,  -1.0,
        0.0,   1.0,   2.0,   4.0,   5.0,   7.0,   8.0,  10.0,  11.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  -7.0,  -5.0,  -4.0,  -3.0,  -2.0,
        0.0,   1.0,   2.0,   4.0,   5.0,   6.0,   8.0,   9.0,  11.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  -7.0,  -6.0,  -4.0,  -3.0,  -2.0,
        0.0,   1.0,   2.0,   4.0,   5.0,   6.0,   8.0,   9.0,  11.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  -7.0,  -6.0,  -5.0,  -3.0,  -2.0,
       -1.0,   1.0,   2.0,   3.0,   5.0,   6.0,   8.0,   9.0,  11.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  -8.0,  -6.0,  -5.0,  -4.0,  -2.0,
       -1.0,   0.0,   2.0,   3.0,   5.0,   6.0,   8.0,   9.0,  11.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  -8.0,  -7.0,  -5.0,  -4.0,  -3.0,
       -1.0,   0.0,   2.0,   3.0,   5.0,   6.0,   8.0,   9.0,  11.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  -8.0,  -7.0,  -6.0,  -4.0,  -3.0,
       -1.0,   0.0,   2.0,   3.0,   4.0,   6.0,   7.0,   9.0,  11.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  -9.0,  -7.0,  -6.0,  -4.0,  -3.0,
       -2.0,   0.0,   1.0,   3.0,   4.0,   6.0,   7.0,   9.0,  11.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  -9.0,  -8.0,  -6.0,  -5.0,  -3.0,
       -2.0,   0.0,   1.0,   3.0,   4.0,   6.0,   7.0,   9.0,  11.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  -9.0,  -8.0,  -6.0,  -5.0,  -3.0,
       -2.0,  -1.0,   1.0,   2.0,   4.0,   6.0,   7.0,   9.0,  11.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -10.0,  -8.0,  -7.0,  -5.0,  -4.0,
       -2.0,  -1.0,   1.0,   2.0,   4.0,   5.0,   7.0,   9.0,  11.0,  13.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -10.0,  -8.0,  -7.0,  -5.0,  -4.0,
       -2.0,  -1.0,   1.0,   2.0,   4.0,   5.0,   7.0,   9.0,  11.0,  12.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -10.0,  -9.0,  -7.0,  -6.0,  -4.0,
       -3.0,  -1.0,   0.0,   2.0,   4.0,   5.0,   7.0,   9.0,  10.0,  12.0,
       15.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -11.0,  -9.0,  -7.0,  -6.0,  -4.0,
       -3.0,  -1.0,   0.0,   2.0,   3.0,   5.0,   7.0,   9.0,  10.0,  12.0,
       14.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -11.0,  -9.0,  -8.0,  -6.0,  -5.0,
       -3.0,  -2.0,   0.0,   2.0,   3.0,   5.0,   7.0,   9.0,  10.0,  12.0,
       14.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -11.0, -10.0,  -8.0,  -7.0,  -5.0,
       -3.0,  -2.0,   0.0,   2.0,   3.0,   5.0,   7.0,   8.0,  10.0,  12.0,
       14.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -12.0, -10.0,  -8.0,  -7.0,  -5.0,
       -4.0,  -2.0,   0.0,   1.0,   3.0,   5.0,   7.0,   8.0,  10.0,  12.0,
       14.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -12.0, -10.0,  -9.0,  -7.0,  -5.0,
       -4.0,  -2.0,  -1.0,   1.0,   3.0,   5.0,   6.0,   8.0,  10.0,  12.0,
       14.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -12.0, -11.0,  -9.0,  -7.0,  -6.0,
       -4.0,  -2.0,  -1.0,   1.0,   3.0,   4.0,   6.0,   8.0,  10.0,  12.0,
       14.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -13.0, -11.0,  -9.0,  -8.0,  -6.0,
       -4.0,  -3.0,  -1.0,   1.0,   3.0,   4.0,   6.0,   8.0,  10.0,  12.0,
       14.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -13.0, -11.0, -10.0,  -8.0,  -6.0,
       -4.0,  -3.0,  -1.0,   1.0,   2.0,   4.0,   6.0,   8.0,  10.0,  12.0,
       14.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -13.0, -12.0, -10.0,  -8.0,  -6.0,
       -5.0,  -3.0,  -1.0,   1.0,   2.0,   4.0,   6.0,   8.0,  10.0,  12.0,
       14.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -14.0, -12.0, -10.0,  -8.0,  -7.0,
       -5.0,  -3.0,  -1.0,   0.0,   2.0,   4.0,   6.0,   8.0,  10.0,  12.0,
       14.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -14.0, -12.0, -11.0,  -9.0,  -7.0,
       -5.0,  -3.0,  -2.0,   0.0,   2.0,   4.0,   6.0,   8.0,  10.0,  12.0,
       14.0,  17.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -14.0, -13.0, -11.0,  -9.0,  -7.0,
       -5.0,  -4.0,  -2.0,   0.0,   2.0,   4.0,   6.0,   8.0,  10.0,  12.0,
       14.0,  16.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -15.0, -13.0, -11.0,  -9.0,  -7.0,
       -6.0,  -4.0,  -2.0,   0.0,   2.0,   4.0,   6.0,   8.0,  10.0,  12.0,
       14.0,  16.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -15.0, -13.0, -11.0, -10.0,  -8.0,
       -6.0,  -4.0,  -2.0,   0.0,   2.0,   3.0,   5.0,   7.0,  10.0,  12.0,
       14.0,  16.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -15.0, -14.0, -12.0, -10.0,  -8.0,
       -6.0,  -4.0,  -2.0,  -1.0,   1.0,   3.0,   5.0,   7.0,   9.0,  12.0,
       14.0,  16.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -16.0, -14.0, -12.0, -10.0,  -8.0,
       -6.0,  -4.0,  -3.0,  -1.0,   1.0,   3.0,   5.0,   7.0,   9.0,  12.0,
       14.0,  16.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -16.0, -14.0, -12.0, -10.0,  -9.0,
       -7.0,  -5.0,  -3.0,  -1.0,   1.0,   3.0,   5.0,   7.0,   9.0,  12.0,
       14.0,  16.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -16.0, -15.0, -13.0, -11.0,  -9.0,
       -7.0,  -5.0,  -3.0,  -1.0,   1.0,   3.0,   5.0,   7.0,   9.0,  12.0,
       14.0,  16.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -17.0, -15.0, -13.0, -11.0,  -9.0,
       -7.0,  -5.0,  -3.0,  -1.0,   1.0,   3.0,   5.0,   7.0,   9.0,  11.0,
       14.0,  16.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -17.0, -15.0, -13.0, -11.0,  -9.0,
       -7.0,  -5.0,  -3.0,  -1.0,   1.0,   3.0,   5.0,   7.0,   9.0,  11.0,
       14.0,  16.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -18.0, -16.0, -14.0, -12.0, -10.0,
       -8.0,  -6.0,  -4.0,  -2.0,   0.0,   3.0,   5.0,   7.0,   9.0,  11.0,
       14.0,  16.0,  19.0,  22.0,  25.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -18.0, -16.0, -14.0, -12.0, -10.0,
       -8.0,  -6.0,  -4.0,  -2.0,   0.0,   2.0,   5.0,   7.0,   9.0,  11.0,
       14.0,  16.0,  19.0,  22.0,  24.0,  28.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -18.0, -16.0, -14.0, -12.0, -10.0,
       -8.0,  -6.0,  -4.0,  -2.0,   0.0,   2.0,   4.0,   7.0,   9.0,  11.0,
       14.0,  16.0,  19.0,  22.0,  24.0,  27.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -19.0, -17.0, -15.0, -12.0, -10.0,
       -8.0,  -6.0,  -4.0,  -2.0,   0.0,   2.0,   4.0,   6.0,   9.0,  11.0,
       14.0,  16.0,  19.0,  22.0,  24.0,  27.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -19.0, -17.0, -15.0, -13.0, -11.0,
       -9.0,  -7.0,  -4.0,  -2.0,   0.0,   2.0,   4.0,   6.0,   9.0,  11.0,
       14.0,  16.0,  19.0,  22.0,  24.0,  27.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -19.0, -17.0, -15.0, -13.0, -11.0,
       -9.0,  -7.0,  -5.0,  -3.0,   0.0,   2.0,   4.0,   6.0,   9.0,  11.0,
       13.0,  16.0,  19.0,  22.0,  24.0,  27.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -20.0, -18.0, -15.0, -13.0, -11.0,
       -9.0,  -7.0,  -5.0,  -3.0,  -1.0,   2.0,   4.0,   6.0,   9.0,  11.0,
       13.0,  16.0,  19.0,  22.0,  24.0,  27.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -20.0, -18.0, -16.0, -14.0, -12.0,
       -9.0,  -7.0,  -5.0,  -3.0,  -1.0,   2.0,   4.0,   6.0,   8.0,  11.0,
       13.0,  16.0,  19.0,  22.0,  24.0,  27.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -21.0, -18.0, -16.0, -14.0, -12.0,
      -10.0,  -7.0,  -5.0,  -3.0,  -1.0,   1.0,   4.0,   6.0,   8.0,  11.0,
       13.0,  16.0,  19.0,  21.0,  24.0,  27.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -21.0, -19.0, -16.0, -14.0, -12.0,
      -10.0,  -8.0,  -6.0,  -3.0,  -1.0,   1.0,   4.0,   6.0,   8.0,  11.0,
       13.0,  16.0,  19.0,  21.0,  24.0,  27.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -21.0, -19.0, -17.0, -15.0, -12.0,
      -10.0,  -8.0,  -6.0,  -3.0,  -1.0,   1.0,   3.0,   6.0,   8.0,  11.0,
       13.0,  16.0,  19.0,  21.0,  24.0,  27.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -22.0, -19.0, -17.0, -15.0, -13.0,
      -10.0,  -8.0,  -6.0,  -4.0,  -1.0,   1.0,   3.0,   6.0,   8.0,  11.0,
       13.0,  16.0,  19.0,  21.0,  24.0,  27.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -22.0, -20.0, -17.0, -15.0, -13.0,
      -11.0,  -8.0,  -6.0,  -4.0,  -2.0,   1.0,   3.0,   6.0,   8.0,  11.0,
       13.0,  16.0,  19.0,  21.0,  24.0,  27.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -22.0, -20.0, -18.0, -15.0, -13.0,
      -11.0,  -9.0,  -6.0,  -4.0,  -2.0,   1.0,   3.0,   5.0,   8.0,  10.0,
       13.0,  16.0,  19.0,  21.0,  24.0,  27.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -23.0, -20.0, -18.0, -16.0, -13.0,
      -11.0,  -9.0,  -7.0,  -4.0,  -2.0,   0.0,   3.0,   5.0,   8.0,  10.0,
       13.0,  16.0,  18.0,  21.0,  24.0,  27.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -23.0, -21.0, -18.0, -16.0, -14.0,
      -11.0,  -9.0,  -7.0,  -4.0,  -2.0,   0.0,   3.0,   5.0,   8.0,  10.0,
       13.0,  16.0,  18.0,  21.0,  24.0,  27.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -23.0, -21.0, -19.0, -16.0, -14.0,
      -12.0,  -9.0,  -7.0,  -5.0,  -2.0,   0.0,   3.0,   5.0,   8.0,  10.0,
       13.0,  16.0,  18.0,  21.0,  24.0,  27.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -24.0, -21.0, -19.0, -17.0, -14.0,
      -12.0, -10.0,  -7.0,  -5.0,  -2.0,   0.0,   2.0,   5.0,   8.0,  10.0,
       13.0,  16.0,  18.0,  21.0,  24.0,  27.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -24.0, -22.0, -19.0, -17.0, -15.0,
      -12.0, -10.0,  -7.0,  -5.0,  -3.0,   0.0,   2.0,   5.0,   7.0,  10.0,
       13.0,  16.0,  18.0,  21.0,  24.0,  27.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -24.0, -22.0, -20.0, -17.0, -15.0,
      -12.0, -10.0,  -8.0,  -5.0,  -3.0,   0.0,   2.0,   5.0,   7.0,  10.0,
       13.0,  15.0,  18.0,  21.0,  24.0,  27.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    },
    {
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0, -25.0, -22.0, -20.0, -18.0, -15.0,
      -13.0, -10.0,  -8.0,  -5.0,  -3.0,   0.0,   2.0,   5.0,   7.0,  10.0,
       13.0,  15.0,  18.0,  21.0,  24.0,  27.0,  31.0,  34.0,  37.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,
       40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0,  40.0
    }
  };

double precomp2_01[100][100] =
  {
    {
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0
    },
    {
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,   5.0,   6.0,   6.0,   6.0,   7.0,
        7.0,   8.0,   9.0,   9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,   5.0,   6.0,   6.0,   6.0,   7.0,
        7.0,   8.0,   9.0,   9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,   5.0,   6.0,   6.0,   6.0,   7.0,
        7.0,   8.0,   9.0,   9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,   5.0,   6.0,   6.0,   6.0,   7.0,
        7.0,   8.0,   9.0,   9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,   5.0,   6.0,   6.0,   6.0,   7.0,
        7.0,   8.0,   9.0,   9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,   5.0,   6.0,   6.0,   6.0,   7.0,
        7.0,   8.0,   9.0,   9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,   5.0,   6.0,   6.0,   6.0,   7.0,
        7.0,   8.0,   9.0,   9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,   5.0,   6.0,   6.0,   6.0,   7.0,
        7.0,   8.0,   9.0,   9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,   5.0,   6.0,   6.0,   6.0,   7.0,
        7.0,   8.0,   9.0,   9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,   5.0,   5.0,   6.0,   6.0,   7.0,
        7.0,   8.0,   9.0,   9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,   5.0,   5.0,   6.0,   6.0,   7.0,
        7.0,   8.0,   9.0,   9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,   5.0,   5.0,   6.0,   6.0,   7.0,
        7.0,   8.0,   9.0,   9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,   5.0,   5.0,   6.0,   6.0,   7.0,
        7.0,   8.0,   9.0,   9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,   5.0,   5.0,   6.0,   6.0,   7.0,
        7.0,   8.0,   9.0,   9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,   4.0,   5.0,   5.0,   6.0,   7.0,
        7.0,   8.0,   9.0,   9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,   4.0,   5.0,   5.0,   6.0,   7.0,
        7.0,   8.0,   9.0,   9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,   4.0,   5.0,   5.0,   6.0,   7.0,
        7.0,   8.0,   9.0,   9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,   4.0,   4.0,   5.0,   6.0,   6.0,
        7.0,   8.0,   9.0,   9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,   4.0,   4.0,   5.0,   6.0,   6.0,
        7.0,   8.0,   8.0,   9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,   4.0,   4.0,   5.0,   6.0,   6.0,
        7.0,   8.0,   8.0,   9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,   3.0,   4.0,   5.0,   5.0,   6.0,
        7.0,   8.0,   8.0,   9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,   3.0,   4.0,   4.0,   5.0,   6.0,
        7.0,   8.0,   8.0,   9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,   3.0,   4.0,   4.0,   5.0,   6.0,
        7.0,   7.0,   8.0,   9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,   3.0,   3.0,   4.0,   5.0,   6.0,
        6.0,   7.0,   8.0,   9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,   2.0,   3.0,   4.0,   5.0,   6.0,
        6.0,   7.0,   8.0,   9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,   2.0,   3.0,   4.0,   5.0,   5.0,
        6.0,   7.0,   8.0,   9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,   2.0,   3.0,   4.0,   4.0,   5.0,
        6.0,   7.0,   8.0,   9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,   2.0,   3.0,   3.0,   4.0,   5.0,
        6.0,   7.0,   8.0,   9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,   1.0,   2.0,   3.0,   4.0,   5.0,
        6.0,   7.0,   8.0,   9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,   1.0,   2.0,   3.0,   4.0,   5.0,
        6.0,   7.0,   8.0,   9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,   1.0,   2.0,   3.0,   4.0,   5.0,
        6.0,   7.0,   8.0,   9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,   1.0,   2.0,   3.0,   4.0,   5.0,
        6.0,   6.0,   8.0,   9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,   1.0,   1.0,   2.0,   3.0,   4.0,
        5.0,   6.0,   7.0,   9.0,  10.0,  11.0,  12.0,  13.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,   0.0,   1.0,   2.0,   3.0,   4.0,
        5.0,   6.0,   7.0,   8.0,  10.0,  11.0,  12.0,  13.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,   0.0,   1.0,   2.0,   3.0,   4.0,
        5.0,   6.0,   7.0,   8.0,   9.0,  11.0,  12.0,  13.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,   0.0,   1.0,   2.0,   3.0,   4.0,
        5.0,   6.0,   7.0,   8.0,   9.0,  11.0,  12.0,  13.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  -1.0,   1.0,   2.0,   3.0,   4.0,
        5.0,   6.0,   7.0,   8.0,   9.0,  11.0,  12.0,  13.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  -1.0,   0.0,   1.0,   2.0,   4.0,
        5.0,   6.0,   7.0,   8.0,   9.0,  11.0,  12.0,  13.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  -1.0,   0.0,   1.0,   2.0,   3.0,
        4.0,   6.0,   7.0,   8.0,   9.0,  10.0,  12.0,  13.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  -1.0,   0.0,   1.0,   2.0,   3.0,
        4.0,   5.0,   7.0,   8.0,   9.0,  10.0,  12.0,  13.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  -2.0,  -1.0,   1.0,   2.0,   3.0,
        4.0,   5.0,   7.0,   8.0,   9.0,  10.0,  12.0,  13.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  -2.0,  -1.0,   0.0,   2.0,   3.0,
        4.0,   5.0,   6.0,   8.0,   9.0,  10.0,  12.0,  13.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  -2.0,  -1.0,   0.0,   1.0,   3.0,
        4.0,   5.0,   6.0,   8.0,   9.0,  10.0,  12.0,  13.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  -2.0,  -1.0,   0.0,   1.0,   2.0,
        4.0,   5.0,   6.0,   7.0,   9.0,  10.0,  12.0,  13.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  -3.0,  -1.0,   0.0,   1.0,   2.0,
        3.0,   5.0,   6.0,   7.0,   9.0,  10.0,  12.0,  13.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  -3.0,  -2.0,   0.0,   1.0,   2.0,
        3.0,   5.0,   6.0,   7.0,   9.0,  10.0,  12.0,  13.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  -3.0,  -2.0,  -1.0,   1.0,   2.0,
        3.0,   4.0,   6.0,   7.0,   8.0,  10.0,  11.0,  13.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  -4.0,  -2.0,  -1.0,   0.0,   2.0,
        3.0,   4.0,   6.0,   7.0,   8.0,  10.0,  11.0,  13.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  -4.0,  -3.0,  -1.0,   0.0,   1.0,
        3.0,   4.0,   5.0,   7.0,   8.0,  10.0,  11.0,  13.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  -4.0,  -3.0,  -2.0,   0.0,   1.0,
        3.0,   4.0,   5.0,   7.0,   8.0,  10.0,  11.0,  13.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  -5.0,  -3.0,  -2.0,   0.0,   1.0,
        2.0,   4.0,   5.0,   7.0,   8.0,  10.0,  11.0,  13.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  -5.0,  -3.0,  -2.0,  -1.0,   1.0,
        2.0,   4.0,   5.0,   6.0,   8.0,  10.0,  11.0,  13.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  -5.0,  -4.0,  -2.0,  -1.0,   1.0,
        2.0,   3.0,   5.0,   6.0,   8.0,   9.0,  11.0,  13.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  -5.0,  -4.0,  -3.0,  -1.0,   0.0,
        2.0,   3.0,   5.0,   6.0,   8.0,   9.0,  11.0,  13.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  -6.0,  -4.0,  -3.0,  -1.0,   0.0,
        2.0,   3.0,   5.0,   6.0,   8.0,   9.0,  11.0,  13.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  -6.0,  -5.0,  -3.0,  -2.0,   0.0,
        1.0,   3.0,   4.0,   6.0,   8.0,   9.0,  11.0,  13.0,  15.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  -6.0,  -5.0,  -3.0,  -2.0,   0.0,
        1.0,   3.0,   4.0,   6.0,   7.0,   9.0,  11.0,  13.0,  14.0,  17.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  -7.0,  -5.0,  -4.0,  -2.0,   0.0,
        1.0,   3.0,   4.0,   6.0,   7.0,   9.0,  11.0,  13.0,  14.0,  16.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  -7.0,  -5.0,  -4.0,  -2.0,  -1.0,
        1.0,   2.0,   4.0,   6.0,   7.0,   9.0,  11.0,  12.0,  14.0,  16.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  -7.0,  -6.0,  -4.0,  -3.0,  -1.0,
        1.0,   2.0,   4.0,   5.0,   7.0,   9.0,  11.0,  12.0,  14.0,  16.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  -8.0,  -6.0,  -4.0,  -3.0,  -1.0,
        0.0,   2.0,   4.0,   5.0,   7.0,   9.0,  11.0,  12.0,  14.0,  16.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  -8.0,  -6.0,  -5.0,  -3.0,  -1.0,
        0.0,   2.0,   4.0,   5.0,   7.0,   9.0,  10.0,  12.0,  14.0,  16.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  -8.0,  -7.0,  -5.0,  -3.0,  -2.0,
        0.0,   2.0,   3.0,   5.0,   7.0,   9.0,  10.0,  12.0,  14.0,  16.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  -9.0,  -7.0,  -5.0,  -4.0,  -2.0,
        0.0,   2.0,   3.0,   5.0,   7.0,   8.0,  10.0,  12.0,  14.0,  16.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  -9.0,  -7.0,  -5.0,  -4.0,  -2.0,
        0.0,   1.0,   3.0,   5.0,   7.0,   8.0,  10.0,  12.0,  14.0,  16.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  -9.0,  -8.0,  -6.0,  -4.0,  -2.0,
       -1.0,   1.0,   3.0,   5.0,   6.0,   8.0,  10.0,  12.0,  14.0,  16.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  -9.0,  -8.0,  -6.0,  -4.0,  -3.0,
       -1.0,   1.0,   3.0,   4.0,   6.0,   8.0,  10.0,  12.0,  14.0,  16.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0, -10.0,  -8.0,  -6.0,  -5.0,  -3.0,
       -1.0,   1.0,   2.0,   4.0,   6.0,   8.0,  10.0,  12.0,  14.0,  16.0,
       19.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0, -10.0,  -8.0,  -7.0,  -5.0,  -3.0,
       -1.0,   1.0,   2.0,   4.0,   6.0,   8.0,  10.0,  12.0,  14.0,  16.0,
       18.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0, -10.0,  -9.0,  -7.0,  -5.0,  -3.0,
       -1.0,   0.0,   2.0,   4.0,   6.0,   8.0,  10.0,  12.0,  14.0,  16.0,
       18.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0, -11.0,  -9.0,  -7.0,  -5.0,  -3.0,
       -2.0,   0.0,   2.0,   4.0,   6.0,   8.0,  10.0,  12.0,  14.0,  16.0,
       18.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0, -11.0,  -9.0,  -7.0,  -6.0,  -4.0,
       -2.0,   0.0,   2.0,   4.0,   6.0,   8.0,  10.0,  12.0,  14.0,  16.0,
       18.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0, -11.0, -10.0,  -8.0,  -6.0,  -4.0,
       -2.0,   0.0,   2.0,   4.0,   5.0,   7.0,   9.0,  12.0,  14.0,  16.0,
       18.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0, -12.0, -10.0,  -8.0,  -6.0,  -4.0,
       -2.0,   0.0,   1.0,   3.0,   5.0,   7.0,   9.0,  11.0,  14.0,  16.0,
       18.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0, -12.0, -10.0,  -8.0,  -6.0,  -4.0,
       -3.0,  -1.0,   1.0,   3.0,   5.0,   7.0,   9.0,  11.0,  14.0,  16.0,
       18.0,  21.0,  24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0, -12.0, -10.0,  -9.0,  -7.0,  -5.0,
       -3.0,  -1.0,   1.0,   3.0,   5.0,   7.0,   9.0,  11.0,  14.0,  16.0,
       18.0,  21.0,  24.0,  26.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0, -13.0, -11.0,  -9.0,  -7.0,  -5.0,
       -3.0,  -1.0,   1.0,   3.0,   5.0,   7.0,   9.0,  11.0,  13.0,  16.0,
       18.0,  21.0,  24.0,  26.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0, -13.0, -11.0,  -9.0,  -7.0,  -5.0,
       -3.0,  -1.0,   1.0,   3.0,   5.0,   7.0,   9.0,  11.0,  13.0,  16.0,
       18.0,  21.0,  24.0,  26.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0, -13.0, -11.0,  -9.0,  -7.0,  -5.0,
       -3.0,  -1.0,   1.0,   3.0,   5.0,   7.0,   9.0,  11.0,  13.0,  16.0,
       18.0,  21.0,  24.0,  26.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0, -14.0, -12.0, -10.0,  -8.0,  -6.0,
       -4.0,  -2.0,   0.0,   2.0,   5.0,   7.0,   9.0,  11.0,  13.0,  16.0,
       18.0,  21.0,  24.0,  26.0,  29.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0, -14.0, -12.0, -10.0,  -8.0,  -6.0,
       -4.0,  -2.0,   0.0,   2.0,   4.0,   7.0,   9.0,  11.0,  13.0,  16.0,
       18.0,  21.0,  24.0,  26.0,  29.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0, -14.0, -12.0, -10.0,  -8.0,  -6.0,
       -4.0,  -2.0,   0.0,   2.0,   4.0,   6.0,   9.0,  11.0,  13.0,  16.0,
       18.0,  21.0,  24.0,  26.0,  29.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0, -15.0, -13.0, -11.0,  -9.0,  -6.0,
       -4.0,  -2.0,   0.0,   2.0,   4.0,   6.0,   9.0,  11.0,  13.0,  16.0,
       18.0,  21.0,  24.0,  26.0,  29.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0, -15.0, -13.0, -11.0,  -9.0,  -7.0,
       -5.0,  -2.0,   0.0,   2.0,   4.0,   6.0,   8.0,  11.0,  13.0,  16.0,
       18.0,  21.0,  24.0,  26.0,  29.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0, -15.0, -13.0, -11.0,  -9.0,  -7.0,
       -5.0,  -3.0,  -1.0,   2.0,   4.0,   6.0,   8.0,  11.0,  13.0,  15.0,
       18.0,  21.0,  24.0,  26.0,  29.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0, -16.0, -14.0, -12.0,  -9.0,  -7.0,
       -5.0,  -3.0,  -1.0,   1.0,   4.0,   6.0,   8.0,  11.0,  13.0,  15.0,
       18.0,  21.0,  23.0,  26.0,  29.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0, -16.0, -14.0, -12.0, -10.0,  -7.0,
       -5.0,  -3.0,  -1.0,   1.0,   4.0,   6.0,   8.0,  10.0,  13.0,  15.0,
       18.0,  21.0,  23.0,  26.0,  29.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0, -16.0, -14.0, -12.0, -10.0,  -8.0,
       -6.0,  -3.0,  -1.0,   1.0,   3.0,   6.0,   8.0,  10.0,  13.0,  15.0,
       18.0,  21.0,  23.0,  26.0,  29.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0, -17.0, -15.0, -12.0, -10.0,  -8.0,
       -6.0,  -3.0,  -1.0,   1.0,   3.0,   6.0,   8.0,  10.0,  13.0,  15.0,
       18.0,  21.0,  23.0,  26.0,  29.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0, -17.0, -15.0, -13.0, -10.0,  -8.0,
       -6.0,  -4.0,  -1.0,   1.0,   3.0,   5.0,   8.0,  10.0,  13.0,  15.0,
       18.0,  21.0,  23.0,  26.0,  29.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0, -18.0, -15.0, -13.0, -11.0,  -9.0,
       -6.0,  -4.0,  -2.0,   1.0,   3.0,   5.0,   8.0,  10.0,  13.0,  15.0,
       18.0,  21.0,  23.0,  26.0,  29.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0, -18.0, -16.0, -13.0, -11.0,  -9.0,
       -6.0,  -4.0,  -2.0,   0.0,   3.0,   5.0,   8.0,  10.0,  13.0,  15.0,
       18.0,  21.0,  23.0,  26.0,  29.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0, -18.0, -16.0, -14.0, -11.0,  -9.0,
       -7.0,  -4.0,  -2.0,   0.0,   3.0,   5.0,   7.0,  10.0,  12.0,  15.0,
       18.0,  20.0,  23.0,  26.0,  29.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0, -19.0, -16.0, -14.0, -12.0,  -9.0,
       -7.0,  -5.0,  -2.0,   0.0,   2.0,   5.0,   7.0,  10.0,  12.0,  15.0,
       18.0,  20.0,  23.0,  26.0,  29.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0, -19.0, -17.0, -14.0, -12.0,  -9.0,
       -7.0,  -5.0,  -2.0,   0.0,   2.0,   5.0,   7.0,  10.0,  12.0,  15.0,
       18.0,  20.0,  23.0,  26.0,  29.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0, -19.0, -17.0, -15.0, -12.0, -10.0,
       -7.0,  -5.0,  -3.0,   0.0,   2.0,   5.0,   7.0,  10.0,  12.0,  15.0,
       18.0,  20.0,  23.0,  26.0,  29.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0, -20.0, -17.0, -15.0, -12.0, -10.0,
       -8.0,  -5.0,  -3.0,   0.0,   2.0,   5.0,   7.0,  10.0,  12.0,  15.0,
       18.0,  20.0,  23.0,  26.0,  29.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0, -20.0, -18.0, -15.0, -13.0, -10.0,
       -8.0,  -5.0,  -3.0,  -1.0,   2.0,   4.0,   7.0,   9.0,  12.0,  15.0,
       18.0,  20.0,  23.0,  26.0,  29.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    },
    {
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0, -20.0, -18.0, -15.0, -13.0, -11.0,
       -8.0,  -6.0,  -3.0,  -1.0,   2.0,   4.0,   7.0,   9.0,  12.0,  15.0,
       17.0,  20.0,  23.0,  26.0,  29.0,  33.0,  36.0,  39.0,  43.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,
       46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0,  46.0
    }
  };

double precomp2_001[100][100] =
  {
    {
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0
    },
    {
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,   7.0,   8.0,   8.0,   9.0,  10.0,
       10.0,  11.0,  12.0,  13.0,  14.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   7.0,   8.0,   8.0,   9.0,  10.0,
       10.0,  11.0,  12.0,  13.0,  14.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   7.0,   8.0,   8.0,   9.0,  10.0,
       10.0,  11.0,  12.0,  13.0,  14.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   7.0,   8.0,   8.0,   9.0,  10.0,
       10.0,  11.0,  12.0,  13.0,  14.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   7.0,   8.0,   8.0,   9.0,  10.0,
       10.0,  11.0,  12.0,  13.0,  14.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   7.0,   8.0,   8.0,   9.0,  10.0,
       10.0,  11.0,  12.0,  13.0,  14.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   7.0,   8.0,   8.0,   9.0,  10.0,
       10.0,  11.0,  12.0,  13.0,  14.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   7.0,   8.0,   8.0,   9.0,  10.0,
       10.0,  11.0,  12.0,  13.0,  14.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   7.0,   8.0,   8.0,   9.0,  10.0,
       10.0,  11.0,  12.0,  13.0,  14.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   7.0,   8.0,   8.0,   9.0,  10.0,
       10.0,  11.0,  12.0,  13.0,  14.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   7.0,   8.0,   8.0,   9.0,  10.0,
       10.0,  11.0,  12.0,  13.0,  14.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   7.0,   8.0,   8.0,   9.0,  10.0,
       10.0,  11.0,  12.0,  13.0,  14.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   7.0,   8.0,   8.0,   9.0,  10.0,
       10.0,  11.0,  12.0,  13.0,  14.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   7.0,   8.0,   8.0,   9.0,  10.0,
       10.0,  11.0,  12.0,  13.0,  14.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   7.0,   8.0,   8.0,   9.0,   9.0,
       10.0,  11.0,  12.0,  13.0,  14.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   7.0,   8.0,   8.0,   9.0,   9.0,
       10.0,  11.0,  12.0,  13.0,  14.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   7.0,   7.0,   8.0,   9.0,   9.0,
       10.0,  11.0,  12.0,  13.0,  14.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   7.0,   7.0,   8.0,   9.0,   9.0,
       10.0,  11.0,  12.0,  13.0,  14.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   7.0,   7.0,   8.0,   9.0,   9.0,
       10.0,  11.0,  12.0,  13.0,  14.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   6.0,   7.0,   8.0,   8.0,   9.0,
       10.0,  11.0,  12.0,  13.0,  14.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   6.0,   7.0,   8.0,   8.0,   9.0,
       10.0,  11.0,  12.0,  13.0,  14.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   6.0,   7.0,   8.0,   8.0,   9.0,
       10.0,  11.0,  12.0,  13.0,  14.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   6.0,   7.0,   7.0,   8.0,   9.0,
       10.0,  11.0,  12.0,  13.0,  14.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   6.0,   7.0,   7.0,   8.0,   9.0,
       10.0,  11.0,  12.0,  13.0,  14.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   6.0,   6.0,   7.0,   8.0,   9.0,
       10.0,  11.0,  12.0,  13.0,  14.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   5.0,   6.0,   7.0,   8.0,   9.0,
       10.0,  11.0,  12.0,  13.0,  14.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   5.0,   6.0,   7.0,   8.0,   9.0,
       10.0,  11.0,  11.0,  13.0,  14.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   5.0,   6.0,   7.0,   8.0,   9.0,
       10.0,  10.0,  11.0,  13.0,  14.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   5.0,   6.0,   7.0,   8.0,   9.0,
        9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   5.0,   6.0,   6.0,   7.0,   8.0,
        9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   5.0,   5.0,   6.0,   7.0,   8.0,
        9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   4.0,   5.0,   6.0,   7.0,   8.0,
        9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   4.0,   5.0,   6.0,   7.0,   8.0,
        9.0,  10.0,  11.0,  12.0,  14.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   4.0,   5.0,   6.0,   7.0,   8.0,
        9.0,  10.0,  11.0,  12.0,  13.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   4.0,   5.0,   6.0,   7.0,   8.0,
        9.0,  10.0,  11.0,  12.0,  13.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   3.0,   4.0,   6.0,   7.0,   8.0,
        9.0,  10.0,  11.0,  12.0,  13.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   3.0,   4.0,   5.0,   6.0,   7.0,
        9.0,  10.0,  11.0,  12.0,  13.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   3.0,   4.0,   5.0,   6.0,   7.0,
        8.0,  10.0,  11.0,  12.0,  13.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   3.0,   4.0,   5.0,   6.0,   7.0,
        8.0,  10.0,  11.0,  12.0,  13.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   2.0,   4.0,   5.0,   6.0,   7.0,
        8.0,   9.0,  11.0,  12.0,  13.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   2.0,   3.0,   5.0,   6.0,   7.0,
        8.0,   9.0,  11.0,  12.0,  13.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   2.0,   3.0,   4.0,   6.0,   7.0,
        8.0,   9.0,  10.0,  12.0,  13.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   2.0,   3.0,   4.0,   5.0,   7.0,
        8.0,   9.0,  10.0,  12.0,  13.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   2.0,   3.0,   4.0,   5.0,   6.0,
        8.0,   9.0,  10.0,  12.0,  13.0,  15.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   1.0,   3.0,   4.0,   5.0,   6.0,
        8.0,   9.0,  10.0,  12.0,  13.0,  14.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   1.0,   2.0,   4.0,   5.0,   6.0,
        7.0,   9.0,  10.0,  12.0,  13.0,  14.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   1.0,   2.0,   3.0,   5.0,   6.0,
        7.0,   9.0,  10.0,  11.0,  13.0,  14.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   1.0,   2.0,   3.0,   4.0,   6.0,
        7.0,   9.0,  10.0,  11.0,  13.0,  14.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   0.0,   2.0,   3.0,   4.0,   6.0,
        7.0,   8.0,  10.0,  11.0,  13.0,  14.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   0.0,   1.0,   3.0,   4.0,   6.0,
        7.0,   8.0,  10.0,  11.0,  13.0,  14.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   0.0,   1.0,   3.0,   4.0,   5.0,
        7.0,   8.0,  10.0,  11.0,  13.0,  14.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,   0.0,   1.0,   2.0,   4.0,   5.0,
        7.0,   8.0,   9.0,  11.0,  13.0,  14.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  -1.0,   1.0,   2.0,   4.0,   5.0,
        6.0,   8.0,   9.0,  11.0,  12.0,  14.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  -1.0,   0.0,   2.0,   3.0,   5.0,
        6.0,   8.0,   9.0,  11.0,  12.0,  14.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  -1.0,   0.0,   2.0,   3.0,   5.0,
        6.0,   8.0,   9.0,  11.0,  12.0,  14.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  -2.0,   0.0,   1.0,   3.0,   4.0,
        6.0,   7.0,   9.0,  11.0,  12.0,  14.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  -2.0,   0.0,   1.0,   3.0,   4.0,
        6.0,   7.0,   9.0,  11.0,  12.0,  14.0,  16.0,  18.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  -2.0,  -1.0,   1.0,   2.0,   4.0,
        6.0,   7.0,   9.0,  10.0,  12.0,  14.0,  16.0,  17.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  -2.0,  -1.0,   1.0,   2.0,   4.0,
        5.0,   7.0,   9.0,  10.0,  12.0,  14.0,  16.0,  17.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  -3.0,  -1.0,   0.0,   2.0,   4.0,
        5.0,   7.0,   9.0,  10.0,  12.0,  14.0,  15.0,  17.0,  20.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  -3.0,  -1.0,   0.0,   2.0,   3.0,
        5.0,   7.0,   8.0,  10.0,  12.0,  14.0,  15.0,  17.0,  19.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  -3.0,  -2.0,   0.0,   2.0,   3.0,
        5.0,   7.0,   8.0,  10.0,  12.0,  14.0,  15.0,  17.0,  19.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  -4.0,  -2.0,   0.0,   1.0,   3.0,
        5.0,   6.0,   8.0,  10.0,  12.0,  13.0,  15.0,  17.0,  19.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  -4.0,  -2.0,   0.0,   1.0,   3.0,
        5.0,   6.0,   8.0,  10.0,  12.0,  13.0,  15.0,  17.0,  19.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  -4.0,  -2.0,  -1.0,   1.0,   3.0,
        4.0,   6.0,   8.0,  10.0,  11.0,  13.0,  15.0,  17.0,  19.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  -4.0,  -3.0,  -1.0,   1.0,   2.0,
        4.0,   6.0,   8.0,  10.0,  11.0,  13.0,  15.0,  17.0,  19.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  -5.0,  -3.0,  -1.0,   1.0,   2.0,
        4.0,   6.0,   8.0,   9.0,  11.0,  13.0,  15.0,  17.0,  19.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  -5.0,  -3.0,  -1.0,   0.0,   2.0,
        4.0,   6.0,   7.0,   9.0,  11.0,  13.0,  15.0,  17.0,  19.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  -5.0,  -3.0,  -2.0,   0.0,   2.0,
        4.0,   5.0,   7.0,   9.0,  11.0,  13.0,  15.0,  17.0,  19.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  -6.0,  -4.0,  -2.0,   0.0,   2.0,
        4.0,   5.0,   7.0,   9.0,  11.0,  13.0,  15.0,  17.0,  19.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  -6.0,  -4.0,  -2.0,   0.0,   1.0,
        3.0,   5.0,   7.0,   9.0,  11.0,  13.0,  15.0,  17.0,  19.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  -6.0,  -4.0,  -2.0,  -1.0,   1.0,
        3.0,   5.0,   7.0,   9.0,  11.0,  13.0,  15.0,  17.0,  19.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  -7.0,  -5.0,  -3.0,  -1.0,   1.0,
        3.0,   5.0,   7.0,   9.0,  11.0,  13.0,  15.0,  17.0,  19.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  -7.0,  -5.0,  -3.0,  -1.0,   1.0,
        3.0,   5.0,   7.0,   9.0,  11.0,  13.0,  15.0,  17.0,  19.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  -7.0,  -5.0,  -3.0,  -1.0,   1.0,
        3.0,   5.0,   6.0,   8.0,  10.0,  13.0,  15.0,  17.0,  19.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  -7.0,  -5.0,  -4.0,  -2.0,   0.0,
        2.0,   4.0,   6.0,   8.0,  10.0,  12.0,  15.0,  17.0,  19.0,  22.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  -8.0,  -6.0,  -4.0,  -2.0,   0.0,
        2.0,   4.0,   6.0,   8.0,  10.0,  12.0,  14.0,  17.0,  19.0,  21.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  -8.0,  -6.0,  -4.0,  -2.0,   0.0,
        2.0,   4.0,   6.0,   8.0,  10.0,  12.0,  14.0,  17.0,  19.0,  21.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  -8.0,  -6.0,  -4.0,  -2.0,   0.0,
        2.0,   4.0,   6.0,   8.0,  10.0,  12.0,  14.0,  17.0,  19.0,  21.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  -9.0,  -7.0,  -4.0,  -2.0,   0.0,
        2.0,   4.0,   6.0,   8.0,  10.0,  12.0,  14.0,  17.0,  19.0,  21.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  -9.0,  -7.0,  -5.0,  -3.0,  -1.0,
        1.0,   3.0,   6.0,   8.0,  10.0,  12.0,  14.0,  16.0,  19.0,  21.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  -9.0,  -7.0,  -5.0,  -3.0,  -1.0,
        1.0,   3.0,   5.0,   8.0,  10.0,  12.0,  14.0,  16.0,  19.0,  21.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0, -10.0,  -7.0,  -5.0,  -3.0,  -1.0,
        1.0,   3.0,   5.0,   7.0,  10.0,  12.0,  14.0,  16.0,  19.0,  21.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0, -10.0,  -8.0,  -6.0,  -3.0,  -1.0,
        1.0,   3.0,   5.0,   7.0,   9.0,  12.0,  14.0,  16.0,  19.0,  21.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0, -10.0,  -8.0,  -6.0,  -4.0,  -2.0,
        1.0,   3.0,   5.0,   7.0,   9.0,  12.0,  14.0,  16.0,  19.0,  21.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0, -10.0,  -8.0,  -6.0,  -4.0,  -2.0,
        0.0,   3.0,   5.0,   7.0,   9.0,  11.0,  14.0,  16.0,  19.0,  21.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0, -11.0,  -9.0,  -6.0,  -4.0,  -2.0,
        0.0,   2.0,   5.0,   7.0,   9.0,  11.0,  14.0,  16.0,  19.0,  21.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0, -11.0,  -9.0,  -7.0,  -4.0,  -2.0,
        0.0,   2.0,   4.0,   7.0,   9.0,  11.0,  14.0,  16.0,  19.0,  21.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0, -11.0,  -9.0,  -7.0,  -5.0,  -2.0,
        0.0,   2.0,   4.0,   7.0,   9.0,  11.0,  14.0,  16.0,  19.0,  21.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0, -12.0, -10.0,  -7.0,  -5.0,  -3.0,
        0.0,   2.0,   4.0,   6.0,   9.0,  11.0,  13.0,  16.0,  18.0,  21.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0, -12.0, -10.0,  -7.0,  -5.0,  -3.0,
       -1.0,   2.0,   4.0,   6.0,   9.0,  11.0,  13.0,  16.0,  18.0,  21.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0, -12.0, -10.0,  -8.0,  -5.0,  -3.0,
       -1.0,   1.0,   4.0,   6.0,   8.0,  11.0,  13.0,  16.0,  18.0,  21.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0, -13.0, -10.0,  -8.0,  -6.0,  -3.0,
       -1.0,   1.0,   4.0,   6.0,   8.0,  11.0,  13.0,  16.0,  18.0,  21.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0, -13.0, -11.0,  -8.0,  -6.0,  -4.0,
       -1.0,   1.0,   3.0,   6.0,   8.0,  11.0,  13.0,  16.0,  18.0,  21.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0, -13.0, -11.0,  -9.0,  -6.0,  -4.0,
       -1.0,   1.0,   3.0,   6.0,   8.0,  11.0,  13.0,  16.0,  18.0,  21.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0, -14.0, -11.0,  -9.0,  -6.0,  -4.0,
       -2.0,   1.0,   3.0,   6.0,   8.0,  10.0,  13.0,  16.0,  18.0,  21.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0, -14.0, -12.0,  -9.0,  -7.0,  -4.0,
       -2.0,   1.0,   3.0,   5.0,   8.0,  10.0,  13.0,  15.0,  18.0,  21.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0, -14.0, -12.0,  -9.0,  -7.0,  -5.0,
       -2.0,   0.0,   3.0,   5.0,   8.0,  10.0,  13.0,  15.0,  18.0,  21.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    },
    {
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0, -15.0, -12.0, -10.0,  -7.0,  -5.0,
       -2.0,   0.0,   3.0,   5.0,   8.0,  10.0,  13.0,  15.0,  18.0,  21.0,
       24.0,  27.0,  30.0,  33.0,  36.0,  39.0,  43.0,  46.0,  50.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,
       53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0,  53.0
    }
  };

double precomp2_0001[100][100] =
  {
    {
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0
    },
    {
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,  99.0,
       99.0,  99.0,  99.0,  99.0,  99.0,  10.0,  10.0,  11.0,  11.0,  12.0,
       13.0,  14.0,  15.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  10.0,  10.0,  11.0,  11.0,  12.0,
       13.0,  14.0,  15.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  10.0,  10.0,  11.0,  11.0,  12.0,
       13.0,  14.0,  15.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  10.0,  10.0,  11.0,  11.0,  12.0,
       13.0,  14.0,  15.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  10.0,  10.0,  11.0,  11.0,  12.0,
       13.0,  14.0,  15.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  10.0,  10.0,  11.0,  11.0,  12.0,
       13.0,  14.0,  15.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  10.0,  10.0,  11.0,  11.0,  12.0,
       13.0,  14.0,  15.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  10.0,  10.0,  11.0,  11.0,  12.0,
       13.0,  14.0,  15.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  10.0,  10.0,  11.0,  11.0,  12.0,
       13.0,  14.0,  15.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  10.0,  10.0,  11.0,  11.0,  12.0,
       13.0,  14.0,  15.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   9.0,  10.0,  11.0,  11.0,  12.0,
       13.0,  14.0,  15.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   9.0,  10.0,  11.0,  11.0,  12.0,
       13.0,  14.0,  15.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   9.0,  10.0,  11.0,  11.0,  12.0,
       13.0,  14.0,  15.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   9.0,  10.0,  11.0,  11.0,  12.0,
       13.0,  14.0,  15.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   9.0,  10.0,  11.0,  11.0,  12.0,
       13.0,  14.0,  15.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   9.0,  10.0,  11.0,  11.0,  12.0,
       13.0,  14.0,  15.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   9.0,  10.0,  11.0,  11.0,  12.0,
       13.0,  14.0,  15.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   9.0,  10.0,  11.0,  11.0,  12.0,
       13.0,  14.0,  15.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   9.0,  10.0,  11.0,  11.0,  12.0,
       13.0,  14.0,  15.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   9.0,  10.0,  10.0,  11.0,  12.0,
       13.0,  14.0,  15.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   9.0,  10.0,  10.0,  11.0,  12.0,
       13.0,  14.0,  15.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   9.0,  10.0,  10.0,  11.0,  12.0,
       13.0,  14.0,  15.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   9.0,   9.0,  10.0,  11.0,  12.0,
       13.0,  14.0,  15.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   9.0,   9.0,  10.0,  11.0,  12.0,
       13.0,  14.0,  15.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   8.0,   9.0,  10.0,  11.0,  12.0,
       13.0,  14.0,  15.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   8.0,   9.0,  10.0,  11.0,  12.0,
       13.0,  14.0,  15.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   8.0,   9.0,  10.0,  11.0,  12.0,
       13.0,  14.0,  15.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   8.0,   9.0,  10.0,  11.0,  12.0,
       13.0,  14.0,  15.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   8.0,   9.0,  10.0,  11.0,  12.0,
       13.0,  14.0,  15.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   8.0,   9.0,  10.0,  11.0,  12.0,
       13.0,  14.0,  15.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   8.0,   9.0,   9.0,  10.0,  11.0,
       12.0,  14.0,  15.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   7.0,   8.0,   9.0,  10.0,  11.0,
       12.0,  13.0,  15.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   7.0,   8.0,   9.0,  10.0,  11.0,
       12.0,  13.0,  15.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   7.0,   8.0,   9.0,  10.0,  11.0,
       12.0,  13.0,  15.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   7.0,   8.0,   9.0,  10.0,  11.0,
       12.0,  13.0,  15.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   7.0,   8.0,   9.0,  10.0,  11.0,
       12.0,  13.0,  14.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   7.0,   8.0,   9.0,  10.0,  11.0,
       12.0,  13.0,  14.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   6.0,   7.0,   9.0,  10.0,  11.0,
       12.0,  13.0,  14.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   6.0,   7.0,   8.0,  10.0,  11.0,
       12.0,  13.0,  14.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   6.0,   7.0,   8.0,   9.0,  11.0,
       12.0,  13.0,  14.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   6.0,   7.0,   8.0,   9.0,  10.0,
       12.0,  13.0,  14.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   6.0,   7.0,   8.0,   9.0,  10.0,
       12.0,  13.0,  14.0,  16.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   5.0,   7.0,   8.0,   9.0,  10.0,
       11.0,  13.0,  14.0,  15.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   5.0,   6.0,   8.0,   9.0,  10.0,
       11.0,  13.0,  14.0,  15.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   5.0,   6.0,   7.0,   9.0,  10.0,
       11.0,  13.0,  14.0,  15.0,  17.0,  19.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   5.0,   6.0,   7.0,   9.0,  10.0,
       11.0,  13.0,  14.0,  15.0,  17.0,  18.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   5.0,   6.0,   7.0,   8.0,  10.0,
       11.0,  12.0,  14.0,  15.0,  17.0,  18.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   4.0,   6.0,   7.0,   8.0,  10.0,
       11.0,  12.0,  14.0,  15.0,  17.0,  18.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   4.0,   5.0,   7.0,   8.0,   9.0,
       11.0,  12.0,  14.0,  15.0,  17.0,  18.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   4.0,   5.0,   7.0,   8.0,   9.0,
       11.0,  12.0,  14.0,  15.0,  17.0,  18.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   4.0,   5.0,   6.0,   8.0,   9.0,
       11.0,  12.0,  14.0,  15.0,  17.0,  18.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   3.0,   5.0,   6.0,   8.0,   9.0,
       10.0,  12.0,  13.0,  15.0,  17.0,  18.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   3.0,   5.0,   6.0,   7.0,   9.0,
       10.0,  12.0,  13.0,  15.0,  17.0,  18.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   3.0,   4.0,   6.0,   7.0,   9.0,
       10.0,  12.0,  13.0,  15.0,  17.0,  18.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   3.0,   4.0,   6.0,   7.0,   9.0,
       10.0,  12.0,  13.0,  15.0,  16.0,  18.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   2.0,   4.0,   5.0,   7.0,   8.0,
       10.0,  12.0,  13.0,  15.0,  16.0,  18.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   2.0,   4.0,   5.0,   7.0,   8.0,
       10.0,  11.0,  13.0,  15.0,  16.0,  18.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   2.0,   3.0,   5.0,   7.0,   8.0,
       10.0,  11.0,  13.0,  15.0,  16.0,  18.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   2.0,   3.0,   5.0,   6.0,   8.0,
       10.0,  11.0,  13.0,  15.0,  16.0,  18.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   1.0,   3.0,   5.0,   6.0,   8.0,
        9.0,  11.0,  13.0,  14.0,  16.0,  18.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   1.0,   3.0,   4.0,   6.0,   8.0,
        9.0,  11.0,  13.0,  14.0,  16.0,  18.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   1.0,   2.0,   4.0,   6.0,   8.0,
        9.0,  11.0,  13.0,  14.0,  16.0,  18.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   1.0,   2.0,   4.0,   6.0,   7.0,
        9.0,  11.0,  12.0,  14.0,  16.0,  18.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   0.0,   2.0,   4.0,   5.0,   7.0,
        9.0,  11.0,  12.0,  14.0,  16.0,  18.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   0.0,   2.0,   4.0,   5.0,   7.0,
        9.0,  10.0,  12.0,  14.0,  16.0,  18.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   0.0,   2.0,   3.0,   5.0,   7.0,
        9.0,  10.0,  12.0,  14.0,  16.0,  18.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,   0.0,   1.0,   3.0,   5.0,   7.0,
        8.0,  10.0,  12.0,  14.0,  16.0,  18.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  -1.0,   1.0,   3.0,   5.0,   6.0,
        8.0,  10.0,  12.0,  14.0,  16.0,  18.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  -1.0,   1.0,   3.0,   5.0,   6.0,
        8.0,  10.0,  12.0,  14.0,  16.0,  18.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  -1.0,   1.0,   2.0,   4.0,   6.0,
        8.0,  10.0,  12.0,  14.0,  16.0,  18.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  -1.0,   0.0,   2.0,   4.0,   6.0,
        8.0,  10.0,  12.0,  13.0,  15.0,  17.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  -2.0,   0.0,   2.0,   4.0,   6.0,
        8.0,  10.0,  11.0,  13.0,  15.0,  17.0,  20.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  -2.0,   0.0,   2.0,   4.0,   6.0,
        7.0,   9.0,  11.0,  13.0,  15.0,  17.0,  19.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  -2.0,   0.0,   2.0,   3.0,   5.0,
        7.0,   9.0,  11.0,  13.0,  15.0,  17.0,  19.0,  22.0,  24.0,  27.0,
       30.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  -3.0,  -1.0,   1.0,   3.0,   5.0,
        7.0,   9.0,  11.0,  13.0,  15.0,  17.0,  19.0,  22.0,  24.0,  27.0,
       29.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  -3.0,  -1.0,   1.0,   3.0,   5.0,
        7.0,   9.0,  11.0,  13.0,  15.0,  17.0,  19.0,  22.0,  24.0,  27.0,
       29.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  -3.0,  -1.0,   1.0,   3.0,   5.0,
        7.0,   9.0,  11.0,  13.0,  15.0,  17.0,  19.0,  22.0,  24.0,  27.0,
       29.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  -3.0,  -1.0,   1.0,   3.0,   5.0,
        7.0,   9.0,  11.0,  13.0,  15.0,  17.0,  19.0,  22.0,  24.0,  27.0,
       29.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  -4.0,  -2.0,   0.0,   2.0,   4.0,
        7.0,   9.0,  11.0,  13.0,  15.0,  17.0,  19.0,  22.0,  24.0,  27.0,
       29.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  -4.0,  -2.0,   0.0,   2.0,   4.0,
        6.0,   8.0,  10.0,  13.0,  15.0,  17.0,  19.0,  22.0,  24.0,  27.0,
       29.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  -4.0,  -2.0,   0.0,   2.0,   4.0,
        6.0,   8.0,  10.0,  12.0,  15.0,  17.0,  19.0,  21.0,  24.0,  27.0,
       29.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  -5.0,  -2.0,   0.0,   2.0,   4.0,
        6.0,   8.0,  10.0,  12.0,  15.0,  17.0,  19.0,  21.0,  24.0,  27.0,
       29.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  -5.0,  -3.0,  -1.0,   2.0,   4.0,
        6.0,   8.0,  10.0,  12.0,  14.0,  17.0,  19.0,  21.0,  24.0,  27.0,
       29.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  -5.0,  -3.0,  -1.0,   1.0,   3.0,
        6.0,   8.0,  10.0,  12.0,  14.0,  17.0,  19.0,  21.0,  24.0,  27.0,
       29.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  -5.0,  -3.0,  -1.0,   1.0,   3.0,
        5.0,   8.0,  10.0,  12.0,  14.0,  17.0,  19.0,  21.0,  24.0,  27.0,
       29.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  -6.0,  -4.0,  -1.0,   1.0,   3.0,
        5.0,   7.0,  10.0,  12.0,  14.0,  16.0,  19.0,  21.0,  24.0,  27.0,
       29.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  -6.0,  -4.0,  -2.0,   1.0,   3.0,
        5.0,   7.0,  10.0,  12.0,  14.0,  16.0,  19.0,  21.0,  24.0,  27.0,
       29.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  -6.0,  -4.0,  -2.0,   0.0,   3.0,
        5.0,   7.0,   9.0,  12.0,  14.0,  16.0,  19.0,  21.0,  24.0,  27.0,
       29.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  -7.0,  -4.0,  -2.0,   0.0,   2.0,
        5.0,   7.0,   9.0,  12.0,  14.0,  16.0,  19.0,  21.0,  24.0,  27.0,
       29.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  -7.0,  -5.0,  -2.0,   0.0,   2.0,
        5.0,   7.0,   9.0,  11.0,  14.0,  16.0,  19.0,  21.0,  24.0,  26.0,
       29.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  -7.0,  -5.0,  -3.0,   0.0,   2.0,
        4.0,   7.0,   9.0,  11.0,  14.0,  16.0,  19.0,  21.0,  24.0,  26.0,
       29.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  -8.0,  -5.0,  -3.0,   0.0,   2.0,
        4.0,   6.0,   9.0,  11.0,  14.0,  16.0,  18.0,  21.0,  24.0,  26.0,
       29.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  -8.0,  -5.0,  -3.0,  -1.0,   2.0,
        4.0,   6.0,   9.0,  11.0,  13.0,  16.0,  18.0,  21.0,  24.0,  26.0,
       29.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  -8.0,  -6.0,  -3.0,  -1.0,   1.0,
        4.0,   6.0,   9.0,  11.0,  13.0,  16.0,  18.0,  21.0,  24.0,  26.0,
       29.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  -8.0,  -6.0,  -4.0,  -1.0,   1.0,
        4.0,   6.0,   8.0,  11.0,  13.0,  16.0,  18.0,  21.0,  24.0,  26.0,
       29.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  -9.0,  -6.0,  -4.0,  -1.0,   1.0,
        3.0,   6.0,   8.0,  11.0,  13.0,  16.0,  18.0,  21.0,  24.0,  26.0,
       29.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  -9.0,  -7.0,  -4.0,  -2.0,   1.0,
        3.0,   6.0,   8.0,  11.0,  13.0,  16.0,  18.0,  21.0,  24.0,  26.0,
       29.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  -9.0,  -7.0,  -4.0,  -2.0,   1.0,
        3.0,   6.0,   8.0,  10.0,  13.0,  15.0,  18.0,  21.0,  23.0,  26.0,
       29.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    },
    {
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0, -10.0,  -7.0,  -5.0,  -2.0,   0.0,
        3.0,   5.0,   8.0,  10.0,  13.0,  15.0,  18.0,  21.0,  23.0,  26.0,
       29.0,  32.0,  36.0,  39.0,  42.0,  46.0,  49.0,  53.0,  56.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,
       60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0,  60.0
    }
  };
