/**
 * Type describing a syntax highlighting scheme as a JS object, as used in redux dev tools
 * Based on https://github.com/chriskempson/base16
 */
export interface Base16Theme {
    scheme: string;
    author: string;
    base00: string;
    base01: string;
    base02: string;
    base03: string;
    base04: string;
    base05: string;
    base06: string;
    base07: string;
    base08: string;
    base09: string;
    base0A: string;
    base0B: string;
    base0C: string;
    base0D: string;
    base0E: string;
    base0F: string;
}

// predefined schemes...
export const threezerotwofour: Base16Theme;
export const apathy: Base16Theme;
export const ashes: Base16Theme;
export const atelierDune: Base16Theme;
export const atelierForest: Base16Theme;
export const atelierHeath: Base16Theme;
export const atelierLakeside: Base16Theme;
export const atelierSeaside: Base16Theme;
export const bespin: Base16Theme;
export const brewer: Base16Theme;
export const bright: Base16Theme;
export const chalk: Base16Theme;
export const codeschool: Base16Theme;
export const colors: Base16Theme;
declare const _default: Base16Theme;
export default _default;
export const eighties: Base16Theme;
export const embers: Base16Theme;
export const flat: Base16Theme;
export const google: Base16Theme;
export const grayscale: Base16Theme;
export const greenscreen: Base16Theme;
export const harmonic: Base16Theme;
export const hopscotch: Base16Theme;
export const isotope: Base16Theme;
export const marrakesh: Base16Theme;
export const mocha: Base16Theme;
export const monokai: Base16Theme;
export const ocean: Base16Theme;
export const paraiso: Base16Theme;
export const pop: Base16Theme;
export const railscasts: Base16Theme;
export const shapeshifter: Base16Theme;
export const solarized: Base16Theme;
export const summerfruit: Base16Theme;
export const tomorrow: Base16Theme;
export const tube: Base16Theme;
export const twilight: Base16Theme;
