import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AcmeProviderConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/acme#server_url AcmeProvider#server_url}
    */
    readonly serverUrl: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/acme#alias AcmeProvider#alias}
    */
    readonly alias?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/acme acme}
*/
export declare class AcmeProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "acme";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/acme acme} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AcmeProviderConfig
    */
    constructor(scope: Construct, id: string, config: AcmeProviderConfig);
    private _serverUrl?;
    get serverUrl(): string | undefined;
    set serverUrl(value: string | undefined);
    get serverUrlInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
