import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RegistrationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/acme/r/registration#account_key_pem Registration#account_key_pem}
    */
    readonly accountKeyPem: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/acme/r/registration#email_address Registration#email_address}
    */
    readonly emailAddress: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/acme/r/registration#id Registration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * external_account_binding block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/acme/r/registration#external_account_binding Registration#external_account_binding}
    */
    readonly externalAccountBinding?: RegistrationExternalAccountBinding;
}
export interface RegistrationExternalAccountBinding {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/acme/r/registration#hmac_base64 Registration#hmac_base64}
    */
    readonly hmacBase64: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/acme/r/registration#key_id Registration#key_id}
    */
    readonly keyId: string;
}
export declare function registrationExternalAccountBindingToTerraform(struct?: RegistrationExternalAccountBindingOutputReference | RegistrationExternalAccountBinding): any;
export declare class RegistrationExternalAccountBindingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RegistrationExternalAccountBinding | undefined;
    set internalValue(value: RegistrationExternalAccountBinding | undefined);
    private _hmacBase64?;
    get hmacBase64(): string;
    set hmacBase64(value: string);
    get hmacBase64Input(): string | undefined;
    private _keyId?;
    get keyId(): string;
    set keyId(value: string);
    get keyIdInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/acme/r/registration acme_registration}
*/
export declare class Registration extends cdktf.TerraformResource {
    static readonly tfResourceType = "acme_registration";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/acme/r/registration acme_registration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RegistrationConfig
    */
    constructor(scope: Construct, id: string, config: RegistrationConfig);
    private _accountKeyPem?;
    get accountKeyPem(): string;
    set accountKeyPem(value: string);
    get accountKeyPemInput(): string | undefined;
    private _emailAddress?;
    get emailAddress(): string;
    set emailAddress(value: string);
    get emailAddressInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get registrationUrl(): string;
    private _externalAccountBinding;
    get externalAccountBinding(): RegistrationExternalAccountBindingOutputReference;
    putExternalAccountBinding(value: RegistrationExternalAccountBinding): void;
    resetExternalAccountBinding(): void;
    get externalAccountBindingInput(): RegistrationExternalAccountBinding | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
