/**
 * List of backend frameworks supported by the experimental backends feature
 */
export declare const BACKEND_FRAMEWORKS: readonly ["express", "hono", "h3", "nestjs", "fastify"];
export type BackendFramework = (typeof BACKEND_FRAMEWORKS)[number];
/**
 * Checks if the given framework is a backend framework
 */
export declare function isBackendFramework(framework: string | null | undefined): framework is BackendFramework;
/**
 * Checks if experimental backends are enabled via environment variable
 */
export declare function isExperimentalBackendsEnabled(): boolean;
/**
 * Checks if experimental backends are enabled AND the framework is a backend framework
 */
export declare function shouldUseExperimentalBackends(framework: string | null | undefined): boolean;
