<a id="mypy-boto3-kinesisvideo"></a>

# mypy-boto3-kinesisvideo

[![PyPI - mypy-boto3-kinesisvideo](https://img.shields.io/pypi/v/mypy-boto3-kinesisvideo.svg?color=blue)](https://pypi.org/project/mypy-boto3-kinesisvideo)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-kinesisvideo.svg?color=blue)](https://pypi.org/project/mypy-boto3-kinesisvideo)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-kinesisvideo?color=blue)](https://pypistats.org/packages/mypy-boto3-kinesisvideo)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.KinesisVideo 1.17.109](https://boto3.amazonaws.com/v1/documentation/api/1.17.109/reference/services/kinesisvideo.html#KinesisVideo)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.22.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-kinesisvideo docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_kinesisvideo/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-kinesisvideo](#mypy-boto3-kinesisvideo)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `KinesisVideo` service.

```bash
python -m pip install boto3-stubs[kinesisvideo]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[kinesisvideo]` in your environment:
  `python -m pip install 'boto3-stubs[kinesisvideo]'`

Both type checking and auto-complete should work for `KinesisVideo` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[kinesisvideo]` in your environment:
  `python -m pip install 'boto3-stubs[kinesisvideo]'`

Both type checking and auto-complete should work for `KinesisVideo` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[kinesisvideo]` in your environment:
  `python -m pip install 'boto3-stubs[kinesisvideo]'`
- Run `mypy` as usual

Type checking should work for `KinesisVideo` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[kinesisvideo]` in your environment:
  `python -m pip install 'boto3-stubs[kinesisvideo]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `KinesisVideo` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`KinesisVideoClient` provides annotations for `boto3.client("kinesisvideo")`.

```python
import boto3

from mypy_boto3_kinesisvideo import KinesisVideoClient

client: KinesisVideoClient = boto3.client("kinesisvideo")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: KinesisVideoClient = session.client("kinesisvideo")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_kinesisvideo.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_kinesisvideo import KinesisVideoClient
from mypy_boto3_kinesisvideo.paginator import (
    ListSignalingChannelsPaginator,
    ListStreamsPaginator,
)

client: KinesisVideoClient = boto3.client("kinesisvideo")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_signaling_channels_paginator: ListSignalingChannelsPaginator = client.get_paginator("list_signaling_channels")
list_streams_paginator: ListStreamsPaginator = client.get_paginator("list_streams")
```

<a id="literals"></a>

### Literals

`mypy_boto3_kinesisvideo.literals` module contains literals extracted from
shapes that can be used in user code for type checking.

```python
from mypy_boto3_kinesisvideo.literals import (
    APINameType,
    ChannelProtocolType,
    ChannelRoleType,
    ChannelTypeType,
    ComparisonOperatorType,
    ListSignalingChannelsPaginatorName,
    ListStreamsPaginatorName,
    StatusType,
    UpdateDataRetentionOperationType,
)

def check_value(value: APINameType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_kinesisvideo.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_kinesisvideo.type_defs import (
    ChannelInfoTypeDef,
    ChannelNameConditionTypeDef,
    CreateSignalingChannelInputRequestTypeDef,
    CreateSignalingChannelOutputTypeDef,
    CreateStreamInputRequestTypeDef,
    CreateStreamOutputTypeDef,
    DeleteSignalingChannelInputRequestTypeDef,
    DeleteStreamInputRequestTypeDef,
    DescribeSignalingChannelInputRequestTypeDef,
    DescribeSignalingChannelOutputTypeDef,
    DescribeStreamInputRequestTypeDef,
    DescribeStreamOutputTypeDef,
    GetDataEndpointInputRequestTypeDef,
    GetDataEndpointOutputTypeDef,
    GetSignalingChannelEndpointInputRequestTypeDef,
    GetSignalingChannelEndpointOutputTypeDef,
    ListSignalingChannelsInputRequestTypeDef,
    ListSignalingChannelsOutputTypeDef,
    ListStreamsInputRequestTypeDef,
    ListStreamsOutputTypeDef,
    ListTagsForResourceInputRequestTypeDef,
    ListTagsForResourceOutputTypeDef,
    ListTagsForStreamInputRequestTypeDef,
    ListTagsForStreamOutputTypeDef,
    PaginatorConfigTypeDef,
    ResourceEndpointListItemTypeDef,
    ResponseMetadataTypeDef,
    SingleMasterChannelEndpointConfigurationTypeDef,
    SingleMasterConfigurationTypeDef,
    StreamInfoTypeDef,
    StreamNameConditionTypeDef,
    TagResourceInputRequestTypeDef,
    TagStreamInputRequestTypeDef,
    TagTypeDef,
    UntagResourceInputRequestTypeDef,
    UntagStreamInputRequestTypeDef,
    UpdateDataRetentionInputRequestTypeDef,
    UpdateSignalingChannelInputRequestTypeDef,
    UpdateStreamInputRequestTypeDef,
)

def get_structure() -> ChannelInfoTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-kinesisvideo` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-kinesisvideo docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_kinesisvideo/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
