# Decline Analysis

A Python package for decline curve analysis of oil well production using Arps models and LLM-based forecasting methods.

## Features

- Traditional Arps decline curve analysis (exponential, hyperbolic, harmonic)
- Advanced forecasting with machine learning models (ARIMA, Chronos, TimesFM)
- Economic analysis and reserves estimation
- Sensitivity analysis capabilities
- Data visualization and plotting tools

## Installation

```bash
pip install decline-analysis
```

## Usage

```python
from decline_analysis import dca

# Load your production data
# Run decline curve analysis
# Generate forecasts and economic metrics
```

## Development

Install in development mode:

```bash
pip install -e .
```

Run tests:

```bash
pytest
```

## License

Apache-2.0
