# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/06b_research_utils.ipynb.

# %% auto 0
__all__ = ['pred_postprocess']

# %% ../nbs/06b_research_utils.ipynb 1
import numpy as np
from scipy.ndimage import label
from skimage.morphology import remove_small_objects

# %% ../nbs/06b_research_utils.ipynb 2
def pred_postprocess(pred_mask, avg_disc=10437, percentage=0.2): 
    small_objects = avg_disc*percentage    
    labeled_mask, ncomponents = label(pred_mask)
    labeled_mask = remove_small_objects(labeled_mask, min_size=small_objects)
    
    return np.where(labeled_mask>0, 1., 0.)
