# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AppSecAdvancedSettingsPrefetchArgs', 'AppSecAdvancedSettingsPrefetch']

@pulumi.input_type
class AppSecAdvancedSettingsPrefetchArgs:
    def __init__(__self__, *,
                 all_extensions: pulumi.Input[_builtins.bool],
                 config_id: pulumi.Input[_builtins.int],
                 enable_app_layer: pulumi.Input[_builtins.bool],
                 enable_rate_controls: pulumi.Input[_builtins.bool],
                 extensions: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        """
        The set of arguments for constructing a AppSecAdvancedSettingsPrefetch resource.
        :param pulumi.Input[_builtins.bool] all_extensions: Whether to enable prefetch requests for all file extensions
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[_builtins.bool] enable_app_layer: Whether to enable or disable prefetch requests
        :param pulumi.Input[_builtins.bool] enable_rate_controls: Whether to enable prefetch requests for rate controls
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] extensions: List of file extensions
        """
        pulumi.set(__self__, "all_extensions", all_extensions)
        pulumi.set(__self__, "config_id", config_id)
        pulumi.set(__self__, "enable_app_layer", enable_app_layer)
        pulumi.set(__self__, "enable_rate_controls", enable_rate_controls)
        pulumi.set(__self__, "extensions", extensions)

    @_builtins.property
    @pulumi.getter(name="allExtensions")
    def all_extensions(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether to enable prefetch requests for all file extensions
        """
        return pulumi.get(self, "all_extensions")

    @all_extensions.setter
    def all_extensions(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "all_extensions", value)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Input[_builtins.int]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter(name="enableAppLayer")
    def enable_app_layer(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether to enable or disable prefetch requests
        """
        return pulumi.get(self, "enable_app_layer")

    @enable_app_layer.setter
    def enable_app_layer(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enable_app_layer", value)

    @_builtins.property
    @pulumi.getter(name="enableRateControls")
    def enable_rate_controls(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether to enable prefetch requests for rate controls
        """
        return pulumi.get(self, "enable_rate_controls")

    @enable_rate_controls.setter
    def enable_rate_controls(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enable_rate_controls", value)

    @_builtins.property
    @pulumi.getter
    def extensions(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of file extensions
        """
        return pulumi.get(self, "extensions")

    @extensions.setter
    def extensions(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "extensions", value)


@pulumi.input_type
class _AppSecAdvancedSettingsPrefetchState:
    def __init__(__self__, *,
                 all_extensions: Optional[pulumi.Input[_builtins.bool]] = None,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_app_layer: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_rate_controls: Optional[pulumi.Input[_builtins.bool]] = None,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering AppSecAdvancedSettingsPrefetch resources.
        :param pulumi.Input[_builtins.bool] all_extensions: Whether to enable prefetch requests for all file extensions
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[_builtins.bool] enable_app_layer: Whether to enable or disable prefetch requests
        :param pulumi.Input[_builtins.bool] enable_rate_controls: Whether to enable prefetch requests for rate controls
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] extensions: List of file extensions
        """
        if all_extensions is not None:
            pulumi.set(__self__, "all_extensions", all_extensions)
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if enable_app_layer is not None:
            pulumi.set(__self__, "enable_app_layer", enable_app_layer)
        if enable_rate_controls is not None:
            pulumi.set(__self__, "enable_rate_controls", enable_rate_controls)
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)

    @_builtins.property
    @pulumi.getter(name="allExtensions")
    def all_extensions(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable prefetch requests for all file extensions
        """
        return pulumi.get(self, "all_extensions")

    @all_extensions.setter
    def all_extensions(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "all_extensions", value)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter(name="enableAppLayer")
    def enable_app_layer(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable or disable prefetch requests
        """
        return pulumi.get(self, "enable_app_layer")

    @enable_app_layer.setter
    def enable_app_layer(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_app_layer", value)

    @_builtins.property
    @pulumi.getter(name="enableRateControls")
    def enable_rate_controls(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable prefetch requests for rate controls
        """
        return pulumi.get(self, "enable_rate_controls")

    @enable_rate_controls.setter
    def enable_rate_controls(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_rate_controls", value)

    @_builtins.property
    @pulumi.getter
    def extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of file extensions
        """
        return pulumi.get(self, "extensions")

    @extensions.setter
    def extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "extensions", value)


@pulumi.type_token("akamai:index/appSecAdvancedSettingsPrefetch:AppSecAdvancedSettingsPrefetch")
class AppSecAdvancedSettingsPrefetch(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 all_extensions: Optional[pulumi.Input[_builtins.bool]] = None,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_app_layer: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_rate_controls: Optional[pulumi.Input[_builtins.bool]] = None,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Create a AppSecAdvancedSettingsPrefetch resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] all_extensions: Whether to enable prefetch requests for all file extensions
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[_builtins.bool] enable_app_layer: Whether to enable or disable prefetch requests
        :param pulumi.Input[_builtins.bool] enable_rate_controls: Whether to enable prefetch requests for rate controls
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] extensions: List of file extensions
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppSecAdvancedSettingsPrefetchArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AppSecAdvancedSettingsPrefetch resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AppSecAdvancedSettingsPrefetchArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppSecAdvancedSettingsPrefetchArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 all_extensions: Optional[pulumi.Input[_builtins.bool]] = None,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_app_layer: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_rate_controls: Optional[pulumi.Input[_builtins.bool]] = None,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppSecAdvancedSettingsPrefetchArgs.__new__(AppSecAdvancedSettingsPrefetchArgs)

            if all_extensions is None and not opts.urn:
                raise TypeError("Missing required property 'all_extensions'")
            __props__.__dict__["all_extensions"] = all_extensions
            if config_id is None and not opts.urn:
                raise TypeError("Missing required property 'config_id'")
            __props__.__dict__["config_id"] = config_id
            if enable_app_layer is None and not opts.urn:
                raise TypeError("Missing required property 'enable_app_layer'")
            __props__.__dict__["enable_app_layer"] = enable_app_layer
            if enable_rate_controls is None and not opts.urn:
                raise TypeError("Missing required property 'enable_rate_controls'")
            __props__.__dict__["enable_rate_controls"] = enable_rate_controls
            if extensions is None and not opts.urn:
                raise TypeError("Missing required property 'extensions'")
            __props__.__dict__["extensions"] = extensions
        super(AppSecAdvancedSettingsPrefetch, __self__).__init__(
            'akamai:index/appSecAdvancedSettingsPrefetch:AppSecAdvancedSettingsPrefetch',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            all_extensions: Optional[pulumi.Input[_builtins.bool]] = None,
            config_id: Optional[pulumi.Input[_builtins.int]] = None,
            enable_app_layer: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_rate_controls: Optional[pulumi.Input[_builtins.bool]] = None,
            extensions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'AppSecAdvancedSettingsPrefetch':
        """
        Get an existing AppSecAdvancedSettingsPrefetch resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] all_extensions: Whether to enable prefetch requests for all file extensions
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[_builtins.bool] enable_app_layer: Whether to enable or disable prefetch requests
        :param pulumi.Input[_builtins.bool] enable_rate_controls: Whether to enable prefetch requests for rate controls
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] extensions: List of file extensions
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppSecAdvancedSettingsPrefetchState.__new__(_AppSecAdvancedSettingsPrefetchState)

        __props__.__dict__["all_extensions"] = all_extensions
        __props__.__dict__["config_id"] = config_id
        __props__.__dict__["enable_app_layer"] = enable_app_layer
        __props__.__dict__["enable_rate_controls"] = enable_rate_controls
        __props__.__dict__["extensions"] = extensions
        return AppSecAdvancedSettingsPrefetch(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allExtensions")
    def all_extensions(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to enable prefetch requests for all file extensions
        """
        return pulumi.get(self, "all_extensions")

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Output[_builtins.int]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @_builtins.property
    @pulumi.getter(name="enableAppLayer")
    def enable_app_layer(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to enable or disable prefetch requests
        """
        return pulumi.get(self, "enable_app_layer")

    @_builtins.property
    @pulumi.getter(name="enableRateControls")
    def enable_rate_controls(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to enable prefetch requests for rate controls
        """
        return pulumi.get(self, "enable_rate_controls")

    @_builtins.property
    @pulumi.getter
    def extensions(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of file extensions
        """
        return pulumi.get(self, "extensions")

