# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AppSecByPassNetworkListArgs', 'AppSecByPassNetworkList']

@pulumi.input_type
class AppSecByPassNetworkListArgs:
    def __init__(__self__, *,
                 bypass_network_lists: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 config_id: pulumi.Input[_builtins.int],
                 security_policy_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a AppSecByPassNetworkList resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] bypass_network_lists: List of network list IDs that compose the bypass list
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[_builtins.str] security_policy_id: The unique identifier of the security policy governing the bypass network lists
        """
        pulumi.set(__self__, "bypass_network_lists", bypass_network_lists)
        pulumi.set(__self__, "config_id", config_id)
        pulumi.set(__self__, "security_policy_id", security_policy_id)

    @_builtins.property
    @pulumi.getter(name="bypassNetworkLists")
    def bypass_network_lists(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of network list IDs that compose the bypass list
        """
        return pulumi.get(self, "bypass_network_lists")

    @bypass_network_lists.setter
    def bypass_network_lists(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "bypass_network_lists", value)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Input[_builtins.int]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> pulumi.Input[_builtins.str]:
        """
        The unique identifier of the security policy governing the bypass network lists
        """
        return pulumi.get(self, "security_policy_id")

    @security_policy_id.setter
    def security_policy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "security_policy_id", value)


@pulumi.input_type
class _AppSecByPassNetworkListState:
    def __init__(__self__, *,
                 bypass_network_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AppSecByPassNetworkList resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] bypass_network_lists: List of network list IDs that compose the bypass list
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[_builtins.str] security_policy_id: The unique identifier of the security policy governing the bypass network lists
        """
        if bypass_network_lists is not None:
            pulumi.set(__self__, "bypass_network_lists", bypass_network_lists)
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if security_policy_id is not None:
            pulumi.set(__self__, "security_policy_id", security_policy_id)

    @_builtins.property
    @pulumi.getter(name="bypassNetworkLists")
    def bypass_network_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of network list IDs that compose the bypass list
        """
        return pulumi.get(self, "bypass_network_lists")

    @bypass_network_lists.setter
    def bypass_network_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "bypass_network_lists", value)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the security policy governing the bypass network lists
        """
        return pulumi.get(self, "security_policy_id")

    @security_policy_id.setter
    def security_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_policy_id", value)


@pulumi.type_token("akamai:index/appSecByPassNetworkList:AppSecByPassNetworkList")
class AppSecByPassNetworkList(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bypass_network_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a AppSecByPassNetworkList resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] bypass_network_lists: List of network list IDs that compose the bypass list
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[_builtins.str] security_policy_id: The unique identifier of the security policy governing the bypass network lists
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppSecByPassNetworkListArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AppSecByPassNetworkList resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AppSecByPassNetworkListArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppSecByPassNetworkListArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bypass_network_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppSecByPassNetworkListArgs.__new__(AppSecByPassNetworkListArgs)

            if bypass_network_lists is None and not opts.urn:
                raise TypeError("Missing required property 'bypass_network_lists'")
            __props__.__dict__["bypass_network_lists"] = bypass_network_lists
            if config_id is None and not opts.urn:
                raise TypeError("Missing required property 'config_id'")
            __props__.__dict__["config_id"] = config_id
            if security_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_policy_id'")
            __props__.__dict__["security_policy_id"] = security_policy_id
        super(AppSecByPassNetworkList, __self__).__init__(
            'akamai:index/appSecByPassNetworkList:AppSecByPassNetworkList',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bypass_network_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            config_id: Optional[pulumi.Input[_builtins.int]] = None,
            security_policy_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'AppSecByPassNetworkList':
        """
        Get an existing AppSecByPassNetworkList resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] bypass_network_lists: List of network list IDs that compose the bypass list
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[_builtins.str] security_policy_id: The unique identifier of the security policy governing the bypass network lists
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppSecByPassNetworkListState.__new__(_AppSecByPassNetworkListState)

        __props__.__dict__["bypass_network_lists"] = bypass_network_lists
        __props__.__dict__["config_id"] = config_id
        __props__.__dict__["security_policy_id"] = security_policy_id
        return AppSecByPassNetworkList(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="bypassNetworkLists")
    def bypass_network_lists(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of network list IDs that compose the bypass list
        """
        return pulumi.get(self, "bypass_network_lists")

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Output[_builtins.int]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the security policy governing the bypass network lists
        """
        return pulumi.get(self, "security_policy_id")

