# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AppSecConfigurationArgs', 'AppSecConfiguration']

@pulumi.input_type
class AppSecConfigurationArgs:
    def __init__(__self__, *,
                 contract_id: pulumi.Input[_builtins.str],
                 description: pulumi.Input[_builtins.str],
                 group_id: pulumi.Input[_builtins.str],
                 host_names: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 create_from_config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 create_from_version: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AppSecConfiguration resource.
        :param pulumi.Input[_builtins.str] contract_id: Unique identifier of the Akamai contract associated with the new configuration
        :param pulumi.Input[_builtins.str] description: Brief description of the new configuration
        :param pulumi.Input[_builtins.str] group_id: Unique identifier of the contract group associated with the new configuration
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_names: Hostnames to be protected by the new configuration
        :param pulumi.Input[_builtins.int] create_from_config_id: Unique identifier of the existing configuration being cloned to create the new configuration
        :param pulumi.Input[_builtins.int] create_from_version: Version number of the existing configuration being cloned to create the new configuration
        :param pulumi.Input[_builtins.str] name: Name of the new configuration
        """
        pulumi.set(__self__, "contract_id", contract_id)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "host_names", host_names)
        if create_from_config_id is not None:
            pulumi.set(__self__, "create_from_config_id", create_from_config_id)
        if create_from_version is not None:
            pulumi.set(__self__, "create_from_version", create_from_version)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Input[_builtins.str]:
        """
        Unique identifier of the Akamai contract associated with the new configuration
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "contract_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        Brief description of the new configuration
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[_builtins.str]:
        """
        Unique identifier of the contract group associated with the new configuration
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="hostNames")
    def host_names(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Hostnames to be protected by the new configuration
        """
        return pulumi.get(self, "host_names")

    @host_names.setter
    def host_names(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "host_names", value)

    @_builtins.property
    @pulumi.getter(name="createFromConfigId")
    def create_from_config_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Unique identifier of the existing configuration being cloned to create the new configuration
        """
        return pulumi.get(self, "create_from_config_id")

    @create_from_config_id.setter
    def create_from_config_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "create_from_config_id", value)

    @_builtins.property
    @pulumi.getter(name="createFromVersion")
    def create_from_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Version number of the existing configuration being cloned to create the new configuration
        """
        return pulumi.get(self, "create_from_version")

    @create_from_version.setter
    def create_from_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "create_from_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the new configuration
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _AppSecConfigurationState:
    def __init__(__self__, *,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 create_from_config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 create_from_version: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AppSecConfiguration resources.
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the new security configuration
        :param pulumi.Input[_builtins.str] contract_id: Unique identifier of the Akamai contract associated with the new configuration
        :param pulumi.Input[_builtins.int] create_from_config_id: Unique identifier of the existing configuration being cloned to create the new configuration
        :param pulumi.Input[_builtins.int] create_from_version: Version number of the existing configuration being cloned to create the new configuration
        :param pulumi.Input[_builtins.str] description: Brief description of the new configuration
        :param pulumi.Input[_builtins.str] group_id: Unique identifier of the contract group associated with the new configuration
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_names: Hostnames to be protected by the new configuration
        :param pulumi.Input[_builtins.str] name: Name of the new configuration
        """
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if contract_id is not None:
            pulumi.set(__self__, "contract_id", contract_id)
        if create_from_config_id is not None:
            pulumi.set(__self__, "create_from_config_id", create_from_config_id)
        if create_from_version is not None:
            pulumi.set(__self__, "create_from_version", create_from_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if host_names is not None:
            pulumi.set(__self__, "host_names", host_names)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Unique identifier of the new security configuration
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the Akamai contract associated with the new configuration
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "contract_id", value)

    @_builtins.property
    @pulumi.getter(name="createFromConfigId")
    def create_from_config_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Unique identifier of the existing configuration being cloned to create the new configuration
        """
        return pulumi.get(self, "create_from_config_id")

    @create_from_config_id.setter
    def create_from_config_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "create_from_config_id", value)

    @_builtins.property
    @pulumi.getter(name="createFromVersion")
    def create_from_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Version number of the existing configuration being cloned to create the new configuration
        """
        return pulumi.get(self, "create_from_version")

    @create_from_version.setter
    def create_from_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "create_from_version", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Brief description of the new configuration
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the contract group associated with the new configuration
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="hostNames")
    def host_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Hostnames to be protected by the new configuration
        """
        return pulumi.get(self, "host_names")

    @host_names.setter
    def host_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "host_names", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the new configuration
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("akamai:index/appSecConfiguration:AppSecConfiguration")
class AppSecConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 create_from_config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 create_from_version: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a AppSecConfiguration resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] contract_id: Unique identifier of the Akamai contract associated with the new configuration
        :param pulumi.Input[_builtins.int] create_from_config_id: Unique identifier of the existing configuration being cloned to create the new configuration
        :param pulumi.Input[_builtins.int] create_from_version: Version number of the existing configuration being cloned to create the new configuration
        :param pulumi.Input[_builtins.str] description: Brief description of the new configuration
        :param pulumi.Input[_builtins.str] group_id: Unique identifier of the contract group associated with the new configuration
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_names: Hostnames to be protected by the new configuration
        :param pulumi.Input[_builtins.str] name: Name of the new configuration
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppSecConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AppSecConfiguration resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AppSecConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppSecConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 create_from_config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 create_from_version: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppSecConfigurationArgs.__new__(AppSecConfigurationArgs)

            if contract_id is None and not opts.urn:
                raise TypeError("Missing required property 'contract_id'")
            __props__.__dict__["contract_id"] = contract_id
            __props__.__dict__["create_from_config_id"] = create_from_config_id
            __props__.__dict__["create_from_version"] = create_from_version
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            if host_names is None and not opts.urn:
                raise TypeError("Missing required property 'host_names'")
            __props__.__dict__["host_names"] = host_names
            __props__.__dict__["name"] = name
            __props__.__dict__["config_id"] = None
        super(AppSecConfiguration, __self__).__init__(
            'akamai:index/appSecConfiguration:AppSecConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config_id: Optional[pulumi.Input[_builtins.int]] = None,
            contract_id: Optional[pulumi.Input[_builtins.str]] = None,
            create_from_config_id: Optional[pulumi.Input[_builtins.int]] = None,
            create_from_version: Optional[pulumi.Input[_builtins.int]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            group_id: Optional[pulumi.Input[_builtins.str]] = None,
            host_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'AppSecConfiguration':
        """
        Get an existing AppSecConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the new security configuration
        :param pulumi.Input[_builtins.str] contract_id: Unique identifier of the Akamai contract associated with the new configuration
        :param pulumi.Input[_builtins.int] create_from_config_id: Unique identifier of the existing configuration being cloned to create the new configuration
        :param pulumi.Input[_builtins.int] create_from_version: Version number of the existing configuration being cloned to create the new configuration
        :param pulumi.Input[_builtins.str] description: Brief description of the new configuration
        :param pulumi.Input[_builtins.str] group_id: Unique identifier of the contract group associated with the new configuration
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_names: Hostnames to be protected by the new configuration
        :param pulumi.Input[_builtins.str] name: Name of the new configuration
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppSecConfigurationState.__new__(_AppSecConfigurationState)

        __props__.__dict__["config_id"] = config_id
        __props__.__dict__["contract_id"] = contract_id
        __props__.__dict__["create_from_config_id"] = create_from_config_id
        __props__.__dict__["create_from_version"] = create_from_version
        __props__.__dict__["description"] = description
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["host_names"] = host_names
        __props__.__dict__["name"] = name
        return AppSecConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Output[_builtins.int]:
        """
        Unique identifier of the new security configuration
        """
        return pulumi.get(self, "config_id")

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the Akamai contract associated with the new configuration
        """
        return pulumi.get(self, "contract_id")

    @_builtins.property
    @pulumi.getter(name="createFromConfigId")
    def create_from_config_id(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Unique identifier of the existing configuration being cloned to create the new configuration
        """
        return pulumi.get(self, "create_from_config_id")

    @_builtins.property
    @pulumi.getter(name="createFromVersion")
    def create_from_version(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Version number of the existing configuration being cloned to create the new configuration
        """
        return pulumi.get(self, "create_from_version")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Brief description of the new configuration
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the contract group associated with the new configuration
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter(name="hostNames")
    def host_names(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Hostnames to be protected by the new configuration
        """
        return pulumi.get(self, "host_names")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the new configuration
        """
        return pulumi.get(self, "name")

