# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AppSecRuleArgs', 'AppSecRule']

@pulumi.input_type
class AppSecRuleArgs:
    def __init__(__self__, *,
                 config_id: pulumi.Input[_builtins.int],
                 rule_id: pulumi.Input[_builtins.int],
                 security_policy_id: pulumi.Input[_builtins.str],
                 condition_exception: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_action: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AppSecRule resource.
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[_builtins.int] rule_id: Unique identifier of the rule
        :param pulumi.Input[_builtins.str] security_policy_id: Unique identifier of the security policy
        :param pulumi.Input[_builtins.str] condition_exception: JSON-formatted condition and exception information for the rule
        :param pulumi.Input[_builtins.str] rule_action: Action to be taken when the rule is triggered
        """
        pulumi.set(__self__, "config_id", config_id)
        pulumi.set(__self__, "rule_id", rule_id)
        pulumi.set(__self__, "security_policy_id", security_policy_id)
        if condition_exception is not None:
            pulumi.set(__self__, "condition_exception", condition_exception)
        if rule_action is not None:
            pulumi.set(__self__, "rule_action", rule_action)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Input[_builtins.int]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> pulumi.Input[_builtins.int]:
        """
        Unique identifier of the rule
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "rule_id", value)

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> pulumi.Input[_builtins.str]:
        """
        Unique identifier of the security policy
        """
        return pulumi.get(self, "security_policy_id")

    @security_policy_id.setter
    def security_policy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "security_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="conditionException")
    def condition_exception(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON-formatted condition and exception information for the rule
        """
        return pulumi.get(self, "condition_exception")

    @condition_exception.setter
    def condition_exception(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition_exception", value)

    @_builtins.property
    @pulumi.getter(name="ruleAction")
    def rule_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Action to be taken when the rule is triggered
        """
        return pulumi.get(self, "rule_action")

    @rule_action.setter
    def rule_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_action", value)


@pulumi.input_type
class _AppSecRuleState:
    def __init__(__self__, *,
                 condition_exception: Optional[pulumi.Input[_builtins.str]] = None,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 rule_action: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_id: Optional[pulumi.Input[_builtins.int]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AppSecRule resources.
        :param pulumi.Input[_builtins.str] condition_exception: JSON-formatted condition and exception information for the rule
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[_builtins.str] rule_action: Action to be taken when the rule is triggered
        :param pulumi.Input[_builtins.int] rule_id: Unique identifier of the rule
        :param pulumi.Input[_builtins.str] security_policy_id: Unique identifier of the security policy
        """
        if condition_exception is not None:
            pulumi.set(__self__, "condition_exception", condition_exception)
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if rule_action is not None:
            pulumi.set(__self__, "rule_action", rule_action)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)
        if security_policy_id is not None:
            pulumi.set(__self__, "security_policy_id", security_policy_id)

    @_builtins.property
    @pulumi.getter(name="conditionException")
    def condition_exception(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON-formatted condition and exception information for the rule
        """
        return pulumi.get(self, "condition_exception")

    @condition_exception.setter
    def condition_exception(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition_exception", value)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter(name="ruleAction")
    def rule_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Action to be taken when the rule is triggered
        """
        return pulumi.get(self, "rule_action")

    @rule_action.setter
    def rule_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_action", value)

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Unique identifier of the rule
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rule_id", value)

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the security policy
        """
        return pulumi.get(self, "security_policy_id")

    @security_policy_id.setter
    def security_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_policy_id", value)


@pulumi.type_token("akamai:index/appSecRule:AppSecRule")
class AppSecRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 condition_exception: Optional[pulumi.Input[_builtins.str]] = None,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 rule_action: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_id: Optional[pulumi.Input[_builtins.int]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a AppSecRule resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] condition_exception: JSON-formatted condition and exception information for the rule
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[_builtins.str] rule_action: Action to be taken when the rule is triggered
        :param pulumi.Input[_builtins.int] rule_id: Unique identifier of the rule
        :param pulumi.Input[_builtins.str] security_policy_id: Unique identifier of the security policy
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppSecRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AppSecRule resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AppSecRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppSecRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 condition_exception: Optional[pulumi.Input[_builtins.str]] = None,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 rule_action: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_id: Optional[pulumi.Input[_builtins.int]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppSecRuleArgs.__new__(AppSecRuleArgs)

            __props__.__dict__["condition_exception"] = condition_exception
            if config_id is None and not opts.urn:
                raise TypeError("Missing required property 'config_id'")
            __props__.__dict__["config_id"] = config_id
            __props__.__dict__["rule_action"] = rule_action
            if rule_id is None and not opts.urn:
                raise TypeError("Missing required property 'rule_id'")
            __props__.__dict__["rule_id"] = rule_id
            if security_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_policy_id'")
            __props__.__dict__["security_policy_id"] = security_policy_id
        super(AppSecRule, __self__).__init__(
            'akamai:index/appSecRule:AppSecRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            condition_exception: Optional[pulumi.Input[_builtins.str]] = None,
            config_id: Optional[pulumi.Input[_builtins.int]] = None,
            rule_action: Optional[pulumi.Input[_builtins.str]] = None,
            rule_id: Optional[pulumi.Input[_builtins.int]] = None,
            security_policy_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'AppSecRule':
        """
        Get an existing AppSecRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] condition_exception: JSON-formatted condition and exception information for the rule
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[_builtins.str] rule_action: Action to be taken when the rule is triggered
        :param pulumi.Input[_builtins.int] rule_id: Unique identifier of the rule
        :param pulumi.Input[_builtins.str] security_policy_id: Unique identifier of the security policy
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppSecRuleState.__new__(_AppSecRuleState)

        __props__.__dict__["condition_exception"] = condition_exception
        __props__.__dict__["config_id"] = config_id
        __props__.__dict__["rule_action"] = rule_action
        __props__.__dict__["rule_id"] = rule_id
        __props__.__dict__["security_policy_id"] = security_policy_id
        return AppSecRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="conditionException")
    def condition_exception(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        JSON-formatted condition and exception information for the rule
        """
        return pulumi.get(self, "condition_exception")

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Output[_builtins.int]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @_builtins.property
    @pulumi.getter(name="ruleAction")
    def rule_action(self) -> pulumi.Output[_builtins.str]:
        """
        Action to be taken when the rule is triggered
        """
        return pulumi.get(self, "rule_action")

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> pulumi.Output[_builtins.int]:
        """
        Unique identifier of the rule
        """
        return pulumi.get(self, "rule_id")

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the security policy
        """
        return pulumi.get(self, "security_policy_id")

