# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MtlskeystoreClientCertificateThirdPartyArgs', 'MtlskeystoreClientCertificateThirdParty']

@pulumi.input_type
class MtlskeystoreClientCertificateThirdPartyArgs:
    def __init__(__self__, *,
                 certificate_name: pulumi.Input[_builtins.str],
                 contract_id: pulumi.Input[_builtins.str],
                 geography: pulumi.Input[_builtins.str],
                 group_id: pulumi.Input[_builtins.int],
                 notification_emails: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 secure_network: pulumi.Input[_builtins.str],
                 versions: pulumi.Input[Mapping[str, pulumi.Input['MtlskeystoreClientCertificateThirdPartyVersionsArgs']]],
                 key_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 subject: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MtlskeystoreClientCertificateThirdParty resource.
        :param pulumi.Input[_builtins.str] certificate_name: The name of the client certificate. Must be between 1 and 64 characters.
        :param pulumi.Input[_builtins.str] contract_id: The contract assigned to the client certificate. Must have a length of at least 1.
        :param pulumi.Input[_builtins.str] geography: Specifies the type of network to deploy the client certificate. Possible values: `CORE`, `RUSSIA_AND_CORE`, or `CHINA_AND_CORE`.
        :param pulumi.Input[_builtins.int] group_id: The group assigned to the client certificate. Must be greater than or equal to 0.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notification_emails: The email addresses to notify for client certificate-related issues. Must have at least one email address.
        :param pulumi.Input[_builtins.str] secure_network: Identifies the network deployment type. Possible values: `STANDARD_TLS` or `ENHANCED_TLS`.
        :param pulumi.Input[Mapping[str, pulumi.Input['MtlskeystoreClientCertificateThirdPartyVersionsArgs']]] versions: A map of client certificate versions as a value and user defined identifier as a key. Each version represents a specific iteration of the client certificate.
        :param pulumi.Input[_builtins.str] key_algorithm: The cryptographic algorithm used for key generation. Possible values: `RSA` or `ECDSA`. The default is `RSA`.
        :param pulumi.Input[_builtins.str] subject: The CA certificate’s key value details. The `CN` attribute is required and included in the subject. When not specified, the subject is constructed in this format: `/C=US/O=Akamai Technologies, Inc./OU={vcd_id} {contract_id} {group_id}/CN={certificate_name}/`.
        """
        pulumi.set(__self__, "certificate_name", certificate_name)
        pulumi.set(__self__, "contract_id", contract_id)
        pulumi.set(__self__, "geography", geography)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "notification_emails", notification_emails)
        pulumi.set(__self__, "secure_network", secure_network)
        pulumi.set(__self__, "versions", versions)
        if key_algorithm is not None:
            pulumi.set(__self__, "key_algorithm", key_algorithm)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)

    @_builtins.property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the client certificate. Must be between 1 and 64 characters.
        """
        return pulumi.get(self, "certificate_name")

    @certificate_name.setter
    def certificate_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "certificate_name", value)

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Input[_builtins.str]:
        """
        The contract assigned to the client certificate. Must have a length of at least 1.
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "contract_id", value)

    @_builtins.property
    @pulumi.getter
    def geography(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of network to deploy the client certificate. Possible values: `CORE`, `RUSSIA_AND_CORE`, or `CHINA_AND_CORE`.
        """
        return pulumi.get(self, "geography")

    @geography.setter
    def geography(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "geography", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[_builtins.int]:
        """
        The group assigned to the client certificate. Must be greater than or equal to 0.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="notificationEmails")
    def notification_emails(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The email addresses to notify for client certificate-related issues. Must have at least one email address.
        """
        return pulumi.get(self, "notification_emails")

    @notification_emails.setter
    def notification_emails(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "notification_emails", value)

    @_builtins.property
    @pulumi.getter(name="secureNetwork")
    def secure_network(self) -> pulumi.Input[_builtins.str]:
        """
        Identifies the network deployment type. Possible values: `STANDARD_TLS` or `ENHANCED_TLS`.
        """
        return pulumi.get(self, "secure_network")

    @secure_network.setter
    def secure_network(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "secure_network", value)

    @_builtins.property
    @pulumi.getter
    def versions(self) -> pulumi.Input[Mapping[str, pulumi.Input['MtlskeystoreClientCertificateThirdPartyVersionsArgs']]]:
        """
        A map of client certificate versions as a value and user defined identifier as a key. Each version represents a specific iteration of the client certificate.
        """
        return pulumi.get(self, "versions")

    @versions.setter
    def versions(self, value: pulumi.Input[Mapping[str, pulumi.Input['MtlskeystoreClientCertificateThirdPartyVersionsArgs']]]):
        pulumi.set(self, "versions", value)

    @_builtins.property
    @pulumi.getter(name="keyAlgorithm")
    def key_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cryptographic algorithm used for key generation. Possible values: `RSA` or `ECDSA`. The default is `RSA`.
        """
        return pulumi.get(self, "key_algorithm")

    @key_algorithm.setter
    def key_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_algorithm", value)

    @_builtins.property
    @pulumi.getter
    def subject(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CA certificate’s key value details. The `CN` attribute is required and included in the subject. When not specified, the subject is constructed in this format: `/C=US/O=Akamai Technologies, Inc./OU={vcd_id} {contract_id} {group_id}/CN={certificate_name}/`.
        """
        return pulumi.get(self, "subject")

    @subject.setter
    def subject(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subject", value)


@pulumi.input_type
class _MtlskeystoreClientCertificateThirdPartyState:
    def __init__(__self__, *,
                 certificate_id: Optional[pulumi.Input[_builtins.int]] = None,
                 certificate_name: Optional[pulumi.Input[_builtins.str]] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 geography: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.int]] = None,
                 key_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 secure_network: Optional[pulumi.Input[_builtins.str]] = None,
                 subject: Optional[pulumi.Input[_builtins.str]] = None,
                 versions: Optional[pulumi.Input[Mapping[str, pulumi.Input['MtlskeystoreClientCertificateThirdPartyVersionsArgs']]]] = None):
        """
        Input properties used for looking up and filtering MtlskeystoreClientCertificateThirdParty resources.
        :param pulumi.Input[_builtins.int] certificate_id: The unique identifier of the client certificate.
        :param pulumi.Input[_builtins.str] certificate_name: The name of the client certificate. Must be between 1 and 64 characters.
        :param pulumi.Input[_builtins.str] contract_id: The contract assigned to the client certificate. Must have a length of at least 1.
        :param pulumi.Input[_builtins.str] geography: Specifies the type of network to deploy the client certificate. Possible values: `CORE`, `RUSSIA_AND_CORE`, or `CHINA_AND_CORE`.
        :param pulumi.Input[_builtins.int] group_id: The group assigned to the client certificate. Must be greater than or equal to 0.
        :param pulumi.Input[_builtins.str] key_algorithm: The cryptographic algorithm used for key generation. Possible values: `RSA` or `ECDSA`. The default is `RSA`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notification_emails: The email addresses to notify for client certificate-related issues. Must have at least one email address.
        :param pulumi.Input[_builtins.str] secure_network: Identifies the network deployment type. Possible values: `STANDARD_TLS` or `ENHANCED_TLS`.
        :param pulumi.Input[_builtins.str] subject: The CA certificate’s key value details. The `CN` attribute is required and included in the subject. When not specified, the subject is constructed in this format: `/C=US/O=Akamai Technologies, Inc./OU={vcd_id} {contract_id} {group_id}/CN={certificate_name}/`.
        :param pulumi.Input[Mapping[str, pulumi.Input['MtlskeystoreClientCertificateThirdPartyVersionsArgs']]] versions: A map of client certificate versions as a value and user defined identifier as a key. Each version represents a specific iteration of the client certificate.
        """
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if certificate_name is not None:
            pulumi.set(__self__, "certificate_name", certificate_name)
        if contract_id is not None:
            pulumi.set(__self__, "contract_id", contract_id)
        if geography is not None:
            pulumi.set(__self__, "geography", geography)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if key_algorithm is not None:
            pulumi.set(__self__, "key_algorithm", key_algorithm)
        if notification_emails is not None:
            pulumi.set(__self__, "notification_emails", notification_emails)
        if secure_network is not None:
            pulumi.set(__self__, "secure_network", secure_network)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if versions is not None:
            pulumi.set(__self__, "versions", versions)

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The unique identifier of the client certificate.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "certificate_id", value)

    @_builtins.property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the client certificate. Must be between 1 and 64 characters.
        """
        return pulumi.get(self, "certificate_name")

    @certificate_name.setter
    def certificate_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_name", value)

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The contract assigned to the client certificate. Must have a length of at least 1.
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "contract_id", value)

    @_builtins.property
    @pulumi.getter
    def geography(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of network to deploy the client certificate. Possible values: `CORE`, `RUSSIA_AND_CORE`, or `CHINA_AND_CORE`.
        """
        return pulumi.get(self, "geography")

    @geography.setter
    def geography(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "geography", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The group assigned to the client certificate. Must be greater than or equal to 0.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="keyAlgorithm")
    def key_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cryptographic algorithm used for key generation. Possible values: `RSA` or `ECDSA`. The default is `RSA`.
        """
        return pulumi.get(self, "key_algorithm")

    @key_algorithm.setter
    def key_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="notificationEmails")
    def notification_emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The email addresses to notify for client certificate-related issues. Must have at least one email address.
        """
        return pulumi.get(self, "notification_emails")

    @notification_emails.setter
    def notification_emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "notification_emails", value)

    @_builtins.property
    @pulumi.getter(name="secureNetwork")
    def secure_network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifies the network deployment type. Possible values: `STANDARD_TLS` or `ENHANCED_TLS`.
        """
        return pulumi.get(self, "secure_network")

    @secure_network.setter
    def secure_network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secure_network", value)

    @_builtins.property
    @pulumi.getter
    def subject(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CA certificate’s key value details. The `CN` attribute is required and included in the subject. When not specified, the subject is constructed in this format: `/C=US/O=Akamai Technologies, Inc./OU={vcd_id} {contract_id} {group_id}/CN={certificate_name}/`.
        """
        return pulumi.get(self, "subject")

    @subject.setter
    def subject(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subject", value)

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['MtlskeystoreClientCertificateThirdPartyVersionsArgs']]]]:
        """
        A map of client certificate versions as a value and user defined identifier as a key. Each version represents a specific iteration of the client certificate.
        """
        return pulumi.get(self, "versions")

    @versions.setter
    def versions(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['MtlskeystoreClientCertificateThirdPartyVersionsArgs']]]]):
        pulumi.set(self, "versions", value)


@pulumi.type_token("akamai:index/mtlskeystoreClientCertificateThirdParty:MtlskeystoreClientCertificateThirdParty")
class MtlskeystoreClientCertificateThirdParty(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_name: Optional[pulumi.Input[_builtins.str]] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 geography: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.int]] = None,
                 key_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 secure_network: Optional[pulumi.Input[_builtins.str]] = None,
                 subject: Optional[pulumi.Input[_builtins.str]] = None,
                 versions: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['MtlskeystoreClientCertificateThirdPartyVersionsArgs', 'MtlskeystoreClientCertificateThirdPartyVersionsArgsDict']]]]] = None,
                 __props__=None):
        """
        Create a MtlskeystoreClientCertificateThirdParty resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate_name: The name of the client certificate. Must be between 1 and 64 characters.
        :param pulumi.Input[_builtins.str] contract_id: The contract assigned to the client certificate. Must have a length of at least 1.
        :param pulumi.Input[_builtins.str] geography: Specifies the type of network to deploy the client certificate. Possible values: `CORE`, `RUSSIA_AND_CORE`, or `CHINA_AND_CORE`.
        :param pulumi.Input[_builtins.int] group_id: The group assigned to the client certificate. Must be greater than or equal to 0.
        :param pulumi.Input[_builtins.str] key_algorithm: The cryptographic algorithm used for key generation. Possible values: `RSA` or `ECDSA`. The default is `RSA`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notification_emails: The email addresses to notify for client certificate-related issues. Must have at least one email address.
        :param pulumi.Input[_builtins.str] secure_network: Identifies the network deployment type. Possible values: `STANDARD_TLS` or `ENHANCED_TLS`.
        :param pulumi.Input[_builtins.str] subject: The CA certificate’s key value details. The `CN` attribute is required and included in the subject. When not specified, the subject is constructed in this format: `/C=US/O=Akamai Technologies, Inc./OU={vcd_id} {contract_id} {group_id}/CN={certificate_name}/`.
        :param pulumi.Input[Mapping[str, pulumi.Input[Union['MtlskeystoreClientCertificateThirdPartyVersionsArgs', 'MtlskeystoreClientCertificateThirdPartyVersionsArgsDict']]]] versions: A map of client certificate versions as a value and user defined identifier as a key. Each version represents a specific iteration of the client certificate.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MtlskeystoreClientCertificateThirdPartyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a MtlskeystoreClientCertificateThirdParty resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param MtlskeystoreClientCertificateThirdPartyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MtlskeystoreClientCertificateThirdPartyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_name: Optional[pulumi.Input[_builtins.str]] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 geography: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.int]] = None,
                 key_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 secure_network: Optional[pulumi.Input[_builtins.str]] = None,
                 subject: Optional[pulumi.Input[_builtins.str]] = None,
                 versions: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['MtlskeystoreClientCertificateThirdPartyVersionsArgs', 'MtlskeystoreClientCertificateThirdPartyVersionsArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MtlskeystoreClientCertificateThirdPartyArgs.__new__(MtlskeystoreClientCertificateThirdPartyArgs)

            if certificate_name is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_name'")
            __props__.__dict__["certificate_name"] = certificate_name
            if contract_id is None and not opts.urn:
                raise TypeError("Missing required property 'contract_id'")
            __props__.__dict__["contract_id"] = contract_id
            if geography is None and not opts.urn:
                raise TypeError("Missing required property 'geography'")
            __props__.__dict__["geography"] = geography
            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            __props__.__dict__["key_algorithm"] = key_algorithm
            if notification_emails is None and not opts.urn:
                raise TypeError("Missing required property 'notification_emails'")
            __props__.__dict__["notification_emails"] = notification_emails
            if secure_network is None and not opts.urn:
                raise TypeError("Missing required property 'secure_network'")
            __props__.__dict__["secure_network"] = secure_network
            __props__.__dict__["subject"] = subject
            if versions is None and not opts.urn:
                raise TypeError("Missing required property 'versions'")
            __props__.__dict__["versions"] = versions
            __props__.__dict__["certificate_id"] = None
        super(MtlskeystoreClientCertificateThirdParty, __self__).__init__(
            'akamai:index/mtlskeystoreClientCertificateThirdParty:MtlskeystoreClientCertificateThirdParty',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_id: Optional[pulumi.Input[_builtins.int]] = None,
            certificate_name: Optional[pulumi.Input[_builtins.str]] = None,
            contract_id: Optional[pulumi.Input[_builtins.str]] = None,
            geography: Optional[pulumi.Input[_builtins.str]] = None,
            group_id: Optional[pulumi.Input[_builtins.int]] = None,
            key_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            notification_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            secure_network: Optional[pulumi.Input[_builtins.str]] = None,
            subject: Optional[pulumi.Input[_builtins.str]] = None,
            versions: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['MtlskeystoreClientCertificateThirdPartyVersionsArgs', 'MtlskeystoreClientCertificateThirdPartyVersionsArgsDict']]]]] = None) -> 'MtlskeystoreClientCertificateThirdParty':
        """
        Get an existing MtlskeystoreClientCertificateThirdParty resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] certificate_id: The unique identifier of the client certificate.
        :param pulumi.Input[_builtins.str] certificate_name: The name of the client certificate. Must be between 1 and 64 characters.
        :param pulumi.Input[_builtins.str] contract_id: The contract assigned to the client certificate. Must have a length of at least 1.
        :param pulumi.Input[_builtins.str] geography: Specifies the type of network to deploy the client certificate. Possible values: `CORE`, `RUSSIA_AND_CORE`, or `CHINA_AND_CORE`.
        :param pulumi.Input[_builtins.int] group_id: The group assigned to the client certificate. Must be greater than or equal to 0.
        :param pulumi.Input[_builtins.str] key_algorithm: The cryptographic algorithm used for key generation. Possible values: `RSA` or `ECDSA`. The default is `RSA`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notification_emails: The email addresses to notify for client certificate-related issues. Must have at least one email address.
        :param pulumi.Input[_builtins.str] secure_network: Identifies the network deployment type. Possible values: `STANDARD_TLS` or `ENHANCED_TLS`.
        :param pulumi.Input[_builtins.str] subject: The CA certificate’s key value details. The `CN` attribute is required and included in the subject. When not specified, the subject is constructed in this format: `/C=US/O=Akamai Technologies, Inc./OU={vcd_id} {contract_id} {group_id}/CN={certificate_name}/`.
        :param pulumi.Input[Mapping[str, pulumi.Input[Union['MtlskeystoreClientCertificateThirdPartyVersionsArgs', 'MtlskeystoreClientCertificateThirdPartyVersionsArgsDict']]]] versions: A map of client certificate versions as a value and user defined identifier as a key. Each version represents a specific iteration of the client certificate.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MtlskeystoreClientCertificateThirdPartyState.__new__(_MtlskeystoreClientCertificateThirdPartyState)

        __props__.__dict__["certificate_id"] = certificate_id
        __props__.__dict__["certificate_name"] = certificate_name
        __props__.__dict__["contract_id"] = contract_id
        __props__.__dict__["geography"] = geography
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["key_algorithm"] = key_algorithm
        __props__.__dict__["notification_emails"] = notification_emails
        __props__.__dict__["secure_network"] = secure_network
        __props__.__dict__["subject"] = subject
        __props__.__dict__["versions"] = versions
        return MtlskeystoreClientCertificateThirdParty(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> pulumi.Output[_builtins.int]:
        """
        The unique identifier of the client certificate.
        """
        return pulumi.get(self, "certificate_id")

    @_builtins.property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the client certificate. Must be between 1 and 64 characters.
        """
        return pulumi.get(self, "certificate_name")

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Output[_builtins.str]:
        """
        The contract assigned to the client certificate. Must have a length of at least 1.
        """
        return pulumi.get(self, "contract_id")

    @_builtins.property
    @pulumi.getter
    def geography(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the type of network to deploy the client certificate. Possible values: `CORE`, `RUSSIA_AND_CORE`, or `CHINA_AND_CORE`.
        """
        return pulumi.get(self, "geography")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[_builtins.int]:
        """
        The group assigned to the client certificate. Must be greater than or equal to 0.
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter(name="keyAlgorithm")
    def key_algorithm(self) -> pulumi.Output[_builtins.str]:
        """
        The cryptographic algorithm used for key generation. Possible values: `RSA` or `ECDSA`. The default is `RSA`.
        """
        return pulumi.get(self, "key_algorithm")

    @_builtins.property
    @pulumi.getter(name="notificationEmails")
    def notification_emails(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The email addresses to notify for client certificate-related issues. Must have at least one email address.
        """
        return pulumi.get(self, "notification_emails")

    @_builtins.property
    @pulumi.getter(name="secureNetwork")
    def secure_network(self) -> pulumi.Output[_builtins.str]:
        """
        Identifies the network deployment type. Possible values: `STANDARD_TLS` or `ENHANCED_TLS`.
        """
        return pulumi.get(self, "secure_network")

    @_builtins.property
    @pulumi.getter
    def subject(self) -> pulumi.Output[_builtins.str]:
        """
        The CA certificate’s key value details. The `CN` attribute is required and included in the subject. When not specified, the subject is constructed in this format: `/C=US/O=Akamai Technologies, Inc./OU={vcd_id} {contract_id} {group_id}/CN={certificate_name}/`.
        """
        return pulumi.get(self, "subject")

    @_builtins.property
    @pulumi.getter
    def versions(self) -> pulumi.Output[Mapping[str, 'outputs.MtlskeystoreClientCertificateThirdPartyVersions']]:
        """
        A map of client certificate versions as a value and user defined identifier as a key. Each version represents a specific iteration of the client certificate.
        """
        return pulumi.get(self, "versions")

