# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from .......core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel, update_forward_refs
from ..common.api_application_route_details import ApiApplicationRouteDetails
from ..common.api_type import ApiType
from ..common.security_requirement import SecurityRequirement
from ..common.security_scheme import SecurityScheme
from .graph_ql_query import GraphQlQuery


class EnumerateGraphqlData(UniversalBaseModel):
    api_type: ApiType = pydantic.Field(alias="apiType")
    base_endpoint_url: str = pydantic.Field(alias="baseEndpointUrl")
    version: typing.Optional[str] = None
    schema_url: typing.Optional[str] = pydantic.Field(alias="schemaUrl", default=None)
    routes: typing.Optional[typing.List[ApiApplicationRouteDetails]] = None
    security_schemes: typing.Optional[typing.Dict[str, SecurityScheme]] = pydantic.Field(
        alias="securitySchemes", default=None
    )
    security: typing.Optional[typing.List[SecurityRequirement]] = None
    queries: typing.Optional[typing.List[GraphQlQuery]] = None
    raw: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


from ..common.request_schema import RequestSchema  # noqa: E402, F401, I001
from ..common.schema_property import SchemaProperty  # noqa: E402, F401, I001

update_forward_refs(EnumerateGraphqlData)
