#!/usr/bin/env python

# Built-in
import os
import argparse

# Common
import numpy as np

_save = True
_here = os.path.abspath(os.path.dirname(__file__))
_Exp, _Cls, _name = os.path.split(__file__)[1].split('_')[:3]
assert not any([any([ss in s for ss in ['Notes','.']])
               for s in [_Exp, _Cls, _name]])


def get_notes():
    notes = {}
    # Samples from metrology
    # C4 - D
    notes['sampXYZ-D'] = [[1.53858885, -0.317150161,  0.495340],
                          [1.55346017, -0.316698552,  0.414281],
                          [1.58584884, -0.316851465,  0.348142],
                          [1.61372436, -0.316772548,  0.286890],
                          [1.63649027, -0.316136243,  0.223451],
                          [1.65305608, -0.316798816,  0.158320],
                          [1.66405349, -0.316906099,  0.091980],
                          [1.66947363, -0.316720751,  0.024930],
                          [1.66869769, -0.316878256, -0.042300],
                          [1.66231606, -0.316079895, -0.109200],
                          [1.64991395, -0.316419198, -0.175280],
                          [1.63218580, -0.316491420, -0.240020],
                          [1.60771501, -0.315952021, -0.304940],
                          [1.57945958, -0.318684815, -0.363551],
                          [1.54829413, -0.317704783, -0.433810]]

    # C4 - G
    notes['sampXYZ-G'] = [[1.53927586, 0.316218900,  0.495340],
                          [1.55416224, 0.317882549,  0.414281],
                          [1.58637810, 0.317035251,  0.348142],
                          [1.61420646, 0.318080523,  0.286890],
                          [1.63678831, 0.316923505,  0.223451],
                          [1.65359660, 0.311701203,  0.158320],
                          [1.66476593, 0.316589819,  0.091980],
                          [1.67003280, 0.315827173,  0.024930],
                          [1.66972635, 0.316856021, -0.042300],
                          [1.66309487, 0.316981217, -0.109200],
                          [1.65082120, 0.317274875, -0.175280],
                          [1.63294007, 0.317606267, -0.240020],
                          [1.60813816, 0.318085317, -0.304940],
                          [1.58034273, 0.317932644, -0.363551],
                          [1.54951659, 0.316900258, -0.433810]]

    notes['sampXYZ-D'] = np.array(notes['sampXYZ-D'])
    notes['sampXYZ-G'] = np.array(notes['sampXYZ-G'])
    return notes

def get_notes2():
    notes = {}
    # Samples from 3D drawings - (assumed identical to LH1)
    notes['sampXYZ'] = [[-1991.385,-494.911, -2191.731],  # Back
                        [-2133.133,-318.000, -2143.935],  # Back
                        [-3205.596,-318.000, -3043.838],  # Back
                        [-3205.596, 318.000, -3043.838],  # Back
                        [-2133.133, 318.000, -2143.935],  # Back
                        [-1991.385, 494.911, -2191.731],  # Back
                        [-1952.407, 504.105, -2020.357],  # First pt
                        [-1917.893, 504.799, -2020.259],
                        [-1919.621, 465.078, -2021.709],
                        [-1953.944, 468.768, -2021.646],  # bottom
                        [-1954.102, 467.342, -2021.779],  # bottom
                        [-1919.804, 463.423, -2021.863],
                        [-1926.790, 424.698, -2027.724],
                        [-1960.317, 432.890, -2026.994],  # bottom
                        [-1960.662, 431.522, -2027.284],  # bottom
                        [-1927.191, 423.110, -2028.061],
                        [-1939.221, 386.556, -2038.156],
                        [-1971.365, 399.002, -2036.265],  # bottom
                        [-1972.262, 397.685, -2035.711],  # bottom
                        [-1939.844, 385.107, -2038.678],
                        [-1951.819, 356.614, -2048.726],
                        [-1984.237, 369.192, -2045.760],  # bottom
                        [-1985.046, 367.162, -2046.439],  # bottom
                        [-1952.225, 355.596, -2049.067],
                        [-1963.236, 326.447, -2058.307],
                        [-1996.058, 338.013, -2055.679],  # bottom
                        [-1996.799, 335.939, -2056.300],  # bottom
                        [-1963.608, 325.407, -2058.618],
                        [-1973.635, 295.659, -2067.032],
                        [-2006.826, 306.191, -2064.714],  # bottom
                        [-2007.497, 304.077, -2065.277],  # bottom
                        [-1973.971, 294.599, -2067.314],
                        [-1982.995, 264.308, -2074.886],
                        [-2016.520, 273.786, -2072.849],  # bottom
                        [-2017.120, 271.635, -2073.352],  # bottom
                        [-1983.296, 263.230, -2075.138],
                        [-1991.298, 232.454, -2081.853],
                        [-2025.123, 240.860, -2080.067],  # bottom
                        [-2025.650, 238.677, -2080.509],  # bottom
                        [-1991.563, 231.360, -2082.075],
                        [-1998.529, 200.158, -2087.921],
                        [-2032.617, 207.476, -2086.355],  # bottom
                        [-2033.070, 205.265, -2086.736],  # bottom
                        [-1998.757, 199.049, -2088.112],
                        [-2004.675, 167.481, -2093.077],
                        [-2038.988, 173.696, -2091.701],  # bottom
                        [-2039.367, 171.461, -2092.020],  # bottom
                        [-2004.865, 166.360, -2093.237],
                        [-2009.722, 134.484, -2097.313],
                        [-2044.224, 139.586, -2096.095],  # bottom
                        [-2044.529, 137.332, -2096.351],  # bottom
                        [-2009.875, 133.354, -2097.441],
                        [-2013.662, 101.232, -2100.619],
                        [-2048.316, 105.210, -2099.529],  # bottom
                        [-2048.545, 102.941, -2099.721],  # bottom
                        [-2013.777, 100.094, -2100.715],
                        [-2016.487,  67.787, -2102.989],
                        [-2051.255,  70.634, -2101.995],  # bottom
                        [-2051.408,  68.354, -2102.123],  # bottom
                        [-2016.564,  66.644, -2103.054],
                        [-2018.192,  34.213, -2104.420],
                        [-2053.037,  35.923, -2103.490],  # bottom
                        [-2053.113,  33.637, -2103.554],  # bottom
                        [-2018.231,  33.066, -2104.452],
                        [-2018.774,   0.574, -2104.908],
                        [-2053.656,   1.144, -2104.009],  # bottom
                        [-2053.656,  -1.144, -2104.009],  # bottom
                        [-2018.774,  -0.574, -2104.908],
                        [-2018.231, -33.066, -2104.452],
                        [-2053.113, -33.637, -2103.554],  # bottom
                        [-2053.037, -35.923, -2103.490],  # bottom
                        [-2018.192, -34.213, -2104.420],
                        [-2016.564, -66.644, -2103.054],
                        [-2051.408, -68.354, -2102.123],  # bottom
                        [-2051.255, -70.634, -2101.995],  # bottom
                        [-2016.487, -67.787, -2102.989],
                        [-2013.777,-100.094, -2100.715],
                        [-2048.545,-102.941, -2099.721],  # bottom
                        [-2048.316,-105.210, -2099.529],  # bottom
                        [-2013.662,-101.232, -2100.619],
                        [-2009.875,-133.354, -2097.441],
                        [-2044.529,-137.332, -2096.351],  # bottom
                        [-2044.224,-139.586, -2096.095],  # bottom
                        [-2009.722,-134.484, -2097.131],
                        [-2004.865,-166.360, -2093.237],
                        [-2039.367,-171.461, -2092.020],  # bottom
                        [-2038.988,-173.696, -2091.701],  # bottom
                        [-2004.675,-167.481, -2093.077],
                        [-1998.757,-199.049, -2088.112],
                        [-2033.070,-205.265, -2086.736],  # bottom
                        [-2032.617,-207.476, -2086.355],  # bottom
                        [-1998.529,-200.158, -2087.921],
                        [-1991.523,-231.360, -2082.075],
                        [-2025.650,-238.677, -2080.509],  # bottom
                        [-2025.123,-240.860, -2080.067],  # bottom
                        [-1991.298,-232.454, -2081.853],
                        [-1983.296,-263.230, -2075.138],
                        [-2017.120,-271.635, -2073.352],  # bottom
                        [-2016.520,-273.786, -2072.849],  # bottom
                        [-1982.995,-264.308, -2074.886],
                        [-1973.971,-294.599, -2067.314],
                        [-2007.497,-304.077, -2065.277],  # bottom
                        [-2006.826,-306.191, -2064.714],  # bottom
                        [-1973.635,-295.659, -2067.032],
                        [-1963.608,-325.407, -2058.618],
                        [-1996.799,-335.939, -2056.300],  # bottom
                        [-1996.058,-338.013, -2055.679],  # bottom
                        [-1963.236,-326.447, -2058.307],
                        [-1952.225,-355.596, -2049.067],
                        [-1985.046,-367.162, -2046.439],  # bottom
                        [-1984.237,-369.192, -2045.760],  # bottom
                        [-1951.819,-356.614, -2048.726],
                        [-1939.844,-385.107, -2038.678],
                        [-1972.262,-397.685, -2035.711],  # bottom
                        [-1971.365,-399.002, -2036.265],  # bottom
                        [-1939.221,-386.556, -2038.156],
                        [-1927.191,-423.110, -2028.061],
                        [-1960.662,-431.522, -2027.284],  # bottom
                        [-1960.317,-432.890, -2026.994],  # bottom
                        [-1926.790,-424.698, -2027.724],
                        [-1919.804,-463.423, -2021.863],
                        [-1954.102,-467.342, -2021.779],  # bottom
                        [-1953.944,-468.768, -2021.646],  # bottom
                        [-1919.621,-465.078, -2021.709],
                        [-1917.893,-504.799, -2020.259],
                        [-1952.407,-504.105, -2020.357]]
    notes['sampXYZ'] = np.array(notes['sampXYZ'])
    nn = notes['sampXYZ'].shape[0]
    ind = np.arange(8,nn-4,4)
    notes['indedges'] = np.array([ind,ind+3])
    ind = np.arange(9,nn-4,4)
    notes['indbottom'] = np.unique(np.array([ind,ind+1]).ravel())
    return notes

def make_Poly(save=_save, path=_here):
    notes = get_notes2()
    Rref, Rmax = 3., 3.4

    #D1, G1 = notes['sampXYZ-D'], notes['sampXYZ-G']
    #R = np.mean(np.vstack((D1[:,0],G1[:,0])),axis=0)
    #Z = np.mean(np.vstack((D1[:,2],G1[:,2])),axis=0)
    R = np.hypot(notes['sampXYZ'][:,0],notes['sampXYZ'][:,2])/1000.
    Z = notes['sampXYZ'][:,1]/1000.
    #R = R-np.max(R)+Rref
    #Poly0 = np.array([np.r_[R, Rmax, Rmax], np.r_[Z,np.min(Z),np.max(Z)]])
    R = R-np.min(R[np.abs(Z)<0.01])+Rref
    R[2:4] = Rmax

    Poly1 = np.array([R,Z])
    ind = notes['indedges']
    Ptemp = 0.5*(Poly1[:,ind[0,:]] + Poly1[:,ind[1,:]])
    Poly0 = np.concatenate((Poly1[:,:ind[0,0]], Ptemp,
                            Poly1[:,ind[1,-1]+1:]),axis=1)
    if save:
        cstr = '%s_%s_%s'%(_Exp,_Cls,_name)
        pathfilext = os.path.join(path, cstr+'_V0.txt')
        np.savetxt(pathfilext, Poly0)
        pathfilext = os.path.join(path, cstr+'_V1.txt')
        np.savetxt(pathfilext, Poly1)
    return Poly0, Poly1, notes


if __name__=='__main__':

    # Parse input arguments
    msg = 'Launch creation of polygons txt from bash'
    parser = argparse.ArgumentParser(description = msg)

    parser.add_argument('-save', type=bool, help='save ?', default=_save)
    parser.add_argument('-path', type=str, help='saving path ?', default=_here)

    args = parser.parse_args()

    # Call wrapper function
    make_Poly(save=args.save, path=args.path)
