from collections.abc import Mapping
from typing import Any, Literal, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

T = TypeVar("T", bound="CitationContentBlockLocationParam")


@_attrs_define
class CitationContentBlockLocationParam:
    """
    Attributes:
        cited_text (str):
        document_index (int):
        document_title (Union[None, str]):
        end_block_index (int):
        start_block_index (int):
        type_ (Literal['content_block_location']):
    """

    cited_text: str
    document_index: int
    document_title: Union[None, str]
    end_block_index: int
    start_block_index: int
    type_: Literal["content_block_location"]
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        cited_text = self.cited_text

        document_index = self.document_index

        document_title: Union[None, str]
        document_title = self.document_title

        end_block_index = self.end_block_index

        start_block_index = self.start_block_index

        type_ = self.type_

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "cited_text": cited_text,
                "document_index": document_index,
                "document_title": document_title,
                "end_block_index": end_block_index,
                "start_block_index": start_block_index,
                "type": type_,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        d = dict(src_dict)
        cited_text = d.pop("cited_text")

        document_index = d.pop("document_index")

        def _parse_document_title(data: object) -> Union[None, str]:
            if data is None:
                return data
            return cast(Union[None, str], data)

        document_title = _parse_document_title(d.pop("document_title"))

        end_block_index = d.pop("end_block_index")

        start_block_index = d.pop("start_block_index")

        type_ = cast(Literal["content_block_location"], d.pop("type"))
        if type_ != "content_block_location":
            raise ValueError(f"type must match const 'content_block_location', got '{type_}'")

        citation_content_block_location_param = cls(
            cited_text=cited_text,
            document_index=document_index,
            document_title=document_title,
            end_block_index=end_block_index,
            start_block_index=start_block_index,
            type_=type_,
        )

        citation_content_block_location_param.additional_properties = d
        return citation_content_block_location_param

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
