from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, Literal, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.cache_control_ephemeral_param import CacheControlEphemeralParam


T = TypeVar("T", bound="ToolUseBlockParam")


@_attrs_define
class ToolUseBlockParam:
    """
    Attributes:
        id (str):
        input_ (Any):
        name (str):
        type_ (Literal['tool_use']):
        cache_control (Union['CacheControlEphemeralParam', None, Unset]):
    """

    id: str
    input_: Any
    name: str
    type_: Literal["tool_use"]
    cache_control: Union["CacheControlEphemeralParam", None, Unset] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        from ..models.cache_control_ephemeral_param import CacheControlEphemeralParam

        id = self.id

        input_ = self.input_

        name = self.name

        type_ = self.type_

        cache_control: Union[None, Unset, dict[str, Any]]
        if isinstance(self.cache_control, Unset):
            cache_control = UNSET
        elif isinstance(self.cache_control, CacheControlEphemeralParam):
            cache_control = self.cache_control.to_dict()
        else:
            cache_control = self.cache_control

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "id": id,
                "input": input_,
                "name": name,
                "type": type_,
            }
        )
        if cache_control is not UNSET:
            field_dict["cache_control"] = cache_control

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.cache_control_ephemeral_param import CacheControlEphemeralParam

        d = dict(src_dict)
        id = d.pop("id")

        input_ = d.pop("input")

        name = d.pop("name")

        type_ = cast(Literal["tool_use"], d.pop("type"))
        if type_ != "tool_use":
            raise ValueError(f"type must match const 'tool_use', got '{type_}'")

        def _parse_cache_control(data: object) -> Union["CacheControlEphemeralParam", None, Unset]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, dict):
                    raise TypeError()
                cache_control_type_0 = CacheControlEphemeralParam.from_dict(data)

                return cache_control_type_0
            except:  # noqa: E722
                pass
            return cast(Union["CacheControlEphemeralParam", None, Unset], data)

        cache_control = _parse_cache_control(d.pop("cache_control", UNSET))

        tool_use_block_param = cls(
            id=id,
            input_=input_,
            name=name,
            type_=type_,
            cache_control=cache_control,
        )

        tool_use_block_param.additional_properties = d
        return tool_use_block_param

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
