import logging
import sys


class SimpleLogger:
    def __init__(self, name="SpeechRecognition"):
        self.logger = logging.getLogger(name)
        self.logger.setLevel(logging.CRITICAL)
        
        if not self.logger.handlers:
            handler = logging.StreamHandler(sys.stdout)
            formatter = logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(message)s')
            handler.setFormatter(formatter)
            self.logger.addHandler(handler)
    
    def info(self, message):
        self.logger.info(message)
    
    def error(self, message):
        self.logger.error(message)
    
    def warning(self, message):
        self.logger.warning(message)
    
    def debug(self, message):
        self.logger.debug(message)

# global logger
logger = SimpleLogger()