# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TimeChartArgs', 'TimeChart']

@pulumi.input_type
class TimeChartArgs:
    def __init__(__self__, *,
                 program_text: pulumi.Input[_builtins.str],
                 axes_include_zero: Optional[pulumi.Input[_builtins.bool]] = None,
                 axes_precision: Optional[pulumi.Input[_builtins.int]] = None,
                 axis_left: Optional[pulumi.Input['TimeChartAxisLeftArgs']] = None,
                 axis_right: Optional[pulumi.Input['TimeChartAxisRightArgs']] = None,
                 color_by: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_sampling: Optional[pulumi.Input[_builtins.bool]] = None,
                 end_time: Optional[pulumi.Input[_builtins.int]] = None,
                 event_options: Optional[pulumi.Input[Sequence[pulumi.Input['TimeChartEventOptionArgs']]]] = None,
                 histogram_options: Optional[pulumi.Input[Sequence[pulumi.Input['TimeChartHistogramOptionArgs']]]] = None,
                 legend_fields_to_hides: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 legend_options_fields: Optional[pulumi.Input[Sequence[pulumi.Input['TimeChartLegendOptionsFieldArgs']]]] = None,
                 max_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 minimum_resolution: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 on_chart_legend_dimension: Optional[pulumi.Input[_builtins.str]] = None,
                 plot_type: Optional[pulumi.Input[_builtins.str]] = None,
                 show_data_markers: Optional[pulumi.Input[_builtins.bool]] = None,
                 show_event_lines: Optional[pulumi.Input[_builtins.bool]] = None,
                 stacked: Optional[pulumi.Input[_builtins.bool]] = None,
                 start_time: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 time_range: Optional[pulumi.Input[_builtins.int]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 viz_options: Optional[pulumi.Input[Sequence[pulumi.Input['TimeChartVizOptionArgs']]]] = None):
        """
        The set of arguments for constructing a TimeChart resource.
        :param pulumi.Input[_builtins.str] program_text: Signalflow program text for the chart. More info [in the Splunk Observability Cloud docs](https://dev.splunk.com/observability/docs/signalflow/).
        :param pulumi.Input[_builtins.bool] axes_include_zero: Force the chart to display zero on the y-axes, even if none of the data is near zero.
        :param pulumi.Input[_builtins.int] axes_precision: Specifies the digits Splunk Observability Cloud displays for values plotted on the chart. Defaults to `3`.
        :param pulumi.Input['TimeChartAxisLeftArgs'] axis_left: Set of axis options.
        :param pulumi.Input['TimeChartAxisRightArgs'] axis_right: Set of axis options.
        :param pulumi.Input[_builtins.str] color_by: Must be `"Dimension"` or `"Metric"`. `"Dimension"` by default.
        :param pulumi.Input[_builtins.str] description: Description of the chart.
        :param pulumi.Input[_builtins.bool] disable_sampling: If `false`, samples a subset of the output MTS, which improves UI performance. `false` by default
        :param pulumi.Input[_builtins.int] end_time: Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        :param pulumi.Input[Sequence[pulumi.Input['TimeChartEventOptionArgs']]] event_options: Event customization options, associated with a publish statement. You will need to use this to change settings for any `events(…)` statements you use.
        :param pulumi.Input[Sequence[pulumi.Input['TimeChartHistogramOptionArgs']]] histogram_options: Only used when `plot_type` is `"Histogram"`. Histogram specific options.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] legend_fields_to_hides: List of properties that should not be displayed in the chart legend (i.e. dimension names). All the properties are visible by default. Deprecated, please use `legend_options_fields`.
        :param pulumi.Input[Sequence[pulumi.Input['TimeChartLegendOptionsFieldArgs']]] legend_options_fields: List of property names and enabled flags that should be displayed in the data table for the chart, in the order provided. This option cannot be used with `legend_fields_to_hide`.
        :param pulumi.Input[_builtins.int] max_delay: How long (in seconds) to wait for late datapoints.
        :param pulumi.Input[_builtins.int] minimum_resolution: The minimum resolution (in seconds) to use for computing the underlying program.
        :param pulumi.Input[_builtins.str] name: Name of the chart.
        :param pulumi.Input[_builtins.str] on_chart_legend_dimension: Dimensions to show in the on-chart legend. On-chart legend is off unless a dimension is specified. Allowed: `"metric"`, `"plot_label"` and any dimension.
        :param pulumi.Input[_builtins.str] plot_type: The default plot display style for the visualization. Must be `"LineChart"`, `"AreaChart"`, `"ColumnChart"`, or `"Histogram"`. Default: `"LineChart"`.
        :param pulumi.Input[_builtins.bool] show_data_markers: Show markers (circles) for each datapoint used to draw line or area charts. `false` by default.
        :param pulumi.Input[_builtins.bool] show_event_lines: Whether vertical highlight lines should be drawn in the visualizations at times when events occurred. `false` by default.
        :param pulumi.Input[_builtins.bool] stacked: Whether area and bar charts in the visualization should be stacked. `false` by default.
        :param pulumi.Input[_builtins.int] start_time: Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags associated with the chart
        :param pulumi.Input[_builtins.int] time_range: How many seconds ago from which to display data. For example, the last hour would be `3600`, etc. Conflicts with `start_time` and `end_time`.
        :param pulumi.Input[_builtins.str] timezone: Time zone that SignalFlow uses as the basis of calendar window transformation methods. For example, if you set "timezone": "Europe/Paris" and then use the transformation sum(cycle="week", cycle_start="Monday") in your chart's SignalFlow program, the calendar window starts on Monday, Paris time. See the [full list of timezones for more](https://dev.splunk.com/observability/docs/signalflow/). `"UTC"` by default.
        :param pulumi.Input[_builtins.str] unit_prefix: Must be `"Metric"` or `"Binary`". `"Metric"` by default.
        :param pulumi.Input[Sequence[pulumi.Input['TimeChartVizOptionArgs']]] viz_options: Plot-level customization options, associated with a publish statement.
        """
        pulumi.set(__self__, "program_text", program_text)
        if axes_include_zero is not None:
            pulumi.set(__self__, "axes_include_zero", axes_include_zero)
        if axes_precision is not None:
            pulumi.set(__self__, "axes_precision", axes_precision)
        if axis_left is not None:
            pulumi.set(__self__, "axis_left", axis_left)
        if axis_right is not None:
            pulumi.set(__self__, "axis_right", axis_right)
        if color_by is not None:
            pulumi.set(__self__, "color_by", color_by)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_sampling is not None:
            pulumi.set(__self__, "disable_sampling", disable_sampling)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if event_options is not None:
            pulumi.set(__self__, "event_options", event_options)
        if histogram_options is not None:
            pulumi.set(__self__, "histogram_options", histogram_options)
        if legend_fields_to_hides is not None:
            warnings.warn("""Please use legend_options_fields""", DeprecationWarning)
            pulumi.log.warn("""legend_fields_to_hides is deprecated: Please use legend_options_fields""")
        if legend_fields_to_hides is not None:
            pulumi.set(__self__, "legend_fields_to_hides", legend_fields_to_hides)
        if legend_options_fields is not None:
            pulumi.set(__self__, "legend_options_fields", legend_options_fields)
        if max_delay is not None:
            pulumi.set(__self__, "max_delay", max_delay)
        if minimum_resolution is not None:
            pulumi.set(__self__, "minimum_resolution", minimum_resolution)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if on_chart_legend_dimension is not None:
            pulumi.set(__self__, "on_chart_legend_dimension", on_chart_legend_dimension)
        if plot_type is not None:
            pulumi.set(__self__, "plot_type", plot_type)
        if show_data_markers is not None:
            pulumi.set(__self__, "show_data_markers", show_data_markers)
        if show_event_lines is not None:
            pulumi.set(__self__, "show_event_lines", show_event_lines)
        if stacked is not None:
            pulumi.set(__self__, "stacked", stacked)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if tags is not None:
            warnings.warn("""signalfx_time_chart.tags is being removed in the next release""", DeprecationWarning)
            pulumi.log.warn("""tags is deprecated: signalfx_time_chart.tags is being removed in the next release""")
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_range is not None:
            pulumi.set(__self__, "time_range", time_range)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if unit_prefix is not None:
            pulumi.set(__self__, "unit_prefix", unit_prefix)
        if viz_options is not None:
            pulumi.set(__self__, "viz_options", viz_options)

    @_builtins.property
    @pulumi.getter(name="programText")
    def program_text(self) -> pulumi.Input[_builtins.str]:
        """
        Signalflow program text for the chart. More info [in the Splunk Observability Cloud docs](https://dev.splunk.com/observability/docs/signalflow/).
        """
        return pulumi.get(self, "program_text")

    @program_text.setter
    def program_text(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "program_text", value)

    @_builtins.property
    @pulumi.getter(name="axesIncludeZero")
    def axes_include_zero(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Force the chart to display zero on the y-axes, even if none of the data is near zero.
        """
        return pulumi.get(self, "axes_include_zero")

    @axes_include_zero.setter
    def axes_include_zero(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "axes_include_zero", value)

    @_builtins.property
    @pulumi.getter(name="axesPrecision")
    def axes_precision(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the digits Splunk Observability Cloud displays for values plotted on the chart. Defaults to `3`.
        """
        return pulumi.get(self, "axes_precision")

    @axes_precision.setter
    def axes_precision(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "axes_precision", value)

    @_builtins.property
    @pulumi.getter(name="axisLeft")
    def axis_left(self) -> Optional[pulumi.Input['TimeChartAxisLeftArgs']]:
        """
        Set of axis options.
        """
        return pulumi.get(self, "axis_left")

    @axis_left.setter
    def axis_left(self, value: Optional[pulumi.Input['TimeChartAxisLeftArgs']]):
        pulumi.set(self, "axis_left", value)

    @_builtins.property
    @pulumi.getter(name="axisRight")
    def axis_right(self) -> Optional[pulumi.Input['TimeChartAxisRightArgs']]:
        """
        Set of axis options.
        """
        return pulumi.get(self, "axis_right")

    @axis_right.setter
    def axis_right(self, value: Optional[pulumi.Input['TimeChartAxisRightArgs']]):
        pulumi.set(self, "axis_right", value)

    @_builtins.property
    @pulumi.getter(name="colorBy")
    def color_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Must be `"Dimension"` or `"Metric"`. `"Dimension"` by default.
        """
        return pulumi.get(self, "color_by")

    @color_by.setter
    def color_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "color_by", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the chart.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disableSampling")
    def disable_sampling(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `false`, samples a subset of the output MTS, which improves UI performance. `false` by default
        """
        return pulumi.get(self, "disable_sampling")

    @disable_sampling.setter
    def disable_sampling(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_sampling", value)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter(name="eventOptions")
    def event_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TimeChartEventOptionArgs']]]]:
        """
        Event customization options, associated with a publish statement. You will need to use this to change settings for any `events(…)` statements you use.
        """
        return pulumi.get(self, "event_options")

    @event_options.setter
    def event_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TimeChartEventOptionArgs']]]]):
        pulumi.set(self, "event_options", value)

    @_builtins.property
    @pulumi.getter(name="histogramOptions")
    def histogram_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TimeChartHistogramOptionArgs']]]]:
        """
        Only used when `plot_type` is `"Histogram"`. Histogram specific options.
        """
        return pulumi.get(self, "histogram_options")

    @histogram_options.setter
    def histogram_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TimeChartHistogramOptionArgs']]]]):
        pulumi.set(self, "histogram_options", value)

    @_builtins.property
    @pulumi.getter(name="legendFieldsToHides")
    @_utilities.deprecated("""Please use legend_options_fields""")
    def legend_fields_to_hides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of properties that should not be displayed in the chart legend (i.e. dimension names). All the properties are visible by default. Deprecated, please use `legend_options_fields`.
        """
        return pulumi.get(self, "legend_fields_to_hides")

    @legend_fields_to_hides.setter
    def legend_fields_to_hides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "legend_fields_to_hides", value)

    @_builtins.property
    @pulumi.getter(name="legendOptionsFields")
    def legend_options_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TimeChartLegendOptionsFieldArgs']]]]:
        """
        List of property names and enabled flags that should be displayed in the data table for the chart, in the order provided. This option cannot be used with `legend_fields_to_hide`.
        """
        return pulumi.get(self, "legend_options_fields")

    @legend_options_fields.setter
    def legend_options_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TimeChartLegendOptionsFieldArgs']]]]):
        pulumi.set(self, "legend_options_fields", value)

    @_builtins.property
    @pulumi.getter(name="maxDelay")
    def max_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How long (in seconds) to wait for late datapoints.
        """
        return pulumi.get(self, "max_delay")

    @max_delay.setter
    def max_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_delay", value)

    @_builtins.property
    @pulumi.getter(name="minimumResolution")
    def minimum_resolution(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum resolution (in seconds) to use for computing the underlying program.
        """
        return pulumi.get(self, "minimum_resolution")

    @minimum_resolution.setter
    def minimum_resolution(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "minimum_resolution", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the chart.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="onChartLegendDimension")
    def on_chart_legend_dimension(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Dimensions to show in the on-chart legend. On-chart legend is off unless a dimension is specified. Allowed: `"metric"`, `"plot_label"` and any dimension.
        """
        return pulumi.get(self, "on_chart_legend_dimension")

    @on_chart_legend_dimension.setter
    def on_chart_legend_dimension(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_chart_legend_dimension", value)

    @_builtins.property
    @pulumi.getter(name="plotType")
    def plot_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default plot display style for the visualization. Must be `"LineChart"`, `"AreaChart"`, `"ColumnChart"`, or `"Histogram"`. Default: `"LineChart"`.
        """
        return pulumi.get(self, "plot_type")

    @plot_type.setter
    def plot_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plot_type", value)

    @_builtins.property
    @pulumi.getter(name="showDataMarkers")
    def show_data_markers(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Show markers (circles) for each datapoint used to draw line or area charts. `false` by default.
        """
        return pulumi.get(self, "show_data_markers")

    @show_data_markers.setter
    def show_data_markers(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "show_data_markers", value)

    @_builtins.property
    @pulumi.getter(name="showEventLines")
    def show_event_lines(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether vertical highlight lines should be drawn in the visualizations at times when events occurred. `false` by default.
        """
        return pulumi.get(self, "show_event_lines")

    @show_event_lines.setter
    def show_event_lines(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "show_event_lines", value)

    @_builtins.property
    @pulumi.getter
    def stacked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether area and bar charts in the visualization should be stacked. `false` by default.
        """
        return pulumi.get(self, "stacked")

    @stacked.setter
    def stacked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "stacked", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "start_time", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""signalfx_time_chart.tags is being removed in the next release""")
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags associated with the chart
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="timeRange")
    def time_range(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How many seconds ago from which to display data. For example, the last hour would be `3600`, etc. Conflicts with `start_time` and `end_time`.
        """
        return pulumi.get(self, "time_range")

    @time_range.setter
    def time_range(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "time_range", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time zone that SignalFlow uses as the basis of calendar window transformation methods. For example, if you set "timezone": "Europe/Paris" and then use the transformation sum(cycle="week", cycle_start="Monday") in your chart's SignalFlow program, the calendar window starts on Monday, Paris time. See the [full list of timezones for more](https://dev.splunk.com/observability/docs/signalflow/). `"UTC"` by default.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter(name="unitPrefix")
    def unit_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Must be `"Metric"` or `"Binary`". `"Metric"` by default.
        """
        return pulumi.get(self, "unit_prefix")

    @unit_prefix.setter
    def unit_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unit_prefix", value)

    @_builtins.property
    @pulumi.getter(name="vizOptions")
    def viz_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TimeChartVizOptionArgs']]]]:
        """
        Plot-level customization options, associated with a publish statement.
        """
        return pulumi.get(self, "viz_options")

    @viz_options.setter
    def viz_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TimeChartVizOptionArgs']]]]):
        pulumi.set(self, "viz_options", value)


@pulumi.input_type
class _TimeChartState:
    def __init__(__self__, *,
                 axes_include_zero: Optional[pulumi.Input[_builtins.bool]] = None,
                 axes_precision: Optional[pulumi.Input[_builtins.int]] = None,
                 axis_left: Optional[pulumi.Input['TimeChartAxisLeftArgs']] = None,
                 axis_right: Optional[pulumi.Input['TimeChartAxisRightArgs']] = None,
                 color_by: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_sampling: Optional[pulumi.Input[_builtins.bool]] = None,
                 end_time: Optional[pulumi.Input[_builtins.int]] = None,
                 event_options: Optional[pulumi.Input[Sequence[pulumi.Input['TimeChartEventOptionArgs']]]] = None,
                 histogram_options: Optional[pulumi.Input[Sequence[pulumi.Input['TimeChartHistogramOptionArgs']]]] = None,
                 legend_fields_to_hides: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 legend_options_fields: Optional[pulumi.Input[Sequence[pulumi.Input['TimeChartLegendOptionsFieldArgs']]]] = None,
                 max_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 minimum_resolution: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 on_chart_legend_dimension: Optional[pulumi.Input[_builtins.str]] = None,
                 plot_type: Optional[pulumi.Input[_builtins.str]] = None,
                 program_text: Optional[pulumi.Input[_builtins.str]] = None,
                 show_data_markers: Optional[pulumi.Input[_builtins.bool]] = None,
                 show_event_lines: Optional[pulumi.Input[_builtins.bool]] = None,
                 stacked: Optional[pulumi.Input[_builtins.bool]] = None,
                 start_time: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 time_range: Optional[pulumi.Input[_builtins.int]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 viz_options: Optional[pulumi.Input[Sequence[pulumi.Input['TimeChartVizOptionArgs']]]] = None):
        """
        Input properties used for looking up and filtering TimeChart resources.
        :param pulumi.Input[_builtins.bool] axes_include_zero: Force the chart to display zero on the y-axes, even if none of the data is near zero.
        :param pulumi.Input[_builtins.int] axes_precision: Specifies the digits Splunk Observability Cloud displays for values plotted on the chart. Defaults to `3`.
        :param pulumi.Input['TimeChartAxisLeftArgs'] axis_left: Set of axis options.
        :param pulumi.Input['TimeChartAxisRightArgs'] axis_right: Set of axis options.
        :param pulumi.Input[_builtins.str] color_by: Must be `"Dimension"` or `"Metric"`. `"Dimension"` by default.
        :param pulumi.Input[_builtins.str] description: Description of the chart.
        :param pulumi.Input[_builtins.bool] disable_sampling: If `false`, samples a subset of the output MTS, which improves UI performance. `false` by default
        :param pulumi.Input[_builtins.int] end_time: Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        :param pulumi.Input[Sequence[pulumi.Input['TimeChartEventOptionArgs']]] event_options: Event customization options, associated with a publish statement. You will need to use this to change settings for any `events(…)` statements you use.
        :param pulumi.Input[Sequence[pulumi.Input['TimeChartHistogramOptionArgs']]] histogram_options: Only used when `plot_type` is `"Histogram"`. Histogram specific options.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] legend_fields_to_hides: List of properties that should not be displayed in the chart legend (i.e. dimension names). All the properties are visible by default. Deprecated, please use `legend_options_fields`.
        :param pulumi.Input[Sequence[pulumi.Input['TimeChartLegendOptionsFieldArgs']]] legend_options_fields: List of property names and enabled flags that should be displayed in the data table for the chart, in the order provided. This option cannot be used with `legend_fields_to_hide`.
        :param pulumi.Input[_builtins.int] max_delay: How long (in seconds) to wait for late datapoints.
        :param pulumi.Input[_builtins.int] minimum_resolution: The minimum resolution (in seconds) to use for computing the underlying program.
        :param pulumi.Input[_builtins.str] name: Name of the chart.
        :param pulumi.Input[_builtins.str] on_chart_legend_dimension: Dimensions to show in the on-chart legend. On-chart legend is off unless a dimension is specified. Allowed: `"metric"`, `"plot_label"` and any dimension.
        :param pulumi.Input[_builtins.str] plot_type: The default plot display style for the visualization. Must be `"LineChart"`, `"AreaChart"`, `"ColumnChart"`, or `"Histogram"`. Default: `"LineChart"`.
        :param pulumi.Input[_builtins.str] program_text: Signalflow program text for the chart. More info [in the Splunk Observability Cloud docs](https://dev.splunk.com/observability/docs/signalflow/).
        :param pulumi.Input[_builtins.bool] show_data_markers: Show markers (circles) for each datapoint used to draw line or area charts. `false` by default.
        :param pulumi.Input[_builtins.bool] show_event_lines: Whether vertical highlight lines should be drawn in the visualizations at times when events occurred. `false` by default.
        :param pulumi.Input[_builtins.bool] stacked: Whether area and bar charts in the visualization should be stacked. `false` by default.
        :param pulumi.Input[_builtins.int] start_time: Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags associated with the chart
        :param pulumi.Input[_builtins.int] time_range: How many seconds ago from which to display data. For example, the last hour would be `3600`, etc. Conflicts with `start_time` and `end_time`.
        :param pulumi.Input[_builtins.str] timezone: Time zone that SignalFlow uses as the basis of calendar window transformation methods. For example, if you set "timezone": "Europe/Paris" and then use the transformation sum(cycle="week", cycle_start="Monday") in your chart's SignalFlow program, the calendar window starts on Monday, Paris time. See the [full list of timezones for more](https://dev.splunk.com/observability/docs/signalflow/). `"UTC"` by default.
        :param pulumi.Input[_builtins.str] unit_prefix: Must be `"Metric"` or `"Binary`". `"Metric"` by default.
        :param pulumi.Input[_builtins.str] url: The URL of the chart.
        :param pulumi.Input[Sequence[pulumi.Input['TimeChartVizOptionArgs']]] viz_options: Plot-level customization options, associated with a publish statement.
        """
        if axes_include_zero is not None:
            pulumi.set(__self__, "axes_include_zero", axes_include_zero)
        if axes_precision is not None:
            pulumi.set(__self__, "axes_precision", axes_precision)
        if axis_left is not None:
            pulumi.set(__self__, "axis_left", axis_left)
        if axis_right is not None:
            pulumi.set(__self__, "axis_right", axis_right)
        if color_by is not None:
            pulumi.set(__self__, "color_by", color_by)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_sampling is not None:
            pulumi.set(__self__, "disable_sampling", disable_sampling)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if event_options is not None:
            pulumi.set(__self__, "event_options", event_options)
        if histogram_options is not None:
            pulumi.set(__self__, "histogram_options", histogram_options)
        if legend_fields_to_hides is not None:
            warnings.warn("""Please use legend_options_fields""", DeprecationWarning)
            pulumi.log.warn("""legend_fields_to_hides is deprecated: Please use legend_options_fields""")
        if legend_fields_to_hides is not None:
            pulumi.set(__self__, "legend_fields_to_hides", legend_fields_to_hides)
        if legend_options_fields is not None:
            pulumi.set(__self__, "legend_options_fields", legend_options_fields)
        if max_delay is not None:
            pulumi.set(__self__, "max_delay", max_delay)
        if minimum_resolution is not None:
            pulumi.set(__self__, "minimum_resolution", minimum_resolution)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if on_chart_legend_dimension is not None:
            pulumi.set(__self__, "on_chart_legend_dimension", on_chart_legend_dimension)
        if plot_type is not None:
            pulumi.set(__self__, "plot_type", plot_type)
        if program_text is not None:
            pulumi.set(__self__, "program_text", program_text)
        if show_data_markers is not None:
            pulumi.set(__self__, "show_data_markers", show_data_markers)
        if show_event_lines is not None:
            pulumi.set(__self__, "show_event_lines", show_event_lines)
        if stacked is not None:
            pulumi.set(__self__, "stacked", stacked)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if tags is not None:
            warnings.warn("""signalfx_time_chart.tags is being removed in the next release""", DeprecationWarning)
            pulumi.log.warn("""tags is deprecated: signalfx_time_chart.tags is being removed in the next release""")
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_range is not None:
            pulumi.set(__self__, "time_range", time_range)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if unit_prefix is not None:
            pulumi.set(__self__, "unit_prefix", unit_prefix)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if viz_options is not None:
            pulumi.set(__self__, "viz_options", viz_options)

    @_builtins.property
    @pulumi.getter(name="axesIncludeZero")
    def axes_include_zero(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Force the chart to display zero on the y-axes, even if none of the data is near zero.
        """
        return pulumi.get(self, "axes_include_zero")

    @axes_include_zero.setter
    def axes_include_zero(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "axes_include_zero", value)

    @_builtins.property
    @pulumi.getter(name="axesPrecision")
    def axes_precision(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the digits Splunk Observability Cloud displays for values plotted on the chart. Defaults to `3`.
        """
        return pulumi.get(self, "axes_precision")

    @axes_precision.setter
    def axes_precision(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "axes_precision", value)

    @_builtins.property
    @pulumi.getter(name="axisLeft")
    def axis_left(self) -> Optional[pulumi.Input['TimeChartAxisLeftArgs']]:
        """
        Set of axis options.
        """
        return pulumi.get(self, "axis_left")

    @axis_left.setter
    def axis_left(self, value: Optional[pulumi.Input['TimeChartAxisLeftArgs']]):
        pulumi.set(self, "axis_left", value)

    @_builtins.property
    @pulumi.getter(name="axisRight")
    def axis_right(self) -> Optional[pulumi.Input['TimeChartAxisRightArgs']]:
        """
        Set of axis options.
        """
        return pulumi.get(self, "axis_right")

    @axis_right.setter
    def axis_right(self, value: Optional[pulumi.Input['TimeChartAxisRightArgs']]):
        pulumi.set(self, "axis_right", value)

    @_builtins.property
    @pulumi.getter(name="colorBy")
    def color_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Must be `"Dimension"` or `"Metric"`. `"Dimension"` by default.
        """
        return pulumi.get(self, "color_by")

    @color_by.setter
    def color_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "color_by", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the chart.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disableSampling")
    def disable_sampling(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `false`, samples a subset of the output MTS, which improves UI performance. `false` by default
        """
        return pulumi.get(self, "disable_sampling")

    @disable_sampling.setter
    def disable_sampling(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_sampling", value)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter(name="eventOptions")
    def event_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TimeChartEventOptionArgs']]]]:
        """
        Event customization options, associated with a publish statement. You will need to use this to change settings for any `events(…)` statements you use.
        """
        return pulumi.get(self, "event_options")

    @event_options.setter
    def event_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TimeChartEventOptionArgs']]]]):
        pulumi.set(self, "event_options", value)

    @_builtins.property
    @pulumi.getter(name="histogramOptions")
    def histogram_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TimeChartHistogramOptionArgs']]]]:
        """
        Only used when `plot_type` is `"Histogram"`. Histogram specific options.
        """
        return pulumi.get(self, "histogram_options")

    @histogram_options.setter
    def histogram_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TimeChartHistogramOptionArgs']]]]):
        pulumi.set(self, "histogram_options", value)

    @_builtins.property
    @pulumi.getter(name="legendFieldsToHides")
    @_utilities.deprecated("""Please use legend_options_fields""")
    def legend_fields_to_hides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of properties that should not be displayed in the chart legend (i.e. dimension names). All the properties are visible by default. Deprecated, please use `legend_options_fields`.
        """
        return pulumi.get(self, "legend_fields_to_hides")

    @legend_fields_to_hides.setter
    def legend_fields_to_hides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "legend_fields_to_hides", value)

    @_builtins.property
    @pulumi.getter(name="legendOptionsFields")
    def legend_options_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TimeChartLegendOptionsFieldArgs']]]]:
        """
        List of property names and enabled flags that should be displayed in the data table for the chart, in the order provided. This option cannot be used with `legend_fields_to_hide`.
        """
        return pulumi.get(self, "legend_options_fields")

    @legend_options_fields.setter
    def legend_options_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TimeChartLegendOptionsFieldArgs']]]]):
        pulumi.set(self, "legend_options_fields", value)

    @_builtins.property
    @pulumi.getter(name="maxDelay")
    def max_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How long (in seconds) to wait for late datapoints.
        """
        return pulumi.get(self, "max_delay")

    @max_delay.setter
    def max_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_delay", value)

    @_builtins.property
    @pulumi.getter(name="minimumResolution")
    def minimum_resolution(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum resolution (in seconds) to use for computing the underlying program.
        """
        return pulumi.get(self, "minimum_resolution")

    @minimum_resolution.setter
    def minimum_resolution(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "minimum_resolution", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the chart.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="onChartLegendDimension")
    def on_chart_legend_dimension(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Dimensions to show in the on-chart legend. On-chart legend is off unless a dimension is specified. Allowed: `"metric"`, `"plot_label"` and any dimension.
        """
        return pulumi.get(self, "on_chart_legend_dimension")

    @on_chart_legend_dimension.setter
    def on_chart_legend_dimension(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_chart_legend_dimension", value)

    @_builtins.property
    @pulumi.getter(name="plotType")
    def plot_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default plot display style for the visualization. Must be `"LineChart"`, `"AreaChart"`, `"ColumnChart"`, or `"Histogram"`. Default: `"LineChart"`.
        """
        return pulumi.get(self, "plot_type")

    @plot_type.setter
    def plot_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plot_type", value)

    @_builtins.property
    @pulumi.getter(name="programText")
    def program_text(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Signalflow program text for the chart. More info [in the Splunk Observability Cloud docs](https://dev.splunk.com/observability/docs/signalflow/).
        """
        return pulumi.get(self, "program_text")

    @program_text.setter
    def program_text(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "program_text", value)

    @_builtins.property
    @pulumi.getter(name="showDataMarkers")
    def show_data_markers(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Show markers (circles) for each datapoint used to draw line or area charts. `false` by default.
        """
        return pulumi.get(self, "show_data_markers")

    @show_data_markers.setter
    def show_data_markers(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "show_data_markers", value)

    @_builtins.property
    @pulumi.getter(name="showEventLines")
    def show_event_lines(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether vertical highlight lines should be drawn in the visualizations at times when events occurred. `false` by default.
        """
        return pulumi.get(self, "show_event_lines")

    @show_event_lines.setter
    def show_event_lines(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "show_event_lines", value)

    @_builtins.property
    @pulumi.getter
    def stacked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether area and bar charts in the visualization should be stacked. `false` by default.
        """
        return pulumi.get(self, "stacked")

    @stacked.setter
    def stacked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "stacked", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "start_time", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""signalfx_time_chart.tags is being removed in the next release""")
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags associated with the chart
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="timeRange")
    def time_range(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How many seconds ago from which to display data. For example, the last hour would be `3600`, etc. Conflicts with `start_time` and `end_time`.
        """
        return pulumi.get(self, "time_range")

    @time_range.setter
    def time_range(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "time_range", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time zone that SignalFlow uses as the basis of calendar window transformation methods. For example, if you set "timezone": "Europe/Paris" and then use the transformation sum(cycle="week", cycle_start="Monday") in your chart's SignalFlow program, the calendar window starts on Monday, Paris time. See the [full list of timezones for more](https://dev.splunk.com/observability/docs/signalflow/). `"UTC"` by default.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter(name="unitPrefix")
    def unit_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Must be `"Metric"` or `"Binary`". `"Metric"` by default.
        """
        return pulumi.get(self, "unit_prefix")

    @unit_prefix.setter
    def unit_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unit_prefix", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the chart.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="vizOptions")
    def viz_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TimeChartVizOptionArgs']]]]:
        """
        Plot-level customization options, associated with a publish statement.
        """
        return pulumi.get(self, "viz_options")

    @viz_options.setter
    def viz_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TimeChartVizOptionArgs']]]]):
        pulumi.set(self, "viz_options", value)


@pulumi.type_token("signalfx:index/timeChart:TimeChart")
class TimeChart(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 axes_include_zero: Optional[pulumi.Input[_builtins.bool]] = None,
                 axes_precision: Optional[pulumi.Input[_builtins.int]] = None,
                 axis_left: Optional[pulumi.Input[Union['TimeChartAxisLeftArgs', 'TimeChartAxisLeftArgsDict']]] = None,
                 axis_right: Optional[pulumi.Input[Union['TimeChartAxisRightArgs', 'TimeChartAxisRightArgsDict']]] = None,
                 color_by: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_sampling: Optional[pulumi.Input[_builtins.bool]] = None,
                 end_time: Optional[pulumi.Input[_builtins.int]] = None,
                 event_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TimeChartEventOptionArgs', 'TimeChartEventOptionArgsDict']]]]] = None,
                 histogram_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TimeChartHistogramOptionArgs', 'TimeChartHistogramOptionArgsDict']]]]] = None,
                 legend_fields_to_hides: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 legend_options_fields: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TimeChartLegendOptionsFieldArgs', 'TimeChartLegendOptionsFieldArgsDict']]]]] = None,
                 max_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 minimum_resolution: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 on_chart_legend_dimension: Optional[pulumi.Input[_builtins.str]] = None,
                 plot_type: Optional[pulumi.Input[_builtins.str]] = None,
                 program_text: Optional[pulumi.Input[_builtins.str]] = None,
                 show_data_markers: Optional[pulumi.Input[_builtins.bool]] = None,
                 show_event_lines: Optional[pulumi.Input[_builtins.bool]] = None,
                 stacked: Optional[pulumi.Input[_builtins.bool]] = None,
                 start_time: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 time_range: Optional[pulumi.Input[_builtins.int]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 viz_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TimeChartVizOptionArgs', 'TimeChartVizOptionArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides a Splunk Observability Cloud time chart resource. This can be used to create and manage the different types of time charts.

        Time charts display data points over a period of time.

        ## Example

        ```python
        import pulumi
        import pulumi_signalfx as signalfx

        mychart0 = signalfx.TimeChart("mychart0",
            name="CPU Total Idle",
            program_text="data(\\"cpu.total.idle\\").publish(label=\\"CPU Idle\\")\\n",
            time_range=3600,
            plot_type="LineChart",
            show_data_markers=True,
            legend_options_fields=[
                {
                    "property": "collector",
                    "enabled": False,
                },
                {
                    "property": "hostname",
                    "enabled": False,
                },
            ],
            viz_options=[{
                "label": "CPU Idle",
                "axis": "left",
                "color": "orange",
            }],
            axis_left={
                "label": "CPU Total Idle",
                "low_watermark": 1000,
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] axes_include_zero: Force the chart to display zero on the y-axes, even if none of the data is near zero.
        :param pulumi.Input[_builtins.int] axes_precision: Specifies the digits Splunk Observability Cloud displays for values plotted on the chart. Defaults to `3`.
        :param pulumi.Input[Union['TimeChartAxisLeftArgs', 'TimeChartAxisLeftArgsDict']] axis_left: Set of axis options.
        :param pulumi.Input[Union['TimeChartAxisRightArgs', 'TimeChartAxisRightArgsDict']] axis_right: Set of axis options.
        :param pulumi.Input[_builtins.str] color_by: Must be `"Dimension"` or `"Metric"`. `"Dimension"` by default.
        :param pulumi.Input[_builtins.str] description: Description of the chart.
        :param pulumi.Input[_builtins.bool] disable_sampling: If `false`, samples a subset of the output MTS, which improves UI performance. `false` by default
        :param pulumi.Input[_builtins.int] end_time: Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TimeChartEventOptionArgs', 'TimeChartEventOptionArgsDict']]]] event_options: Event customization options, associated with a publish statement. You will need to use this to change settings for any `events(…)` statements you use.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TimeChartHistogramOptionArgs', 'TimeChartHistogramOptionArgsDict']]]] histogram_options: Only used when `plot_type` is `"Histogram"`. Histogram specific options.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] legend_fields_to_hides: List of properties that should not be displayed in the chart legend (i.e. dimension names). All the properties are visible by default. Deprecated, please use `legend_options_fields`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TimeChartLegendOptionsFieldArgs', 'TimeChartLegendOptionsFieldArgsDict']]]] legend_options_fields: List of property names and enabled flags that should be displayed in the data table for the chart, in the order provided. This option cannot be used with `legend_fields_to_hide`.
        :param pulumi.Input[_builtins.int] max_delay: How long (in seconds) to wait for late datapoints.
        :param pulumi.Input[_builtins.int] minimum_resolution: The minimum resolution (in seconds) to use for computing the underlying program.
        :param pulumi.Input[_builtins.str] name: Name of the chart.
        :param pulumi.Input[_builtins.str] on_chart_legend_dimension: Dimensions to show in the on-chart legend. On-chart legend is off unless a dimension is specified. Allowed: `"metric"`, `"plot_label"` and any dimension.
        :param pulumi.Input[_builtins.str] plot_type: The default plot display style for the visualization. Must be `"LineChart"`, `"AreaChart"`, `"ColumnChart"`, or `"Histogram"`. Default: `"LineChart"`.
        :param pulumi.Input[_builtins.str] program_text: Signalflow program text for the chart. More info [in the Splunk Observability Cloud docs](https://dev.splunk.com/observability/docs/signalflow/).
        :param pulumi.Input[_builtins.bool] show_data_markers: Show markers (circles) for each datapoint used to draw line or area charts. `false` by default.
        :param pulumi.Input[_builtins.bool] show_event_lines: Whether vertical highlight lines should be drawn in the visualizations at times when events occurred. `false` by default.
        :param pulumi.Input[_builtins.bool] stacked: Whether area and bar charts in the visualization should be stacked. `false` by default.
        :param pulumi.Input[_builtins.int] start_time: Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags associated with the chart
        :param pulumi.Input[_builtins.int] time_range: How many seconds ago from which to display data. For example, the last hour would be `3600`, etc. Conflicts with `start_time` and `end_time`.
        :param pulumi.Input[_builtins.str] timezone: Time zone that SignalFlow uses as the basis of calendar window transformation methods. For example, if you set "timezone": "Europe/Paris" and then use the transformation sum(cycle="week", cycle_start="Monday") in your chart's SignalFlow program, the calendar window starts on Monday, Paris time. See the [full list of timezones for more](https://dev.splunk.com/observability/docs/signalflow/). `"UTC"` by default.
        :param pulumi.Input[_builtins.str] unit_prefix: Must be `"Metric"` or `"Binary`". `"Metric"` by default.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TimeChartVizOptionArgs', 'TimeChartVizOptionArgsDict']]]] viz_options: Plot-level customization options, associated with a publish statement.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TimeChartArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Splunk Observability Cloud time chart resource. This can be used to create and manage the different types of time charts.

        Time charts display data points over a period of time.

        ## Example

        ```python
        import pulumi
        import pulumi_signalfx as signalfx

        mychart0 = signalfx.TimeChart("mychart0",
            name="CPU Total Idle",
            program_text="data(\\"cpu.total.idle\\").publish(label=\\"CPU Idle\\")\\n",
            time_range=3600,
            plot_type="LineChart",
            show_data_markers=True,
            legend_options_fields=[
                {
                    "property": "collector",
                    "enabled": False,
                },
                {
                    "property": "hostname",
                    "enabled": False,
                },
            ],
            viz_options=[{
                "label": "CPU Idle",
                "axis": "left",
                "color": "orange",
            }],
            axis_left={
                "label": "CPU Total Idle",
                "low_watermark": 1000,
            })
        ```

        :param str resource_name: The name of the resource.
        :param TimeChartArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TimeChartArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 axes_include_zero: Optional[pulumi.Input[_builtins.bool]] = None,
                 axes_precision: Optional[pulumi.Input[_builtins.int]] = None,
                 axis_left: Optional[pulumi.Input[Union['TimeChartAxisLeftArgs', 'TimeChartAxisLeftArgsDict']]] = None,
                 axis_right: Optional[pulumi.Input[Union['TimeChartAxisRightArgs', 'TimeChartAxisRightArgsDict']]] = None,
                 color_by: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_sampling: Optional[pulumi.Input[_builtins.bool]] = None,
                 end_time: Optional[pulumi.Input[_builtins.int]] = None,
                 event_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TimeChartEventOptionArgs', 'TimeChartEventOptionArgsDict']]]]] = None,
                 histogram_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TimeChartHistogramOptionArgs', 'TimeChartHistogramOptionArgsDict']]]]] = None,
                 legend_fields_to_hides: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 legend_options_fields: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TimeChartLegendOptionsFieldArgs', 'TimeChartLegendOptionsFieldArgsDict']]]]] = None,
                 max_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 minimum_resolution: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 on_chart_legend_dimension: Optional[pulumi.Input[_builtins.str]] = None,
                 plot_type: Optional[pulumi.Input[_builtins.str]] = None,
                 program_text: Optional[pulumi.Input[_builtins.str]] = None,
                 show_data_markers: Optional[pulumi.Input[_builtins.bool]] = None,
                 show_event_lines: Optional[pulumi.Input[_builtins.bool]] = None,
                 stacked: Optional[pulumi.Input[_builtins.bool]] = None,
                 start_time: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 time_range: Optional[pulumi.Input[_builtins.int]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 viz_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TimeChartVizOptionArgs', 'TimeChartVizOptionArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TimeChartArgs.__new__(TimeChartArgs)

            __props__.__dict__["axes_include_zero"] = axes_include_zero
            __props__.__dict__["axes_precision"] = axes_precision
            __props__.__dict__["axis_left"] = axis_left
            __props__.__dict__["axis_right"] = axis_right
            __props__.__dict__["color_by"] = color_by
            __props__.__dict__["description"] = description
            __props__.__dict__["disable_sampling"] = disable_sampling
            __props__.__dict__["end_time"] = end_time
            __props__.__dict__["event_options"] = event_options
            __props__.__dict__["histogram_options"] = histogram_options
            __props__.__dict__["legend_fields_to_hides"] = legend_fields_to_hides
            __props__.__dict__["legend_options_fields"] = legend_options_fields
            __props__.__dict__["max_delay"] = max_delay
            __props__.__dict__["minimum_resolution"] = minimum_resolution
            __props__.__dict__["name"] = name
            __props__.__dict__["on_chart_legend_dimension"] = on_chart_legend_dimension
            __props__.__dict__["plot_type"] = plot_type
            if program_text is None and not opts.urn:
                raise TypeError("Missing required property 'program_text'")
            __props__.__dict__["program_text"] = program_text
            __props__.__dict__["show_data_markers"] = show_data_markers
            __props__.__dict__["show_event_lines"] = show_event_lines
            __props__.__dict__["stacked"] = stacked
            __props__.__dict__["start_time"] = start_time
            __props__.__dict__["tags"] = tags
            __props__.__dict__["time_range"] = time_range
            __props__.__dict__["timezone"] = timezone
            __props__.__dict__["unit_prefix"] = unit_prefix
            __props__.__dict__["viz_options"] = viz_options
            __props__.__dict__["url"] = None
        super(TimeChart, __self__).__init__(
            'signalfx:index/timeChart:TimeChart',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            axes_include_zero: Optional[pulumi.Input[_builtins.bool]] = None,
            axes_precision: Optional[pulumi.Input[_builtins.int]] = None,
            axis_left: Optional[pulumi.Input[Union['TimeChartAxisLeftArgs', 'TimeChartAxisLeftArgsDict']]] = None,
            axis_right: Optional[pulumi.Input[Union['TimeChartAxisRightArgs', 'TimeChartAxisRightArgsDict']]] = None,
            color_by: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disable_sampling: Optional[pulumi.Input[_builtins.bool]] = None,
            end_time: Optional[pulumi.Input[_builtins.int]] = None,
            event_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TimeChartEventOptionArgs', 'TimeChartEventOptionArgsDict']]]]] = None,
            histogram_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TimeChartHistogramOptionArgs', 'TimeChartHistogramOptionArgsDict']]]]] = None,
            legend_fields_to_hides: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            legend_options_fields: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TimeChartLegendOptionsFieldArgs', 'TimeChartLegendOptionsFieldArgsDict']]]]] = None,
            max_delay: Optional[pulumi.Input[_builtins.int]] = None,
            minimum_resolution: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            on_chart_legend_dimension: Optional[pulumi.Input[_builtins.str]] = None,
            plot_type: Optional[pulumi.Input[_builtins.str]] = None,
            program_text: Optional[pulumi.Input[_builtins.str]] = None,
            show_data_markers: Optional[pulumi.Input[_builtins.bool]] = None,
            show_event_lines: Optional[pulumi.Input[_builtins.bool]] = None,
            stacked: Optional[pulumi.Input[_builtins.bool]] = None,
            start_time: Optional[pulumi.Input[_builtins.int]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            time_range: Optional[pulumi.Input[_builtins.int]] = None,
            timezone: Optional[pulumi.Input[_builtins.str]] = None,
            unit_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None,
            viz_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TimeChartVizOptionArgs', 'TimeChartVizOptionArgsDict']]]]] = None) -> 'TimeChart':
        """
        Get an existing TimeChart resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] axes_include_zero: Force the chart to display zero on the y-axes, even if none of the data is near zero.
        :param pulumi.Input[_builtins.int] axes_precision: Specifies the digits Splunk Observability Cloud displays for values plotted on the chart. Defaults to `3`.
        :param pulumi.Input[Union['TimeChartAxisLeftArgs', 'TimeChartAxisLeftArgsDict']] axis_left: Set of axis options.
        :param pulumi.Input[Union['TimeChartAxisRightArgs', 'TimeChartAxisRightArgsDict']] axis_right: Set of axis options.
        :param pulumi.Input[_builtins.str] color_by: Must be `"Dimension"` or `"Metric"`. `"Dimension"` by default.
        :param pulumi.Input[_builtins.str] description: Description of the chart.
        :param pulumi.Input[_builtins.bool] disable_sampling: If `false`, samples a subset of the output MTS, which improves UI performance. `false` by default
        :param pulumi.Input[_builtins.int] end_time: Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TimeChartEventOptionArgs', 'TimeChartEventOptionArgsDict']]]] event_options: Event customization options, associated with a publish statement. You will need to use this to change settings for any `events(…)` statements you use.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TimeChartHistogramOptionArgs', 'TimeChartHistogramOptionArgsDict']]]] histogram_options: Only used when `plot_type` is `"Histogram"`. Histogram specific options.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] legend_fields_to_hides: List of properties that should not be displayed in the chart legend (i.e. dimension names). All the properties are visible by default. Deprecated, please use `legend_options_fields`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TimeChartLegendOptionsFieldArgs', 'TimeChartLegendOptionsFieldArgsDict']]]] legend_options_fields: List of property names and enabled flags that should be displayed in the data table for the chart, in the order provided. This option cannot be used with `legend_fields_to_hide`.
        :param pulumi.Input[_builtins.int] max_delay: How long (in seconds) to wait for late datapoints.
        :param pulumi.Input[_builtins.int] minimum_resolution: The minimum resolution (in seconds) to use for computing the underlying program.
        :param pulumi.Input[_builtins.str] name: Name of the chart.
        :param pulumi.Input[_builtins.str] on_chart_legend_dimension: Dimensions to show in the on-chart legend. On-chart legend is off unless a dimension is specified. Allowed: `"metric"`, `"plot_label"` and any dimension.
        :param pulumi.Input[_builtins.str] plot_type: The default plot display style for the visualization. Must be `"LineChart"`, `"AreaChart"`, `"ColumnChart"`, or `"Histogram"`. Default: `"LineChart"`.
        :param pulumi.Input[_builtins.str] program_text: Signalflow program text for the chart. More info [in the Splunk Observability Cloud docs](https://dev.splunk.com/observability/docs/signalflow/).
        :param pulumi.Input[_builtins.bool] show_data_markers: Show markers (circles) for each datapoint used to draw line or area charts. `false` by default.
        :param pulumi.Input[_builtins.bool] show_event_lines: Whether vertical highlight lines should be drawn in the visualizations at times when events occurred. `false` by default.
        :param pulumi.Input[_builtins.bool] stacked: Whether area and bar charts in the visualization should be stacked. `false` by default.
        :param pulumi.Input[_builtins.int] start_time: Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags associated with the chart
        :param pulumi.Input[_builtins.int] time_range: How many seconds ago from which to display data. For example, the last hour would be `3600`, etc. Conflicts with `start_time` and `end_time`.
        :param pulumi.Input[_builtins.str] timezone: Time zone that SignalFlow uses as the basis of calendar window transformation methods. For example, if you set "timezone": "Europe/Paris" and then use the transformation sum(cycle="week", cycle_start="Monday") in your chart's SignalFlow program, the calendar window starts on Monday, Paris time. See the [full list of timezones for more](https://dev.splunk.com/observability/docs/signalflow/). `"UTC"` by default.
        :param pulumi.Input[_builtins.str] unit_prefix: Must be `"Metric"` or `"Binary`". `"Metric"` by default.
        :param pulumi.Input[_builtins.str] url: The URL of the chart.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TimeChartVizOptionArgs', 'TimeChartVizOptionArgsDict']]]] viz_options: Plot-level customization options, associated with a publish statement.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TimeChartState.__new__(_TimeChartState)

        __props__.__dict__["axes_include_zero"] = axes_include_zero
        __props__.__dict__["axes_precision"] = axes_precision
        __props__.__dict__["axis_left"] = axis_left
        __props__.__dict__["axis_right"] = axis_right
        __props__.__dict__["color_by"] = color_by
        __props__.__dict__["description"] = description
        __props__.__dict__["disable_sampling"] = disable_sampling
        __props__.__dict__["end_time"] = end_time
        __props__.__dict__["event_options"] = event_options
        __props__.__dict__["histogram_options"] = histogram_options
        __props__.__dict__["legend_fields_to_hides"] = legend_fields_to_hides
        __props__.__dict__["legend_options_fields"] = legend_options_fields
        __props__.__dict__["max_delay"] = max_delay
        __props__.__dict__["minimum_resolution"] = minimum_resolution
        __props__.__dict__["name"] = name
        __props__.__dict__["on_chart_legend_dimension"] = on_chart_legend_dimension
        __props__.__dict__["plot_type"] = plot_type
        __props__.__dict__["program_text"] = program_text
        __props__.__dict__["show_data_markers"] = show_data_markers
        __props__.__dict__["show_event_lines"] = show_event_lines
        __props__.__dict__["stacked"] = stacked
        __props__.__dict__["start_time"] = start_time
        __props__.__dict__["tags"] = tags
        __props__.__dict__["time_range"] = time_range
        __props__.__dict__["timezone"] = timezone
        __props__.__dict__["unit_prefix"] = unit_prefix
        __props__.__dict__["url"] = url
        __props__.__dict__["viz_options"] = viz_options
        return TimeChart(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="axesIncludeZero")
    def axes_include_zero(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Force the chart to display zero on the y-axes, even if none of the data is near zero.
        """
        return pulumi.get(self, "axes_include_zero")

    @_builtins.property
    @pulumi.getter(name="axesPrecision")
    def axes_precision(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the digits Splunk Observability Cloud displays for values plotted on the chart. Defaults to `3`.
        """
        return pulumi.get(self, "axes_precision")

    @_builtins.property
    @pulumi.getter(name="axisLeft")
    def axis_left(self) -> pulumi.Output[Optional['outputs.TimeChartAxisLeft']]:
        """
        Set of axis options.
        """
        return pulumi.get(self, "axis_left")

    @_builtins.property
    @pulumi.getter(name="axisRight")
    def axis_right(self) -> pulumi.Output[Optional['outputs.TimeChartAxisRight']]:
        """
        Set of axis options.
        """
        return pulumi.get(self, "axis_right")

    @_builtins.property
    @pulumi.getter(name="colorBy")
    def color_by(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Must be `"Dimension"` or `"Metric"`. `"Dimension"` by default.
        """
        return pulumi.get(self, "color_by")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the chart.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="disableSampling")
    def disable_sampling(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If `false`, samples a subset of the output MTS, which improves UI performance. `false` by default
        """
        return pulumi.get(self, "disable_sampling")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="eventOptions")
    def event_options(self) -> pulumi.Output[Optional[Sequence['outputs.TimeChartEventOption']]]:
        """
        Event customization options, associated with a publish statement. You will need to use this to change settings for any `events(…)` statements you use.
        """
        return pulumi.get(self, "event_options")

    @_builtins.property
    @pulumi.getter(name="histogramOptions")
    def histogram_options(self) -> pulumi.Output[Optional[Sequence['outputs.TimeChartHistogramOption']]]:
        """
        Only used when `plot_type` is `"Histogram"`. Histogram specific options.
        """
        return pulumi.get(self, "histogram_options")

    @_builtins.property
    @pulumi.getter(name="legendFieldsToHides")
    @_utilities.deprecated("""Please use legend_options_fields""")
    def legend_fields_to_hides(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of properties that should not be displayed in the chart legend (i.e. dimension names). All the properties are visible by default. Deprecated, please use `legend_options_fields`.
        """
        return pulumi.get(self, "legend_fields_to_hides")

    @_builtins.property
    @pulumi.getter(name="legendOptionsFields")
    def legend_options_fields(self) -> pulumi.Output[Optional[Sequence['outputs.TimeChartLegendOptionsField']]]:
        """
        List of property names and enabled flags that should be displayed in the data table for the chart, in the order provided. This option cannot be used with `legend_fields_to_hide`.
        """
        return pulumi.get(self, "legend_options_fields")

    @_builtins.property
    @pulumi.getter(name="maxDelay")
    def max_delay(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        How long (in seconds) to wait for late datapoints.
        """
        return pulumi.get(self, "max_delay")

    @_builtins.property
    @pulumi.getter(name="minimumResolution")
    def minimum_resolution(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The minimum resolution (in seconds) to use for computing the underlying program.
        """
        return pulumi.get(self, "minimum_resolution")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the chart.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="onChartLegendDimension")
    def on_chart_legend_dimension(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Dimensions to show in the on-chart legend. On-chart legend is off unless a dimension is specified. Allowed: `"metric"`, `"plot_label"` and any dimension.
        """
        return pulumi.get(self, "on_chart_legend_dimension")

    @_builtins.property
    @pulumi.getter(name="plotType")
    def plot_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The default plot display style for the visualization. Must be `"LineChart"`, `"AreaChart"`, `"ColumnChart"`, or `"Histogram"`. Default: `"LineChart"`.
        """
        return pulumi.get(self, "plot_type")

    @_builtins.property
    @pulumi.getter(name="programText")
    def program_text(self) -> pulumi.Output[_builtins.str]:
        """
        Signalflow program text for the chart. More info [in the Splunk Observability Cloud docs](https://dev.splunk.com/observability/docs/signalflow/).
        """
        return pulumi.get(self, "program_text")

    @_builtins.property
    @pulumi.getter(name="showDataMarkers")
    def show_data_markers(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Show markers (circles) for each datapoint used to draw line or area charts. `false` by default.
        """
        return pulumi.get(self, "show_data_markers")

    @_builtins.property
    @pulumi.getter(name="showEventLines")
    def show_event_lines(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether vertical highlight lines should be drawn in the visualizations at times when events occurred. `false` by default.
        """
        return pulumi.get(self, "show_event_lines")

    @_builtins.property
    @pulumi.getter
    def stacked(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether area and bar charts in the visualization should be stacked. `false` by default.
        """
        return pulumi.get(self, "stacked")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""signalfx_time_chart.tags is being removed in the next release""")
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Tags associated with the chart
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="timeRange")
    def time_range(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        How many seconds ago from which to display data. For example, the last hour would be `3600`, etc. Conflicts with `start_time` and `end_time`.
        """
        return pulumi.get(self, "time_range")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Time zone that SignalFlow uses as the basis of calendar window transformation methods. For example, if you set "timezone": "Europe/Paris" and then use the transformation sum(cycle="week", cycle_start="Monday") in your chart's SignalFlow program, the calendar window starts on Monday, Paris time. See the [full list of timezones for more](https://dev.splunk.com/observability/docs/signalflow/). `"UTC"` by default.
        """
        return pulumi.get(self, "timezone")

    @_builtins.property
    @pulumi.getter(name="unitPrefix")
    def unit_prefix(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Must be `"Metric"` or `"Binary`". `"Metric"` by default.
        """
        return pulumi.get(self, "unit_prefix")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        The URL of the chart.
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="vizOptions")
    def viz_options(self) -> pulumi.Output[Optional[Sequence['outputs.TimeChartVizOption']]]:
        """
        Plot-level customization options, associated with a publish statement.
        """
        return pulumi.get(self, "viz_options")

