# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CsiVolumeRegistrationArgs', 'CsiVolumeRegistration']

@pulumi.input_type
class CsiVolumeRegistrationArgs:
    def __init__(__self__, *,
                 external_id: pulumi.Input[_builtins.str],
                 plugin_id: pulumi.Input[_builtins.str],
                 volume_id: pulumi.Input[_builtins.str],
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input['CsiVolumeRegistrationCapabilityArgs']]]] = None,
                 capacity_max: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity_min: Optional[pulumi.Input[_builtins.str]] = None,
                 context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 deregister_on_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 mount_options: Optional[pulumi.Input['CsiVolumeRegistrationMountOptionsArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 secrets: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 topology_request: Optional[pulumi.Input['CsiVolumeRegistrationTopologyRequestArgs']] = None):
        """
        The set of arguments for constructing a CsiVolumeRegistration resource.
        :param pulumi.Input[_builtins.str] external_id: `(string: <required>)` - The ID of the physical volume from the storage provider.
        :param pulumi.Input[_builtins.str] plugin_id: `(string: <required>)` - The ID of the Nomad plugin for registering this volume.
        :param pulumi.Input[_builtins.str] volume_id: `(string: <required>)` - The unique ID of the volume.
        :param pulumi.Input[Sequence[pulumi.Input['CsiVolumeRegistrationCapabilityArgs']]] capabilities: `(``Capability``: <required>)` - Options for validating the capability of a volume.
        :param pulumi.Input[_builtins.str] capacity_max: `(string: <optional>)` - Option to signal a maximum volume size. This may not be supported by all storage providers.
        :param pulumi.Input[_builtins.str] capacity_min: `(string: <optional>)` - Option to signal a minimum volume size. This may not be supported by all storage providers.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] context: `(map[string]string: <optional>)` - An optional key-value map of strings passed directly to the CSI plugin to validate the volume.
        :param pulumi.Input[_builtins.bool] deregister_on_destroy: `(boolean: true)` - If true, the volume will be deregistered on destroy.
        :param pulumi.Input['CsiVolumeRegistrationMountOptionsArgs'] mount_options: `(block: <optional>)` Options for mounting `block-device` volumes without a pre-formatted file system.
        :param pulumi.Input[_builtins.str] name: `(string: <required>)` - The display name for the volume.
        :param pulumi.Input[_builtins.str] namespace: `(string: "default")` - The namespace in which to register the volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: `(map[string]string: <optional>)` - An optional key-value map of strings passed directly to the CSI plugin to configure the volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] secrets: `(map[string]string: <optional>)` - An optional key-value map of strings used as credentials for publishing and unpublishing volumes.
        :param pulumi.Input['CsiVolumeRegistrationTopologyRequestArgs'] topology_request: `(``TopologyRequest``: <optional>)` - Specify locations (region, zone, rack, etc.) where the provisioned volume is accessible from.
        """
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "plugin_id", plugin_id)
        pulumi.set(__self__, "volume_id", volume_id)
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if capacity_max is not None:
            pulumi.set(__self__, "capacity_max", capacity_max)
        if capacity_min is not None:
            pulumi.set(__self__, "capacity_min", capacity_min)
        if context is not None:
            pulumi.set(__self__, "context", context)
        if deregister_on_destroy is not None:
            pulumi.set(__self__, "deregister_on_destroy", deregister_on_destroy)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if topology_request is not None:
            pulumi.set(__self__, "topology_request", topology_request)

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Input[_builtins.str]:
        """
        `(string: <required>)` - The ID of the physical volume from the storage provider.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "external_id", value)

    @_builtins.property
    @pulumi.getter(name="pluginId")
    def plugin_id(self) -> pulumi.Input[_builtins.str]:
        """
        `(string: <required>)` - The ID of the Nomad plugin for registering this volume.
        """
        return pulumi.get(self, "plugin_id")

    @plugin_id.setter
    def plugin_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "plugin_id", value)

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> pulumi.Input[_builtins.str]:
        """
        `(string: <required>)` - The unique ID of the volume.
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "volume_id", value)

    @_builtins.property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CsiVolumeRegistrationCapabilityArgs']]]]:
        """
        `(``Capability``: <required>)` - Options for validating the capability of a volume.
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CsiVolumeRegistrationCapabilityArgs']]]]):
        pulumi.set(self, "capabilities", value)

    @_builtins.property
    @pulumi.getter(name="capacityMax")
    def capacity_max(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `(string: <optional>)` - Option to signal a maximum volume size. This may not be supported by all storage providers.
        """
        return pulumi.get(self, "capacity_max")

    @capacity_max.setter
    def capacity_max(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "capacity_max", value)

    @_builtins.property
    @pulumi.getter(name="capacityMin")
    def capacity_min(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `(string: <optional>)` - Option to signal a minimum volume size. This may not be supported by all storage providers.
        """
        return pulumi.get(self, "capacity_min")

    @capacity_min.setter
    def capacity_min(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "capacity_min", value)

    @_builtins.property
    @pulumi.getter
    def context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        `(map[string]string: <optional>)` - An optional key-value map of strings passed directly to the CSI plugin to validate the volume.
        """
        return pulumi.get(self, "context")

    @context.setter
    def context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "context", value)

    @_builtins.property
    @pulumi.getter(name="deregisterOnDestroy")
    def deregister_on_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        `(boolean: true)` - If true, the volume will be deregistered on destroy.
        """
        return pulumi.get(self, "deregister_on_destroy")

    @deregister_on_destroy.setter
    def deregister_on_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deregister_on_destroy", value)

    @_builtins.property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[pulumi.Input['CsiVolumeRegistrationMountOptionsArgs']]:
        """
        `(block: <optional>)` Options for mounting `block-device` volumes without a pre-formatted file system.
        """
        return pulumi.get(self, "mount_options")

    @mount_options.setter
    def mount_options(self, value: Optional[pulumi.Input['CsiVolumeRegistrationMountOptionsArgs']]):
        pulumi.set(self, "mount_options", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `(string: <required>)` - The display name for the volume.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `(string: "default")` - The namespace in which to register the volume.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        `(map[string]string: <optional>)` - An optional key-value map of strings passed directly to the CSI plugin to configure the volume.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        `(map[string]string: <optional>)` - An optional key-value map of strings used as credentials for publishing and unpublishing volumes.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "secrets", value)

    @_builtins.property
    @pulumi.getter(name="topologyRequest")
    def topology_request(self) -> Optional[pulumi.Input['CsiVolumeRegistrationTopologyRequestArgs']]:
        """
        `(``TopologyRequest``: <optional>)` - Specify locations (region, zone, rack, etc.) where the provisioned volume is accessible from.
        """
        return pulumi.get(self, "topology_request")

    @topology_request.setter
    def topology_request(self, value: Optional[pulumi.Input['CsiVolumeRegistrationTopologyRequestArgs']]):
        pulumi.set(self, "topology_request", value)


@pulumi.input_type
class _CsiVolumeRegistrationState:
    def __init__(__self__, *,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input['CsiVolumeRegistrationCapabilityArgs']]]] = None,
                 capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 capacity_max: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity_max_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 capacity_min: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity_min_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 controller_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 controllers_expected: Optional[pulumi.Input[_builtins.int]] = None,
                 controllers_healthy: Optional[pulumi.Input[_builtins.int]] = None,
                 deregister_on_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mount_options: Optional[pulumi.Input['CsiVolumeRegistrationMountOptionsArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 nodes_expected: Optional[pulumi.Input[_builtins.int]] = None,
                 nodes_healthy: Optional[pulumi.Input[_builtins.int]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 plugin_id: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_provider_version: Optional[pulumi.Input[_builtins.str]] = None,
                 schedulable: Optional[pulumi.Input[_builtins.bool]] = None,
                 secrets: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 topologies: Optional[pulumi.Input[Sequence[pulumi.Input['CsiVolumeRegistrationTopologyArgs']]]] = None,
                 topology_request: Optional[pulumi.Input['CsiVolumeRegistrationTopologyRequestArgs']] = None,
                 volume_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CsiVolumeRegistration resources.
        :param pulumi.Input[Sequence[pulumi.Input['CsiVolumeRegistrationCapabilityArgs']]] capabilities: `(``Capability``: <required>)` - Options for validating the capability of a volume.
        :param pulumi.Input[_builtins.str] capacity_max: `(string: <optional>)` - Option to signal a maximum volume size. This may not be supported by all storage providers.
        :param pulumi.Input[_builtins.str] capacity_min: `(string: <optional>)` - Option to signal a minimum volume size. This may not be supported by all storage providers.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] context: `(map[string]string: <optional>)` - An optional key-value map of strings passed directly to the CSI plugin to validate the volume.
        :param pulumi.Input[_builtins.bool] deregister_on_destroy: `(boolean: true)` - If true, the volume will be deregistered on destroy.
        :param pulumi.Input[_builtins.str] external_id: `(string: <required>)` - The ID of the physical volume from the storage provider.
        :param pulumi.Input['CsiVolumeRegistrationMountOptionsArgs'] mount_options: `(block: <optional>)` Options for mounting `block-device` volumes without a pre-formatted file system.
        :param pulumi.Input[_builtins.str] name: `(string: <required>)` - The display name for the volume.
        :param pulumi.Input[_builtins.str] namespace: `(string: "default")` - The namespace in which to register the volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: `(map[string]string: <optional>)` - An optional key-value map of strings passed directly to the CSI plugin to configure the volume.
        :param pulumi.Input[_builtins.str] plugin_id: `(string: <required>)` - The ID of the Nomad plugin for registering this volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] secrets: `(map[string]string: <optional>)` - An optional key-value map of strings used as credentials for publishing and unpublishing volumes.
        :param pulumi.Input['CsiVolumeRegistrationTopologyRequestArgs'] topology_request: `(``TopologyRequest``: <optional>)` - Specify locations (region, zone, rack, etc.) where the provisioned volume is accessible from.
        :param pulumi.Input[_builtins.str] volume_id: `(string: <required>)` - The unique ID of the volume.
        """
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if capacity_max is not None:
            pulumi.set(__self__, "capacity_max", capacity_max)
        if capacity_max_bytes is not None:
            pulumi.set(__self__, "capacity_max_bytes", capacity_max_bytes)
        if capacity_min is not None:
            pulumi.set(__self__, "capacity_min", capacity_min)
        if capacity_min_bytes is not None:
            pulumi.set(__self__, "capacity_min_bytes", capacity_min_bytes)
        if context is not None:
            pulumi.set(__self__, "context", context)
        if controller_required is not None:
            pulumi.set(__self__, "controller_required", controller_required)
        if controllers_expected is not None:
            pulumi.set(__self__, "controllers_expected", controllers_expected)
        if controllers_healthy is not None:
            pulumi.set(__self__, "controllers_healthy", controllers_healthy)
        if deregister_on_destroy is not None:
            pulumi.set(__self__, "deregister_on_destroy", deregister_on_destroy)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if nodes_expected is not None:
            pulumi.set(__self__, "nodes_expected", nodes_expected)
        if nodes_healthy is not None:
            pulumi.set(__self__, "nodes_healthy", nodes_healthy)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if plugin_id is not None:
            pulumi.set(__self__, "plugin_id", plugin_id)
        if plugin_provider is not None:
            pulumi.set(__self__, "plugin_provider", plugin_provider)
        if plugin_provider_version is not None:
            pulumi.set(__self__, "plugin_provider_version", plugin_provider_version)
        if schedulable is not None:
            pulumi.set(__self__, "schedulable", schedulable)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if topologies is not None:
            pulumi.set(__self__, "topologies", topologies)
        if topology_request is not None:
            pulumi.set(__self__, "topology_request", topology_request)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)

    @_builtins.property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CsiVolumeRegistrationCapabilityArgs']]]]:
        """
        `(``Capability``: <required>)` - Options for validating the capability of a volume.
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CsiVolumeRegistrationCapabilityArgs']]]]):
        pulumi.set(self, "capabilities", value)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "capacity", value)

    @_builtins.property
    @pulumi.getter(name="capacityMax")
    def capacity_max(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `(string: <optional>)` - Option to signal a maximum volume size. This may not be supported by all storage providers.
        """
        return pulumi.get(self, "capacity_max")

    @capacity_max.setter
    def capacity_max(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "capacity_max", value)

    @_builtins.property
    @pulumi.getter(name="capacityMaxBytes")
    def capacity_max_bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "capacity_max_bytes")

    @capacity_max_bytes.setter
    def capacity_max_bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "capacity_max_bytes", value)

    @_builtins.property
    @pulumi.getter(name="capacityMin")
    def capacity_min(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `(string: <optional>)` - Option to signal a minimum volume size. This may not be supported by all storage providers.
        """
        return pulumi.get(self, "capacity_min")

    @capacity_min.setter
    def capacity_min(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "capacity_min", value)

    @_builtins.property
    @pulumi.getter(name="capacityMinBytes")
    def capacity_min_bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "capacity_min_bytes")

    @capacity_min_bytes.setter
    def capacity_min_bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "capacity_min_bytes", value)

    @_builtins.property
    @pulumi.getter
    def context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        `(map[string]string: <optional>)` - An optional key-value map of strings passed directly to the CSI plugin to validate the volume.
        """
        return pulumi.get(self, "context")

    @context.setter
    def context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "context", value)

    @_builtins.property
    @pulumi.getter(name="controllerRequired")
    def controller_required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "controller_required")

    @controller_required.setter
    def controller_required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "controller_required", value)

    @_builtins.property
    @pulumi.getter(name="controllersExpected")
    def controllers_expected(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "controllers_expected")

    @controllers_expected.setter
    def controllers_expected(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "controllers_expected", value)

    @_builtins.property
    @pulumi.getter(name="controllersHealthy")
    def controllers_healthy(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "controllers_healthy")

    @controllers_healthy.setter
    def controllers_healthy(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "controllers_healthy", value)

    @_builtins.property
    @pulumi.getter(name="deregisterOnDestroy")
    def deregister_on_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        `(boolean: true)` - If true, the volume will be deregistered on destroy.
        """
        return pulumi.get(self, "deregister_on_destroy")

    @deregister_on_destroy.setter
    def deregister_on_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deregister_on_destroy", value)

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `(string: <required>)` - The ID of the physical volume from the storage provider.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_id", value)

    @_builtins.property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[pulumi.Input['CsiVolumeRegistrationMountOptionsArgs']]:
        """
        `(block: <optional>)` Options for mounting `block-device` volumes without a pre-formatted file system.
        """
        return pulumi.get(self, "mount_options")

    @mount_options.setter
    def mount_options(self, value: Optional[pulumi.Input['CsiVolumeRegistrationMountOptionsArgs']]):
        pulumi.set(self, "mount_options", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `(string: <required>)` - The display name for the volume.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `(string: "default")` - The namespace in which to register the volume.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="nodesExpected")
    def nodes_expected(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "nodes_expected")

    @nodes_expected.setter
    def nodes_expected(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "nodes_expected", value)

    @_builtins.property
    @pulumi.getter(name="nodesHealthy")
    def nodes_healthy(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "nodes_healthy")

    @nodes_healthy.setter
    def nodes_healthy(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "nodes_healthy", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        `(map[string]string: <optional>)` - An optional key-value map of strings passed directly to the CSI plugin to configure the volume.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="pluginId")
    def plugin_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `(string: <required>)` - The ID of the Nomad plugin for registering this volume.
        """
        return pulumi.get(self, "plugin_id")

    @plugin_id.setter
    def plugin_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plugin_id", value)

    @_builtins.property
    @pulumi.getter(name="pluginProvider")
    def plugin_provider(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "plugin_provider")

    @plugin_provider.setter
    def plugin_provider(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plugin_provider", value)

    @_builtins.property
    @pulumi.getter(name="pluginProviderVersion")
    def plugin_provider_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "plugin_provider_version")

    @plugin_provider_version.setter
    def plugin_provider_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plugin_provider_version", value)

    @_builtins.property
    @pulumi.getter
    def schedulable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "schedulable")

    @schedulable.setter
    def schedulable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "schedulable", value)

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        `(map[string]string: <optional>)` - An optional key-value map of strings used as credentials for publishing and unpublishing volumes.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "secrets", value)

    @_builtins.property
    @pulumi.getter
    def topologies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CsiVolumeRegistrationTopologyArgs']]]]:
        return pulumi.get(self, "topologies")

    @topologies.setter
    def topologies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CsiVolumeRegistrationTopologyArgs']]]]):
        pulumi.set(self, "topologies", value)

    @_builtins.property
    @pulumi.getter(name="topologyRequest")
    def topology_request(self) -> Optional[pulumi.Input['CsiVolumeRegistrationTopologyRequestArgs']]:
        """
        `(``TopologyRequest``: <optional>)` - Specify locations (region, zone, rack, etc.) where the provisioned volume is accessible from.
        """
        return pulumi.get(self, "topology_request")

    @topology_request.setter
    def topology_request(self, value: Optional[pulumi.Input['CsiVolumeRegistrationTopologyRequestArgs']]):
        pulumi.set(self, "topology_request", value)

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `(string: <required>)` - The unique ID of the volume.
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_id", value)


@pulumi.type_token("nomad:index/csiVolumeRegistration:CsiVolumeRegistration")
class CsiVolumeRegistration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CsiVolumeRegistrationCapabilityArgs', 'CsiVolumeRegistrationCapabilityArgsDict']]]]] = None,
                 capacity_max: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity_min: Optional[pulumi.Input[_builtins.str]] = None,
                 context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 deregister_on_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mount_options: Optional[pulumi.Input[Union['CsiVolumeRegistrationMountOptionsArgs', 'CsiVolumeRegistrationMountOptionsArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 plugin_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secrets: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 topology_request: Optional[pulumi.Input[Union['CsiVolumeRegistrationTopologyRequestArgs', 'CsiVolumeRegistrationTopologyRequestArgsDict']]] = None,
                 volume_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a CsiVolumeRegistration resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CsiVolumeRegistrationCapabilityArgs', 'CsiVolumeRegistrationCapabilityArgsDict']]]] capabilities: `(``Capability``: <required>)` - Options for validating the capability of a volume.
        :param pulumi.Input[_builtins.str] capacity_max: `(string: <optional>)` - Option to signal a maximum volume size. This may not be supported by all storage providers.
        :param pulumi.Input[_builtins.str] capacity_min: `(string: <optional>)` - Option to signal a minimum volume size. This may not be supported by all storage providers.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] context: `(map[string]string: <optional>)` - An optional key-value map of strings passed directly to the CSI plugin to validate the volume.
        :param pulumi.Input[_builtins.bool] deregister_on_destroy: `(boolean: true)` - If true, the volume will be deregistered on destroy.
        :param pulumi.Input[_builtins.str] external_id: `(string: <required>)` - The ID of the physical volume from the storage provider.
        :param pulumi.Input[Union['CsiVolumeRegistrationMountOptionsArgs', 'CsiVolumeRegistrationMountOptionsArgsDict']] mount_options: `(block: <optional>)` Options for mounting `block-device` volumes without a pre-formatted file system.
        :param pulumi.Input[_builtins.str] name: `(string: <required>)` - The display name for the volume.
        :param pulumi.Input[_builtins.str] namespace: `(string: "default")` - The namespace in which to register the volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: `(map[string]string: <optional>)` - An optional key-value map of strings passed directly to the CSI plugin to configure the volume.
        :param pulumi.Input[_builtins.str] plugin_id: `(string: <required>)` - The ID of the Nomad plugin for registering this volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] secrets: `(map[string]string: <optional>)` - An optional key-value map of strings used as credentials for publishing and unpublishing volumes.
        :param pulumi.Input[Union['CsiVolumeRegistrationTopologyRequestArgs', 'CsiVolumeRegistrationTopologyRequestArgsDict']] topology_request: `(``TopologyRequest``: <optional>)` - Specify locations (region, zone, rack, etc.) where the provisioned volume is accessible from.
        :param pulumi.Input[_builtins.str] volume_id: `(string: <required>)` - The unique ID of the volume.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CsiVolumeRegistrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a CsiVolumeRegistration resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param CsiVolumeRegistrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CsiVolumeRegistrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CsiVolumeRegistrationCapabilityArgs', 'CsiVolumeRegistrationCapabilityArgsDict']]]]] = None,
                 capacity_max: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity_min: Optional[pulumi.Input[_builtins.str]] = None,
                 context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 deregister_on_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mount_options: Optional[pulumi.Input[Union['CsiVolumeRegistrationMountOptionsArgs', 'CsiVolumeRegistrationMountOptionsArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 plugin_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secrets: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 topology_request: Optional[pulumi.Input[Union['CsiVolumeRegistrationTopologyRequestArgs', 'CsiVolumeRegistrationTopologyRequestArgsDict']]] = None,
                 volume_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CsiVolumeRegistrationArgs.__new__(CsiVolumeRegistrationArgs)

            __props__.__dict__["capabilities"] = capabilities
            __props__.__dict__["capacity_max"] = capacity_max
            __props__.__dict__["capacity_min"] = capacity_min
            __props__.__dict__["context"] = context
            __props__.__dict__["deregister_on_destroy"] = deregister_on_destroy
            if external_id is None and not opts.urn:
                raise TypeError("Missing required property 'external_id'")
            __props__.__dict__["external_id"] = external_id
            __props__.__dict__["mount_options"] = mount_options
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["parameters"] = parameters
            if plugin_id is None and not opts.urn:
                raise TypeError("Missing required property 'plugin_id'")
            __props__.__dict__["plugin_id"] = plugin_id
            __props__.__dict__["secrets"] = None if secrets is None else pulumi.Output.secret(secrets)
            __props__.__dict__["topology_request"] = topology_request
            if volume_id is None and not opts.urn:
                raise TypeError("Missing required property 'volume_id'")
            __props__.__dict__["volume_id"] = volume_id
            __props__.__dict__["capacity"] = None
            __props__.__dict__["capacity_max_bytes"] = None
            __props__.__dict__["capacity_min_bytes"] = None
            __props__.__dict__["controller_required"] = None
            __props__.__dict__["controllers_expected"] = None
            __props__.__dict__["controllers_healthy"] = None
            __props__.__dict__["nodes_expected"] = None
            __props__.__dict__["nodes_healthy"] = None
            __props__.__dict__["plugin_provider"] = None
            __props__.__dict__["plugin_provider_version"] = None
            __props__.__dict__["schedulable"] = None
            __props__.__dict__["topologies"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secrets"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(CsiVolumeRegistration, __self__).__init__(
            'nomad:index/csiVolumeRegistration:CsiVolumeRegistration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CsiVolumeRegistrationCapabilityArgs', 'CsiVolumeRegistrationCapabilityArgsDict']]]]] = None,
            capacity: Optional[pulumi.Input[_builtins.int]] = None,
            capacity_max: Optional[pulumi.Input[_builtins.str]] = None,
            capacity_max_bytes: Optional[pulumi.Input[_builtins.int]] = None,
            capacity_min: Optional[pulumi.Input[_builtins.str]] = None,
            capacity_min_bytes: Optional[pulumi.Input[_builtins.int]] = None,
            context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            controller_required: Optional[pulumi.Input[_builtins.bool]] = None,
            controllers_expected: Optional[pulumi.Input[_builtins.int]] = None,
            controllers_healthy: Optional[pulumi.Input[_builtins.int]] = None,
            deregister_on_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
            external_id: Optional[pulumi.Input[_builtins.str]] = None,
            mount_options: Optional[pulumi.Input[Union['CsiVolumeRegistrationMountOptionsArgs', 'CsiVolumeRegistrationMountOptionsArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            nodes_expected: Optional[pulumi.Input[_builtins.int]] = None,
            nodes_healthy: Optional[pulumi.Input[_builtins.int]] = None,
            parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            plugin_id: Optional[pulumi.Input[_builtins.str]] = None,
            plugin_provider: Optional[pulumi.Input[_builtins.str]] = None,
            plugin_provider_version: Optional[pulumi.Input[_builtins.str]] = None,
            schedulable: Optional[pulumi.Input[_builtins.bool]] = None,
            secrets: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            topologies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CsiVolumeRegistrationTopologyArgs', 'CsiVolumeRegistrationTopologyArgsDict']]]]] = None,
            topology_request: Optional[pulumi.Input[Union['CsiVolumeRegistrationTopologyRequestArgs', 'CsiVolumeRegistrationTopologyRequestArgsDict']]] = None,
            volume_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'CsiVolumeRegistration':
        """
        Get an existing CsiVolumeRegistration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CsiVolumeRegistrationCapabilityArgs', 'CsiVolumeRegistrationCapabilityArgsDict']]]] capabilities: `(``Capability``: <required>)` - Options for validating the capability of a volume.
        :param pulumi.Input[_builtins.str] capacity_max: `(string: <optional>)` - Option to signal a maximum volume size. This may not be supported by all storage providers.
        :param pulumi.Input[_builtins.str] capacity_min: `(string: <optional>)` - Option to signal a minimum volume size. This may not be supported by all storage providers.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] context: `(map[string]string: <optional>)` - An optional key-value map of strings passed directly to the CSI plugin to validate the volume.
        :param pulumi.Input[_builtins.bool] deregister_on_destroy: `(boolean: true)` - If true, the volume will be deregistered on destroy.
        :param pulumi.Input[_builtins.str] external_id: `(string: <required>)` - The ID of the physical volume from the storage provider.
        :param pulumi.Input[Union['CsiVolumeRegistrationMountOptionsArgs', 'CsiVolumeRegistrationMountOptionsArgsDict']] mount_options: `(block: <optional>)` Options for mounting `block-device` volumes without a pre-formatted file system.
        :param pulumi.Input[_builtins.str] name: `(string: <required>)` - The display name for the volume.
        :param pulumi.Input[_builtins.str] namespace: `(string: "default")` - The namespace in which to register the volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: `(map[string]string: <optional>)` - An optional key-value map of strings passed directly to the CSI plugin to configure the volume.
        :param pulumi.Input[_builtins.str] plugin_id: `(string: <required>)` - The ID of the Nomad plugin for registering this volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] secrets: `(map[string]string: <optional>)` - An optional key-value map of strings used as credentials for publishing and unpublishing volumes.
        :param pulumi.Input[Union['CsiVolumeRegistrationTopologyRequestArgs', 'CsiVolumeRegistrationTopologyRequestArgsDict']] topology_request: `(``TopologyRequest``: <optional>)` - Specify locations (region, zone, rack, etc.) where the provisioned volume is accessible from.
        :param pulumi.Input[_builtins.str] volume_id: `(string: <required>)` - The unique ID of the volume.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CsiVolumeRegistrationState.__new__(_CsiVolumeRegistrationState)

        __props__.__dict__["capabilities"] = capabilities
        __props__.__dict__["capacity"] = capacity
        __props__.__dict__["capacity_max"] = capacity_max
        __props__.__dict__["capacity_max_bytes"] = capacity_max_bytes
        __props__.__dict__["capacity_min"] = capacity_min
        __props__.__dict__["capacity_min_bytes"] = capacity_min_bytes
        __props__.__dict__["context"] = context
        __props__.__dict__["controller_required"] = controller_required
        __props__.__dict__["controllers_expected"] = controllers_expected
        __props__.__dict__["controllers_healthy"] = controllers_healthy
        __props__.__dict__["deregister_on_destroy"] = deregister_on_destroy
        __props__.__dict__["external_id"] = external_id
        __props__.__dict__["mount_options"] = mount_options
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["nodes_expected"] = nodes_expected
        __props__.__dict__["nodes_healthy"] = nodes_healthy
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["plugin_id"] = plugin_id
        __props__.__dict__["plugin_provider"] = plugin_provider
        __props__.__dict__["plugin_provider_version"] = plugin_provider_version
        __props__.__dict__["schedulable"] = schedulable
        __props__.__dict__["secrets"] = secrets
        __props__.__dict__["topologies"] = topologies
        __props__.__dict__["topology_request"] = topology_request
        __props__.__dict__["volume_id"] = volume_id
        return CsiVolumeRegistration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def capabilities(self) -> pulumi.Output[Optional[Sequence['outputs.CsiVolumeRegistrationCapability']]]:
        """
        `(``Capability``: <required>)` - Options for validating the capability of a volume.
        """
        return pulumi.get(self, "capabilities")

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "capacity")

    @_builtins.property
    @pulumi.getter(name="capacityMax")
    def capacity_max(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `(string: <optional>)` - Option to signal a maximum volume size. This may not be supported by all storage providers.
        """
        return pulumi.get(self, "capacity_max")

    @_builtins.property
    @pulumi.getter(name="capacityMaxBytes")
    def capacity_max_bytes(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "capacity_max_bytes")

    @_builtins.property
    @pulumi.getter(name="capacityMin")
    def capacity_min(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `(string: <optional>)` - Option to signal a minimum volume size. This may not be supported by all storage providers.
        """
        return pulumi.get(self, "capacity_min")

    @_builtins.property
    @pulumi.getter(name="capacityMinBytes")
    def capacity_min_bytes(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "capacity_min_bytes")

    @_builtins.property
    @pulumi.getter
    def context(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        `(map[string]string: <optional>)` - An optional key-value map of strings passed directly to the CSI plugin to validate the volume.
        """
        return pulumi.get(self, "context")

    @_builtins.property
    @pulumi.getter(name="controllerRequired")
    def controller_required(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "controller_required")

    @_builtins.property
    @pulumi.getter(name="controllersExpected")
    def controllers_expected(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "controllers_expected")

    @_builtins.property
    @pulumi.getter(name="controllersHealthy")
    def controllers_healthy(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "controllers_healthy")

    @_builtins.property
    @pulumi.getter(name="deregisterOnDestroy")
    def deregister_on_destroy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        `(boolean: true)` - If true, the volume will be deregistered on destroy.
        """
        return pulumi.get(self, "deregister_on_destroy")

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Output[_builtins.str]:
        """
        `(string: <required>)` - The ID of the physical volume from the storage provider.
        """
        return pulumi.get(self, "external_id")

    @_builtins.property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> pulumi.Output[Optional['outputs.CsiVolumeRegistrationMountOptions']]:
        """
        `(block: <optional>)` Options for mounting `block-device` volumes without a pre-formatted file system.
        """
        return pulumi.get(self, "mount_options")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        `(string: <required>)` - The display name for the volume.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `(string: "default")` - The namespace in which to register the volume.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="nodesExpected")
    def nodes_expected(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "nodes_expected")

    @_builtins.property
    @pulumi.getter(name="nodesHealthy")
    def nodes_healthy(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "nodes_healthy")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        `(map[string]string: <optional>)` - An optional key-value map of strings passed directly to the CSI plugin to configure the volume.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="pluginId")
    def plugin_id(self) -> pulumi.Output[_builtins.str]:
        """
        `(string: <required>)` - The ID of the Nomad plugin for registering this volume.
        """
        return pulumi.get(self, "plugin_id")

    @_builtins.property
    @pulumi.getter(name="pluginProvider")
    def plugin_provider(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "plugin_provider")

    @_builtins.property
    @pulumi.getter(name="pluginProviderVersion")
    def plugin_provider_version(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "plugin_provider_version")

    @_builtins.property
    @pulumi.getter
    def schedulable(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "schedulable")

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        `(map[string]string: <optional>)` - An optional key-value map of strings used as credentials for publishing and unpublishing volumes.
        """
        return pulumi.get(self, "secrets")

    @_builtins.property
    @pulumi.getter
    def topologies(self) -> pulumi.Output[Sequence['outputs.CsiVolumeRegistrationTopology']]:
        return pulumi.get(self, "topologies")

    @_builtins.property
    @pulumi.getter(name="topologyRequest")
    def topology_request(self) -> pulumi.Output[Optional['outputs.CsiVolumeRegistrationTopologyRequest']]:
        """
        `(``TopologyRequest``: <optional>)` - Specify locations (region, zone, rack, etc.) where the provisioned volume is accessible from.
        """
        return pulumi.get(self, "topology_request")

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> pulumi.Output[_builtins.str]:
        """
        `(string: <required>)` - The unique ID of the volume.
        """
        return pulumi.get(self, "volume_id")

