# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DynamicHostVolumeArgs', 'DynamicHostVolume']

@pulumi.input_type
class DynamicHostVolumeArgs:
    def __init__(__self__, *,
                 capabilities: pulumi.Input[Sequence[pulumi.Input['DynamicHostVolumeCapabilityArgs']]],
                 plugin_id: pulumi.Input[_builtins.str],
                 capacity_max: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity_min: Optional[pulumi.Input[_builtins.str]] = None,
                 constraints: Optional[pulumi.Input[Sequence[pulumi.Input['DynamicHostVolumeConstraintArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 node_id: Optional[pulumi.Input[_builtins.str]] = None,
                 node_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a DynamicHostVolume resource.
        :param pulumi.Input[Sequence[pulumi.Input['DynamicHostVolumeCapabilityArgs']]] capabilities: `(block: <optional>)` - Option for validating the capability of a
               volume. Each capability block has the following attributes:
        :param pulumi.Input[_builtins.str] plugin_id: Plugin ID
        :param pulumi.Input[_builtins.str] capacity_max: `(string: <optional>)` - Option for requesting a maximum
               capacity, in bytes. The capacity of a volume may be the physical size of a
               disk, or a quota, depending on the plugin. The specific size of the resulting
               volume is somewhere between `capacity_min` and `capacity_max`; the exact
               behavior is up to the plugin. If you want to specify an exact size, set
               `capacity_min` and `capacity_max` to the same value. Accepts human-friendly
               suffixes such as `"100GiB"`. Plugins that cannot restrict the size of volumes
               may ignore this field.
        :param pulumi.Input[_builtins.str] capacity_min: `(string: <optional>)` - Option for requesting a minimum
               capacity, in bytes. The capacity of a volume may be the physical size of a
               disk, or a quota, depending on the plugin. The specific size of the resulting
               volume is somewhere between `capacity_min` and `capacity_max`; the exact
               behavior is up to the plugin. If you want to specify an exact size, set
               `capacity_min` and `capacity_max` to the same value. Accepts human-friendly
               suffixes such as `"100GiB"`. Plugins that cannot restrict the size of volumes
               may ignore this field.
        :param pulumi.Input[Sequence[pulumi.Input['DynamicHostVolumeConstraintArgs']]] constraints: `(block: <optional>)` - A restriction on the eligible nodes where
               a volume can be created, similar to the [`constraint`][] block on a Nomad job
               specification.. You can provide multiple `constraint` blocks to add more
               constraints. Each constraint block has the following attributes.
        :param pulumi.Input[_builtins.str] name: `(string: <required>)` - The name of the volume, which is used as the
               [`volume.source`][volume_source] field in job specifications that claim this
               volume. Host volume names must be unique per node. Names are visible to any
               user with `node:read` ACL, even across namespaces, so they should not be
               treated as sensitive values.
        :param pulumi.Input[_builtins.str] namespace: `(string: <optional>)` - The namespace of the volume. This field
               overrides the namespace provided by the `-namespace` flag or `NOMAD_NAMESPACE`
               environment variable. Defaults to `"default"` if unset.
        :param pulumi.Input[_builtins.str] node_id: `(string: <optional>)` - A specific node where you would like the
               volume to be created.
        :param pulumi.Input[_builtins.str] node_pool: `(string: <optional>)` - A specific node pool where you would like
               the volume to be created. If you also provide `node_id`, the node must be in the
               provided `node_pool`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: `(map<string|string>: <optional>)` - A key-value map of strings
               passed directly to the plugin to configure the volume. The details of these
               parameters are specific to the plugin.
        """
        pulumi.set(__self__, "capabilities", capabilities)
        pulumi.set(__self__, "plugin_id", plugin_id)
        if capacity_max is not None:
            pulumi.set(__self__, "capacity_max", capacity_max)
        if capacity_min is not None:
            pulumi.set(__self__, "capacity_min", capacity_min)
        if constraints is not None:
            pulumi.set(__self__, "constraints", constraints)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if node_pool is not None:
            pulumi.set(__self__, "node_pool", node_pool)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @_builtins.property
    @pulumi.getter
    def capabilities(self) -> pulumi.Input[Sequence[pulumi.Input['DynamicHostVolumeCapabilityArgs']]]:
        """
        `(block: <optional>)` - Option for validating the capability of a
        volume. Each capability block has the following attributes:
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: pulumi.Input[Sequence[pulumi.Input['DynamicHostVolumeCapabilityArgs']]]):
        pulumi.set(self, "capabilities", value)

    @_builtins.property
    @pulumi.getter(name="pluginId")
    def plugin_id(self) -> pulumi.Input[_builtins.str]:
        """
        Plugin ID
        """
        return pulumi.get(self, "plugin_id")

    @plugin_id.setter
    def plugin_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "plugin_id", value)

    @_builtins.property
    @pulumi.getter(name="capacityMax")
    def capacity_max(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `(string: <optional>)` - Option for requesting a maximum
        capacity, in bytes. The capacity of a volume may be the physical size of a
        disk, or a quota, depending on the plugin. The specific size of the resulting
        volume is somewhere between `capacity_min` and `capacity_max`; the exact
        behavior is up to the plugin. If you want to specify an exact size, set
        `capacity_min` and `capacity_max` to the same value. Accepts human-friendly
        suffixes such as `"100GiB"`. Plugins that cannot restrict the size of volumes
        may ignore this field.
        """
        return pulumi.get(self, "capacity_max")

    @capacity_max.setter
    def capacity_max(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "capacity_max", value)

    @_builtins.property
    @pulumi.getter(name="capacityMin")
    def capacity_min(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `(string: <optional>)` - Option for requesting a minimum
        capacity, in bytes. The capacity of a volume may be the physical size of a
        disk, or a quota, depending on the plugin. The specific size of the resulting
        volume is somewhere between `capacity_min` and `capacity_max`; the exact
        behavior is up to the plugin. If you want to specify an exact size, set
        `capacity_min` and `capacity_max` to the same value. Accepts human-friendly
        suffixes such as `"100GiB"`. Plugins that cannot restrict the size of volumes
        may ignore this field.
        """
        return pulumi.get(self, "capacity_min")

    @capacity_min.setter
    def capacity_min(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "capacity_min", value)

    @_builtins.property
    @pulumi.getter
    def constraints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DynamicHostVolumeConstraintArgs']]]]:
        """
        `(block: <optional>)` - A restriction on the eligible nodes where
        a volume can be created, similar to the [`constraint`][] block on a Nomad job
        specification.. You can provide multiple `constraint` blocks to add more
        constraints. Each constraint block has the following attributes.
        """
        return pulumi.get(self, "constraints")

    @constraints.setter
    def constraints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DynamicHostVolumeConstraintArgs']]]]):
        pulumi.set(self, "constraints", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `(string: <required>)` - The name of the volume, which is used as the
        [`volume.source`][volume_source] field in job specifications that claim this
        volume. Host volume names must be unique per node. Names are visible to any
        user with `node:read` ACL, even across namespaces, so they should not be
        treated as sensitive values.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `(string: <optional>)` - The namespace of the volume. This field
        overrides the namespace provided by the `-namespace` flag or `NOMAD_NAMESPACE`
        environment variable. Defaults to `"default"` if unset.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `(string: <optional>)` - A specific node where you would like the
        volume to be created.
        """
        return pulumi.get(self, "node_id")

    @node_id.setter
    def node_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_id", value)

    @_builtins.property
    @pulumi.getter(name="nodePool")
    def node_pool(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `(string: <optional>)` - A specific node pool where you would like
        the volume to be created. If you also provide `node_id`, the node must be in the
        provided `node_pool`.
        """
        return pulumi.get(self, "node_pool")

    @node_pool.setter
    def node_pool(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_pool", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        `(map<string|string>: <optional>)` - A key-value map of strings
        passed directly to the plugin to configure the volume. The details of these
        parameters are specific to the plugin.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class _DynamicHostVolumeState:
    def __init__(__self__, *,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input['DynamicHostVolumeCapabilityArgs']]]] = None,
                 capacity: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 capacity_max: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity_max_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 capacity_min: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity_min_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 constraints: Optional[pulumi.Input[Sequence[pulumi.Input['DynamicHostVolumeConstraintArgs']]]] = None,
                 host_path: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 node_id: Optional[pulumi.Input[_builtins.str]] = None,
                 node_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 plugin_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DynamicHostVolume resources.
        :param pulumi.Input[Sequence[pulumi.Input['DynamicHostVolumeCapabilityArgs']]] capabilities: `(block: <optional>)` - Option for validating the capability of a
               volume. Each capability block has the following attributes:
        :param pulumi.Input[_builtins.str] capacity: Provisioned capacity
        :param pulumi.Input[_builtins.str] capacity_max: `(string: <optional>)` - Option for requesting a maximum
               capacity, in bytes. The capacity of a volume may be the physical size of a
               disk, or a quota, depending on the plugin. The specific size of the resulting
               volume is somewhere between `capacity_min` and `capacity_max`; the exact
               behavior is up to the plugin. If you want to specify an exact size, set
               `capacity_min` and `capacity_max` to the same value. Accepts human-friendly
               suffixes such as `"100GiB"`. Plugins that cannot restrict the size of volumes
               may ignore this field.
        :param pulumi.Input[_builtins.str] capacity_min: `(string: <optional>)` - Option for requesting a minimum
               capacity, in bytes. The capacity of a volume may be the physical size of a
               disk, or a quota, depending on the plugin. The specific size of the resulting
               volume is somewhere between `capacity_min` and `capacity_max`; the exact
               behavior is up to the plugin. If you want to specify an exact size, set
               `capacity_min` and `capacity_max` to the same value. Accepts human-friendly
               suffixes such as `"100GiB"`. Plugins that cannot restrict the size of volumes
               may ignore this field.
        :param pulumi.Input[Sequence[pulumi.Input['DynamicHostVolumeConstraintArgs']]] constraints: `(block: <optional>)` - A restriction on the eligible nodes where
               a volume can be created, similar to the [`constraint`][] block on a Nomad job
               specification.. You can provide multiple `constraint` blocks to add more
               constraints. Each constraint block has the following attributes.
        :param pulumi.Input[_builtins.str] host_path: Host path
        :param pulumi.Input[_builtins.str] name: `(string: <required>)` - The name of the volume, which is used as the
               [`volume.source`][volume_source] field in job specifications that claim this
               volume. Host volume names must be unique per node. Names are visible to any
               user with `node:read` ACL, even across namespaces, so they should not be
               treated as sensitive values.
        :param pulumi.Input[_builtins.str] namespace: `(string: <optional>)` - The namespace of the volume. This field
               overrides the namespace provided by the `-namespace` flag or `NOMAD_NAMESPACE`
               environment variable. Defaults to `"default"` if unset.
        :param pulumi.Input[_builtins.str] node_id: `(string: <optional>)` - A specific node where you would like the
               volume to be created.
        :param pulumi.Input[_builtins.str] node_pool: `(string: <optional>)` - A specific node pool where you would like
               the volume to be created. If you also provide `node_id`, the node must be in the
               provided `node_pool`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: `(map<string|string>: <optional>)` - A key-value map of strings
               passed directly to the plugin to configure the volume. The details of these
               parameters are specific to the plugin.
        :param pulumi.Input[_builtins.str] plugin_id: Plugin ID
        :param pulumi.Input[_builtins.str] state: State
        """
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if capacity_bytes is not None:
            pulumi.set(__self__, "capacity_bytes", capacity_bytes)
        if capacity_max is not None:
            pulumi.set(__self__, "capacity_max", capacity_max)
        if capacity_max_bytes is not None:
            pulumi.set(__self__, "capacity_max_bytes", capacity_max_bytes)
        if capacity_min is not None:
            pulumi.set(__self__, "capacity_min", capacity_min)
        if capacity_min_bytes is not None:
            pulumi.set(__self__, "capacity_min_bytes", capacity_min_bytes)
        if constraints is not None:
            pulumi.set(__self__, "constraints", constraints)
        if host_path is not None:
            pulumi.set(__self__, "host_path", host_path)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if node_pool is not None:
            pulumi.set(__self__, "node_pool", node_pool)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if plugin_id is not None:
            pulumi.set(__self__, "plugin_id", plugin_id)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DynamicHostVolumeCapabilityArgs']]]]:
        """
        `(block: <optional>)` - Option for validating the capability of a
        volume. Each capability block has the following attributes:
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DynamicHostVolumeCapabilityArgs']]]]):
        pulumi.set(self, "capabilities", value)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provisioned capacity
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "capacity", value)

    @_builtins.property
    @pulumi.getter(name="capacityBytes")
    def capacity_bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "capacity_bytes")

    @capacity_bytes.setter
    def capacity_bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "capacity_bytes", value)

    @_builtins.property
    @pulumi.getter(name="capacityMax")
    def capacity_max(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `(string: <optional>)` - Option for requesting a maximum
        capacity, in bytes. The capacity of a volume may be the physical size of a
        disk, or a quota, depending on the plugin. The specific size of the resulting
        volume is somewhere between `capacity_min` and `capacity_max`; the exact
        behavior is up to the plugin. If you want to specify an exact size, set
        `capacity_min` and `capacity_max` to the same value. Accepts human-friendly
        suffixes such as `"100GiB"`. Plugins that cannot restrict the size of volumes
        may ignore this field.
        """
        return pulumi.get(self, "capacity_max")

    @capacity_max.setter
    def capacity_max(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "capacity_max", value)

    @_builtins.property
    @pulumi.getter(name="capacityMaxBytes")
    def capacity_max_bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "capacity_max_bytes")

    @capacity_max_bytes.setter
    def capacity_max_bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "capacity_max_bytes", value)

    @_builtins.property
    @pulumi.getter(name="capacityMin")
    def capacity_min(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `(string: <optional>)` - Option for requesting a minimum
        capacity, in bytes. The capacity of a volume may be the physical size of a
        disk, or a quota, depending on the plugin. The specific size of the resulting
        volume is somewhere between `capacity_min` and `capacity_max`; the exact
        behavior is up to the plugin. If you want to specify an exact size, set
        `capacity_min` and `capacity_max` to the same value. Accepts human-friendly
        suffixes such as `"100GiB"`. Plugins that cannot restrict the size of volumes
        may ignore this field.
        """
        return pulumi.get(self, "capacity_min")

    @capacity_min.setter
    def capacity_min(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "capacity_min", value)

    @_builtins.property
    @pulumi.getter(name="capacityMinBytes")
    def capacity_min_bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "capacity_min_bytes")

    @capacity_min_bytes.setter
    def capacity_min_bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "capacity_min_bytes", value)

    @_builtins.property
    @pulumi.getter
    def constraints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DynamicHostVolumeConstraintArgs']]]]:
        """
        `(block: <optional>)` - A restriction on the eligible nodes where
        a volume can be created, similar to the [`constraint`][] block on a Nomad job
        specification.. You can provide multiple `constraint` blocks to add more
        constraints. Each constraint block has the following attributes.
        """
        return pulumi.get(self, "constraints")

    @constraints.setter
    def constraints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DynamicHostVolumeConstraintArgs']]]]):
        pulumi.set(self, "constraints", value)

    @_builtins.property
    @pulumi.getter(name="hostPath")
    def host_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Host path
        """
        return pulumi.get(self, "host_path")

    @host_path.setter
    def host_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_path", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `(string: <required>)` - The name of the volume, which is used as the
        [`volume.source`][volume_source] field in job specifications that claim this
        volume. Host volume names must be unique per node. Names are visible to any
        user with `node:read` ACL, even across namespaces, so they should not be
        treated as sensitive values.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `(string: <optional>)` - The namespace of the volume. This field
        overrides the namespace provided by the `-namespace` flag or `NOMAD_NAMESPACE`
        environment variable. Defaults to `"default"` if unset.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `(string: <optional>)` - A specific node where you would like the
        volume to be created.
        """
        return pulumi.get(self, "node_id")

    @node_id.setter
    def node_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_id", value)

    @_builtins.property
    @pulumi.getter(name="nodePool")
    def node_pool(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `(string: <optional>)` - A specific node pool where you would like
        the volume to be created. If you also provide `node_id`, the node must be in the
        provided `node_pool`.
        """
        return pulumi.get(self, "node_pool")

    @node_pool.setter
    def node_pool(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_pool", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        `(map<string|string>: <optional>)` - A key-value map of strings
        passed directly to the plugin to configure the volume. The details of these
        parameters are specific to the plugin.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="pluginId")
    def plugin_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Plugin ID
        """
        return pulumi.get(self, "plugin_id")

    @plugin_id.setter
    def plugin_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plugin_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        State
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.type_token("nomad:index/dynamicHostVolume:DynamicHostVolume")
class DynamicHostVolume(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DynamicHostVolumeCapabilityArgs', 'DynamicHostVolumeCapabilityArgsDict']]]]] = None,
                 capacity_max: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity_min: Optional[pulumi.Input[_builtins.str]] = None,
                 constraints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DynamicHostVolumeConstraintArgs', 'DynamicHostVolumeConstraintArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 node_id: Optional[pulumi.Input[_builtins.str]] = None,
                 node_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 plugin_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        layout: "nomad"
        page_title: "Nomad: DynamicHostVolume"
        sidebar_current: "docs-nomad-resource-dynamic-host-volume"
        description: |-
          Manages the lifecycle of creating and deleting dynamic host volumes.
        ---

        Creates and registers a dynamic host volume in Nomad. Note that Nomad supports
        two workflows for dynamic host volumes: create and register. Both resources
        result in the same data source with the same outputs.

        > **Warning:** Destroying this resource **will result in data loss**. Use the
          [`prevent_destroy`][tf_docs_prevent_destroy] directive to avoid accidental
          deletions.

        ## Example Usage

        Creating a dynamic host volume:

        ```python
        import pulumi
        import pulumi_nomad as nomad

        example = nomad.DynamicHostVolume("example",
            name="example",
            namespace="prod",
            plugin_id="mkdir",
            capacity_max="12 GiB",
            capacity_min="1.0 GiB",
            capabilities=[{
                "access_mode": "single-node-writer",
                "attachment_mode": "file-system",
            }],
            constraints=[{
                "attribute": "${attr.kernel.name}",
                "value": "linux",
            }],
            parameters={
                "some_key": "some_value",
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DynamicHostVolumeCapabilityArgs', 'DynamicHostVolumeCapabilityArgsDict']]]] capabilities: `(block: <optional>)` - Option for validating the capability of a
               volume. Each capability block has the following attributes:
        :param pulumi.Input[_builtins.str] capacity_max: `(string: <optional>)` - Option for requesting a maximum
               capacity, in bytes. The capacity of a volume may be the physical size of a
               disk, or a quota, depending on the plugin. The specific size of the resulting
               volume is somewhere between `capacity_min` and `capacity_max`; the exact
               behavior is up to the plugin. If you want to specify an exact size, set
               `capacity_min` and `capacity_max` to the same value. Accepts human-friendly
               suffixes such as `"100GiB"`. Plugins that cannot restrict the size of volumes
               may ignore this field.
        :param pulumi.Input[_builtins.str] capacity_min: `(string: <optional>)` - Option for requesting a minimum
               capacity, in bytes. The capacity of a volume may be the physical size of a
               disk, or a quota, depending on the plugin. The specific size of the resulting
               volume is somewhere between `capacity_min` and `capacity_max`; the exact
               behavior is up to the plugin. If you want to specify an exact size, set
               `capacity_min` and `capacity_max` to the same value. Accepts human-friendly
               suffixes such as `"100GiB"`. Plugins that cannot restrict the size of volumes
               may ignore this field.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DynamicHostVolumeConstraintArgs', 'DynamicHostVolumeConstraintArgsDict']]]] constraints: `(block: <optional>)` - A restriction on the eligible nodes where
               a volume can be created, similar to the [`constraint`][] block on a Nomad job
               specification.. You can provide multiple `constraint` blocks to add more
               constraints. Each constraint block has the following attributes.
        :param pulumi.Input[_builtins.str] name: `(string: <required>)` - The name of the volume, which is used as the
               [`volume.source`][volume_source] field in job specifications that claim this
               volume. Host volume names must be unique per node. Names are visible to any
               user with `node:read` ACL, even across namespaces, so they should not be
               treated as sensitive values.
        :param pulumi.Input[_builtins.str] namespace: `(string: <optional>)` - The namespace of the volume. This field
               overrides the namespace provided by the `-namespace` flag or `NOMAD_NAMESPACE`
               environment variable. Defaults to `"default"` if unset.
        :param pulumi.Input[_builtins.str] node_id: `(string: <optional>)` - A specific node where you would like the
               volume to be created.
        :param pulumi.Input[_builtins.str] node_pool: `(string: <optional>)` - A specific node pool where you would like
               the volume to be created. If you also provide `node_id`, the node must be in the
               provided `node_pool`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: `(map<string|string>: <optional>)` - A key-value map of strings
               passed directly to the plugin to configure the volume. The details of these
               parameters are specific to the plugin.
        :param pulumi.Input[_builtins.str] plugin_id: Plugin ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DynamicHostVolumeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        layout: "nomad"
        page_title: "Nomad: DynamicHostVolume"
        sidebar_current: "docs-nomad-resource-dynamic-host-volume"
        description: |-
          Manages the lifecycle of creating and deleting dynamic host volumes.
        ---

        Creates and registers a dynamic host volume in Nomad. Note that Nomad supports
        two workflows for dynamic host volumes: create and register. Both resources
        result in the same data source with the same outputs.

        > **Warning:** Destroying this resource **will result in data loss**. Use the
          [`prevent_destroy`][tf_docs_prevent_destroy] directive to avoid accidental
          deletions.

        ## Example Usage

        Creating a dynamic host volume:

        ```python
        import pulumi
        import pulumi_nomad as nomad

        example = nomad.DynamicHostVolume("example",
            name="example",
            namespace="prod",
            plugin_id="mkdir",
            capacity_max="12 GiB",
            capacity_min="1.0 GiB",
            capabilities=[{
                "access_mode": "single-node-writer",
                "attachment_mode": "file-system",
            }],
            constraints=[{
                "attribute": "${attr.kernel.name}",
                "value": "linux",
            }],
            parameters={
                "some_key": "some_value",
            })
        ```

        :param str resource_name: The name of the resource.
        :param DynamicHostVolumeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DynamicHostVolumeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DynamicHostVolumeCapabilityArgs', 'DynamicHostVolumeCapabilityArgsDict']]]]] = None,
                 capacity_max: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity_min: Optional[pulumi.Input[_builtins.str]] = None,
                 constraints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DynamicHostVolumeConstraintArgs', 'DynamicHostVolumeConstraintArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 node_id: Optional[pulumi.Input[_builtins.str]] = None,
                 node_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 plugin_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DynamicHostVolumeArgs.__new__(DynamicHostVolumeArgs)

            if capabilities is None and not opts.urn:
                raise TypeError("Missing required property 'capabilities'")
            __props__.__dict__["capabilities"] = capabilities
            __props__.__dict__["capacity_max"] = capacity_max
            __props__.__dict__["capacity_min"] = capacity_min
            __props__.__dict__["constraints"] = constraints
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["node_id"] = node_id
            __props__.__dict__["node_pool"] = node_pool
            __props__.__dict__["parameters"] = parameters
            if plugin_id is None and not opts.urn:
                raise TypeError("Missing required property 'plugin_id'")
            __props__.__dict__["plugin_id"] = plugin_id
            __props__.__dict__["capacity"] = None
            __props__.__dict__["capacity_bytes"] = None
            __props__.__dict__["capacity_max_bytes"] = None
            __props__.__dict__["capacity_min_bytes"] = None
            __props__.__dict__["host_path"] = None
            __props__.__dict__["state"] = None
        super(DynamicHostVolume, __self__).__init__(
            'nomad:index/dynamicHostVolume:DynamicHostVolume',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DynamicHostVolumeCapabilityArgs', 'DynamicHostVolumeCapabilityArgsDict']]]]] = None,
            capacity: Optional[pulumi.Input[_builtins.str]] = None,
            capacity_bytes: Optional[pulumi.Input[_builtins.int]] = None,
            capacity_max: Optional[pulumi.Input[_builtins.str]] = None,
            capacity_max_bytes: Optional[pulumi.Input[_builtins.int]] = None,
            capacity_min: Optional[pulumi.Input[_builtins.str]] = None,
            capacity_min_bytes: Optional[pulumi.Input[_builtins.int]] = None,
            constraints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DynamicHostVolumeConstraintArgs', 'DynamicHostVolumeConstraintArgsDict']]]]] = None,
            host_path: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            node_id: Optional[pulumi.Input[_builtins.str]] = None,
            node_pool: Optional[pulumi.Input[_builtins.str]] = None,
            parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            plugin_id: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None) -> 'DynamicHostVolume':
        """
        Get an existing DynamicHostVolume resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DynamicHostVolumeCapabilityArgs', 'DynamicHostVolumeCapabilityArgsDict']]]] capabilities: `(block: <optional>)` - Option for validating the capability of a
               volume. Each capability block has the following attributes:
        :param pulumi.Input[_builtins.str] capacity: Provisioned capacity
        :param pulumi.Input[_builtins.str] capacity_max: `(string: <optional>)` - Option for requesting a maximum
               capacity, in bytes. The capacity of a volume may be the physical size of a
               disk, or a quota, depending on the plugin. The specific size of the resulting
               volume is somewhere between `capacity_min` and `capacity_max`; the exact
               behavior is up to the plugin. If you want to specify an exact size, set
               `capacity_min` and `capacity_max` to the same value. Accepts human-friendly
               suffixes such as `"100GiB"`. Plugins that cannot restrict the size of volumes
               may ignore this field.
        :param pulumi.Input[_builtins.str] capacity_min: `(string: <optional>)` - Option for requesting a minimum
               capacity, in bytes. The capacity of a volume may be the physical size of a
               disk, or a quota, depending on the plugin. The specific size of the resulting
               volume is somewhere between `capacity_min` and `capacity_max`; the exact
               behavior is up to the plugin. If you want to specify an exact size, set
               `capacity_min` and `capacity_max` to the same value. Accepts human-friendly
               suffixes such as `"100GiB"`. Plugins that cannot restrict the size of volumes
               may ignore this field.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DynamicHostVolumeConstraintArgs', 'DynamicHostVolumeConstraintArgsDict']]]] constraints: `(block: <optional>)` - A restriction on the eligible nodes where
               a volume can be created, similar to the [`constraint`][] block on a Nomad job
               specification.. You can provide multiple `constraint` blocks to add more
               constraints. Each constraint block has the following attributes.
        :param pulumi.Input[_builtins.str] host_path: Host path
        :param pulumi.Input[_builtins.str] name: `(string: <required>)` - The name of the volume, which is used as the
               [`volume.source`][volume_source] field in job specifications that claim this
               volume. Host volume names must be unique per node. Names are visible to any
               user with `node:read` ACL, even across namespaces, so they should not be
               treated as sensitive values.
        :param pulumi.Input[_builtins.str] namespace: `(string: <optional>)` - The namespace of the volume. This field
               overrides the namespace provided by the `-namespace` flag or `NOMAD_NAMESPACE`
               environment variable. Defaults to `"default"` if unset.
        :param pulumi.Input[_builtins.str] node_id: `(string: <optional>)` - A specific node where you would like the
               volume to be created.
        :param pulumi.Input[_builtins.str] node_pool: `(string: <optional>)` - A specific node pool where you would like
               the volume to be created. If you also provide `node_id`, the node must be in the
               provided `node_pool`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: `(map<string|string>: <optional>)` - A key-value map of strings
               passed directly to the plugin to configure the volume. The details of these
               parameters are specific to the plugin.
        :param pulumi.Input[_builtins.str] plugin_id: Plugin ID
        :param pulumi.Input[_builtins.str] state: State
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DynamicHostVolumeState.__new__(_DynamicHostVolumeState)

        __props__.__dict__["capabilities"] = capabilities
        __props__.__dict__["capacity"] = capacity
        __props__.__dict__["capacity_bytes"] = capacity_bytes
        __props__.__dict__["capacity_max"] = capacity_max
        __props__.__dict__["capacity_max_bytes"] = capacity_max_bytes
        __props__.__dict__["capacity_min"] = capacity_min
        __props__.__dict__["capacity_min_bytes"] = capacity_min_bytes
        __props__.__dict__["constraints"] = constraints
        __props__.__dict__["host_path"] = host_path
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["node_id"] = node_id
        __props__.__dict__["node_pool"] = node_pool
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["plugin_id"] = plugin_id
        __props__.__dict__["state"] = state
        return DynamicHostVolume(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def capabilities(self) -> pulumi.Output[Sequence['outputs.DynamicHostVolumeCapability']]:
        """
        `(block: <optional>)` - Option for validating the capability of a
        volume. Each capability block has the following attributes:
        """
        return pulumi.get(self, "capabilities")

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> pulumi.Output[_builtins.str]:
        """
        Provisioned capacity
        """
        return pulumi.get(self, "capacity")

    @_builtins.property
    @pulumi.getter(name="capacityBytes")
    def capacity_bytes(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "capacity_bytes")

    @_builtins.property
    @pulumi.getter(name="capacityMax")
    def capacity_max(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `(string: <optional>)` - Option for requesting a maximum
        capacity, in bytes. The capacity of a volume may be the physical size of a
        disk, or a quota, depending on the plugin. The specific size of the resulting
        volume is somewhere between `capacity_min` and `capacity_max`; the exact
        behavior is up to the plugin. If you want to specify an exact size, set
        `capacity_min` and `capacity_max` to the same value. Accepts human-friendly
        suffixes such as `"100GiB"`. Plugins that cannot restrict the size of volumes
        may ignore this field.
        """
        return pulumi.get(self, "capacity_max")

    @_builtins.property
    @pulumi.getter(name="capacityMaxBytes")
    def capacity_max_bytes(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "capacity_max_bytes")

    @_builtins.property
    @pulumi.getter(name="capacityMin")
    def capacity_min(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `(string: <optional>)` - Option for requesting a minimum
        capacity, in bytes. The capacity of a volume may be the physical size of a
        disk, or a quota, depending on the plugin. The specific size of the resulting
        volume is somewhere between `capacity_min` and `capacity_max`; the exact
        behavior is up to the plugin. If you want to specify an exact size, set
        `capacity_min` and `capacity_max` to the same value. Accepts human-friendly
        suffixes such as `"100GiB"`. Plugins that cannot restrict the size of volumes
        may ignore this field.
        """
        return pulumi.get(self, "capacity_min")

    @_builtins.property
    @pulumi.getter(name="capacityMinBytes")
    def capacity_min_bytes(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "capacity_min_bytes")

    @_builtins.property
    @pulumi.getter
    def constraints(self) -> pulumi.Output[Optional[Sequence['outputs.DynamicHostVolumeConstraint']]]:
        """
        `(block: <optional>)` - A restriction on the eligible nodes where
        a volume can be created, similar to the [`constraint`][] block on a Nomad job
        specification.. You can provide multiple `constraint` blocks to add more
        constraints. Each constraint block has the following attributes.
        """
        return pulumi.get(self, "constraints")

    @_builtins.property
    @pulumi.getter(name="hostPath")
    def host_path(self) -> pulumi.Output[_builtins.str]:
        """
        Host path
        """
        return pulumi.get(self, "host_path")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        `(string: <required>)` - The name of the volume, which is used as the
        [`volume.source`][volume_source] field in job specifications that claim this
        volume. Host volume names must be unique per node. Names are visible to any
        user with `node:read` ACL, even across namespaces, so they should not be
        treated as sensitive values.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `(string: <optional>)` - The namespace of the volume. This field
        overrides the namespace provided by the `-namespace` flag or `NOMAD_NAMESPACE`
        environment variable. Defaults to `"default"` if unset.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> pulumi.Output[_builtins.str]:
        """
        `(string: <optional>)` - A specific node where you would like the
        volume to be created.
        """
        return pulumi.get(self, "node_id")

    @_builtins.property
    @pulumi.getter(name="nodePool")
    def node_pool(self) -> pulumi.Output[_builtins.str]:
        """
        `(string: <optional>)` - A specific node pool where you would like
        the volume to be created. If you also provide `node_id`, the node must be in the
        provided `node_pool`.
        """
        return pulumi.get(self, "node_pool")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        `(map<string|string>: <optional>)` - A key-value map of strings
        passed directly to the plugin to configure the volume. The details of these
        parameters are specific to the plugin.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="pluginId")
    def plugin_id(self) -> pulumi.Output[_builtins.str]:
        """
        Plugin ID
        """
        return pulumi.get(self, "plugin_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        State
        """
        return pulumi.get(self, "state")

