# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetVolumesResult',
    'AwaitableGetVolumesResult',
    'get_volumes',
    'get_volumes_output',
]

@pulumi.output_type
class GetVolumesResult:
    """
    A collection of values returned by getVolumes.
    """
    def __init__(__self__, id=None, namespace=None, node_id=None, plugin_id=None, type=None, volumes=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if node_id and not isinstance(node_id, str):
            raise TypeError("Expected argument 'node_id' to be a str")
        pulumi.set(__self__, "node_id", node_id)
        if plugin_id and not isinstance(plugin_id, str):
            raise TypeError("Expected argument 'plugin_id' to be a str")
        pulumi.set(__self__, "plugin_id", plugin_id)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if volumes and not isinstance(volumes, list):
            raise TypeError("Expected argument 'volumes' to be a list")
        pulumi.set(__self__, "volumes", volumes)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        `string` Volume namespace.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "node_id")

    @_builtins.property
    @pulumi.getter(name="pluginId")
    def plugin_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "plugin_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Sequence[Mapping[str, _builtins.str]]:
        """
        `list of maps` a list of volumes in the cluster.
        """
        return pulumi.get(self, "volumes")


class AwaitableGetVolumesResult(GetVolumesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVolumesResult(
            id=self.id,
            namespace=self.namespace,
            node_id=self.node_id,
            plugin_id=self.plugin_id,
            type=self.type,
            volumes=self.volumes)


def get_volumes(namespace: Optional[_builtins.str] = None,
                node_id: Optional[_builtins.str] = None,
                plugin_id: Optional[_builtins.str] = None,
                type: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVolumesResult:
    """
    Retrieve a list of volumes in Nomad.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nomad as nomad

    example = nomad.get_volumes()
    ```


    :param _builtins.str namespace: `(string: "default")` Nomad namespace.
    :param _builtins.str node_id: `(string: optional)` Volume node filter.
    :param _builtins.str plugin_id: `(string: optional)` Plugin ID filter.
    :param _builtins.str type: `(string: "csi")` Volume type (one of `csi` or `host`)
    """
    __args__ = dict()
    __args__['namespace'] = namespace
    __args__['nodeId'] = node_id
    __args__['pluginId'] = plugin_id
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nomad:index/getVolumes:getVolumes', __args__, opts=opts, typ=GetVolumesResult).value

    return AwaitableGetVolumesResult(
        id=pulumi.get(__ret__, 'id'),
        namespace=pulumi.get(__ret__, 'namespace'),
        node_id=pulumi.get(__ret__, 'node_id'),
        plugin_id=pulumi.get(__ret__, 'plugin_id'),
        type=pulumi.get(__ret__, 'type'),
        volumes=pulumi.get(__ret__, 'volumes'))
def get_volumes_output(namespace: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       node_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       plugin_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVolumesResult]:
    """
    Retrieve a list of volumes in Nomad.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nomad as nomad

    example = nomad.get_volumes()
    ```


    :param _builtins.str namespace: `(string: "default")` Nomad namespace.
    :param _builtins.str node_id: `(string: optional)` Volume node filter.
    :param _builtins.str plugin_id: `(string: optional)` Plugin ID filter.
    :param _builtins.str type: `(string: "csi")` Volume type (one of `csi` or `host`)
    """
    __args__ = dict()
    __args__['namespace'] = namespace
    __args__['nodeId'] = node_id
    __args__['pluginId'] = plugin_id
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nomad:index/getVolumes:getVolumes', __args__, opts=opts, typ=GetVolumesResult)
    return __ret__.apply(lambda __response__: GetVolumesResult(
        id=pulumi.get(__response__, 'id'),
        namespace=pulumi.get(__response__, 'namespace'),
        node_id=pulumi.get(__response__, 'node_id'),
        plugin_id=pulumi.get(__response__, 'plugin_id'),
        type=pulumi.get(__response__, 'type'),
        volumes=pulumi.get(__response__, 'volumes')))
