from enum import Enum
from typing import Dict, Tuple

Edges = Tuple[Tuple[int, int], ...]


class Skeleton(Enum):
    COCO: Edges = (
        (1, 2),
        (1, 3),
        (2, 3),
        (2, 4),
        (3, 5),
        (6, 12),
        (6, 7),
        (6, 8),
        (7, 13),
        (7, 9),
        (8, 10),
        (9, 11),
        (12, 13),
        (14, 12),
        (15, 13),
        (16, 14),
        (17, 15),
    )

    GHUM: Edges = (
        (1, 2),
        (1, 5),
        (2, 3),
        (3, 4),
        (4, 8),
        (5, 6),
        (6, 7),
        (7, 9),
        (10, 11),
        (12, 13),
        (12, 14),
        (12, 24),
        (13, 15),
        (13, 25),
        (14, 16),
        (15, 17),
        (16, 18),
        (15, 19),
        (16, 22),
        (17, 19),
        (17, 21),
        (17, 23),
        (18, 20),
        (19, 21),
        (24, 25),
        (24, 26),
        (25, 27),
        (26, 28),
        (27, 29),
        (28, 30),
        (28, 32),
        (29, 31),
        (29, 33),
        (30, 32),
        (31, 33),
    )

    FACEMESH_TESSELATION_NO_IRIS: Edges = (
        (128, 35),
        (35, 140),
        (140, 128),
        (12, 1),
        (1, 38),
        (38, 12),
        (233, 232),
        (232, 121),
        (121, 233),
        (73, 38),
        (38, 40),
        (40, 73),
        (129, 122),
        (122, 48),
        (48, 129),
        (233, 122),
        (122, 129),
        (129, 233),
        (105, 70),
        (70, 68),
        (68, 105),
        (176, 172),
        (172, 149),
        (149, 176),
        (119, 51),
        (51, 102),
        (102, 119),
        (74, 40),
        (40, 41),
        (41, 74),
        (10, 152),
        (152, 109),
        (109, 10),
        (49, 116),
        (116, 132),
        (132, 49),
        (195, 205),
        (205, 212),
        (212, 195),
        (75, 41),
        (41, 186),
        (186, 75),
        (81, 43),
        (43, 184),
        (184, 81),
        (41, 93),
        (93, 187),
        (187, 41),
        (231, 230),
        (230, 119),
        (119, 231),
        (203, 213),
        (213, 215),
        (215, 203),
        (84, 19),
        (19, 18),
        (18, 84),
        (77, 62),
        (62, 147),
        (147, 77),
        (161, 30),
        (30, 31),
        (31, 161),
        (57, 158),
        (158, 174),
        (174, 57),
        (107, 205),
        (205, 195),
        (195, 107),
        (136, 215),
        (215, 193),
        (193, 136),
        (204, 166),
        (166, 99),
        (99, 204),
        (22, 72),
        (72, 69),
        (69, 22),
        (52, 46),
        (46, 5),
        (5, 52),
        (145, 25),
        (25, 24),
        (24, 145),
        (78, 147),
        (147, 92),
        (92, 78),
        (206, 51),
        (51, 188),
        (188, 206),
        (202, 201),
        (201, 19),
        (19, 202),
        (92, 107),
        (107, 183),
        (183, 92),
        (91, 92),
        (92, 182),
        (182, 91),
        (86, 85),
        (85, 18),
        (18, 86),
        (207, 204),
        (204, 37),
        (37, 207),
        (149, 172),
        (172, 141),
        (141, 149),
        (93, 41),
        (41, 40),
        (40, 93),
        (194, 190),
        (190, 245),
        (245, 194),
        (160, 159),
        (159, 29),
        (29, 160),
        (248, 247),
        (247, 162),
        (162, 248),
        (237, 4),
        (4, 197),
        (197, 237),
        (55, 69),
        (69, 105),
        (105, 55),
        (194, 169),
        (169, 9),
        (9, 194),
        (118, 229),
        (229, 32),
        (32, 118),
        (190, 194),
        (194, 56),
        (56, 190),
        (99, 98),
        (98, 100),
        (100, 99),
        (127, 48),
        (48, 101),
        (101, 127),
        (167, 80),
        (80, 219),
        (219, 167),
        (156, 155),
        (155, 27),
        (27, 156),
        (210, 50),
        (50, 132),
        (132, 210),
        (136, 137),
        (137, 151),
        (151, 136),
        (48, 127),
        (127, 218),
        (218, 48),
        (224, 53),
        (53, 54),
        (54, 224),
        (46, 52),
        (52, 135),
        (135, 46),
        (212, 171),
        (171, 141),
        (141, 212),
        (68, 70),
        (70, 109),
        (109, 68),
        (44, 107),
        (107, 92),
        (92, 44),
        (231, 120),
        (120, 121),
        (121, 231),
        (227, 131),
        (131, 248),
        (248, 227),
        (64, 54),
        (54, 53),
        (53, 64),
        (239, 21),
        (21, 243),
        (243, 239),
        (47, 71),
        (71, 157),
        (157, 47),
        (79, 63),
        (63, 97),
        (97, 79),
        (47, 54),
        (54, 64),
        (64, 47),
        (144, 35),
        (35, 228),
        (228, 144),
        (124, 118),
        (118, 112),
        (112, 124),
        (45, 126),
        (126, 20),
        (20, 45),
        (237, 135),
        (135, 52),
        (52, 237),
        (217, 207),
        (207, 206),
        (206, 217),
        (155, 154),
        (154, 23),
        (23, 155),
        (40, 38),
        (38, 168),
        (168, 40),
        (201, 202),
        (202, 209),
        (209, 201),
        (37, 143),
        (143, 101),
        (101, 37),
        (58, 213),
        (213, 203),
        (203, 58),
        (21, 61),
        (61, 100),
        (100, 21),
        (29, 159),
        (159, 158),
        (158, 29),
        (36, 227),
        (227, 114),
        (114, 36),
        (161, 160),
        (160, 28),
        (28, 161),
        (205, 203),
        (203, 211),
        (211, 205),
        (114, 226),
        (226, 47),
        (47, 114),
        (44, 203),
        (203, 205),
        (205, 44),
        (63, 77),
        (77, 78),
        (78, 63),
        (138, 124),
        (124, 117),
        (117, 138),
        (42, 39),
        (39, 73),
        (73, 42),
        (204, 130),
        (130, 143),
        (143, 204),
        (65, 99),
        (99, 241),
        (241, 65),
        (50, 103),
        (103, 65),
        (65, 50),
        (42, 74),
        (74, 75),
        (75, 42),
        (213, 217),
        (217, 208),
        (208, 213),
        (43, 75),
        (75, 185),
        (185, 43),
        (170, 171),
        (171, 212),
        (212, 170),
        (171, 150),
        (150, 177),
        (177, 171),
        (106, 67),
        (67, 70),
        (70, 106),
        (123, 7),
        (7, 169),
        (169, 123),
        (124, 148),
        (148, 188),
        (188, 124),
        (97, 78),
        (78, 91),
        (91, 97),
        (66, 56),
        (56, 108),
        (108, 66),
        (90, 91),
        (91, 181),
        (181, 90),
        (102, 101),
        (101, 121),
        (121, 102),
        (64, 106),
        (106, 105),
        (105, 64),
        (94, 138),
        (138, 228),
        (228, 94),
        (16, 87),
        (87, 86),
        (86, 16),
        (130, 103),
        (103, 50),
        (50, 130),
        (15, 88),
        (88, 87),
        (87, 15),
        (56, 9),
        (9, 10),
        (10, 56),
        (101, 48),
        (48, 122),
        (122, 101),
        (146, 24),
        (24, 23),
        (23, 146),
        (89, 90),
        (90, 180),
        (180, 89),
        (7, 123),
        (123, 197),
        (197, 7),
        (89, 96),
        (96, 97),
        (97, 89),
        (139, 173),
        (173, 137),
        (137, 139),
        (216, 59),
        (59, 173),
        (173, 216),
        (116, 49),
        (49, 220),
        (220, 116),
        (43, 81),
        (81, 82),
        (82, 43),
        (196, 4),
        (4, 52),
        (52, 196),
        (44, 147),
        (147, 62),
        (62, 44),
        (172, 176),
        (176, 200),
        (200, 172),
        (82, 83),
        (83, 39),
        (39, 82),
        (54, 47),
        (47, 226),
        (226, 54),
        (145, 164),
        (164, 111),
        (111, 145),
        (53, 66),
        (66, 67),
        (67, 53),
        (230, 229),
        (229, 118),
        (118, 230),
        (35, 128),
        (128, 235),
        (235, 35),
        (108, 109),
        (109, 70),
        (70, 108),
        (110, 109),
        (109, 152),
        (152, 110),
        (49, 65),
        (65, 236),
        (236, 49),
        (63, 79),
        (79, 192),
        (192, 63),
        (130, 210),
        (210, 127),
        (127, 130),
        (112, 36),
        (36, 144),
        (144, 112),
        (118, 124),
        (124, 51),
        (51, 118),
        (223, 66),
        (66, 53),
        (53, 223),
        (20, 126),
        (126, 142),
        (142, 20),
        (222, 56),
        (56, 66),
        (66, 222),
        (4, 196),
        (196, 198),
        (198, 4),
        (26, 8),
        (8, 34),
        (34, 26),
        (221, 238),
        (238, 45),
        (45, 221),
        (71, 72),
        (72, 140),
        (140, 71),
        (123, 194),
        (194, 246),
        (246, 123),
        (248, 131),
        (131, 34),
        (34, 248),
        (72, 22),
        (22, 163),
        (163, 72),
        (171, 170),
        (170, 151),
        (151, 171),
        (189, 175),
        (175, 197),
        (197, 189),
        (217, 187),
        (187, 93),
        (93, 217),
        (3, 98),
        (98, 168),
        (168, 3),
        (142, 126),
        (126, 242),
        (242, 142),
        (165, 168),
        (168, 38),
        (38, 165),
        (73, 39),
        (39, 13),
        (13, 73),
        (39, 83),
        (83, 14),
        (14, 39),
        (64, 69),
        (69, 72),
        (72, 64),
        (227, 36),
        (36, 112),
        (112, 227),
        (102, 51),
        (51, 206),
        (206, 102),
        (207, 93),
        (93, 166),
        (166, 207),
        (210, 199),
        (199, 218),
        (218, 210),
        (166, 168),
        (168, 98),
        (98, 166),
        (221, 116),
        (116, 219),
        (219, 221),
        (134, 113),
        (113, 244),
        (244, 134),
        (240, 239),
        (239, 242),
        (242, 240),
        (215, 136),
        (136, 170),
        (170, 215),
        (191, 174),
        (174, 134),
        (134, 191),
        (172, 209),
        (209, 33),
        (33, 172),
        (126, 45),
        (45, 238),
        (238, 126),
        (87, 88),
        (88, 179),
        (179, 87),
        (86, 87),
        (87, 180),
        (180, 86),
        (85, 86),
        (86, 181),
        (181, 85),
        (84, 85),
        (85, 182),
        (182, 84),
        (202, 84),
        (84, 183),
        (183, 202),
        (138, 94),
        (94, 133),
        (133, 138),
        (77, 63),
        (63, 184),
        (184, 77),
        (62, 77),
        (77, 185),
        (185, 62),
        (58, 62),
        (62, 186),
        (186, 58),
        (213, 58),
        (58, 187),
        (187, 213),
        (215, 208),
        (208, 188),
        (188, 215),
        (35, 144),
        (144, 157),
        (157, 35),
        (80, 240),
        (240, 238),
        (238, 80),
        (124, 138),
        (138, 178),
        (178, 124),
        (45, 2),
        (2, 5),
        (5, 45),
        (202, 195),
        (195, 33),
        (33, 202),
        (65, 103),
        (103, 130),
        (130, 65),
        (214, 216),
        (216, 139),
        (139, 214),
        (60, 167),
        (167, 220),
        (220, 60),
        (243, 100),
        (100, 98),
        (98, 243),
        (3, 95),
        (95, 142),
        (142, 3),
        (76, 60),
        (60, 236),
        (236, 76),
        (25, 111),
        (111, 229),
        (229, 25),
        (26, 131),
        (131, 227),
        (227, 26),
        (24, 25),
        (25, 230),
        (230, 24),
        (23, 24),
        (24, 231),
        (231, 23),
        (27, 23),
        (23, 232),
        (232, 27),
        (113, 27),
        (27, 233),
        (233, 113),
        (190, 191),
        (191, 244),
        (244, 190),
        (222, 57),
        (57, 191),
        (191, 222),
        (29, 57),
        (57, 222),
        (222, 29),
        (28, 29),
        (29, 223),
        (223, 28),
        (30, 28),
        (28, 224),
        (224, 30),
        (31, 30),
        (30, 225),
        (225, 31),
        (248, 31),
        (31, 226),
        (226, 248),
        (239, 80),
        (80, 21),
        (21, 239),
        (167, 60),
        (60, 76),
        (76, 167),
        (61, 76),
        (76, 241),
        (241, 61),
        (148, 178),
        (178, 216),
        (216, 148),
        (21, 80),
        (80, 167),
        (167, 21),
        (188, 148),
        (148, 214),
        (214, 188),
        (113, 234),
        (234, 245),
        (245, 113),
        (234, 129),
        (129, 246),
        (246, 234),
        (129, 115),
        (115, 189),
        (189, 129),
        (115, 218),
        (218, 175),
        (175, 115),
        (132, 116),
        (116, 221),
        (221, 132),
        (218, 199),
        (199, 237),
        (237, 218),
        (199, 132),
        (132, 135),
        (135, 199),
        (178, 133),
        (133, 59),
        (59, 178),
        (144, 36),
        (36, 125),
        (125, 144),
        (111, 164),
        (164, 8),
        (8, 111),
        (229, 111),
        (111, 26),
        (26, 229),
        (357, 390),
        (390, 369),
        (369, 357),
        (12, 303),
        (303, 268),
        (268, 12),
        (453, 351),
        (351, 350),
        (350, 453),
        (303, 304),
        (304, 270),
        (270, 303),
        (358, 344),
        (344, 278),
        (278, 358),
        (453, 454),
        (454, 358),
        (358, 453),
        (334, 333),
        (333, 298),
        (298, 334),
        (176, 153),
        (153, 378),
        (378, 176),
        (348, 349),
        (349, 331),
        (331, 348),
        (304, 305),
        (305, 271),
        (271, 304),
        (10, 337),
        (337, 338),
        (338, 10),
        (279, 280),
        (280, 361),
        (361, 279),
        (419, 263),
        (263, 432),
        (432, 419),
        (305, 409),
        (409, 410),
        (410, 305),
        (311, 416),
        (416, 408),
        (408, 311),
        (271, 410),
        (410, 411),
        (411, 271),
        (451, 349),
        (349, 348),
        (348, 451),
        (423, 431),
        (431, 435),
        (435, 423),
        (314, 315),
        (315, 18),
        (18, 314),
        (307, 308),
        (308, 376),
        (376, 307),
        (388, 389),
        (389, 261),
        (261, 388),
        (287, 415),
        (415, 399),
        (399, 287),
        (336, 407),
        (407, 419),
        (419, 336),
        (365, 368),
        (368, 417),
        (417, 365),
        (424, 359),
        (359, 328),
        (328, 424),
        (252, 285),
        (285, 299),
        (299, 252),
        (282, 6),
        (6, 5),
        (5, 282),
        (374, 375),
        (375, 254),
        (254, 374),
        (308, 321),
        (321, 322),
        (322, 308),
        (426, 428),
        (428, 412),
        (412, 426),
        (422, 314),
        (314, 19),
        (19, 422),
        (322, 406),
        (406, 407),
        (407, 322),
        (321, 405),
        (405, 406),
        (406, 321),
        (316, 17),
        (17, 18),
        (18, 316),
        (427, 426),
        (426, 267),
        (267, 427),
        (378, 401),
        (401, 370),
        (370, 378),
        (323, 392),
        (392, 270),
        (270, 323),
        (418, 466),
        (466, 465),
        (465, 418),
        (387, 258),
        (258, 259),
        (259, 387),
        (467, 261),
        (261, 389),
        (389, 467),
        (457, 400),
        (400, 420),
        (420, 457),
        (285, 333),
        (333, 334),
        (334, 285),
        (418, 286),
        (286, 9),
        (9, 418),
        (347, 341),
        (341, 262),
        (262, 347),
        (414, 442),
        (442, 286),
        (286, 414),
        (328, 461),
        (461, 329),
        (329, 328),
        (356, 372),
        (372, 330),
        (330, 356),
        (393, 440),
        (440, 439),
        (439, 393),
        (383, 342),
        (342, 257),
        (257, 383),
        (430, 421),
        (421, 361),
        (361, 430),
        (365, 395),
        (395, 380),
        (380, 365),
        (278, 344),
        (344, 438),
        (438, 278),
        (444, 445),
        (445, 284),
        (284, 444),
        (276, 441),
        (441, 364),
        (364, 276),
        (432, 263),
        (263, 370),
        (370, 432),
        (298, 339),
        (339, 338),
        (338, 298),
        (274, 376),
        (376, 322),
        (322, 274),
        (451, 452),
        (452, 350),
        (350, 451),
        (447, 343),
        (343, 468),
        (468, 447),
        (294, 335),
        (335, 283),
        (283, 294),
        (459, 462),
        (462, 463),
        (463, 459),
        (277, 354),
        (354, 384),
        (384, 277),
        (309, 325),
        (325, 326),
        (326, 309),
        (277, 301),
        (301, 294),
        (294, 277),
        (373, 346),
        (346, 448),
        (448, 373),
        (353, 346),
        (346, 341),
        (341, 353),
        (275, 2),
        (2, 20),
        (20, 275),
        (457, 249),
        (249, 282),
        (282, 457),
        (437, 428),
        (428, 426),
        (426, 437),
        (382, 257),
        (257, 253),
        (253, 382),
        (270, 392),
        (392, 394),
        (394, 270),
        (201, 200),
        (200, 429),
        (429, 201),
        (267, 331),
        (331, 330),
        (330, 267),
        (288, 274),
        (274, 423),
        (423, 288),
        (251, 463),
        (463, 329),
        (329, 251),
        (259, 287),
        (287, 385),
        (385, 259),
        (266, 354),
        (354, 343),
        (343, 266),
        (388, 260),
        (260, 258),
        (258, 388),
        (425, 432),
        (432, 431),
        (431, 425),
        (343, 354),
        (354, 277),
        (277, 343),
        (274, 336),
        (336, 425),
        (425, 274),
        (293, 326),
        (326, 308),
        (308, 293),
        (367, 448),
        (448, 346),
        (346, 367),
        (272, 304),
        (304, 303),
        (303, 272),
        (424, 267),
        (267, 372),
        (372, 424),
        (295, 456),
        (456, 461),
        (461, 295),
        (280, 279),
        (279, 295),
        (295, 280),
        (272, 273),
        (273, 305),
        (305, 272),
        (433, 435),
        (435, 428),
        (428, 433),
        (273, 408),
        (408, 409),
        (409, 273),
        (395, 431),
        (431, 432),
        (432, 395),
        (396, 370),
        (370, 401),
        (401, 396),
        (335, 334),
        (334, 300),
        (300, 335),
        (352, 418),
        (418, 169),
        (169, 352),
        (353, 281),
        (281, 412),
        (412, 353),
        (326, 320),
        (320, 321),
        (321, 326),
        (296, 297),
        (297, 337),
        (337, 296),
        (320, 404),
        (404, 405),
        (405, 320),
        (331, 349),
        (349, 350),
        (350, 331),
        (294, 299),
        (299, 334),
        (334, 294),
        (324, 455),
        (455, 448),
        (448, 324),
        (16, 17),
        (17, 316),
        (316, 16),
        (359, 430),
        (430, 280),
        (280, 359),
        (15, 16),
        (16, 317),
        (317, 15),
        (286, 337),
        (337, 10),
        (10, 286),
        (330, 350),
        (350, 351),
        (351, 330),
        (375, 381),
        (381, 253),
        (253, 375),
        (319, 403),
        (403, 404),
        (404, 319),
        (7, 198),
        (198, 420),
        (420, 7),
        (319, 320),
        (320, 326),
        (326, 319),
        (368, 365),
        (365, 366),
        (366, 368),
        (436, 368),
        (368, 398),
        (398, 436),
        (345, 439),
        (439, 440),
        (440, 345),
        (273, 272),
        (272, 312),
        (312, 273),
        (196, 6),
        (6, 282),
        (282, 196),
        (274, 288),
        (288, 292),
        (292, 274),
        (397, 429),
        (429, 200),
        (200, 397),
        (312, 272),
        (272, 269),
        (269, 312),
        (284, 445),
        (445, 446),
        (446, 284),
        (374, 255),
        (255, 340),
        (340, 374),
        (283, 335),
        (335, 297),
        (297, 283),
        (450, 348),
        (348, 347),
        (347, 450),
        (265, 448),
        (448, 455),
        (455, 265),
        (337, 297),
        (297, 300),
        (300, 337),
        (339, 11),
        (11, 152),
        (152, 339),
        (279, 440),
        (440, 456),
        (456, 279),
        (293, 408),
        (408, 416),
        (416, 293),
        (359, 372),
        (372, 356),
        (356, 359),
        (341, 346),
        (346, 373),
        (373, 341),
        (347, 348),
        (348, 281),
        (281, 347),
        (443, 444),
        (444, 283),
        (283, 443),
        (20, 95),
        (95, 371),
        (371, 20),
        (442, 443),
        (443, 296),
        (296, 442),
        (249, 420),
        (420, 198),
        (198, 249),
        (264, 256),
        (256, 360),
        (360, 264),
        (441, 276),
        (276, 275),
        (275, 441),
        (301, 384),
        (384, 369),
        (369, 301),
        (352, 413),
        (413, 466),
        (466, 352),
        (264, 468),
        (468, 467),
        (467, 264),
        (302, 369),
        (369, 390),
        (390, 302),
        (396, 379),
        (379, 380),
        (380, 396),
        (413, 352),
        (352, 420),
        (420, 413),
        (437, 427),
        (427, 323),
        (323, 437),
        (3, 165),
        (165, 394),
        (394, 3),
        (371, 463),
        (463, 462),
        (462, 371),
        (165, 1),
        (1, 268),
        (268, 165),
        (303, 12),
        (12, 13),
        (13, 303),
        (269, 13),
        (13, 14),
        (14, 269),
        (294, 301),
        (301, 302),
        (302, 294),
        (447, 262),
        (262, 341),
        (341, 447),
        (331, 267),
        (267, 426),
        (426, 331),
        (427, 424),
        (424, 392),
        (392, 427),
        (430, 356),
        (356, 438),
        (438, 430),
        (392, 328),
        (328, 327),
        (327, 392),
        (441, 458),
        (458, 439),
        (439, 441),
        (342, 383),
        (383, 363),
        (363, 342),
        (460, 458),
        (458, 462),
        (462, 460),
        (435, 431),
        (431, 395),
        (395, 435),
        (415, 464),
        (464, 363),
        (363, 415),
        (397, 370),
        (370, 263),
        (263, 397),
        (355, 462),
        (462, 458),
        (458, 355),
        (317, 404),
        (404, 403),
        (403, 317),
        (316, 405),
        (405, 404),
        (404, 316),
        (315, 406),
        (406, 405),
        (405, 315),
        (314, 407),
        (407, 406),
        (406, 314),
        (422, 419),
        (419, 407),
        (407, 422),
        (367, 402),
        (402, 362),
        (362, 367),
        (307, 409),
        (409, 408),
        (408, 307),
        (292, 410),
        (410, 409),
        (409, 292),
        (288, 411),
        (411, 410),
        (410, 288),
        (433, 437),
        (437, 411),
        (411, 433),
        (435, 417),
        (417, 412),
        (412, 435),
        (265, 369),
        (369, 384),
        (384, 265),
        (310, 439),
        (439, 458),
        (458, 310),
        (353, 377),
        (377, 402),
        (402, 353),
        (275, 276),
        (276, 5),
        (5, 275),
        (422, 429),
        (429, 263),
        (263, 422),
        (295, 328),
        (328, 359),
        (359, 295),
        (434, 417),
        (417, 368),
        (368, 434),
        (290, 456),
        (456, 440),
        (440, 290),
        (463, 371),
        (371, 327),
        (327, 463),
        (3, 327),
        (327, 371),
        (371, 3),
        (306, 461),
        (461, 456),
        (456, 306),
        (255, 450),
        (450, 449),
        (449, 255),
        (256, 262),
        (262, 447),
        (447, 256),
        (254, 451),
        (451, 450),
        (450, 254),
        (253, 452),
        (452, 451),
        (451, 253),
        (257, 453),
        (453, 452),
        (452, 257),
        (342, 454),
        (454, 453),
        (453, 342),
        (414, 465),
        (465, 464),
        (464, 414),
        (442, 414),
        (414, 415),
        (415, 442),
        (259, 443),
        (443, 442),
        (442, 259),
        (258, 444),
        (444, 443),
        (443, 258),
        (260, 445),
        (445, 444),
        (444, 260),
        (261, 446),
        (446, 445),
        (445, 261),
        (468, 343),
        (343, 446),
        (446, 468),
        (460, 459),
        (459, 251),
        (251, 460),
        (290, 393),
        (393, 291),
        (291, 290),
        (291, 329),
        (329, 461),
        (461, 291),
        (377, 434),
        (434, 436),
        (436, 377),
        (251, 291),
        (291, 393),
        (393, 251),
        (412, 417),
        (417, 434),
        (434, 412),
        (342, 464),
        (464, 465),
        (465, 342),
        (454, 465),
        (465, 466),
        (466, 454),
        (358, 466),
        (466, 413),
        (413, 358),
        (344, 413),
        (413, 400),
        (400, 344),
        (361, 364),
        (364, 441),
        (441, 361),
        (438, 400),
        (400, 457),
        (457, 438),
        (421, 457),
        (457, 364),
        (364, 421),
        (402, 436),
        (436, 289),
        (289, 402),
        (373, 384),
        (384, 354),
        (354, 373),
        (340, 256),
        (256, 250),
        (250, 340),
        (449, 262),
        (262, 256),
        (256, 449),
        (134, 244),
        (244, 191),
        (191, 134),
        (134, 156),
        (156, 113),
        (113, 134),
        (34, 247),
        (247, 248),
        (248, 34),
        (34, 131),
        (131, 26),
        (26, 34),
        (399, 385),
        (385, 287),
        (287, 399),
        (363, 399),
        (399, 415),
        (415, 363),
        (363, 464),
        (464, 342),
        (342, 363),
        (264, 360),
        (360, 468),
        (468, 264),
        (264, 250),
        (250, 256),
        (256, 264),
        (467, 468),
        (468, 261),
        (261, 467),
        (76, 61),
        (61, 167),
        (167, 76),
        (239, 240),
        (240, 80),
        (80, 239),
        (163, 128),
        (128, 140),
        (140, 163),
        (73, 12),
        (12, 38),
        (38, 73),
        (122, 233),
        (233, 121),
        (121, 122),
        (74, 73),
        (73, 40),
        (40, 74),
        (115, 129),
        (129, 48),
        (48, 115),
        (234, 233),
        (233, 129),
        (129, 234),
        (104, 105),
        (105, 68),
        (68, 104),
        (153, 176),
        (176, 149),
        (149, 153),
        (120, 119),
        (119, 102),
        (102, 120),
        (75, 74),
        (74, 41),
        (41, 75),
        (108, 10),
        (10, 109),
        (109, 108),
        (50, 49),
        (49, 132),
        (132, 50),
        (33, 195),
        (195, 212),
        (212, 33),
        (185, 75),
        (75, 186),
        (186, 185),
        (192, 81),
        (81, 184),
        (184, 192),
        (186, 41),
        (41, 187),
        (187, 186),
        (120, 231),
        (231, 119),
        (119, 120),
        (211, 203),
        (203, 215),
        (215, 211),
        (85, 84),
        (84, 18),
        (18, 85),
        (78, 77),
        (77, 147),
        (147, 78),
        (162, 161),
        (161, 31),
        (31, 162),
        (191, 57),
        (57, 174),
        (174, 191),
        (183, 107),
        (107, 195),
        (195, 183),
        (139, 136),
        (136, 193),
        (193, 139),
        (130, 204),
        (204, 99),
        (99, 130),
        (55, 22),
        (22, 69),
        (69, 55),
        (6, 52),
        (52, 5),
        (5, 6),
        (146, 145),
        (145, 24),
        (24, 146),
        (91, 78),
        (78, 92),
        (92, 91),
        (208, 206),
        (206, 188),
        (188, 208),
        (84, 202),
        (202, 19),
        (19, 84),
        (182, 92),
        (92, 183),
        (183, 182),
        (181, 91),
        (91, 182),
        (182, 181),
        (17, 86),
        (86, 18),
        (18, 17),
        (206, 207),
        (207, 37),
        (37, 206),
        (177, 149),
        (149, 141),
        (141, 177),
        (166, 93),
        (93, 40),
        (40, 166),
        (246, 194),
        (194, 245),
        (245, 246),
        (28, 160),
        (160, 29),
        (29, 28),
        (31, 248),
        (248, 162),
        (162, 31),
        (175, 237),
        (237, 197),
        (197, 175),
        (104, 55),
        (55, 105),
        (105, 104),
        (56, 194),
        (194, 9),
        (9, 56),
        (112, 118),
        (118, 32),
        (32, 112),
        (222, 190),
        (190, 56),
        (56, 222),
        (241, 99),
        (99, 100),
        (100, 241),
        (143, 127),
        (127, 101),
        (101, 143),
        (220, 167),
        (167, 219),
        (219, 220),
        (113, 156),
        (156, 27),
        (27, 113),
        (199, 210),
        (210, 132),
        (132, 199),
        (170, 136),
        (136, 151),
        (151, 170),
        (115, 48),
        (48, 218),
        (218, 115),
        (225, 224),
        (224, 54),
        (54, 225),
        (221, 46),
        (46, 135),
        (135, 221),
        (33, 212),
        (212, 141),
        (141, 33),
        (110, 68),
        (68, 109),
        (109, 110),
        (147, 44),
        (44, 92),
        (92, 147),
        (232, 231),
        (231, 121),
        (121, 232),
        (114, 227),
        (227, 248),
        (248, 114),
        (106, 64),
        (64, 53),
        (53, 106),
        (242, 239),
        (239, 243),
        (243, 242),
        (125, 47),
        (47, 157),
        (157, 125),
        (96, 79),
        (79, 97),
        (97, 96),
        (71, 47),
        (47, 64),
        (64, 71),
        (117, 144),
        (144, 228),
        (228, 117),
        (117, 124),
        (124, 112),
        (112, 117),
        (2, 45),
        (45, 20),
        (20, 2),
        (4, 237),
        (237, 52),
        (52, 4),
        (208, 217),
        (217, 206),
        (206, 208),
        (27, 155),
        (155, 23),
        (23, 27),
        (166, 40),
        (40, 168),
        (168, 166),
        (200, 201),
        (201, 209),
        (209, 200),
        (102, 37),
        (37, 101),
        (101, 102),
        (44, 58),
        (58, 203),
        (203, 44),
        (243, 21),
        (21, 100),
        (100, 243),
        (57, 29),
        (29, 158),
        (158, 57),
        (125, 36),
        (36, 114),
        (114, 125),
        (30, 161),
        (161, 28),
        (28, 30),
        (212, 205),
        (205, 211),
        (211, 212),
        (125, 114),
        (114, 47),
        (47, 125),
        (107, 44),
        (44, 205),
        (205, 107),
        (97, 63),
        (63, 78),
        (78, 97),
        (228, 138),
        (138, 117),
        (117, 228),
        (74, 42),
        (42, 73),
        (73, 74),
        (37, 204),
        (204, 143),
        (143, 37),
        (236, 65),
        (65, 241),
        (241, 236),
        (49, 50),
        (50, 65),
        (65, 49),
        (43, 42),
        (42, 75),
        (75, 43),
        (215, 213),
        (213, 208),
        (208, 215),
        (184, 43),
        (43, 185),
        (185, 184),
        (211, 170),
        (170, 212),
        (212, 211),
        (141, 171),
        (171, 177),
        (177, 141),
        (105, 106),
        (106, 70),
        (70, 105),
        (194, 123),
        (123, 169),
        (169, 194),
        (51, 124),
        (124, 188),
        (188, 51),
        (90, 97),
        (97, 91),
        (91, 90),
        (67, 66),
        (66, 108),
        (108, 67),
        (180, 90),
        (90, 181),
        (181, 180),
        (120, 102),
        (102, 121),
        (121, 120),
        (69, 64),
        (64, 105),
        (105, 69),
        (235, 94),
        (94, 228),
        (228, 235),
        (17, 16),
        (16, 86),
        (86, 17),
        (210, 130),
        (130, 50),
        (50, 210),
        (16, 15),
        (15, 87),
        (87, 16),
        (108, 56),
        (56, 10),
        (10, 108),
        (121, 101),
        (101, 122),
        (122, 121),
        (154, 146),
        (146, 23),
        (23, 154),
        (179, 89),
        (89, 180),
        (180, 179),
        (198, 7),
        (7, 197),
        (197, 198),
        (90, 89),
        (89, 97),
        (97, 90),
        (136, 139),
        (139, 137),
        (137, 136),
        (139, 216),
        (216, 173),
        (173, 139),
        (219, 116),
        (116, 220),
        (220, 219),
        (42, 43),
        (43, 82),
        (82, 42),
        (6, 196),
        (196, 52),
        (52, 6),
        (58, 44),
        (44, 62),
        (62, 58),
        (209, 172),
        (172, 200),
        (200, 209),
        (42, 82),
        (82, 39),
        (39, 42),
        (225, 54),
        (54, 226),
        (226, 225),
        (25, 145),
        (145, 111),
        (111, 25),
        (106, 53),
        (53, 67),
        (67, 106),
        (119, 230),
        (230, 118),
        (118, 119),
        (228, 35),
        (35, 235),
        (235, 228),
        (67, 108),
        (108, 70),
        (70, 67),
        (11, 110),
        (110, 152),
        (152, 11),
        (220, 49),
        (49, 236),
        (236, 220),
        (184, 63),
        (63, 192),
        (192, 184),
        (143, 130),
        (130, 127),
        (127, 143),
        (117, 112),
        (112, 144),
        (144, 117),
        (119, 118),
        (118, 51),
        (51, 119),
        (224, 223),
        (223, 53),
        (53, 224),
        (95, 20),
        (20, 142),
        (142, 95),
        (223, 222),
        (222, 66),
        (66, 223),
        (197, 4),
        (4, 198),
        (198, 197),
        (46, 221),
        (221, 45),
        (45, 46),
        (157, 71),
        (71, 140),
        (140, 157),
        (189, 123),
        (123, 246),
        (246, 189),
        (140, 72),
        (72, 163),
        (163, 140),
        (150, 171),
        (171, 151),
        (151, 150),
        (123, 189),
        (189, 197),
        (197, 123),
        (207, 217),
        (217, 93),
        (93, 207),
        (165, 3),
        (3, 168),
        (168, 165),
        (243, 142),
        (142, 242),
        (242, 243),
        (1, 165),
        (165, 38),
        (38, 1),
        (12, 73),
        (73, 13),
        (13, 12),
        (13, 39),
        (39, 14),
        (14, 13),
        (71, 64),
        (64, 72),
        (72, 71),
        (32, 227),
        (227, 112),
        (112, 32),
        (37, 102),
        (102, 206),
        (206, 37),
        (204, 207),
        (207, 166),
        (166, 204),
        (127, 210),
        (210, 218),
        (218, 127),
        (99, 166),
        (166, 98),
        (98, 99),
        (238, 221),
        (221, 219),
        (219, 238),
        (238, 240),
        (240, 242),
        (242, 238),
        (211, 215),
        (215, 170),
        (170, 211),
        (141, 172),
        (172, 33),
        (33, 141),
        (242, 126),
        (126, 238),
        (238, 242),
        (180, 87),
        (87, 179),
        (179, 180),
        (181, 86),
        (86, 180),
        (180, 181),
        (182, 85),
        (85, 181),
        (181, 182),
        (183, 84),
        (84, 182),
        (182, 183),
        (195, 202),
        (202, 183),
        (183, 195),
        (178, 138),
        (138, 133),
        (133, 178),
        (185, 77),
        (77, 184),
        (184, 185),
        (186, 62),
        (62, 185),
        (185, 186),
        (187, 58),
        (58, 186),
        (186, 187),
        (217, 213),
        (213, 187),
        (187, 217),
        (193, 215),
        (215, 188),
        (188, 193),
        (140, 35),
        (35, 157),
        (157, 140),
        (219, 80),
        (80, 238),
        (238, 219),
        (148, 124),
        (124, 178),
        (178, 148),
        (46, 45),
        (45, 5),
        (5, 46),
        (209, 202),
        (202, 33),
        (33, 209),
        (99, 65),
        (65, 130),
        (130, 99),
        (193, 214),
        (214, 139),
        (139, 193),
        (236, 60),
        (60, 220),
        (220, 236),
        (142, 243),
        (243, 98),
        (98, 142),
        (98, 3),
        (3, 142),
        (142, 98),
        (241, 76),
        (76, 236),
        (236, 241),
        (230, 25),
        (25, 229),
        (229, 230),
        (32, 26),
        (26, 227),
        (227, 32),
        (231, 24),
        (24, 230),
        (230, 231),
        (232, 23),
        (23, 231),
        (231, 232),
        (233, 27),
        (27, 232),
        (232, 233),
        (234, 113),
        (113, 233),
        (233, 234),
        (245, 190),
        (190, 244),
        (244, 245),
        (190, 222),
        (222, 191),
        (191, 190),
        (223, 29),
        (29, 222),
        (222, 223),
        (224, 28),
        (28, 223),
        (223, 224),
        (225, 30),
        (30, 224),
        (224, 225),
        (226, 31),
        (31, 225),
        (225, 226),
        (114, 248),
        (248, 226),
        (226, 114),
        (100, 61),
        (61, 241),
        (241, 100),
        (214, 148),
        (148, 216),
        (216, 214),
        (61, 21),
        (21, 167),
        (167, 61),
        (193, 188),
        (188, 214),
        (214, 193),
        (244, 113),
        (113, 245),
        (245, 244),
        (245, 234),
        (234, 246),
        (246, 245),
        (246, 129),
        (129, 189),
        (189, 246),
        (189, 115),
        (115, 175),
        (175, 189),
        (135, 132),
        (132, 221),
        (221, 135),
        (175, 218),
        (218, 237),
        (237, 175),
        (237, 199),
        (199, 135),
        (135, 237),
        (216, 178),
        (178, 59),
        (59, 216),
        (157, 144),
        (144, 125),
        (125, 157),
        (26, 111),
        (111, 8),
        (8, 26),
        (32, 229),
        (229, 26),
        (26, 32),
        (265, 357),
        (357, 369),
        (369, 265),
        (1, 12),
        (12, 268),
        (268, 1),
        (452, 453),
        (453, 350),
        (350, 452),
        (268, 303),
        (303, 270),
        (270, 268),
        (351, 358),
        (358, 278),
        (278, 351),
        (351, 453),
        (453, 358),
        (358, 351),
        (300, 334),
        (334, 298),
        (298, 300),
        (397, 176),
        (176, 378),
        (378, 397),
        (281, 348),
        (348, 331),
        (331, 281),
        (270, 304),
        (304, 271),
        (271, 270),
        (152, 10),
        (10, 338),
        (338, 152),
        (345, 279),
        (279, 361),
        (361, 345),
        (425, 419),
        (419, 432),
        (432, 425),
        (271, 305),
        (305, 410),
        (410, 271),
        (273, 311),
        (311, 408),
        (408, 273),
        (323, 271),
        (271, 411),
        (411, 323),
        (450, 451),
        (451, 348),
        (348, 450),
        (433, 423),
        (423, 435),
        (435, 433),
        (19, 314),
        (314, 18),
        (18, 19),
        (292, 307),
        (307, 376),
        (376, 292),
        (260, 388),
        (388, 261),
        (261, 260),
        (425, 336),
        (336, 419),
        (419, 425),
        (435, 365),
        (365, 417),
        (417, 435),
        (392, 424),
        (424, 328),
        (328, 392),
        (302, 252),
        (252, 299),
        (299, 302),
        (276, 282),
        (282, 5),
        (5, 276),
        (255, 374),
        (374, 254),
        (254, 255),
        (376, 308),
        (308, 322),
        (322, 376),
        (281, 426),
        (426, 412),
        (412, 281),
        (201, 422),
        (422, 19),
        (19, 201),
        (336, 322),
        (322, 407),
        (407, 336),
        (322, 321),
        (321, 406),
        (406, 322),
        (315, 316),
        (316, 18),
        (18, 315),
        (424, 427),
        (427, 267),
        (267, 424),
        (397, 378),
        (378, 370),
        (370, 397),
        (271, 323),
        (323, 270),
        (270, 271),
        (414, 418),
        (418, 465),
        (465, 414),
        (386, 387),
        (387, 259),
        (259, 386),
        (249, 457),
        (457, 420),
        (420, 249),
        (299, 285),
        (285, 334),
        (334, 299),
        (169, 418),
        (418, 9),
        (9, 169),
        (449, 347),
        (347, 262),
        (262, 449),
        (418, 414),
        (414, 286),
        (286, 418),
        (327, 328),
        (328, 329),
        (329, 327),
        (278, 356),
        (356, 330),
        (330, 278),
        (310, 393),
        (393, 439),
        (439, 310),
        (382, 383),
        (383, 257),
        (257, 382),
        (280, 430),
        (430, 361),
        (361, 280),
        (366, 365),
        (365, 380),
        (380, 366),
        (356, 278),
        (278, 438),
        (438, 356),
        (283, 444),
        (444, 284),
        (284, 283),
        (282, 276),
        (276, 364),
        (364, 282),
        (396, 432),
        (432, 370),
        (370, 396),
        (300, 298),
        (298, 338),
        (338, 300),
        (336, 274),
        (274, 322),
        (322, 336),
        (349, 451),
        (451, 350),
        (350, 349),
        (360, 447),
        (447, 468),
        (468, 360),
        (284, 294),
        (294, 283),
        (283, 284),
        (251, 459),
        (459, 463),
        (463, 251),
        (301, 277),
        (277, 384),
        (384, 301),
        (293, 309),
        (309, 326),
        (326, 293),
        (284, 277),
        (277, 294),
        (294, 284),
        (265, 373),
        (373, 448),
        (448, 265),
        (347, 353),
        (353, 341),
        (341, 347),
        (355, 275),
        (275, 20),
        (20, 355),
        (364, 457),
        (457, 282),
        (282, 364),
        (427, 437),
        (437, 426),
        (426, 427),
        (381, 382),
        (382, 253),
        (253, 381),
        (268, 270),
        (270, 394),
        (394, 268),
        (422, 201),
        (201, 429),
        (429, 422),
        (372, 267),
        (267, 330),
        (330, 372),
        (433, 288),
        (288, 423),
        (423, 433),
        (291, 251),
        (251, 329),
        (329, 291),
        (386, 259),
        (259, 385),
        (385, 386),
        (447, 266),
        (266, 343),
        (343, 447),
        (387, 388),
        (388, 258),
        (258, 387),
        (423, 425),
        (425, 431),
        (431, 423),
        (446, 343),
        (343, 277),
        (277, 446),
        (423, 274),
        (274, 425),
        (425, 423),
        (307, 293),
        (293, 308),
        (308, 307),
        (353, 367),
        (367, 346),
        (346, 353),
        (269, 272),
        (272, 303),
        (303, 269),
        (359, 424),
        (424, 372),
        (372, 359),
        (328, 295),
        (295, 461),
        (461, 328),
        (332, 280),
        (280, 295),
        (295, 332),
        (304, 272),
        (272, 305),
        (305, 304),
        (437, 433),
        (433, 428),
        (428, 437),
        (305, 273),
        (273, 409),
        (409, 305),
        (396, 395),
        (395, 432),
        (432, 396),
        (379, 396),
        (396, 401),
        (401, 379),
        (297, 335),
        (335, 300),
        (300, 297),
        (7, 352),
        (352, 169),
        (169, 7),
        (377, 353),
        (353, 412),
        (412, 377),
        (308, 326),
        (326, 321),
        (321, 308),
        (286, 296),
        (296, 337),
        (337, 286),
        (321, 320),
        (320, 405),
        (405, 321),
        (330, 331),
        (331, 350),
        (350, 330),
        (335, 294),
        (294, 334),
        (334, 335),
        (367, 324),
        (324, 448),
        (448, 367),
        (317, 16),
        (16, 316),
        (316, 317),
        (332, 359),
        (359, 280),
        (280, 332),
        (318, 15),
        (15, 317),
        (317, 318),
        (9, 286),
        (286, 10),
        (10, 9),
        (278, 330),
        (330, 351),
        (351, 278),
        (254, 375),
        (375, 253),
        (253, 254),
        (320, 319),
        (319, 404),
        (404, 320),
        (352, 7),
        (7, 420),
        (420, 352),
        (325, 319),
        (319, 326),
        (326, 325),
        (398, 368),
        (368, 366),
        (366, 398),
        (289, 436),
        (436, 398),
        (398, 289),
        (279, 345),
        (345, 440),
        (440, 279),
        (311, 273),
        (273, 312),
        (312, 311),
        (249, 196),
        (196, 282),
        (282, 249),
        (376, 274),
        (274, 292),
        (292, 376),
        (176, 397),
        (397, 200),
        (200, 176),
        (313, 312),
        (312, 269),
        (269, 313),
        (277, 284),
        (284, 446),
        (446, 277),
        (391, 374),
        (374, 340),
        (340, 391),
        (296, 283),
        (283, 297),
        (297, 296),
        (449, 450),
        (450, 347),
        (347, 449),
        (357, 265),
        (265, 455),
        (455, 357),
        (338, 337),
        (337, 300),
        (300, 338),
        (338, 339),
        (339, 152),
        (152, 338),
        (295, 279),
        (279, 456),
        (456, 295),
        (309, 293),
        (293, 416),
        (416, 309),
        (430, 359),
        (359, 356),
        (356, 430),
        (266, 341),
        (341, 373),
        (373, 266),
        (353, 347),
        (347, 281),
        (281, 353),
        (296, 443),
        (443, 283),
        (283, 296),
        (355, 20),
        (20, 371),
        (371, 355),
        (286, 442),
        (442, 296),
        (296, 286),
        (196, 249),
        (249, 198),
        (198, 196),
        (458, 441),
        (441, 275),
        (275, 458),
        (302, 301),
        (301, 369),
        (369, 302),
        (418, 352),
        (352, 466),
        (466, 418),
        (252, 302),
        (302, 390),
        (390, 252),
        (395, 396),
        (396, 380),
        (380, 395),
        (400, 413),
        (413, 420),
        (420, 400),
        (411, 437),
        (437, 323),
        (323, 411),
        (327, 3),
        (3, 394),
        (394, 327),
        (355, 371),
        (371, 462),
        (462, 355),
        (394, 165),
        (165, 268),
        (268, 394),
        (269, 303),
        (303, 13),
        (13, 269),
        (313, 269),
        (269, 14),
        (14, 313),
        (299, 294),
        (294, 302),
        (302, 299),
        (266, 447),
        (447, 341),
        (341, 266),
        (281, 331),
        (331, 426),
        (426, 281),
        (323, 427),
        (427, 392),
        (392, 323),
        (421, 430),
        (430, 438),
        (438, 421),
        (394, 392),
        (392, 327),
        (327, 394),
        (345, 441),
        (441, 439),
        (439, 345),
        (459, 460),
        (460, 462),
        (462, 459),
        (365, 435),
        (435, 395),
        (395, 365),
        (429, 397),
        (397, 263),
        (263, 429),
        (275, 355),
        (355, 458),
        (458, 275),
        (318, 317),
        (317, 403),
        (403, 318),
        (317, 316),
        (316, 404),
        (404, 317),
        (316, 315),
        (315, 405),
        (405, 316),
        (315, 314),
        (314, 406),
        (406, 315),
        (314, 422),
        (422, 407),
        (407, 314),
        (324, 367),
        (367, 362),
        (362, 324),
        (293, 307),
        (307, 408),
        (408, 293),
        (307, 292),
        (292, 409),
        (409, 307),
        (292, 288),
        (288, 410),
        (410, 292),
        (288, 433),
        (433, 411),
        (411, 288),
        (428, 435),
        (435, 412),
        (412, 428),
        (373, 265),
        (265, 384),
        (384, 373),
        (460, 310),
        (310, 458),
        (458, 460),
        (367, 353),
        (353, 402),
        (402, 367),
        (2, 275),
        (275, 5),
        (5, 2),
        (419, 422),
        (422, 263),
        (263, 419),
        (332, 295),
        (295, 359),
        (359, 332),
        (436, 434),
        (434, 368),
        (368, 436),
        (393, 290),
        (290, 440),
        (440, 393),
        (329, 463),
        (463, 327),
        (327, 329),
        (95, 3),
        (3, 371),
        (371, 95),
        (290, 306),
        (306, 456),
        (456, 290),
        (340, 255),
        (255, 449),
        (449, 340),
        (360, 256),
        (256, 447),
        (447, 360),
        (255, 254),
        (254, 450),
        (450, 255),
        (254, 253),
        (253, 451),
        (451, 254),
        (253, 257),
        (257, 452),
        (452, 253),
        (257, 342),
        (342, 453),
        (453, 257),
        (415, 414),
        (414, 464),
        (464, 415),
        (287, 442),
        (442, 415),
        (415, 287),
        (287, 259),
        (259, 442),
        (442, 287),
        (259, 258),
        (258, 443),
        (443, 259),
        (258, 260),
        (260, 444),
        (444, 258),
        (260, 261),
        (261, 445),
        (445, 260),
        (261, 468),
        (468, 446),
        (446, 261),
        (310, 460),
        (460, 251),
        (251, 310),
        (306, 290),
        (290, 291),
        (291, 306),
        (306, 291),
        (291, 461),
        (461, 306),
        (402, 377),
        (377, 436),
        (436, 402),
        (310, 251),
        (251, 393),
        (393, 310),
        (377, 412),
        (412, 434),
        (434, 377),
        (454, 342),
        (342, 465),
        (465, 454),
        (358, 454),
        (454, 466),
        (466, 358),
        (344, 358),
        (358, 413),
        (413, 344),
        (438, 344),
        (344, 400),
        (400, 438),
        (345, 361),
        (361, 441),
        (441, 345),
        (421, 438),
        (438, 457),
        (457, 421),
        (361, 421),
        (421, 364),
        (364, 361),
        (362, 402),
        (402, 289),
        (289, 362),
        (266, 373),
        (373, 354),
        (354, 266),
        (391, 340),
        (340, 250),
        (250, 391),
        (340, 449),
        (449, 256),
        (256, 340),
    )

    FACEMESH_TESSELATION: Edges = (
        (474, 474),
        (475, 476),
        (476, 477),
        (477, 478),
        (478, 475),
        (469, 469),
        (470, 471),
        (471, 472),
        (472, 473),
        (473, 470),
        *FACEMESH_TESSELATION_NO_IRIS,
    )


SKELETONS_BY_EDGE_COUNT: Dict[int, Edges] = {}
SKELETONS_BY_VERTEX_COUNT: Dict[int, Edges] = {}

for skeleton in Skeleton:
    SKELETONS_BY_EDGE_COUNT[len(skeleton.value)] = skeleton.value

    unique_vertices = set(vertex for edge in skeleton.value for vertex in edge)
    SKELETONS_BY_VERTEX_COUNT[len(unique_vertices)] = skeleton.value
