# PAB CLI Documentation

Welcome to PAB CLI, a command-line tool for deploying Scrapy spiders to APCloudy platform.

```{toctree}
:maxdepth: 2
:caption: Contents:

installation
quickstart
commands
configuration
examples
troubleshooting
api-reference
```

## What is PAB CLI?

PAB (APCloudy Deployment Tool) is a command-line interface that simplifies the deployment of Scrapy spiders to the APCloudy platform. Similar to how `shub` works with Scrapinghub, PAB provides an easy and efficient way to manage your web scraping projects in the cloud.

## Key Features

- 🚀 **Easy Deployment**: Deploy Scrapy spiders with a single command
- 🔐 **Secure Authentication**: Secure API key management and credential storage
- 📦 **Automatic Packaging**: Automatically packages and uploads your projects
- 📋 **Project Management**: List and manage your projects and spiders
- 🔄 **Real-time Status**: Track deployment status in real-time
- 🌟 **Cross-platform**: Works on Windows, macOS, and Linux

## Quick Links

- [Installation Guide](installation.md)
- [Quick Start Tutorial](quickstart.md)
- [Command Reference](commands.md)
- [Examples](examples.md)

## Need Help?

- Check out our [Troubleshooting Guide](troubleshooting.md)
- Browse the [API Reference](api-reference.md)
- Visit the [GitHub Repository](https://github.com/fawadss1/pab-cli)

## Indices and tables

- {ref}`genindex`
- {ref}`modindex`
- {ref}`search`
