# Welcome to xWRF's documentation!

xWRF provides a lightweight interface for working with the Weather Research and Forecasting (WRF) model output in Xarray. The primary objective of `xwrf` is to replicate crucial functionality from the [wrf-python](https://github.com/NCAR/wrf-python) package in a way that is **more convenient** for users and provides **seamless integration** with the rest of the [Pangeo software stack](https://pangeo.io/packages.html).

## Get in touch

- If you encounter any errors or problems with **xWRF**, please open an issue at the GitHub [main repository](http://github.com/xarray-contrib/xwrf/issues).
- If you have a question like "How do I do ...?", ask on [GitHub discussions](https://github.com/xarray-contrib/xwrf/discussions). Please include a self-contained reproducible example if possible.

```{toctree}
---
maxdepth: 2
hidden:
---
how-to/index.md
tutorials/index.md
explanation/index.md
reference/index.md
changelog.md
```

```{toctree}
---
maxdepth: 1
caption: Contribute to xWRF
hidden:
---
contributing.md
```

```{toctree}
---
maxdepth: 1
caption: Community
hidden:
---
GitHub Repo <https://github.com/xarray-contrib/xwrf>
GitHub discussions <https://github.com/xarray-contrib/xwrf/discussions>
```

```{toctree}
---
maxdepth: 2
hidden:
---
branding/index.md
```
