import copy

import pytest

from dvc.dependency import DEP_MAP, _get
from dvc.stage import Stage
from tests.func.test_output import TESTS as OUT_TESTS

TESTS = copy.copy(OUT_TESTS)
TESTS.append(("http://example.com/path/to/file", "http"))
TESTS.append(("https://example.com/path/to/file", "https"))


def _get_dep(dvc, path):
    return _get(Stage(dvc), path, None)


@pytest.mark.parametrize("url,scheme", TESTS)
def test_scheme(dvc, url, scheme):
    # pylint: disable=unidiomatic-typecheck
    assert type(_get_dep(dvc, url)) == DEP_MAP[scheme]
