if(DEFINED ENV{KALDIFEAT_INSTALL_PREFIX})
  message(STATUS "Using environment variable KALDIFEAT_INSTALL_PREFIX: $ENV{KALDIFEAT_INSTALL_PREFIX}")
  set(KALDIFEAT_CMAKE_PREFIX_PATH $ENV{KALDIFEAT_INSTALL_PREFIX})
else()
  # PYTHON_EXECUTABLE is set by cmake/pybind11.cmake
  message(STATUS "Python executable: ${PYTHON_EXECUTABLE}")

  execute_process(
    COMMAND "${PYTHON_EXECUTABLE}" -c "import kaldifeat; print(kaldifeat.cmake_prefix_path)"
    OUTPUT_STRIP_TRAILING_WHITESPACE
    OUTPUT_VARIABLE KALDIFEAT_CMAKE_PREFIX_PATH
  )
endif()

message(STATUS "KALDIFEAT_CMAKE_PREFIX_PATH: ${KALDIFEAT_CMAKE_PREFIX_PATH}")
list(APPEND CMAKE_PREFIX_PATH "${KALDIFEAT_CMAKE_PREFIX_PATH}")

find_package(kaldifeat REQUIRED)

message(STATUS "KALDIFEAT_FOUND: ${KALDIFEAT_FOUND}")
message(STATUS "KALDIFEAT_INCLUDE_DIRS: ${KALDIFEAT_INCLUDE_DIRS}")
message(STATUS "KALDIFEAT_CXX_FLAGS: ${KALDIFEAT_CXX_FLAGS}")
message(STATUS "KALDIFEAT_LIBRARIES: ${KALDIFEAT_LIBRARIES}")
message(STATUS "KALDIFEAT_VERSION: ${KALDIFEAT_VERSION}")


if((NOT KALDIFEAT_TORCH_VERSION_MAJOR VERSION_EQUAL SHERPA_TORCH_VERSION_MAJOR) OR
  (NOT KALDIFEAT_TORCH_VERSION_MINOR VERSION_EQUAL SHERPA_TORCH_VERSION_MINOR))
  message(FATAL_ERROR "kaldifeat was compiled using "
    "PyTorch ${KALDIFEAT_TORCH_VERSION_MAJOR}.${KALDIFEAT_TORCH_VERSION_MINOR}.\n"
    "But you are using PyTorch ${SHERPA_TORCH_VERSION_MAJOR}.${SHERPA_TORCH_VERSION_MINOR} "
    "to compile sherpa. Please make them the same.".
    )
endif()

set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${KALDIFEAT_CXX_FLAGS}")
message(STATUS "CMAKE_CXX_FLAGS: ${CMAKE_CXX_FLAGS}")
