# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ApiKeyArgs', 'ApiKey']

@pulumi.input_type
class ApiKeyArgs:
    def __init__(__self__, *,
                 role: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 expires_at: Optional[pulumi.Input[_builtins.int]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ApiKey resource.
        :param pulumi.Input[_builtins.str] role: (Enum: `admin`, `basic`, `sending`, `support`, or `developer`) Key role.
        :param pulumi.Input[_builtins.str] description: Key description.
        :param pulumi.Input[_builtins.str] domain_name: Web domain to associate with the key, for keys of `domain` kind.
        :param pulumi.Input[_builtins.str] email: API key user's email address; should be provided for all keys of `web` kind.
        :param pulumi.Input[_builtins.int] expires_at: When the key will expire.
        :param pulumi.Input[_builtins.str] kind: (Enum:`domain`, `user`, or `web`). API key type. Default: `user`.
        :param pulumi.Input[_builtins.str] user_id: API key user's string user ID; should be provided for all keys of `web` kind.
        :param pulumi.Input[_builtins.str] user_name: API key user's name.
        """
        pulumi.set(__self__, "role", role)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Input[_builtins.str]:
        """
        (Enum: `admin`, `basic`, `sending`, `support`, or `developer`) Key role.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Key description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Web domain to associate with the key, for keys of `domain` kind.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        API key user's email address; should be provided for all keys of `web` kind.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        When the key will expire.
        """
        return pulumi.get(self, "expires_at")

    @expires_at.setter
    def expires_at(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "expires_at", value)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Enum:`domain`, `user`, or `web`). API key type. Default: `user`.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kind", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        API key user's string user ID; should be provided for all keys of `web` kind.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_id", value)

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        API key user's name.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class _ApiKeyState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 expires_at: Optional[pulumi.Input[_builtins.int]] = None,
                 is_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 requestor: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 secret: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ApiKey resources.
        :param pulumi.Input[_builtins.str] description: Key description.
        :param pulumi.Input[_builtins.str] disabled_reason: The reason for the key's disablement.
        :param pulumi.Input[_builtins.str] domain_name: Web domain to associate with the key, for keys of `domain` kind.
        :param pulumi.Input[_builtins.str] email: API key user's email address; should be provided for all keys of `web` kind.
        :param pulumi.Input[_builtins.int] expires_at: When the key will expire.
        :param pulumi.Input[_builtins.bool] is_disabled: Whether or not the key is disabled from use.
        :param pulumi.Input[_builtins.str] kind: (Enum:`domain`, `user`, or `web`). API key type. Default: `user`.
        :param pulumi.Input[_builtins.str] requestor: An email address associated with the key.
        :param pulumi.Input[_builtins.str] role: (Enum: `admin`, `basic`, `sending`, `support`, or `developer`) Key role.
        :param pulumi.Input[_builtins.str] secret: The full API key secret in plain text.
        :param pulumi.Input[_builtins.str] user_id: API key user's string user ID; should be provided for all keys of `web` kind.
        :param pulumi.Input[_builtins.str] user_name: API key user's name.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled_reason is not None:
            pulumi.set(__self__, "disabled_reason", disabled_reason)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if is_disabled is not None:
            pulumi.set(__self__, "is_disabled", is_disabled)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if requestor is not None:
            pulumi.set(__self__, "requestor", requestor)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Key description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disabledReason")
    def disabled_reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reason for the key's disablement.
        """
        return pulumi.get(self, "disabled_reason")

    @disabled_reason.setter
    def disabled_reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disabled_reason", value)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Web domain to associate with the key, for keys of `domain` kind.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        API key user's email address; should be provided for all keys of `web` kind.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        When the key will expire.
        """
        return pulumi.get(self, "expires_at")

    @expires_at.setter
    def expires_at(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "expires_at", value)

    @_builtins.property
    @pulumi.getter(name="isDisabled")
    def is_disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not the key is disabled from use.
        """
        return pulumi.get(self, "is_disabled")

    @is_disabled.setter
    def is_disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_disabled", value)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Enum:`domain`, `user`, or `web`). API key type. Default: `user`.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kind", value)

    @_builtins.property
    @pulumi.getter
    def requestor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An email address associated with the key.
        """
        return pulumi.get(self, "requestor")

    @requestor.setter
    def requestor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "requestor", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Enum: `admin`, `basic`, `sending`, `support`, or `developer`) Key role.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The full API key secret in plain text.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        API key user's string user ID; should be provided for all keys of `web` kind.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_id", value)

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        API key user's name.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name", value)


@pulumi.type_token("mailgun:index/apiKey:ApiKey")
class ApiKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 expires_at: Optional[pulumi.Input[_builtins.int]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_mailgun as mailgun

        # Create a new Mailgun API key
        some_key = mailgun.ApiKey("some_key",
            role="basic",
            kind="user",
            description="Some key")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Key description.
        :param pulumi.Input[_builtins.str] domain_name: Web domain to associate with the key, for keys of `domain` kind.
        :param pulumi.Input[_builtins.str] email: API key user's email address; should be provided for all keys of `web` kind.
        :param pulumi.Input[_builtins.int] expires_at: When the key will expire.
        :param pulumi.Input[_builtins.str] kind: (Enum:`domain`, `user`, or `web`). API key type. Default: `user`.
        :param pulumi.Input[_builtins.str] role: (Enum: `admin`, `basic`, `sending`, `support`, or `developer`) Key role.
        :param pulumi.Input[_builtins.str] user_id: API key user's string user ID; should be provided for all keys of `web` kind.
        :param pulumi.Input[_builtins.str] user_name: API key user's name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApiKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_mailgun as mailgun

        # Create a new Mailgun API key
        some_key = mailgun.ApiKey("some_key",
            role="basic",
            kind="user",
            description="Some key")
        ```

        :param str resource_name: The name of the resource.
        :param ApiKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApiKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 expires_at: Optional[pulumi.Input[_builtins.int]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApiKeyArgs.__new__(ApiKeyArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["email"] = email
            __props__.__dict__["expires_at"] = expires_at
            __props__.__dict__["kind"] = kind
            if role is None and not opts.urn:
                raise TypeError("Missing required property 'role'")
            __props__.__dict__["role"] = role
            __props__.__dict__["user_id"] = user_id
            __props__.__dict__["user_name"] = user_name
            __props__.__dict__["disabled_reason"] = None
            __props__.__dict__["is_disabled"] = None
            __props__.__dict__["requestor"] = None
            __props__.__dict__["secret"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ApiKey, __self__).__init__(
            'mailgun:index/apiKey:ApiKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disabled_reason: Optional[pulumi.Input[_builtins.str]] = None,
            domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            email: Optional[pulumi.Input[_builtins.str]] = None,
            expires_at: Optional[pulumi.Input[_builtins.int]] = None,
            is_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
            kind: Optional[pulumi.Input[_builtins.str]] = None,
            requestor: Optional[pulumi.Input[_builtins.str]] = None,
            role: Optional[pulumi.Input[_builtins.str]] = None,
            secret: Optional[pulumi.Input[_builtins.str]] = None,
            user_id: Optional[pulumi.Input[_builtins.str]] = None,
            user_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'ApiKey':
        """
        Get an existing ApiKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Key description.
        :param pulumi.Input[_builtins.str] disabled_reason: The reason for the key's disablement.
        :param pulumi.Input[_builtins.str] domain_name: Web domain to associate with the key, for keys of `domain` kind.
        :param pulumi.Input[_builtins.str] email: API key user's email address; should be provided for all keys of `web` kind.
        :param pulumi.Input[_builtins.int] expires_at: When the key will expire.
        :param pulumi.Input[_builtins.bool] is_disabled: Whether or not the key is disabled from use.
        :param pulumi.Input[_builtins.str] kind: (Enum:`domain`, `user`, or `web`). API key type. Default: `user`.
        :param pulumi.Input[_builtins.str] requestor: An email address associated with the key.
        :param pulumi.Input[_builtins.str] role: (Enum: `admin`, `basic`, `sending`, `support`, or `developer`) Key role.
        :param pulumi.Input[_builtins.str] secret: The full API key secret in plain text.
        :param pulumi.Input[_builtins.str] user_id: API key user's string user ID; should be provided for all keys of `web` kind.
        :param pulumi.Input[_builtins.str] user_name: API key user's name.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApiKeyState.__new__(_ApiKeyState)

        __props__.__dict__["description"] = description
        __props__.__dict__["disabled_reason"] = disabled_reason
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["email"] = email
        __props__.__dict__["expires_at"] = expires_at
        __props__.__dict__["is_disabled"] = is_disabled
        __props__.__dict__["kind"] = kind
        __props__.__dict__["requestor"] = requestor
        __props__.__dict__["role"] = role
        __props__.__dict__["secret"] = secret
        __props__.__dict__["user_id"] = user_id
        __props__.__dict__["user_name"] = user_name
        return ApiKey(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Key description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="disabledReason")
    def disabled_reason(self) -> pulumi.Output[_builtins.str]:
        """
        The reason for the key's disablement.
        """
        return pulumi.get(self, "disabled_reason")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Web domain to associate with the key, for keys of `domain` kind.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        API key user's email address; should be provided for all keys of `web` kind.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        When the key will expire.
        """
        return pulumi.get(self, "expires_at")

    @_builtins.property
    @pulumi.getter(name="isDisabled")
    def is_disabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether or not the key is disabled from use.
        """
        return pulumi.get(self, "is_disabled")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Enum:`domain`, `user`, or `web`). API key type. Default: `user`.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def requestor(self) -> pulumi.Output[_builtins.str]:
        """
        An email address associated with the key.
        """
        return pulumi.get(self, "requestor")

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Output[_builtins.str]:
        """
        (Enum: `admin`, `basic`, `sending`, `support`, or `developer`) Key role.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter
    def secret(self) -> pulumi.Output[_builtins.str]:
        """
        The full API key secret in plain text.
        """
        return pulumi.get(self, "secret")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        API key user's string user ID; should be provided for all keys of `web` kind.
        """
        return pulumi.get(self, "user_id")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        API key user's name.
        """
        return pulumi.get(self, "user_name")

