# Copyright (c) 2025 The Adirondax Team.

"""
Physical Constants in cgs units
"""

constants = {
    "speed_of_light": 2.998e10,  # cm/s
    "gravitational_constant": 6.6743e-8,  # cm^3 g^-1 s^-2
    "planck_constant": 6.6261e-27,  # erg s
    "boltzmann_constant": 1.380649e-16,  # erg K^-1
    "electron_charge": 4.8032e-10,  # statC
    "electron_mass": 9.1094e-28,  # g
    "proton_mass": 1.6726e-24,  # g
    "neutron_mass": 1.6749e-24,  # g
    "atomic_mass_unit": 1.6605e-24,  # g
    "stefan_boltzmann_constant": 5.6704e-5,  # erg cm^-2 s^-1 K^-4
    "avogadro_number": 6.02214076e23,  # mol^-1
    "gas_constant": 8.3145,  # J mol^-1 K^-1
    "faraday_constant": 96485.3321,  # C mol^-1
    "rydberg_constant": 1.09737316e5,  # cm^-1
}
