# Галерея визуализаций EleganPlot 🎨

Коллекция примеров визуализаций, созданных с помощью EleganPlot.

## Эффекты свечения (Glow)

### Базовое свечение линии
![Эффект свечения](images/Glow.png)

Пример создания линии с эффектом свечения (glow). Используются несколько полупрозрачных слоёв для создания мягкого свечения вокруг основной линии.

**Код:**
```python
import eleganplot as eplt
import numpy as np

fig, ax = eplt.subplots()
x = np.linspace(0, 4*np.pi, 200)
y = np.sin(x) * np.exp(-x/8)

main_line, glow_lines = ax.glow_line(
    x, y,
    glow_color='cyan',
    glow_width=5.0,
    glow_alpha=0.8,
    linewidth=2
)
eplt.show()
```

### Простой пример
![Простой пример](images/Simple.png)

Базовый пример использования метода `glow_line` с минимальными настройками.

---

## Градиентные фоны

### График с градиентным фоном
![Градиентный фон](images/test_gradient_bg.png)

Пример использования `gradient_subplots` для создания графика с красивым градиентным фоном.

**Код:**
```python
import eleganplot as eplt
import numpy as np

x = np.linspace(0, 10, 100)
y = np.sin(x)

fig, ax = eplt.gradient_subplots(
    dpi=200,
    gradient_colors=("#00080a", "#042628")
)
ax.plot(x, y, linewidth=2, color='cyan')
ax.set_title('График с градиентным фоном')
eplt.show()
```

---

## Градиентные заливки

### Столбчатая диаграмма с градиентом
![Градиентная заливка](images/gradient_bar.png)

Пример столбчатой диаграммы с градиентной заливкой столбцов.

### Несколько кривых с градиентом
![Несколько кривых](images/gradien_bar.png)

График с несколькими кривыми, использующими градиентную заливку под каждой линией.

### Пример с русскими подписями
![Русские подписи](images/gradien_bar_ru.png)

Демонстрация работы с кириллическими символами в подписях и заголовках.

**Код:**
```python
import eleganplot as eplt
import numpy as np

fig, ax = eplt.subplots()
x = np.linspace(0, 2*np.pi, 100)
y = np.sin(x)

line, gradient = ax.gradient_plot(
    x, y,
    fill_color='blue',
    alpha_coef=0.7
)

ax.set_xlabel('Время')
ax.set_ylabel('Амплитуда')
ax.set_title('График с градиентной заливкой')
eplt.show()
```

---

## Комбинированные эффекты

### Комбинация методов
![Комбинация методов](images/demo_output.png)

Пример комбинирования различных методов: градиентная заливка + эффект свечения + градиентный фон.

**Код:**
```python
import eleganplot as eplt
import numpy as np

x = np.linspace(0, 4*np.pi, 200)
y = np.sin(x) * np.exp(-x/8)

# Создаём фигуру с градиентным фоном
fig, ax = eplt.gradient_subplots(
    dpi=200,
    gradient_colors=("#001020", "#002040")
)

# Добавляем градиентную заливку
line, gradient = ax.gradient_plot(
    x, y,
    fill_color='cyan',
    alpha_coef=0.3,
    linewidth=0
)

# Добавляем свечение линии
main_line, glow_lines = ax.glow_line(
    x, y,
    glow_color='cyan',
    glow_width=4.0,
    glow_alpha=0.8,
    linewidth=2
)

ax.set_title('Комбинация всех эффектов')
eplt.show()
```

---

## Советы по созданию визуализаций

### Для тёмных фонов
- Используйте яркие цвета свечения (cyan, magenta, yellow, lime)
- Увеличьте `glow_alpha` для более заметного эффекта
- Выберите тёмные цвета градиентного фона

### Для светлых фонов
- Используйте более тёмные цвета или уменьшите `glow_alpha`
- Выберите светлые пастельные цвета для градиента
- Уменьшите количество слоёв свечения для более тонкого эффекта

### Для презентаций
- Используйте высокое разрешение (dpi=200-300)
- Комбинируйте различные эффекты
- Выбирайте контрастные цвета для разных серий данных

### Для научных публикаций
- Используйте умеренные эффекты
- Добавляйте градиентную заливку для показа неопределённости
- Комбинируйте с доверительными интервалами

---

## Готовые цветовые схемы

### Тёмные градиенты

| Название | Цвета | Пример использования |
|----------|-------|----------------------|
| **Сине-зелёный** | `("#00080a", "#042628")` | Универсальный, по умолчанию |
| **Фиолетовый** | `("#1a0033", "#330066")` | Презентации, эффектные графики |
| **Зелёный** | `("#002200", "#004400")` | Природная тема, экологические данные |
| **Синий** | `("#000033", "#001166")` | Классический стиль |
| **Чёрно-серый** | `("#0a0a0a", "#1a1a1a")` | Минималистичный дизайн |

### Яркие цвета свечения

| Цвет | HEX | Рекомендуется для |
|------|-----|-------------------|
| **Циан** | `cyan` или `#00FFFF` | Технические графики |
| **Маджента** | `magenta` или `#FF00FF` | Яркие акценты |
| **Лайм** | `lime` или `#00FF00` | Природные данные |
| **Оранжевый** | `orange` или `#FFA500` | Тёплые тона |
| **Жёлтый** | `yellow` или `#FFFF00` | Предупреждения, акценты |

---

## Все примеры в одном месте

Все примеры кода можно найти в папке [examples/](../examples/):
- `glow_line_example.py` - примеры свечения
- `gradient_background_example.py` - градиентные фоны
- `gradient_background_combo_example.py` - комбинированные эффекты
- `combination_methods_example.py` - различные комбинации
- `custom_methods_example.py` - кастомные методы

---

**EleganPlot** — делаем визуализацию данных элегантной! ✨

